
SET QUOTED_IDENTIFIER ON

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "rsrc_role_match_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "last_schedule_date"  datetime NULL
go

--METADATA NAME:global_usr_pref TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('USERS') and column_name=upper('global_usr_pref');
if @col_exist = 0
ALTER TABLE USERS 
  add   "global_usr_pref"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go
 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN private_loc varchar(4000)
go

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN public_loc varchar(4000)
go

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER


--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
go
go 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_extdep_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_extdep_point = charindex('P_EXTDEP',@view_data)
  if (@v_extdep_point is null or @v_extdep_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||P_TASKPRED(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||P_TASKPRED(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||P_EXTDEP(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||P_EXTDEP(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
go

go 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
DROP CONSTRAINT pk_taskuser
go
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

go 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
go

go 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
CREATE  INDEX ndx_dltrsrc_usession
ON DLTRSRC (session_id)
INCLUDE([rsrc_id])
with (drop_existing = on)
go

--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
CREATE  INDEX ndx_dltrsrl_usession
ON DLTRSRL (session_id)
INCLUDE([rsrc_id])
with (drop_existing = on)
go

go 
--END TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/G18296_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
go
go 
--END TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
go

go 
--END TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2412.0005.0000.0000'
go

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:24.10.00
update prefer set min_pro_version='24.10.00'
go

