
SET QUOTED_IDENTIFIER ON
 
--METADATA NAME:max_rolecat_level_cnt TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PREFER') and col_name(parent_object_id,parent_column_id)='max_rolecat_level_cnt'
 if @default_name is not null
  begin
  exec ('alter table dbo.PREFER drop constraint '+@default_name)
  end

  ALTER TABLE PREFER drop column  max_rolecat_level_cnt
go

print 'Creating table ASGNMNTACAT'

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  "taskrsrc_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "asgnmnt_catg_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATTYPE'

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_len"  integer NOT NULL,
  "asgnmnt_catg_type"  varchar(60) NOT NULL,
  "super_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)  )


go
print 'Creating table ASGNMNTCATVAL'

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  "asgnmnt_catg_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_name"  varchar(60) NOT NULL,
  "asgnmnt_catg_name"  varchar(100) NULL,
  "parent_asgnmnt_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)  )


go
print 'Creating table FINTMPL'

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  "fintmpl_id"  integer NOT NULL,
  "fintmpl_name"  varchar(255) NOT NULL,
  "default_flag"  varchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) DEFAULT 'NotPrmUser' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)  )


go
--METADATA  TYPE:ADHOC_SQL
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) Select 1, 'Calendar', 'Y', getdate(), getdate() WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:FINDATES CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FINDATES') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE FINDATES 
  add   "fintmpl_id"  integer DEFAULT 1 with values  NOT NULL
go

--METADATA NAME:min_pro_version TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('min_pro_version');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "min_pro_version"  varchar(10) NULL
go

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "rsrc_role_match_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "last_schedule_date"  datetime NULL
go

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('fintmpl_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "fintmpl_id"  integer NULL
go

--METADATA NAME:global_usr_pref TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('USERS') and column_name=upper('global_usr_pref');
if @col_exist = 0
ALTER TABLE USERS 
  add   "global_usr_pref"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go

print 'Dropping constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='pk_nextkey';
if @cons_cnt > 0  
ALTER TABLE NEXTKEY DROP CONSTRAINT pk_nextkey;
go

print 'Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
go

print 'Creating constraint fk_findates_fintmpl on table FINDATES'


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_project_fintmpl on table PROJECT'


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
go
 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN private_loc varchar(4000)
go

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN public_loc varchar(4000)
go

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER
ALTER TABLE NEXTKEY ALTER COLUMN key_name varchar(60) NOT NULL 
go

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER 
--METADATA NAME:role_catg_type TYPE:FIELD TABLE_NAME:ROLECATTYPE CHANGE:ALTER

--METADATA NAME:role_catg_type TYPE:FIELD TABLE_NAME:ROLECATTYPE CHANGE:ALTER
ALTER TABLE ROLECATTYPE ALTER COLUMN role_catg_type varchar(60) NOT NULL 
go

--METADATA NAME:role_catg_type TYPE:FIELD TABLE_NAME:ROLECATTYPE CHANGE:ALTER 
--METADATA NAME:role_catg_type TYPE:FIELD TABLE_NAME:ROLECATTYPE CHANGE:ALTER 
--METADATA NAME:role_catg_short_name TYPE:FIELD TABLE_NAME:ROLECATVAL CHANGE:ALTER

--METADATA NAME:role_catg_short_name TYPE:FIELD TABLE_NAME:ROLECATVAL CHANGE:ALTER
ALTER TABLE ROLECATVAL ALTER COLUMN role_catg_short_name varchar(60) NOT NULL 
go

--METADATA NAME:role_catg_short_name TYPE:FIELD TABLE_NAME:ROLECATVAL CHANGE:ALTER 
--METADATA NAME:role_catg_short_name TYPE:FIELD TABLE_NAME:ROLECATVAL CHANGE:ALTER
print 'Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnacat_asgnmntcattype
ON ASGNMNTACAT (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_asgnmntcatval
ON ASGNMNTACAT (asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_update_date1
ON ASGNMNTACAT (update_date)

go

print 'Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_dsi
ON ASGNMNTACAT (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_upd
ON ASGNMNTACAT (update_date,delete_session_id)

go

print 'Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_proj_id
ON ASGNMNTACAT (proj_id)

go

print 'Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_taskrsrc_id
ON ASGNMNTACAT (taskrsrc_id)

go

print 'Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_dsi
ON ASGNMNTCATTYPE (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_upd
ON ASGNMNTCATTYPE (update_date,delete_session_id)

go

print 'Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgncatval_asgnmntcattype
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)

go

print 'Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_parent_catg
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)

go

print 'Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_dsi
ON ASGNMNTCATVAL (delete_session_id,delete_date)

go

print 'Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_upd
ON ASGNMNTCATVAL (update_date,delete_session_id)

go

print 'Creating index ndx_findates_fintmpl on table FINDATES'

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_fintmpl
ON FINDATES (fintmpl_id)

go

print 'Creating index ndx_fintmpl_dsi on table FINTMPL'

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_dsi
ON FINTMPL (delete_session_id,delete_date)

go

print 'Creating index ndx_fintmpl_upd on table FINTMPL'

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_upd
ON FINTMPL (update_date,delete_session_id)

go

print 'Creating index ndx_project_fintmpl on table PROJECT'

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_fintmpl
ON PROJECT (fintmpl_id)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVAL_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVAL_asgnmnt_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('FINTMPL_fintmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('FINTMPL_fintmpl_id')) 
go

print 'Creating constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
go



--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', getdate(), getdate()
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2);
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    @v_fin_dates_id int, 
    @v_count        int 
BEGIN 
    SELECT @v_count=count(*) 
    FROM   findates; 
    IF @v_count = 0  
      BEGIN 
          EXEC getnextkeys 'findates_fin_dates_id', 1, @v_fin_dates_id OUTPUT; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT @v_fin_dates_id, LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10), DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0),DATEADD (dd, -1, DATEADD(mm, DATEDIFF(mm, 0, GETDATE()) + 1, 0)), 1, GETDATE(), 'NotPrmUser', GETDATE(), 'NotPrmUser'	  
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = @v_fin_dates_id AND fin_dates_name=LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10) and fintmpl_id = 1); 
               
      END; 
 END; 
 go
go 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 185
WHILE @i < 188
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',1);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',1);
go
go 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
go
go 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_extdep_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_extdep_point = charindex('P_EXTDEP',@view_data)
  if (@v_extdep_point is null or @v_extdep_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||P_TASKPRED(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||P_TASKPRED(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||P_EXTDEP(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||P_EXTDEP(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
go 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
go

go 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
DROP CONSTRAINT pk_taskuser
go
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

go 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
go

go 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
CREATE  INDEX ndx_dltrsrc_usession
ON DLTRSRC (session_id)
INCLUDE([rsrc_id])
with (drop_existing = on)
go

--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
CREATE  INDEX ndx_dltrsrl_usession
ON DLTRSRL (session_id)
INCLUDE([rsrc_id])
with (drop_existing = on)
go

go 
--END TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/G18296_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
go
go 
--END TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
go

--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
go

go 
--END TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2412.0005.0000.0000'
go

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:24.10.00
update prefer set min_pro_version='24.10.00'
go

