
--Run Script as     
SET DEFINE OFF

--METADATA NAME:global_usr_pref TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('global_usr_pref');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   global_usr_pref  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify private_loc varchar2(4000 CHAR)
/

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify public_loc varchar2(4000 CHAR)
/



--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
/

/ 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
SELECT 1 FROM DUAL
/

/ 
--END TYPE:UP2 GROUP:2403to2404 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/G18296_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
/
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
/
--METADATA TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
/
/ 
--END TYPE:UP2 GROUP:2501to2502 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfvalue where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfvalue.udf_type_id=udf_type_id)
/
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udfcode where exists (select 1 from udftype where logical_data_type = 'FT_CODE' and udfcode.udf_type_id=udf_type_id)
/
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
DELETE from udftype where logical_data_type = 'FT_CODE'
/
/ 
--END TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2412.0005.0000.0000'
/

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:24.10.00
update prefer set min_pro_version='24.10.00'
/
commit
/
