--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
begin
for rec in (select granted_role from dba_role_privs where grantee=upper('${pm.or.administrative_user}') and granted_role like 'DBA') loop
begin
 execute immediate 'revoke '||rec.granted_role ||' FROM  ${pm.or.administrative_user}';
exception when others then null;
end;
end loop;
end;
/

--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
declare
v_sql varchar2(2000);
v_cnt integer;
begin
select count(role) into v_cnt  from dba_roles where role = 'PM_ADM_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_ADM_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_BG_JOB_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_BG_JOB_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_PRIV_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_PRIV_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_REPORT_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_REPORT_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_PUBLIC_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_PUBLIC_ROLE';
end if;
exception when others then null;
end;
/

--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
begin
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('${pm.or.administrative_user}') ) loop
  execute immediate 'revoke '||rec.privilege ||' FROM  ${pm.or.administrative_user}';
  execute immediate 'grant '||rec.privilege ||' to PM_ADM_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('${pm.or.privileged_user}') ) loop
  execute immediate 'revoke '||rec.privilege ||' from ${pm.or.privileged_user}';
  execute immediate 'grant '||rec.privilege ||' to PM_PRIV_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('${pm.or.bgjob_user}') ) loop
  execute immediate 'revoke '||rec.privilege ||' from ${pm.or.bgjob_user}';
  execute immediate 'grant '||rec.privilege ||' to PM_BG_JOB_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('${pm.or.odsplus_user}') 
                   and privilege <> 'UNLIMITED TABLESPACE') loop
  execute immediate 'revoke '||rec.privilege ||' FROM  ${pm.or.odsplus_user}';
  execute immediate 'grant '||rec.privilege ||' to PM_REPORT_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('${pm.or.public_user}') ) loop
  execute immediate 'revoke '||rec.privilege ||' from ${pm.or.public_user}';
  execute immediate 'grant '||rec.privilege ||' to PM_PUBLIC_ROLE';
end loop; 
exception when others then null;
end;
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER 
grant CREATE SESSION,CREATE TABLE,CREATE PROCEDURE,CREATE SEQUENCE,CREATE TRIGGER,CREATE TYPE,CREATE VIEW,ADMINISTER DATABASE TRIGGER to PM_ADM_ROLE
/ 
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER 
grant PM_ADM_ROLE to ${pm.or.administrative_user}
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:ADMUSER 
ALTER USER ${pm.or.administrative_user} default role PM_ADM_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant CREATE SESSION,CREATE SYNONYM,CREATE JOB to PM_BG_JOB_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant PM_BG_JOB_ROLE TO ${pm.or.bgjob_user}
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:BGJOBUSER 
ALTER USER ${pm.or.bgjob_user} default role PM_BG_JOB_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant CREATE SESSION,CREATE VIEW,CREATE SYNONYM to PM_PRIV_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant PM_PRIV_ROLE TO ${pm.or.privileged_user}
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PRIVUSER 
ALTER USER ${pm.or.privileged_user} default role PM_PRIV_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PXRPTUSER
grant CREATE SESSION,CREATE VIEW,CREATE SYNONYM to PM_REPORT_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PXRPTUSER
grant PM_REPORT_ROLE TO ${pm.or.odsplus_user}
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PXRPTUSER 
ALTER USER ${pm.or.odsplus_user} default role PM_REPORT_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER
grant CREATE SESSION,CREATE SYNONYM to PM_PUBLIC_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER 
grant PM_PUBLIC_ROLE TO ${pm.or.public_user}
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PUBUSER 
ALTER USER ${pm.or.public_user} default role PM_PUBLIC_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER
grant SELECT ON SYS.DBA_VIEWS to ${pm.or.administrative_user}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${pm.data_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${pm.data_tablespace}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${pm.index_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${pm.index_tablespace}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${pm.lob_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${pm.lob_tablespace}
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:${pm.px_tablespace}
alter user ${pm.or.administrative_user} quota unlimited on ${pm.px_tablespace}
/
