--METADATA NAME:PROJRISK TYPE:TABLE TARGET_OBJECT:PROJRISK CHANGE:DATA
begin
insert into nextkey select 'pc_key_xref_execution_id',1 from dual where not exists ( select 1 from nextkey where key_name='pc_key_xref_execution_id');
insert into nextkey select 'projetllist_projetllist_id',1 from dual where not exists ( select 1 from nextkey where key_name='projetllist_projetllist_id');
commit;
end;
/

--METADATA NAME:PROJWBS TYPE:TRIGGER TARGET_OBJECT:PROJWBS CHANGE:DISABLE
declare
v_stat_trigg number;
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJWBS' and  STATUS ='ENABLED';
IF v_stat_trigg > 0 THEN
execute immediate 'ALTER TABLE PROJWBS DISABLE ALL TRIGGERS';
END IF;
end;
/
--EPPM Base DDL Scripts
--Run Script as     
SET DEFINE OFF

prompt Creating table ACTIVITYCODEHIERARCHY

--METADATA NAME:ACTIVITYCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYCODEHIERARCHY(
  codetypeobjectid  number(10) NOT NULL,
  codetypename  varchar2(40 CHAR) NULL,
  codetypesequencenumber  number(10) NULL,
  codetypeissecure  varchar2(1 CHAR) NULL,
  parentcodevalueobjectid  number(10) NULL,
  parentcodevaluename  varchar2(120 CHAR) NULL,
  parentcodevalueshortname  varchar2(60 CHAR) NULL,
  parentcodevaluesequencenumber  number(10) NULL,
  childcodevalueobjectid  number(10) NULL,
  childcodevaluename  varchar2(120 CHAR) NULL,
  childcodevalueshortname  varchar2(60 CHAR) NULL,
  childcodevaluesequencenumber  number(10) NULL,
  parentlevelsbelowroot  number(10) NULL,
  childlevelsbelowroot  number(10) NULL,
  levelsbetween  number(10) NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL,
  codetypescope  varchar2(10 CHAR) NULL,
  codetypeprojectid  number(10) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ACTIVITYCODETYPESECURITY

--METADATA NAME:ACTIVITYCODETYPESECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYCODETYPESECURITY(
  rdbmsuserid  number(10) NULL,
  projectobjectid  number(10) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ACTIVITYSPREAD

--METADATA NAME:ACTIVITYSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYSPREAD(
  activityobjectid  number(10) NOT NULL,
  startdate  DATE NOT NULL,
  enddate  DATE NOT NULL,
  activitycode  varchar2(40 CHAR) NULL,
  activityname  varchar2(120 CHAR) NULL,
  wbsobjectid  number(10) NOT NULL,
  projectobjectid  number(10) NOT NULL,
  actuallaborunits  NUMBER NULL,
  actualnonlaborunits  NUMBER NULL,
  atcompletionlaborunits  NUMBER NULL,
  atcompletionnonlaborunits  NUMBER NULL,
  baselineactuallaborunits  NUMBER NULL,
  baselineactualnonlaborunits  NUMBER NULL,
  baselineplannedlaborunits  NUMBER NULL,
  baselineplannednonlaborunits  NUMBER NULL,
  baseline1actuallaborunits  NUMBER NULL,
  baseline1actualnonlaborunits  NUMBER NULL,
  baseline1plannedlaborunits  NUMBER NULL,
  baseline1plannednonlaborunits  NUMBER NULL,
  earnedvaluelaborunits  NUMBER NULL,
  estimateatcompletionlaborunits  NUMBER NULL,
  estimatetocompletelaborunits  NUMBER NULL,
  plannedlaborunits  NUMBER NULL,
  plannednonlaborunits  NUMBER NULL,
  plannedvaluelaborunits  NUMBER NULL,
  remaininglaborunits  NUMBER NULL,
  remaininglatelaborunits  NUMBER NULL,
  remaininglatenonlaborunits  NUMBER NULL,
  remainingnonlaborunits  NUMBER NULL,
  actualcost  NUMBER NULL,
  actualexpensecost  NUMBER NULL,
  actuallaborcost  NUMBER NULL,
  actualmaterialcost  NUMBER NULL,
  actualnonlaborcost  NUMBER NULL,
  actualtotalcost  NUMBER NULL,
  atcompletionexpensecost  NUMBER NULL,
  atcompletionlaborcost  NUMBER NULL,
  atcompletionmaterialcost  NUMBER NULL,
  atcompletionnonlaborcost  NUMBER NULL,
  atcompletiontotalcost  NUMBER NULL,
  baselineplannedexpensecost  NUMBER NULL,
  baselineplannedlaborcost  NUMBER NULL,
  baselineplannedmaterialcost  NUMBER NULL,
  baselineplannednonlaborcost  NUMBER NULL,
  baselineplannedtotalcost  NUMBER NULL,
  baselineactualexpensecost  NUMBER NULL,
  baselineactuallaborcost  NUMBER NULL,
  baselineactualmaterialcost  NUMBER NULL,
  baselineactualnonlaborcost  NUMBER NULL,
  baselineactualtotalcost  NUMBER NULL,
  baseline1actualexpensecost  NUMBER NULL,
  baseline1actuallaborcost  NUMBER NULL,
  baseline1actualmaterialcost  NUMBER NULL,
  baseline1actualnonlaborcost  NUMBER NULL,
  baseline1actualtotalcost  NUMBER NULL,
  baseline1plannedexpensecost  NUMBER NULL,
  baseline1plannedlaborcost  NUMBER NULL,
  baseline1plannedmaterialcost  NUMBER NULL,
  baseline1plannednonlaborcost  NUMBER NULL,
  baseline1plannedtotalcost  NUMBER NULL,
  earnedvaluecost  NUMBER NULL,
  estimateatcompletioncost  NUMBER NULL,
  estimatetocompletecost  NUMBER NULL,
  plannedexpensecost  NUMBER NULL,
  plannedlaborcost  NUMBER NULL,
  plannedmaterialcost  NUMBER NULL,
  plannednonlaborcost  NUMBER NULL,
  plannedtotalcost  NUMBER NULL,
  plannedvaluecost  NUMBER NULL,
  remainingexpensecost  NUMBER NULL,
  remaininglaborcost  NUMBER NULL,
  remaininglateexpensecost  NUMBER NULL,
  remaininglatelaborcost  NUMBER NULL,
  remaininglatematerialcost  NUMBER NULL,
  remaininglatenonlaborcost  NUMBER NULL,
  remaininglatetotalcost  NUMBER NULL,
  remainingmaterialcost  NUMBER NULL,
  remainingnonlaborcost  NUMBER NULL,
  remainingtotalcost  NUMBER NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ACTVCODEX

--METADATA NAME:ACTVCODEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVCODEX(
  actv_code_id  number(10) NOT NULL,
  codetypename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  projectobjectid  number(10) NULL,
  codetypescope  varchar2(24 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activitycodex PRIMARY KEY (actv_code_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table AC_PROJRSRCROLELIST

--METADATA NAME:AC_PROJRSRCROLELIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE AC_PROJRSRCROLELIST(
  proj_id  number(10) NULL,
  rsrc_id  varchar2(30 CHAR) NULL,
  role_id  varchar2(30 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ADDTASKPROC

--METADATA NAME:ADDTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTASKPROC(
  proc_id  number(10) NOT NULL,
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  proj_id  number(10) NOT NULL,
  complete_pct  number(10,2) NULL,
  proc_name  varchar2(120 CHAR) NULL,
  proc_wt  number(10,2) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_addtaskproc PRIMARY KEY (proc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ADDTASKPROCX

--METADATA NAME:ADDTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTASKPROCX(
  transaction_id  number(10) NOT NULL,
  proc_id  number(10) NOT NULL,
  changedate  DATE NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_addtaskprocx PRIMARY KEY (proc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ADDTRSRC

--METADATA NAME:ADDTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTRSRC(
  addtrsrc_id  number(10) NOT NULL,
  taskrsrc_id  number(10) NULL,
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'Approved' NOT NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  act_reg_qty  number(17,6) NULL,
  remain_qty  number(17,6) NULL,
  remain_drtn  number(17,6) NULL,
  reend_date  DATE NULL,
  assignment_is_read  varchar2(10 CHAR) DEFAULT 'false' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_addtrsrc PRIMARY KEY (addtrsrc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ALERT

--METADATA NAME:ALERT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ALERT(
  alert_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  alert_type  varchar2(56 CHAR) NULL,
  action_key  varchar2(56 CHAR) NULL,
  alert_status  varchar2(56 CHAR) NULL,
  alert_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_alert PRIMARY KEY (alert_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ALERTPARAM

--METADATA NAME:ALERTPARAM TYPE:TABLE CHANGE:CREATE

CREATE TABLE ALERTPARAM(
  alert_id  number(10) NOT NULL,
  setting_id  number(10) NOT NULL,
  setting_name  varchar2(128 CHAR) NULL,
  setting_value  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_alertparam PRIMARY KEY (alert_id,setting_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ANNOUNCEMENT

--METADATA NAME:ANNOUNCEMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ANNOUNCEMENT(
  announcement_id  number(10) NOT NULL,
  announcement_title  varchar2(255 CHAR) NOT NULL,
  announcement_message  BLOB NOT NULL,
  announce_cloud_id  number(10) NOT NULL,
  status_code  varchar2(10 CHAR) NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  create_date  DATE NULL,
  update_date  DATE NULL,
  create_user  varchar2(40 CHAR) NULL,
  update_user  varchar2(40 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_announcement PRIMARY KEY (announcement_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(announcement_message) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ANNOUNCEMENT_USER

--METADATA NAME:ANNOUNCEMENT_USER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ANNOUNCEMENT_USER(
  user_id  number(10) NOT NULL,
  announcement_id  number(10) NOT NULL,
  status_code  varchar2(1 CHAR) DEFAULT 'U' NOT NULL,
  read_date  DATE NULL,
  create_date  DATE NULL,
  update_date  DATE NULL,
  create_user  varchar2(40 CHAR) NULL,
  update_user  varchar2(40 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_announcement_user PRIMARY KEY (user_id,announcement_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ARBITER_COUNTER

--METADATA NAME:ARBITER_COUNTER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ARBITER_COUNTER(
  arb_id  number(19) NOT NULL,
  sub_date  DATE NULL,
  proj_id  number(10) NULL,
  core_complete_flag  varchar2(1 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ASGNMNTACATX

--METADATA NAME:ASGNMNTACATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTACATX(
  taskrsrc_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  asgnmntcodedescription  varchar2(255 CHAR) NULL,
  asgnmntcodetypename  varchar2(255 CHAR) NULL,
  asgnmntcodevalue  varchar2(255 CHAR) NULL,
  asgnmntid  varchar2(255 CHAR) NULL,
  asgnmntname  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_assignmentcodeassignmentx PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table ASGNMNTCATVALX

--METADATA NAME:ASGNMNTCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATVALX(
  asgnmnt_catg_id  number(10) NOT NULL,
  codetypename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_assignmentcodex PRIMARY KEY (asgnmnt_catg_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table ASSIGNMENTCODEHIERARCHY

--METADATA NAME:ASSIGNMENTCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASSIGNMENTCODEHIERARCHY(
  codetypeobjectid  number(10) NOT NULL,
  codetypename  varchar2(60 CHAR) NOT NULL,
  codetypesequencenumber  number(10) NOT NULL,
  codetypeissecure  varchar2(1 CHAR) NOT NULL,
  parentcodevalueobjectid  number(10) NULL,
  parentcodevaluename  varchar2(100 CHAR) NULL,
  parentcodevalueshortname  varchar2(60 CHAR) NULL,
  parentcodevaluesequencenumber  number(10) NULL,
  childcodevalueobjectid  number(10) NULL,
  childcodevaluename  varchar2(100 CHAR) NULL,
  childcodevalueshortname  varchar2(60 CHAR) NULL,
  childcodevaluesequencenumber  number(10) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ATTR_MASTER

--METADATA NAME:ATTR_MASTER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ATTR_MASTER(
  attr_id  number(10) NOT NULL,
  attr_name  varchar2(120 CHAR) NOT NULL,
  attr_type  varchar2(120 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_attr_master PRIMARY KEY (attr_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table AUTOVUE_ATTR

--METADATA NAME:AUTOVUE_ATTR TYPE:TABLE CHANGE:CREATE

CREATE TABLE AUTOVUE_ATTR(
  property_id  number(10) NOT NULL,
  document_external_key  varchar2(4000 CHAR) NOT NULL,
  property_name  varchar2(4000 CHAR) NULL,
  property_last_updated  DATE NULL,
  property_external_key  varchar2(4000 CHAR) NOT NULL,
  property_doc_type  varchar2(4000 CHAR) NULL,
  property_create_user  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_autovue_attr PRIMARY KEY (property_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BODEFLABELS

--METADATA NAME:BODEFLABELS TYPE:TABLE CHANGE:CREATE

CREATE TABLE BODEFLABELS(
  bodeflabels_id  number(10) NOT NULL,
  bo_name  varchar2(100 CHAR) NOT NULL,
  bo_field_name  varchar2(100 CHAR) NOT NULL,
  bo_field_type  varchar2(100 CHAR) NOT NULL,
  source_table_name  varchar2(100 CHAR) NOT NULL,
  source_column_name  varchar2(100 CHAR) NOT NULL
,CONSTRAINT pk_bodeflabels PRIMARY KEY (bodeflabels_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BUDGCHNGX

--METADATA NAME:BUDGCHNGX TYPE:TABLE CHANGE:CREATE

CREATE TABLE BUDGCHNGX(
  budg_chng_id  number(10) NOT NULL,
  epsid  varchar2(255 CHAR) NULL,
  epsname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectbudgetchangelogx PRIMARY KEY (budg_chng_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table CALENDARX

--METADATA NAME:CALENDARX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CALENDARX(
  clndr_id  number(10) NOT NULL,
  daydate  DATE NOT NULL,
  weekdaynumber  number(10) NULL,
  workdayflag  varchar2(1 CHAR) NULL,
  totalworkhours  number(10,2) NULL,
  workhoursbyhalfhour  varchar2(48 CHAR) NULL,
  workdaystarttime  DATE NULL,
  workdayfinishtime  DATE NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_calendarx PRIMARY KEY (clndr_id,daydate)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table CBS

--METADATA NAME:CBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE CBS(
  cbs_id  number(10) NOT NULL,
  cbs_code  varchar2(120 CHAR) NOT NULL,
  proj_id  number(10) NOT NULL,
  parent_cbs_id  number(10) NULL,
  description  varchar2(4000 CHAR) NULL,
  status  varchar2(20 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_cbs PRIMARY KEY (cbs_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CHGHEAD

--METADATA NAME:CHGHEAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGHEAD(
  transaction_id  number(10) NOT NULL,
  transaction_date  DATE NOT NULL,
  request_user_name  varchar2(255 CHAR) NOT NULL,
  request_user_id  number(10) NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  create_date  DATE DEFAULT sysdate NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chghead PRIMARY KEY (transaction_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CHGTASK

--METADATA NAME:CHGTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASK(
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  proj_id  number(10) NOT NULL,
  new_act_start_date  DATE NULL,
  ovr_act_start_date  DATE NULL,
  new_act_end_date  DATE NULL,
  ovr_act_end_date  DATE NULL,
  new_remain_drtn  number(17,6) NULL,
  ovr_remain_drtn  number(17,6) NULL,
  new_complete_pct  number(10,2) NULL,
  ovr_complete_pct  number(10,2) NULL,
  ovr_act_work_qty  number(17,6) NULL,
  new_act_work_qty  number(17,6) NULL,
  new_act_equip_qty  number(17,6) NULL,
  ovr_act_equip_qty  number(17,6) NULL,
  ovr_remain_work_qty  number(17,6) NULL,
  new_remain_work_qty  number(17,6) NULL,
  new_remain_equip_qty  number(17,6) NULL,
  ovr_remain_equip_qty  number(17,6) NULL,
  new_exp_end_date  DATE NULL,
  ovr_exp_end_date  DATE NULL,
  approval_date  DATE NULL,
  approval_user_name  varchar2(255 CHAR) NULL,
  approval_user_id  number(10) NULL,
  held_date  DATE NULL,
  rejected_by  varchar2(255 CHAR) NULL,
  resubmitted_by  varchar2(255 CHAR) NULL,
  rejected_date  DATE NULL,
  resubmitted_date  DATE NULL,
  all_data  BLOB NULL,
  new_suspend_date  DATE NULL,
  ovr_suspend_date  DATE NULL,
  new_resume_date  DATE NULL,
  ovr_resume_date  DATE NULL,
  offset_val  varchar2(3000 CHAR) NULL,
  new_cstr_date  DATE NULL,
  ovr_cstr_date  DATE NULL,
  new_cstr_type  varchar2(12 CHAR) NULL,
  ovr_cstr_type  varchar2(12 CHAR) NULL,
  last_approved_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgtask PRIMARY KEY (transaction_id,task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(all_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table CHGTASKACTV

--METADATA NAME:CHGTASKACTV TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKACTV(
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  proj_id  number(10) NOT NULL,
  actv_code_type_id  number(10) NULL,
  ovr_actv_code_id  number(10) NULL,
  new_actv_code_id  number(10) NULL,
  approval_date  DATE NULL,
  approval_user_name  varchar2(255 CHAR) NULL,
  approval_user_id  number(10) NULL,
  held_date  DATE NULL,
  rejected_by  varchar2(255 CHAR) NULL,
  resubmitted_by  varchar2(255 CHAR) NULL,
  rejected_date  DATE NULL,
  resubmitted_date  DATE NULL,
  all_data  BLOB NULL,
  offset  number(10) NULL,
  last_approved_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgtaskactv PRIMARY KEY (transaction_id,task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(all_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table CHGTASKACTVX

--METADATA NAME:CHGTASKACTVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKACTVX(
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  changedate  DATE NULL,
  requestuserobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgtaskactvx PRIMARY KEY (transaction_id,task_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CHGTASKMEMO

--METADATA NAME:CHGTASKMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKMEMO(
  transaction_id  number(10) NOT NULL,
  memo_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgtaskmemo PRIMARY KEY (transaction_id,memo_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CHGTASKMEMOX

--METADATA NAME:CHGTASKMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKMEMOX(
  transaction_id  number(10) NOT NULL,
  memo_id  number(10) NOT NULL,
  changedate  DATE NULL,
  requestusername  varchar2(255 CHAR) NULL,
  requestuserobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgtaskmemox PRIMARY KEY (transaction_id,memo_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CHGTASKPROC

--METADATA NAME:CHGTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKPROC(
  transaction_id  number(10) NOT NULL,
  proc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  proj_id  number(10) NOT NULL,
  new_complete_pct  number(10,2) NULL,
  ovr_complete_pct  number(10,2) NULL,
  approval_date  DATE NULL,
  approval_user_name  varchar2(255 CHAR) NULL,
  approval_user_id  number(10) NULL,
  held_date  DATE NULL,
  proc_name  varchar2(120 CHAR) NULL,
  ovr_proc_name  varchar2(120 CHAR) NULL,
  rejected_by  varchar2(255 CHAR) NULL,
  resubmitted_by  varchar2(255 CHAR) NULL,
  rejected_date  DATE NULL,
  resubmitted_date  DATE NULL,
  all_data  BLOB NULL,
  last_approved_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgtaskproc PRIMARY KEY (transaction_id,proc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(all_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table CHGTASKPROCX

--METADATA NAME:CHGTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKPROCX(
  transaction_id  number(10) NOT NULL,
  proc_id  number(10) NOT NULL,
  changedate  DATE NULL,
  requestusername  varchar2(255 CHAR) NULL,
  requestuserobjectid  number(10) NULL,
  pendingstepname  varchar2(120 CHAR) NULL,
  overridestepname  varchar2(120 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgtaskprocx PRIMARY KEY (transaction_id,proc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table CHGTASKX

--METADATA NAME:CHGTASKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKX(
  transaction_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  changedate  DATE NULL,
  requestusername  varchar2(255 CHAR) NULL,
  requestuserobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgtaskx PRIMARY KEY (transaction_id,task_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table CHGTRSRC

--METADATA NAME:CHGTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTRSRC(
  transaction_id  number(10) NOT NULL,
  taskrsrc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  proj_id  number(10) NOT NULL,
  new_act_start_date  DATE NULL,
  ovr_act_start_date  DATE NULL,
  new_act_end_date  DATE NULL,
  ovr_act_end_date  DATE NULL,
  ovr_act_reg_qty  number(17,6) NULL,
  new_act_reg_qty  number(17,6) NULL,
  ovr_remain_qty  number(17,6) NULL,
  new_remain_qty  number(17,6) NULL,
  new_remain_drtn  number(17,6) NULL,
  ovr_remain_drtn  number(17,6) NULL,
  approval_date  DATE NULL,
  approval_user_name  varchar2(255 CHAR) NULL,
  approval_user_id  number(10) NULL,
  held_date  DATE NULL,
  new_reend_date  DATE NULL,
  ovr_reend_date  DATE NULL,
  rejected_by  varchar2(255 CHAR) NULL,
  resubmitted_by  varchar2(255 CHAR) NULL,
  rejected_date  DATE NULL,
  resubmitted_date  DATE NULL,
  all_data  BLOB NULL,
  last_approved_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgtrsrc PRIMARY KEY (transaction_id,taskrsrc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(all_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table CHGTRSRCX

--METADATA NAME:CHGTRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTRSRCX(
  transaction_id  number(10) NOT NULL,
  taskrsrc_id  number(10) NOT NULL,
  changedate  DATE NULL,
  requestusername  varchar2(255 CHAR) NULL,
  requestuserobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgtrsrcx PRIMARY KEY (transaction_id,taskrsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table CHGUDFVALUE

--METADATA NAME:CHGUDFVALUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGUDFVALUE(
  transaction_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) DEFAULT 'TS_Pending' NOT NULL,
  proj_id  number(10) NOT NULL,
  udf_type_id  number(10) NULL,
  ovr_udf_text  varchar2(255 CHAR) NULL,
  ovr_udf_number  NUMBER NULL,
  ovr_udf_code_id  number(10) NULL,
  ovr_udf_date  DATE NULL,
  new_udf_text  varchar2(255 CHAR) NULL,
  new_udf_number  NUMBER NULL,
  new_udf_code_id  number(10) NULL,
  new_udf_date  DATE NULL,
  approval_date  DATE NULL,
  approval_user_name  varchar2(255 CHAR) NULL,
  approval_user_id  number(10) NULL,
  held_date  DATE NULL,
  rejected_by  varchar2(255 CHAR) NULL,
  resubmitted_by  varchar2(255 CHAR) NULL,
  rejected_date  DATE NULL,
  resubmitted_date  DATE NULL,
  all_data  BLOB NULL,
  offset  number(10) NULL,
  last_approved_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_chgudfvalue PRIMARY KEY (transaction_id,fk_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(all_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table CHGUDFVALUEX

--METADATA NAME:CHGUDFVALUEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGUDFVALUEX(
  transaction_id  number(10) NOT NULL,
  fk_id  number(10) NULL,
  udf_type_id  number(10) NOT NULL,
  changedate  DATE NULL,
  overrideudfnumber  NUMBER NULL,
  pendingudfnumber  NUMBER NULL,
  overrideudfinteger  NUMBER NULL,
  pendingudfinteger  NUMBER NULL,
  overrideudfcost  NUMBER NULL,
  pendingudfcost  NUMBER NULL,
  requestuserobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_chgudfvaluex PRIMARY KEY (transaction_id,udf_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table COSTACCOUNTHIERARCHY

--METADATA NAME:COSTACCOUNTHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTACCOUNTHIERARCHY(
  parentobjectid  number(10) NULL,
  parentsequencenumber  number(10) NULL,
  parentname  varchar2(100 CHAR) NULL,
  parentid  varchar2(40 CHAR) NULL,
  childobjectid  number(10) NULL,
  childsequencenumber  number(10) NULL,
  childname  varchar2(100 CHAR) NULL,
  childid  varchar2(40 CHAR) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table COSTSECURITY

--METADATA NAME:COSTSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTSECURITY(
  rdbmsuserid  number(10) NULL,
  projectobjectid  number(10) NULL,
  wholeprojectflag  char(1 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CURRTYPEX

--METADATA NAME:CURRTYPEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CURRTYPEX(
  curr_id  number(10) NOT NULL,
  isbasecurrency  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_currencyx PRIMARY KEY (curr_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DBERRLOG

--METADATA NAME:DBERRLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE DBERRLOG(
  log_id  number(10) GENERATED ALWAYS AS IDENTITY NOT NULL,
  created_on  DATE NULL,
  created_by  varchar2(3000 CHAR) NULL,
  errorcode  number(10) NULL,
  callstack  varchar2(3000 CHAR) NULL,
  errorstack  varchar2(3000 CHAR) NULL,
  backtrace  varchar2(3000 CHAR) NULL,
  error_info  varchar2(3000 CHAR) NULL
,CONSTRAINT pk_dberrlog PRIMARY KEY (log_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DELTASKPROC

--METADATA NAME:DELTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE DELTASKPROC(
  transaction_id  number(10) NOT NULL,
  proc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  proc_name  varchar2(120 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_deltaskproc PRIMARY KEY (transaction_id,proc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DELTASKPROCX

--METADATA NAME:DELTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE DELTASKPROCX(
  transaction_id  number(10) NOT NULL,
  proc_id  number(10) NOT NULL,
  changedate  DATE NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_deltaskprocx PRIMARY KEY (proc_id,transaction_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DM_ATTR

--METADATA NAME:DM_ATTR TYPE:TABLE CHANGE:CREATE

CREATE TABLE DM_ATTR(
  dm_attr_id  number(10) NOT NULL,
  attr_id  number(10) NOT NULL,
  guid  varchar2(255 CHAR) NOT NULL,
  attr_value  varchar2(120 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_dm_attr PRIMARY KEY (dm_attr_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOC

--METADATA NAME:DOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC(
  doc_id  number(10) NOT NULL,
  doc_folder_id  number(10) NOT NULL,
  doc_uuid  varchar2(255 CHAR) NULL,
  current_version  varchar2(255 CHAR) NULL,
  version_label  varchar2(255 CHAR) NULL,
  doc_title  varchar2(255 CHAR) NULL,
  doc_type  varchar2(255 CHAR) NULL,
  author_name  varchar2(255 CHAR) NULL,
  file_name  varchar2(255 CHAR) NULL,
  checkout_flag  varchar2(1 CHAR) NULL,
  checkout_user  varchar2(255 CHAR) NULL,
  doc_comment  varchar2(4000 CHAR) NULL,
  doc_update_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_doc PRIMARY KEY (doc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOCUMENTX

--METADATA NAME:DOCUMENTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENTX(
  doc_id  number(10) NOT NULL,
  documentcategoryname  varchar2(255 CHAR) NULL,
  documentstatuscodename  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_documentx PRIMARY KEY (doc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table DOCUMENT_MAPPER

--METADATA NAME:DOCUMENT_MAPPER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENT_MAPPER(
  doc_id  number(10) NOT NULL,
  doc_name  varchar2(255 CHAR) NULL,
  doc_type  varchar2(255 CHAR) NULL,
  doc_size  varchar2(255 CHAR) NULL,
  doc_external_key  varchar2(255 CHAR) NULL,
  parent_external_key  varchar2(255 CHAR) NULL,
  parent_version  varchar2(255 CHAR) NULL,
  page_number  number(10) NOT NULL
,CONSTRAINT pk_document_mapper PRIMARY KEY (doc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOC_FOLDER

--METADATA NAME:DOC_FOLDER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_FOLDER(
  doc_folder_id  number(10) NOT NULL,
  doc_folder_name  varchar2(255 CHAR) NOT NULL,
  parent_folder_id  number(10) NULL,
  folder_comment  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_doc_folder PRIMARY KEY (doc_folder_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOC_RECENT

--METADATA NAME:DOC_RECENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_RECENT(
  doc_recent_id  number(10) NOT NULL,
  doc_user_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  doc_folder_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_doc_recent PRIMARY KEY (doc_recent_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOC_VERSION

--METADATA NAME:DOC_VERSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_VERSION(
  doc_version_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  doc_uuid  varchar2(255 CHAR) NULL,
  version  varchar2(255 CHAR) NULL,
  doc_size  number(10) NULL,
  version_comment  varchar2(4000 CHAR) NULL,
  doc_data  BLOB NULL,
  doc_scan_status  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_doc_version PRIMARY KEY (doc_version_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(doc_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table EPSHIERARCHY

--METADATA NAME:EPSHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE EPSHIERARCHY(
  parentobjectid  number(10) NULL,
  parentprojectid  number(10) NULL,
  parentsequencenumber  number(10) NULL,
  parentname  varchar2(100 CHAR) NULL,
  parentid  varchar2(40 CHAR) NULL,
  childobjectid  number(10) NULL,
  childprojectid  number(10) NULL,
  childsequencenumber  number(10) NULL,
  childname  varchar2(100 CHAR) NULL,
  childid  varchar2(40 CHAR) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table EPSSPREAD

--METADATA NAME:EPSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE EPSSPREAD(
  objectid  number(10) NULL,
  id  varchar2(40 CHAR) NULL,
  name  varchar2(100 CHAR) NULL,
  parentobjectid  number(10) NULL,
  projectobjectid  number(10) NULL,
  obsobjectid  number(10) NULL,
  obsname  varchar2(100 CHAR) NULL,
  startdate  DATE NULL,
  enddate  DATE NULL,
  actuallaborunits  number(23,6) NULL,
  actualnonlaborunits  number(23,6) NULL,
  atcompletionlaborunits  number(23,6) NULL,
  atcompletionnonlaborunits  number(23,6) NULL,
  baselineplannedlaborunits  number(23,6) NULL,
  baselineplannednonlaborunits  number(23,6) NULL,
  earnedvaluelaborunits  number(23,6) NULL,
  estimateatcompletionlaborunits  number(23,6) NULL,
  estimatetocompletelaborunits  number(23,6) NULL,
  plannedvaluelaborunits  number(23,6) NULL,
  remaininglaborunits  number(23,6) NULL,
  remainingnonlaborunits  number(23,6) NULL,
  actualcost  number(23,6) NULL,
  actualexpensecost  number(23,6) NULL,
  actuallaborcost  number(23,6) NULL,
  actualmaterialcost  number(23,6) NULL,
  actualnonlaborcost  number(23,6) NULL,
  actualtotalcost  number(23,6) NULL,
  atcompletionexpensecost  number(23,6) NULL,
  atcompletionlaborcost  number(23,6) NULL,
  atcompletionmaterialcost  number(23,6) NULL,
  atcompletionnonlaborcost  number(23,6) NULL,
  atcompletiontotalcost  number(23,6) NULL,
  baselineplannedexpensecost  number(23,6) NULL,
  baselineplannedlaborcost  number(23,6) NULL,
  baselineplannedmaterialcost  number(23,6) NULL,
  baselineplannednonlaborcost  number(23,6) NULL,
  baselineplannedtotalcost  number(23,6) NULL,
  earnedvaluecost  number(23,6) NULL,
  estimateatcompletioncost  number(23,6) NULL,
  estimatetocompletecost  number(23,6) NULL,
  plannedvaluecost  number(23,6) NULL,
  remainingexpensecost  number(23,6) NULL,
  remaininglaborcost  number(23,6) NULL,
  remainingmaterialcost  number(23,6) NULL,
  remainingnonlaborcost  number(23,6) NULL,
  remainingtotalcost  number(23,6) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table GATEWAYDEPLOYMENT

--METADATA NAME:GATEWAYDEPLOYMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYDEPLOYMENT(
  deplmnt_id  number(10) NOT NULL,
  deployment_name  varchar2(255 CHAR) NOT NULL,
  provider_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_deplmnt_id PRIMARY KEY (deplmnt_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table GATEWAYPROVIDER

--METADATA NAME:GATEWAYPROVIDER TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYPROVIDER(
  provider_id  number(10) NOT NULL,
  provider_name  varchar2(255 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_provider_id PRIMARY KEY (provider_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table GATEWAYSYNCACTION

--METADATA NAME:GATEWAYSYNCACTION TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYSYNCACTION(
  action_id  number(10) NOT NULL,
  sync_type  varchar2(25 CHAR) NOT NULL,
  sync_name  varchar2(255 CHAR) NOT NULL,
  sync_id  number(10) NULL,
  action_name  varchar2(255 CHAR) NOT NULL,
  deplmnt_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_action_id PRIMARY KEY (action_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table GLOBALSECURITY

--METADATA NAME:GLOBALSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE GLOBALSECURITY(
  rdbmsuserid  number(10) NULL,
  securecodeflag  varchar2(1 CHAR) NULL,
  resourcecostflag  varchar2(1 CHAR) NULL,
  proficiencyflag  varchar2(1 CHAR) NULL,
  auditdataflag  varchar2(1 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table GREPLACE

--METADATA NAME:GREPLACE TYPE:TABLE CHANGE:CREATE

CREATE TABLE GREPLACE(
  greplace_id  number(10) NOT NULL,
  greplace_name  varchar2(40 CHAR) NULL,
  greplace_data  BLOB NULL,
  user_id  number(10) NULL,
  table_name  varchar2(30 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL,
  template_type  varchar2(7 CHAR) NULL
,CONSTRAINT pk_greplace PRIMARY KEY (greplace_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(greplace_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table GTT_CPP_COUNTS

--METADATA NAME:GTT_CPP_COUNTS TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE GTT_CPP_COUNTS(
  proj_id  number(10) NULL,
  key_name  varchar2(100 CHAR) NOT NULL,
  cnt  number(10) NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table GTT_PKLIST

--METADATA NAME:GTT_PKLIST TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE GTT_PKLIST(
  pk_id  number(10) NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table ITERTASK

--METADATA NAME:ITERTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERTASK(
  iteration_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_itertask PRIMARY KEY (iteration_id,task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ITERTEAM

--METADATA NAME:ITERTEAM TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERTEAM(
  iteration_id  number(10) NOT NULL,
  rfolio_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_iterteam PRIMARY KEY (iteration_id,rfolio_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table JOBPROJ_LKP

--METADATA NAME:JOBPROJ_LKP TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBPROJ_LKP(
  jobproj_lkp_id  number(10) NOT NULL,
  job_id  number(10) NULL,
  proj_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table JOBSET

--METADATA NAME:JOBSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBSET(
  job_id  number(10) NOT NULL,
  setting_name  varchar2(255 CHAR) NOT NULL,
  setting_value  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_jobset PRIMARY KEY (job_id,setting_name)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table LEANTASK

--METADATA NAME:LEANTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE LEANTASK(
  lean_task_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  task_type  varchar2(255 CHAR) NOT NULL,
  seq_num  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  lean_task_name  varchar2(120 CHAR) NULL,
  lean_task_short_name  varchar2(30 CHAR) NOT NULL,
  start_date  DATE NULL,
  use_only_work_days  varchar2(1 CHAR) NULL,
  completed_date  DATE NULL,
  due_date  DATE NULL,
  duration  NUMBER NULL,
  company  varchar2(255 CHAR) NULL,
  overdue  varchar2(1 CHAR) NULL,
  status  varchar2(255 CHAR) NULL,
  status_cmpl  varchar2(255 CHAR) NULL,
  status_dts  varchar2(255 CHAR) NULL,
  imp_tsk_flag  varchar2(1 CHAR) NULL,
  proposed_due_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_leantask PRIMARY KEY (lean_task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table MTXSCRTYP

--METADATA NAME:MTXSCRTYP TYPE:TABLE CHANGE:CREATE

CREATE TABLE MTXSCRTYP(
  matrix_id  number(10) NOT NULL,
  scoretype_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_mtxscrtyp PRIMARY KEY (matrix_id,scoretype_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PAUDIT

--METADATA NAME:PAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PAUDIT(
  audit_ts  TIMESTAMP(6) NULL,
  table_name  varchar2(30 CHAR) NULL,
  tx_ident  varchar2(30 CHAR) NULL,
  pk1  varchar2(255 CHAR) NULL,
  pk2  varchar2(255 CHAR) NULL,
  pk3  varchar2(255 CHAR) NULL,
  pk4  varchar2(255 CHAR) NULL,
  proj_id  number(10) NULL,
  oper  varchar2(1 CHAR) NULL,
  prm_user_name  varchar2(255 CHAR) NULL,
  audit_old  varchar2(4000 CHAR) NULL,
  audit_new  varchar2(4000 CHAR) NULL,
  audit_ext_old  BLOB NULL,
  audit_ext_new  BLOB NULL,
  logical_delete_flag  varchar2(1 CHAR) NULL,
  rdbms_user_name  varchar2(255 CHAR) NULL,
  os_user_name  varchar2(255 CHAR) NULL,
  program  varchar2(255 CHAR) NULL,
  host_name  varchar2(255 CHAR) NULL,
  app_name  varchar2(25 CHAR) NULL,
  netaddress  varchar2(64 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(audit_ext_old) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
,LOB(audit_ext_new) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PAUDITX

--METADATA NAME:PAUDITX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PAUDITX(
  table_name  varchar2(30 CHAR) NULL,
  tab_primary_keys  varchar2(4000 CHAR) NULL,
  tab_col_name  varchar2(4000 CHAR) NULL,
  bo_name  varchar2(100 CHAR) NULL,
  bo_field_name  varchar2(100 CHAR) NULL,
  bo_field_type  varchar2(100 CHAR) NULL,
  old_value  varchar2(4000 CHAR) NULL,
  new_value  varchar2(4000 CHAR) NULL,
  ref_old_value_name  varchar2(4000 CHAR) NULL,
  ref_new_value_name  varchar2(4000 CHAR) NULL,
  ref_udf_code_type_label  varchar2(100 CHAR) NULL,
  proj_id  number(10) NULL,
  proj_short_name  varchar2(40 CHAR) NULL,
  proj_name  varchar2(100 CHAR) NULL,
  activity_id  varchar2(40 CHAR) NULL,
  activity_name  varchar2(120 CHAR) NULL,
  oper  varchar2(1 CHAR) NULL,
  prm_user_name  varchar2(255 CHAR) NULL,
  host_name  varchar2(255 CHAR) NULL,
  app_name  varchar2(25 CHAR) NULL,
  audit_ts  TIMESTAMP(6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PCATUSERX

--METADATA NAME:PCATUSERX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATUSERX(
  proj_catg_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  codetypeobjectid  number(10) NULL,
  codevalue  varchar2(255 CHAR) NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectcodeuserx PRIMARY KEY (proj_catg_id,user_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PCATVALX

--METADATA NAME:PCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATVALX(
  proj_catg_id  number(10) NOT NULL,
  codetypename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectcodex PRIMARY KEY (proj_catg_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PC_KEY_XREF

--METADATA NAME:PC_KEY_XREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PC_KEY_XREF(
  execution_id  number(10) NULL,
  ref_table  varchar2(30 CHAR) NULL,
  source_id  number(10) NULL,
  new_id  number(10) NULL,
  new_value  varchar2(100 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PC_PROCESS_STAT

--METADATA NAME:PC_PROCESS_STAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PC_PROCESS_STAT(
  pc_process_stat_id  number(18) NOT NULL,
  execution_id  number(10) NULL,
  process_name  varchar2(60 CHAR) NULL,
  step_name  varchar2(60 CHAR) NULL,
  status  varchar2(10 CHAR) NULL,
  start_ts  TIMESTAMP(6) NULL,
  end_ts  TIMESTAMP(6) NULL,
  estimated_time  number(17,6) NULL,
  actual_time  number(17,6) NULL,
  row_processed  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pc_process_stat PRIMARY KEY (pc_process_stat_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PFOLIOX

--METADATA NAME:PFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIOX(
  pfolio_id  number(10) NOT NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectportfoliox PRIMARY KEY (pfolio_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PLPROJREF

--METADATA NAME:PLPROJREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PLPROJREF(
  proj_id  number(10) NOT NULL,
  ref_cnt  number(10) NOT NULL,
  last_queued_date  DATE NULL
,CONSTRAINT pk_plprojref PRIMARY KEY (proj_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROFPRIVX

--METADATA NAME:PROFPRIVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFPRIVX(
  prof_id  number(10) NOT NULL,
  priv_num  number(10) NOT NULL,
  privlegename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_userprofileprivilegex PRIMARY KEY (prof_id,priv_num)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJCOSTX

--METADATA NAME:PROJCOSTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJCOSTX(
  cost_item_id  number(10) NOT NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  actualunits  NUMBER NULL,
  atcompletioncost  NUMBER NULL,
  atcompletionunits  NUMBER NULL,
  costaccountid  varchar2(255 CHAR) NULL,
  costaccountname  varchar2(255 CHAR) NULL,
  expensecategoryname  varchar2(255 CHAR) NULL,
  expensepercentcomplete  NUMBER NULL,
  overbudget  varchar2(1 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  remainingunits  NUMBER NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activityexpensex PRIMARY KEY (cost_item_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PROJDEPLMENT

--METADATA NAME:PROJDEPLMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJDEPLMENT(
  proj_deplmnt_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  deplmnt_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_proj_deplmnt_id PRIMARY KEY (proj_deplmnt_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECTCODEHIERARCHY

--METADATA NAME:PROJECTCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTCODEHIERARCHY(
  codetypeobjectid  number(10) NOT NULL,
  codetypename  varchar2(60 CHAR) NOT NULL,
  codetypesequencenumber  number(10) NOT NULL,
  codetypeissecure  varchar2(1 CHAR) NOT NULL,
  parentcodevalueobjectid  number(10) NULL,
  parentcodevaluename  varchar2(100 CHAR) NULL,
  parentcodevalueshortname  varchar2(60 CHAR) NULL,
  parentcodevaluesequencenumber  number(10) NULL,
  childcodevalueobjectid  number(10) NULL,
  childcodevaluename  varchar2(100 CHAR) NULL,
  childcodevalueshortname  varchar2(60 CHAR) NULL,
  childcodevaluesequencenumber  number(10) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL,
  codetypeweight  number(23,6) NULL,
  maxcodevalueweight  number(23,6) NULL,
  parentcodevalueweight  number(23,6) NULL,
  childcodevalueweight  number(23,6) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECTCOSTCBSSPREAD

--METADATA NAME:PROJECTCOSTCBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTCOSTCBSSPREAD(
  cost_type_id  number(10) NOT NULL,
  cbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  spread_date  DATE NULL,
  target_qty  number(22,6) NULL,
  act_qty  number(22,6) NULL,
  act_this_per_qty  number(22,6) NULL,
  remain_qty  number(22,6) NULL,
  total_qty  number(22,6) NULL,
  total_period_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  act_cost  number(25,6) NULL,
  act_this_period_cost  number(25,6) NULL,
  remain_cost  number(25,6) NULL,
  total_cost  number(25,6) NULL,
  total_period_cost  number(25,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECTSECURITY

--METADATA NAME:PROJECTSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTSECURITY(
  rdbmsuserid  number(10) NULL,
  projectobjectid  number(10) NULL,
  costflag  varchar2(1 CHAR) NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECTSPREAD

--METADATA NAME:PROJECTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTSPREAD(
  objectid  number(10) NULL,
  id  varchar2(40 CHAR) NULL,
  name  varchar2(100 CHAR) NULL,
  parentepsobjectid  number(10) NULL,
  obsobjectid  number(10) NULL,
  obsname  varchar2(100 CHAR) NULL,
  startdate  DATE NULL,
  enddate  DATE NULL,
  actuallaborunits  number(23,6) NULL,
  actualnonlaborunits  number(23,6) NULL,
  atcompletionlaborunits  number(23,6) NULL,
  atcompletionnonlaborunits  number(23,6) NULL,
  baselineplannedlaborunits  number(23,6) NULL,
  baselineplannednonlaborunits  number(23,6) NULL,
  earnedvaluelaborunits  number(23,6) NULL,
  estimateatcompletionlaborunits  number(23,6) NULL,
  estimatetocompletelaborunits  number(23,6) NULL,
  plannedlaborunits  number(23,6) NULL,
  plannednonlaborunits  number(23,6) NULL,
  plannedvaluelaborunits  number(23,6) NULL,
  remaininglaborunits  number(23,6) NULL,
  remainingnonlaborunits  number(23,6) NULL,
  actualcost  number(23,6) NULL,
  actualexpensecost  number(23,6) NULL,
  actuallaborcost  number(23,6) NULL,
  actualmaterialcost  number(23,6) NULL,
  actualnonlaborcost  number(23,6) NULL,
  actualtotalcost  number(23,6) NULL,
  atcompletionexpensecost  number(23,6) NULL,
  atcompletionlaborcost  number(23,6) NULL,
  atcompletionmaterialcost  number(23,6) NULL,
  atcompletionnonlaborcost  number(23,6) NULL,
  atcompletiontotalcost  number(23,6) NULL,
  baselineplannedexpensecost  number(23,6) NULL,
  baselineplannedlaborcost  number(23,6) NULL,
  baselineplannedmaterialcost  number(23,6) NULL,
  baselineplannednonlaborcost  number(23,6) NULL,
  baselineplannedtotalcost  number(23,6) NULL,
  earnedvaluecost  number(23,6) NULL,
  estimateatcompletioncost  number(23,6) NULL,
  estimatetocompletecost  number(23,6) NULL,
  plannedexpensecost  number(23,6) NULL,
  plannedlaborcost  number(23,6) NULL,
  plannedmaterialcost  number(23,6) NULL,
  plannednonlaborcost  number(23,6) NULL,
  plannedtotalcost  number(23,6) NULL,
  plannedvaluecost  number(23,6) NULL,
  remainingexpensecost  number(23,6) NULL,
  remaininglaborcost  number(23,6) NULL,
  remainingmaterialcost  number(23,6) NULL,
  remainingnonlaborcost  number(23,6) NULL,
  remainingtotalcost  number(23,6) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECTX

--METADATA NAME:PROJECTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTX(
  proj_id  number(10) NOT NULL,
  annualdiscountrate  NUMBER NULL,
  anticipatedfinishdate  DATE NULL,
  anticipatedstartdate  DATE NULL,
  containssummarydata  varchar2(1 CHAR) NULL,
  currentbudget  NUMBER NULL,
  currentvariance  NUMBER NULL,
  datadate  DATE NULL,
  discountapplicationperiod  varchar2(24 CHAR) NULL,
  distributedcurrentbudget  NUMBER NULL,
  earnedvaluecomputetype  varchar2(255 CHAR) NULL,
  earnedvalueetccomputetype  varchar2(255 CHAR) NULL,
  earnedvalueetcuservalue  NUMBER NULL,
  earnedvalueuserpercent  NUMBER NULL,
  finishdate  DATE NULL,
  forecastfinishdate  DATE NULL,
  forecaststartdate  DATE NULL,
  independentetclaborunits  NUMBER NULL,
  independentetctotalcost  NUMBER NULL,
  last_fin_dates_id  number(10) NULL,
  name  varchar2(255 CHAR) NULL,
  obsname  varchar2(255 CHAR) NULL,
  obsobjectid  number(10) NULL,
  originalbudget  NUMBER NULL,
  overallprojectscore  NUMBER NULL,
  parentepsobjectid  number(10) NULL,
  proposedbudget  NUMBER NULL,
  risklevel  varchar2(24 CHAR) NULL,
  riskscore  number(10) NULL,
  riskexposure  NUMBER NULL,
  startdate  DATE NULL,
  status  varchar2(24 CHAR) NULL,
  sumaccountingvarbylaborunits  NUMBER NULL,
  sumaccountingvariancebycost  NUMBER NULL,
  sumactthisperiodmaterialcost  NUMBER NULL,
  sumactthisperiodnonlaborcost  NUMBER NULL,
  sumactthisperiodnonlaborunits  NUMBER NULL,
  sumactualthisperiodlaborcost  NUMBER NULL,
  sumactualthisperiodlaborunits  NUMBER NULL,
  sumatcompletionmaterialcost  NUMBER NULL,
  sumatcompletionnonlaborcost  NUMBER NULL,
  sumatcompletionnonlaborunits  NUMBER NULL,
  sumatcompletiontotalcostvar  NUMBER NULL,
  sumbaselinecompactivitycount  NUMBER NULL,
  sumbaselinenotstartedactcnt  NUMBER NULL,
  sumblinprogressactivitycount  NUMBER NULL,
  sumbudgetatcmpbylaborunits  NUMBER NULL,
  sumbudgetatcompletionbycost  NUMBER NULL,
  sumcostperfindexbycost  NUMBER NULL,
  sumcostperfindexbylaborunits  NUMBER NULL,
  sumcostvariancebylaborunits  NUMBER NULL,
  sumcostvarindexbylaborunits  NUMBER NULL,
  sumdurationpercentofplanned  NUMBER NULL,
  sumeacbycost  NUMBER NULL,
  sumeacbylaborunits  NUMBER NULL,
  sumeachighpctbylaborunits  NUMBER NULL,
  sumeaclowpctbylaborunits  NUMBER NULL,
  sumetcbycost  NUMBER NULL,
  sumetcbylaborunits  NUMBER NULL,
  sumexpensecostpctcomplete  NUMBER NULL,
  sumlaborcostpercentcomplete  NUMBER NULL,
  sumlaborunitspercentcomplete  NUMBER NULL,
  sumactivitycount  NUMBER NULL,
  sumactualduration  NUMBER NULL,
  sumactualexpensecost  NUMBER NULL,
  sumactualfinishdate  DATE NULL,
  summaxactualfinishdate  DATE NULL,
  summaxrestartdate  DATE NULL,
  sumactuallaborcost  NUMBER NULL,
  sumactuallaborunits  NUMBER NULL,
  sumactualmaterialcost  NUMBER NULL,
  sumactualnonlaborcost  NUMBER NULL,
  sumactualnonlaborunits  NUMBER NULL,
  sumactualstartdate  DATE NULL,
  sumactualthisperiodcost  NUMBER NULL,
  sumactualtotalcost  NUMBER NULL,
  sumactualvaluebycost  NUMBER NULL,
  sumactualvaluebylaborunits  NUMBER NULL,
  sumatcompletionduration  NUMBER NULL,
  sumatcompletionexpensecost  NUMBER NULL,
  sumatcompletionlaborcost  NUMBER NULL,
  sumatcompletionlaborunits  NUMBER NULL,
  sumatcompletiontotalcost  NUMBER NULL,
  sumbaselineduration  NUMBER NULL,
  sumbaselineexpensecost  NUMBER NULL,
  sumbaselinefinishdate  DATE NULL,
  sumbaselinelaborcost  NUMBER NULL,
  sumbaselinelaborunits  NUMBER NULL,
  sumbaselinematerialcost  NUMBER NULL,
  sumbaselinenonlaborcost  NUMBER NULL,
  sumbaselinenonlaborunits  NUMBER NULL,
  sumbaselinestartdate  DATE NULL,
  sumbaselinetotalcost  NUMBER NULL,
  sumcompletedactivitycount  NUMBER NULL,
  sumcostpercentcomplete  NUMBER NULL,
  sumcostpercentofplanned  NUMBER NULL,
  sumcostvariancebycost  NUMBER NULL,
  sumcostvarianceindex  NUMBER NULL,
  sumcostvarianceindexbycost  NUMBER NULL,
  sumdurationpercentcomplete  NUMBER NULL,
  sumdurationvariance  NUMBER NULL,
  sumearnedvaluebycost  NUMBER NULL,
  sumearnedvaluebylaborunits  NUMBER NULL,
  sumexpensecostvariance  NUMBER NULL,
  sumfinishdatevariance  NUMBER NULL,
  suminprogressactivitycount  NUMBER NULL,
  sumlaborcostvariance  NUMBER NULL,
  sumlaborunitsvariance  NUMBER NULL,
  summaterialcostvariance  NUMBER NULL,
  sumnonlaborcostvariance  NUMBER NULL,
  sumnonlaborunitsvariance  NUMBER NULL,
  sumnotstartedactivitycount  NUMBER NULL,
  sumplannedvaluebycost  NUMBER NULL,
  sumprogressfinishdate  DATE NULL,
  sumremainingduration  NUMBER NULL,
  sumremainingexpensecost  NUMBER NULL,
  sumremainingfinishdate  DATE NULL,
  sumremaininglaborcost  NUMBER NULL,
  sumremaininglaborunits  NUMBER NULL,
  sumremainingmaterialcost  NUMBER NULL,
  sumremainingnonlaborcost  NUMBER NULL,
  sumremainingnonlaborunits  NUMBER NULL,
  sumremainingstartdate  DATE NULL,
  sumremainingtotalcost  NUMBER NULL,
  sumschedulepercentcomplete  NUMBER NULL,
  sumperformancepercentcomplete  NUMBER NULL,
  sumschedulevariancebycost  NUMBER NULL,
  sumschedulevarianceindex  NUMBER NULL,
  sumstartdatevariance  NUMBER NULL,
  sumtotalcostvariance  NUMBER NULL,
  sumtotalfloat  NUMBER NULL,
  sumunitspercentcomplete  NUMBER NULL,
  summaterialcostpctcomplete  NUMBER NULL,
  sumnonlaborcostpctcomplete  NUMBER NULL,
  sumnonlaborunitspctcomplete  NUMBER NULL,
  sumperfpctcmpbylaborunits  NUMBER NULL,
  sumplannedvaluebylaborunits  NUMBER NULL,
  sumschdpctcmpbylaborunits  NUMBER NULL,
  sumschdperfindexbylaborunits  NUMBER NULL,
  sumschdvariancebylaborunits  NUMBER NULL,
  sumschdvarianceindexbycost  NUMBER NULL,
  sumschdvarindexbylaborunits  NUMBER NULL,
  sumscheduleperfindexbycost  NUMBER NULL,
  sumtocompleteperfindexbycost  NUMBER NULL,
  sumvaratcmpbylaborunits  NUMBER NULL,
  sumearlystartdate  DATE NULL,
  sumearlyenddate  DATE NULL,
  sumlatestartdate  DATE NULL,
  sumlateenddate  DATE NULL,
  summaxcalendarid  NUMBER NULL,
  summincalendarid  NUMBER NULL,
  totalbenefitplan  NUMBER NULL,
  totalbenefitplantally  NUMBER NULL,
  totalfunding  NUMBER NULL,
  totalspendingplan  NUMBER NULL,
  totalspendingplantally  NUMBER NULL,
  unallocatedbudget  NUMBER NULL,
  undistributedcurrentvariance  NUMBER NULL,
  sumactualprogressdate  DATE NULL,
  netpresentvalue  number(23,6) NULL,
  returnoninvestment  number(23,6) NULL,
  paybackperiod  number(10) NULL,
  sumplannedstartdate  DATE NULL,
  sumplannedfinishdate  DATE NULL,
  sumplannedduration  NUMBER NULL,
  sumplannedlaborunits  NUMBER NULL,
  sumplannednonlaborunits  NUMBER NULL,
  sumplannedlaborcost  NUMBER NULL,
  sumplannednonlaborcost  NUMBER NULL,
  sumplannedexpensecost  NUMBER NULL,
  sumplannedmaterialcost  NUMBER NULL,
  sumplannedtotalcost  NUMBER NULL,
  locationname  varchar2(255 CHAR) NULL,
  fintmpl_id  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_dim_hash  NUMBER DEFAULT 0 NULL,
  update_dim_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectx PRIMARY KEY (proj_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJECT_ETL_LIST

--METADATA NAME:PROJECT_ETL_LIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECT_ETL_LIST(
  etl_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
,CONSTRAINT pk_project_etl_list PRIMARY KEY (etl_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJFUNDX

--METADATA NAME:PROJFUNDX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJFUNDX(
  proj_fund_id  number(10) NOT NULL,
  epsid  varchar2(255 CHAR) NULL,
  epsname  varchar2(255 CHAR) NULL,
  epsobjectid  number(10) NULL,
  projectid  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectfundingx PRIMARY KEY (proj_fund_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PROJISSUX

--METADATA NAME:PROJISSUX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJISSUX(
  issue_id  number(10) NOT NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  obsname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  rawtextnote  CLOB NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectissuex PRIMARY KEY (issue_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rawtextnote) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
NOLOGGING

/

prompt Creating table PROJPCATX

--METADATA NAME:PROJPCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPCATX(
  proj_id  number(10) NOT NULL,
  proj_catg_type_id  number(10) NOT NULL,
  projectcodedescription  varchar2(255 CHAR) NULL,
  projectcodetypename  varchar2(255 CHAR) NULL,
  projectcodevalue  varchar2(255 CHAR) NULL,
  projectname  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectcodeassignmentx PRIMARY KEY (proj_id,proj_catg_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PROJSET

--METADATA NAME:PROJSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJSET(
  proj_id  number(10) NOT NULL,
  setting_name  varchar2(255 CHAR) NOT NULL,
  setting_value  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_projset PRIMARY KEY (proj_id,setting_name)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJWBSX

--METADATA NAME:PROJWBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWBSX(
  wbs_id  number(10) NOT NULL,
  id  varchar2(255 CHAR) NULL,
  lastsummarizeddate  DATE NULL,
  plannedstartdate  DATE NULL,
  totalfunding  NUMBER NULL,
  currentbudget  NUMBER NULL,
  currentvariance  NUMBER NULL,
  distributedcurrentbudget  NUMBER NULL,
  finishdate  DATE NULL,
  forecastfinishdate  DATE NULL,
  forecaststartdate  DATE NULL,
  fullname  varchar2(2000 CHAR) NULL,
  fullsequence  varchar2(2000 CHAR) NULL,
  obsname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  proposedbudget  NUMBER NULL,
  startdate  DATE NULL,
  sumaccountingvarbylaborunits  NUMBER NULL,
  sumaccountingvariancebycost  NUMBER NULL,
  sumactthisperiodmaterialcost  NUMBER NULL,
  sumactthisperiodnonlaborcost  NUMBER NULL,
  sumactthisperiodnonlaborunits  NUMBER NULL,
  sumactualthisperiodlaborcost  NUMBER NULL,
  sumactualthisperiodlaborunits  NUMBER NULL,
  sumatcompletionmaterialcost  NUMBER NULL,
  sumatcompletionnonlaborcost  NUMBER NULL,
  sumatcompletionnonlaborunits  NUMBER NULL,
  sumatcompletiontotalcostvar  NUMBER NULL,
  sumbaselinecompactivitycount  NUMBER NULL,
  sumbaselinenotstartedactcnt  NUMBER NULL,
  sumblinprogressactivitycount  NUMBER NULL,
  sumbudgetatcmpbylaborunits  NUMBER NULL,
  sumbudgetatcompletionbycost  NUMBER NULL,
  sumcostperfindexbycost  NUMBER NULL,
  sumcostperfindexbylaborunits  NUMBER NULL,
  sumcostvariancebylaborunits  NUMBER NULL,
  sumcostvarindexbylaborunits  NUMBER NULL,
  sumdurationpercentofplanned  NUMBER NULL,
  sumeacbycost  NUMBER NULL,
  sumeacbylaborunits  NUMBER NULL,
  sumeachighpctbylaborunits  NUMBER NULL,
  sumeaclowpctbylaborunits  NUMBER NULL,
  sumetcbycost  NUMBER NULL,
  sumetcbylaborunits  NUMBER NULL,
  sumexpensecostpctcomplete  NUMBER NULL,
  sumlaborcostpercentcomplete  NUMBER NULL,
  sumlaborunitspercentcomplete  NUMBER NULL,
  sumactivitycount  NUMBER NULL,
  sumactualduration  NUMBER NULL,
  sumactualexpensecost  NUMBER NULL,
  sumactualfinishdate  DATE NULL,
  summaxactualfinishdate  DATE NULL,
  summaxrestartdate  DATE NULL,
  sumactuallaborcost  NUMBER NULL,
  sumactuallaborunits  NUMBER NULL,
  sumactualmaterialcost  NUMBER NULL,
  sumactualnonlaborcost  NUMBER NULL,
  sumactualnonlaborunits  NUMBER NULL,
  sumactualstartdate  DATE NULL,
  sumactualthisperiodcost  NUMBER NULL,
  sumactualtotalcost  NUMBER NULL,
  sumactualvaluebycost  NUMBER NULL,
  sumactualvaluebylaborunits  NUMBER NULL,
  sumatcompletionduration  NUMBER NULL,
  sumatcompletionexpensecost  NUMBER NULL,
  sumatcompletionlaborcost  NUMBER NULL,
  sumatcompletionlaborunits  NUMBER NULL,
  sumatcompletiontotalcost  NUMBER NULL,
  sumbaselineduration  NUMBER NULL,
  sumbaselineexpensecost  NUMBER NULL,
  sumbaselinefinishdate  DATE NULL,
  sumbaselinelaborcost  NUMBER NULL,
  sumbaselinelaborunits  NUMBER NULL,
  sumbaselinematerialcost  NUMBER NULL,
  sumbaselinenonlaborcost  NUMBER NULL,
  sumbaselinenonlaborunits  NUMBER NULL,
  sumbaselinestartdate  DATE NULL,
  sumbaselinetotalcost  NUMBER NULL,
  sumcompletedactivitycount  NUMBER NULL,
  sumcostpercentcomplete  NUMBER NULL,
  sumcostpercentofplanned  NUMBER NULL,
  sumcostvariancebycost  NUMBER NULL,
  sumcostvarianceindex  NUMBER NULL,
  sumcostvarianceindexbycost  NUMBER NULL,
  sumdurationpercentcomplete  NUMBER NULL,
  sumdurationvariance  NUMBER NULL,
  sumearnedvaluebycost  NUMBER NULL,
  sumearnedvaluebylaborunits  NUMBER NULL,
  sumexpensecostvariance  NUMBER NULL,
  sumfinishdatevariance  NUMBER NULL,
  suminprogressactivitycount  NUMBER NULL,
  sumlaborcostvariance  NUMBER NULL,
  sumlaborunitsvariance  NUMBER NULL,
  summaterialcostvariance  NUMBER NULL,
  sumnonlaborcostvariance  NUMBER NULL,
  sumnonlaborunitsvariance  NUMBER NULL,
  sumnotstartedactivitycount  NUMBER NULL,
  sumplannedvaluebycost  NUMBER NULL,
  sumprogressfinishdate  DATE NULL,
  sumremainingduration  NUMBER NULL,
  sumremainingexpensecost  NUMBER NULL,
  sumremainingfinishdate  DATE NULL,
  sumremaininglaborcost  NUMBER NULL,
  sumremaininglaborunits  NUMBER NULL,
  sumremainingmaterialcost  NUMBER NULL,
  sumremainingnonlaborcost  NUMBER NULL,
  sumremainingnonlaborunits  NUMBER NULL,
  sumremainingstartdate  DATE NULL,
  sumremainingtotalcost  NUMBER NULL,
  sumschedulepercentcomplete  NUMBER NULL,
  sumperformancepercentcomplete  NUMBER NULL,
  sumschedulevariancebycost  NUMBER NULL,
  sumschedulevarianceindex  NUMBER NULL,
  sumstartdatevariance  NUMBER NULL,
  sumtotalcostvariance  NUMBER NULL,
  sumtotalfloat  NUMBER NULL,
  sumunitspercentcomplete  NUMBER NULL,
  summaterialcostpctcomplete  NUMBER NULL,
  sumnonlaborcostpctcomplete  NUMBER NULL,
  sumnonlaborunitspctcomplete  NUMBER NULL,
  sumperfpctcmpbylaborunits  NUMBER NULL,
  sumplannedvaluebylaborunits  NUMBER NULL,
  sumschdpctcmpbylaborunits  NUMBER NULL,
  sumschdperfindexbylaborunits  NUMBER NULL,
  sumschdvariancebylaborunits  NUMBER NULL,
  sumschdvarianceindexbycost  NUMBER NULL,
  sumschdvarindexbylaborunits  NUMBER NULL,
  sumscheduleperfindexbycost  NUMBER NULL,
  sumtocompleteperfindexbycost  NUMBER NULL,
  sumvaratcmpbylaborunits  NUMBER NULL,
  sumearlystartdate  DATE NULL,
  sumearlyenddate  DATE NULL,
  sumlatestartdate  DATE NULL,
  sumlateenddate  DATE NULL,
  summaxcalendarid  NUMBER NULL,
  summincalendarid  NUMBER NULL,
  totalbenefitplan  NUMBER NULL,
  totalbenefitplantally  NUMBER NULL,
  totalspendingplan  NUMBER NULL,
  totalspendingplantally  NUMBER NULL,
  unallocatedbudget  NUMBER NULL,
  undistributedcurrentvariance  NUMBER NULL,
  sumactualprogressdate  DATE NULL,
  sumplannedstartdate  DATE NULL,
  sumplannedfinishdate  DATE NULL,
  sumplannedduration  NUMBER NULL,
  sumplannedlaborunits  NUMBER NULL,
  sumplannednonlaborunits  NUMBER NULL,
  sumplannedlaborcost  NUMBER NULL,
  sumplannednonlaborcost  NUMBER NULL,
  sumplannedexpensecost  NUMBER NULL,
  sumplannedmaterialcost  NUMBER NULL,
  sumplannedtotalcost  NUMBER NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_dim_hash  NUMBER DEFAULT 0 NULL,
  update_dim_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_wbsx PRIMARY KEY (wbs_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table PXJOBRUN

--METADATA NAME:PXJOBRUN TYPE:TABLE CHANGE:CREATE

CREATE TABLE PXJOBRUN(
  jobrun_id  number(10) NOT NULL,
  job_type  varchar2(20 CHAR) NOT NULL,
  job_type_key  varchar2(255 CHAR) NULL,
  job_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  run_start_date  DATE NULL,
  run_end_date  DATE NULL,
  run_duration  number(10) NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  recur_data  varchar2(255 CHAR) NULL,
  recur_type  varchar2(20 CHAR) NULL,
  submitted_date  DATE NULL,
  last_error_descr  varchar2(255 CHAR) NULL,
  jab_data  BLOB NULL,
  worker_host  varchar2(50 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pxjobrun PRIMARY KEY (jobrun_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(jab_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RCATVALX

--METADATA NAME:RCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATVALX(
  rsrc_catg_id  number(10) NOT NULL,
  codetypename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcecodex PRIMARY KEY (rsrc_catg_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RELITER

--METADATA NAME:RELITER TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELITER(
  release_id  number(10) NOT NULL,
  iteration_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_reliter PRIMARY KEY (release_id,iteration_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RELPROJ

--METADATA NAME:RELPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELPROJ(
  release_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_relproj PRIMARY KEY (release_id,proj_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table REPORTDATE

--METADATA NAME:REPORTDATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE REPORTDATE(
  datename  number(10) NULL,
  daydate  DATE NULL,
  dayname  varchar2(20 CHAR) NULL,
  dayofmonth  number(10) NULL,
  dayofyear  number(10) NULL,
  ordinaldayofmonth  varchar2(4 CHAR) NULL,
  ordinaldayofyear  varchar2(5 CHAR) NULL,
  weekbegindate  DATE NULL,
  dayofweek  number(10) NULL,
  weeknumber  number(10) NULL,
  monthnumber  number(10) NULL,
  monthname  varchar2(10 CHAR) NULL,
  monthshortname  varchar2(5 CHAR) NULL,
  monthenddate  DATE NULL,
  daysinmonth  number(10) NULL,
  yearmonth  number(10) NULL,
  quarternumber  number(10) NULL,
  quartername  varchar2(6 CHAR) NULL,
  year  number(10) NULL,
  etlprocess  DATE NULL,
  etluser  varchar2(255 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table REPORTTIME

--METADATA NAME:REPORTTIME TYPE:TABLE CHANGE:CREATE

CREATE TABLE REPORTTIME(
  civiliantime  varchar2(5 CHAR) NULL,
  militarytime  varchar2(4 CHAR) NULL,
  twochar  varchar2(2 CHAR) NULL,
  timename  varchar2(2 CHAR) NULL,
  timeofday  number(10) NULL,
  etlprocess  DATE NULL,
  etluser  varchar2(255 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RESOURCEASSIGNMENTCBSSPREAD

--METADATA NAME:RESOURCEASSIGNMENTCBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEASSIGNMENTCBSSPREAD(
  rsrc_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  cbs_id  number(10) NOT NULL,
  spread_date  DATE NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  restart_date  DATE NULL,
  reend_date  DATE NULL,
  target_qty  number(22,6) NULL,
  act_qty  number(22,6) NULL,
  act_this_per_qty  number(22,6) NULL,
  remain_qty  number(22,6) NULL,
  total_qty  number(22,6) NULL,
  total_period_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  act_cost  number(25,6) NULL,
  act_this_period_cost  number(25,6) NULL,
  remain_cost  number(25,6) NULL,
  total_cost  number(25,6) NULL,
  total_period_cost  number(25,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RESOURCEASSIGNMENTSPREAD

--METADATA NAME:RESOURCEASSIGNMENTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEASSIGNMENTSPREAD(
  resourceassignmentobjectid  number(10) NOT NULL,
  startdate  DATE NOT NULL,
  enddate  DATE NOT NULL,
  resourceobjectid  number(10) NULL,
  roleobjectid  number(10) NULL,
  activityobjectid  number(10) NOT NULL,
  wbsobjectid  number(10) NOT NULL,
  projectobjectid  number(10) NOT NULL,
  costaccountobjectid  number(10) NULL,
  actualregularunits  NUMBER NULL,
  actualovertimeunits  NUMBER NULL,
  actualunits  NUMBER NULL,
  atcompletionunits  NUMBER NULL,
  plannedunits  NUMBER NULL,
  remainingunits  NUMBER NULL,
  remaininglateunits  NUMBER NULL,
  staffedremainingunits  NUMBER NULL,
  staffedremaininglateunits  NUMBER NULL,
  unstaffedremainingunits  NUMBER NULL,
  unstaffedremaininglateunits  NUMBER NULL,
  actualregularcost  NUMBER NULL,
  actualovertimecost  NUMBER NULL,
  actualcost  NUMBER NULL,
  atcompletioncost  NUMBER NULL,
  plannedcost  NUMBER NULL,
  remainingcost  NUMBER NULL,
  remaininglatecost  NUMBER NULL,
  staffedremainingcost  NUMBER NULL,
  staffedremaininglatecost  NUMBER NULL,
  unstaffedremainingcost  NUMBER NULL,
  unstaffedremaininglatecost  NUMBER NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RESOURCECODEHIERARCHY

--METADATA NAME:RESOURCECODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCECODEHIERARCHY(
  codetypeobjectid  number(10) NOT NULL,
  codetypename  varchar2(40 CHAR) NOT NULL,
  codetypesequencenumber  number(10) NOT NULL,
  codetypeissecure  varchar2(1 CHAR) NOT NULL,
  parentcodevalueobjectid  number(10) NULL,
  parentcodevaluename  varchar2(100 CHAR) NULL,
  parentcodevalueshortname  varchar2(32 CHAR) NULL,
  parentcodevaluesequencenumber  number(10) NULL,
  childcodevalueobjectid  number(10) NULL,
  childcodevaluename  varchar2(100 CHAR) NULL,
  childcodevalueshortname  varchar2(32 CHAR) NULL,
  childcodevaluesequencenumber  number(10) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RESOURCEHIERARCHY

--METADATA NAME:RESOURCEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEHIERARCHY(
  parentobjectid  number(10) NULL,
  parentsequencenumber  number(10) NULL,
  parentname  varchar2(255 CHAR) NULL,
  parentid  varchar2(255 CHAR) NULL,
  childobjectid  number(10) NULL,
  childsequencenumber  number(10) NULL,
  childname  varchar2(255 CHAR) NULL,
  childid  varchar2(255 CHAR) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RESOURCELIMIT

--METADATA NAME:RESOURCELIMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCELIMIT(
  rsrc_id  number(10) NOT NULL,
  startdate  DATE NOT NULL,
  enddate  DATE NOT NULL,
  limit  NUMBER NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
,CONSTRAINT pk_resourcelimit PRIMARY KEY (rsrc_id,startdate)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RFOLIOX

--METADATA NAME:RFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RFOLIOX(
  rfolio_id  number(10) NOT NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourceteamx PRIMARY KEY (rfolio_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RISK

--METADATA NAME:RISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISK(
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  id  varchar2(40 CHAR) NOT NULL,
  name  varchar2(200 CHAR) NULL,
  total_cost  number(23,6) NOT NULL,
  rsrc_id  number(10) NULL,
  type  varchar2(10 CHAR) NOT NULL,
  status  varchar2(10 CHAR) NOT NULL,
  category_id  number(10) NULL,
  description  varchar2(4000 CHAR) NULL,
  cause  varchar2(4000 CHAR) NULL,
  effect  varchar2(4000 CHAR) NULL,
  note  varchar2(4000 CHAR) NULL,
  identified_by_id  number(10) NULL,
  identified_date  DATE NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_risk PRIMARY KEY (risk_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKIMPACT

--METADATA NAME:RISKIMPACT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKIMPACT(
  risk_id  number(10) NOT NULL,
  scoretype_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  threshold_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskimpact PRIMARY KEY (risk_id,scoretype_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKMIT

--METADATA NAME:RISKMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMIT(
  mitigation_id  number(10) NOT NULL,
  id  varchar2(40 CHAR) NOT NULL,
  response_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  name  varchar2(200 CHAR) NULL,
  start_date  DATE NOT NULL,
  finish_date  DATE NOT NULL,
  base_start_date  DATE NOT NULL,
  base_finish_date  DATE NOT NULL,
  remaining_cost  number(23,6) NOT NULL,
  actual_cost  number(23,6) NOT NULL,
  budget_cost  number(23,6) NOT NULL,
  status  varchar2(10 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskmit PRIMARY KEY (mitigation_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKMITIMP

--METADATA NAME:RISKMITIMP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMITIMP(
  mitigation_id  number(10) NOT NULL,
  scoretype_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  threshold_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskmitimp PRIMARY KEY (mitigation_id,scoretype_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKMITX

--METADATA NAME:RISKMITX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMITX(
  mitigation_id  number(10) NOT NULL,
  score  number(10) NULL,
  scoretext  varchar2(40 CHAR) NULL,
  scorecolor  varchar2(8 CHAR) NULL,
  physicalstartdate  DATE NULL,
  physicalfinishdate  DATE NULL,
  physicalbasestartdate  DATE NULL,
  physicalbasefinishdate  DATE NULL,
  remainingcost  number(23,6) NULL,
  actualcost  number(23,6) NULL,
  plannedcost  number(23,6) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_riskresponseactionx PRIMARY KEY (mitigation_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKMTXSCR

--METADATA NAME:RISKMTXSCR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMTXSCR(
  score_id  number(10) NOT NULL,
  matrix_id  number(10) NOT NULL,
  probability_threshold_level  number(10) NOT NULL,
  severity1  number(10) NULL,
  severity1label  varchar2(40 CHAR) NULL,
  severity2  number(10) NULL,
  severity2label  varchar2(40 CHAR) NULL,
  severity3  number(10) NULL,
  severity3label  varchar2(40 CHAR) NULL,
  severity4  number(10) NULL,
  severity4label  varchar2(40 CHAR) NULL,
  severity5  number(10) NULL,
  severity5label  varchar2(40 CHAR) NULL,
  severity6  number(10) NULL,
  severity6label  varchar2(40 CHAR) NULL,
  severity7  number(10) NULL,
  severity7label  varchar2(40 CHAR) NULL,
  severity8  number(10) NULL,
  severity8label  varchar2(40 CHAR) NULL,
  severity9  number(10) NULL,
  severity9label  varchar2(40 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskmtxscr PRIMARY KEY (score_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKRSPPLN

--METADATA NAME:RISKRSPPLN TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKRSPPLN(
  response_id  number(10) NOT NULL,
  id  varchar2(40 CHAR) NOT NULL,
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  name  varchar2(200 CHAR) NOT NULL,
  used  char(1 CHAR) NOT NULL,
  type  varchar2(10 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskrsppln PRIMARY KEY (response_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKRSPPLNX

--METADATA NAME:RISKRSPPLNX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKRSPPLNX(
  response_id  number(10) NOT NULL,
  actualcost  number(23,6) NULL,
  remainingcost  number(23,6) NULL,
  plannedcost  number(23,6) NULL,
  startdate  DATE NULL,
  finishdate  DATE NULL,
  plannedstartdate  DATE NULL,
  plannedfinishdate  DATE NULL,
  score  number(10) NULL,
  scoretext  varchar2(40 CHAR) NULL,
  scorecolor  varchar2(8 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_riskresponseplanx PRIMARY KEY (response_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKSCRMTX

--METADATA NAME:RISKSCRMTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRMTX(
  matrix_id  number(10) NOT NULL,
  name  varchar2(40 CHAR) NOT NULL,
  description  varchar2(4000 CHAR) NULL,
  method  varchar2(10 CHAR) NOT NULL,
  impact_levels  number(10) NOT NULL,
  probability_levels  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskscrmtx PRIMARY KEY (matrix_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKSCRTHR

--METADATA NAME:RISKSCRTHR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRTHR(
  threshold_id  number(10) NOT NULL,
  scoretype_id  number(10) NOT NULL,
  short_name  varchar2(10 CHAR) NOT NULL,
  full_name  varchar2(40 CHAR) NOT NULL,
  color  char(6 CHAR) NOT NULL,
  lvl  number(10) NOT NULL,
  value  varchar2(100 CHAR) NULL,
  probability_value  number(10,6) NULL,
  tolerance_value  number(10) NULL,
  schedule_value  number(17,6) NULL,
  cost_value  number(23,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskscrthr PRIMARY KEY (threshold_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKSCRTYP

--METADATA NAME:RISKSCRTYP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRTYP(
  scoretype_id  number(10) NOT NULL,
  name  varchar2(40 CHAR) NOT NULL,
  type  varchar2(10 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_riskscrtyp PRIMARY KEY (scoretype_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RISKX

--METADATA NAME:RISKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKX(
  risk_id  number(10) NOT NULL,
  score  number(10) NULL,
  scoretext  varchar2(40 CHAR) NULL,
  scorecolor  varchar2(8 CHAR) NULL,
  exposure  NUMBER NULL,
  identifiedbyresourceid  varchar2(255 CHAR) NULL,
  identifiedbyresourcename  varchar2(255 CHAR) NULL,
  exposurestartdate  DATE NULL,
  exposurefinishdate  DATE NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_riskx PRIMARY KEY (risk_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RLFOLIOX

--METADATA NAME:RLFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RLFOLIOX(
  rlfolio_id  number(10) NOT NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_roleteamx PRIMARY KEY (rlfolio_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table ROLECATVALX

--METADATA NAME:ROLECATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATVALX(
  role_catg_id  number(10) NOT NULL,
  codetypename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_rolecodex PRIMARY KEY (role_catg_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table ROLECODEHIERARCHY

--METADATA NAME:ROLECODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECODEHIERARCHY(
  codetypeobjectid  number(10) NOT NULL,
  codetypename  varchar2(60 CHAR) NOT NULL,
  codetypesequencenumber  number(10) NOT NULL,
  codetypeissecure  varchar2(1 CHAR) NOT NULL,
  parentcodevalueobjectid  number(10) NULL,
  parentcodevaluename  varchar2(100 CHAR) NULL,
  parentcodevalueshortname  varchar2(60 CHAR) NULL,
  parentcodevaluesequencenumber  number(10) NULL,
  childcodevalueobjectid  number(10) NULL,
  childcodevaluename  varchar2(100 CHAR) NULL,
  childcodevalueshortname  varchar2(60 CHAR) NULL,
  childcodevaluesequencenumber  number(10) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLERATEX

--METADATA NAME:ROLERATEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERATEX(
  role_rate_id  number(10) NOT NULL,
  roleid  varchar2(255 CHAR) NULL,
  rolename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_roleratex PRIMARY KEY (role_rate_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table ROLERCATX

--METADATA NAME:ROLERCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERCATX(
  role_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  rolecodedescription  varchar2(255 CHAR) NULL,
  rolecodetypename  varchar2(255 CHAR) NULL,
  rolecodevalue  varchar2(255 CHAR) NULL,
  roleid  varchar2(255 CHAR) NULL,
  rolename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_rolecodeassignmentx PRIMARY KEY (role_id,role_catg_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCCURVX

--METADATA NAME:RSRCCURVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCCURVX(
  curv_id  number(10) NOT NULL,
  value0  NUMBER NULL,
  value5  NUMBER NULL,
  value10  NUMBER NULL,
  value15  NUMBER NULL,
  value20  NUMBER NULL,
  value25  NUMBER NULL,
  value30  NUMBER NULL,
  value35  NUMBER NULL,
  value40  NUMBER NULL,
  value45  NUMBER NULL,
  value50  NUMBER NULL,
  value55  NUMBER NULL,
  value60  NUMBER NULL,
  value65  NUMBER NULL,
  value70  NUMBER NULL,
  value75  NUMBER NULL,
  value80  NUMBER NULL,
  value85  NUMBER NULL,
  value90  NUMBER NULL,
  value95  NUMBER NULL,
  value100  NUMBER NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcecurvex PRIMARY KEY (curv_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCHOURX

--METADATA NAME:RSRCHOURX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCHOURX(
  rsrc_hr_id  number(10) NOT NULL,
  projectid  varchar2(255 CHAR) NULL,
  projectname  varchar2(255 CHAR) NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcehourx PRIMARY KEY (rsrc_hr_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCLOC

--METADATA NAME:RSRCLOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCLOC(
  rsrc_loc_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  longitude  NUMBER NULL,
  latitude  NUMBER NULL,
  geo_location  SDO_GEOMETRY NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rsrcloc PRIMARY KEY (rsrc_loc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('RSRCLOC', 'GEO_LOCATION', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_rsrcloc_geo_location TYPE:INDEX TABLE_NAME:RSRCLOC CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_rsrcloc_geo_location
ON rsrcloc (geo_location)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  
prompt Creating table RSRCOVERALLOC

--METADATA NAME:RSRCOVERALLOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCOVERALLOC(
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  overalloc_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCRATEX

--METADATA NAME:RSRCRATEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRATEX(
  rsrc_rate_id  number(10) NOT NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourceratex PRIMARY KEY (rsrc_rate_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCRCATX

--METADATA NAME:RSRCRCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRCATX(
  rsrc_id  number(10) NOT NULL,
  rsrc_catg_type_id  number(10) NOT NULL,
  resourcecodedescription  varchar2(255 CHAR) NULL,
  resourcecodetypename  varchar2(255 CHAR) NULL,
  resourcecodevalue  varchar2(255 CHAR) NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcecodeassignmentx PRIMARY KEY (rsrc_id,rsrc_catg_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCROLEASGNMENTSPREAD

--METADATA NAME:RSRCROLEASGNMENTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLEASGNMENTSPREAD(
  id  number(10) NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  spread_start_date  DATE NULL,
  spread_end_date  DATE NULL,
  plan_start_date  DATE NULL,
  plan_end_date  DATE NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  rem_start_date  DATE NULL,
  rem_end_date  DATE NULL,
  plan_qty  number(22,6) NULL,
  staffed_act_qty  number(22,6) NULL,
  unstaffed_act_qty  number(22,6) NULL,
  act_this_per_qty  number(22,6) NULL,
  staffed_remain_qty  number(22,6) NULL,
  unstaffed_remain_qty  number(22,6) NULL,
  staffed_total_qty  number(22,6) NULL,
  unstaffed_total_qty  number(22,6) NULL,
  total_period_qty  number(22,6) NULL,
  plan_cost  number(25,6) NULL,
  staffed_act_cost  number(25,6) NULL,
  unstaffed_act_cost  number(25,6) NULL,
  act_this_period_cost  number(25,6) NULL,
  staffed_remain_cost  number(25,6) NULL,
  unstaffed_remain_cost  number(25,6) NULL,
  staffed_total_cost  number(25,6) NULL,
  unstaffed_total_cost  number(25,6) NULL,
  total_period_cost  number(25,6) NULL,
  rolledup_record  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL,
  overalloc_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCROLEX

--METADATA NAME:RSRCROLEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLEX(
  rsrc_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  proficiency  varchar2(24 CHAR) NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  roleid  varchar2(255 CHAR) NULL,
  rolename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcerolex PRIMARY KEY (rsrc_id,role_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCSECX

--METADATA NAME:RSRCSECX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCSECX(
  user_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourceaccessx PRIMARY KEY (user_id,rsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table RSRCX

--METADATA NAME:RSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCX(
  rsrc_id  number(10) NOT NULL,
  calendarname  varchar2(255 CHAR) NULL,
  currencyid  varchar2(255 CHAR) NULL,
  currencyname  varchar2(255 CHAR) NULL,
  primaryroleid  varchar2(255 CHAR) NULL,
  primaryrolename  varchar2(255 CHAR) NULL,
  timesheetapprovalmanager  varchar2(255 CHAR) NULL,
  username  varchar2(255 CHAR) NULL,
  locationname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourcesx PRIMARY KEY (rsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table SAFETYDATE

--METADATA NAME:SAFETYDATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE SAFETYDATE(
  setting_name  varchar2(30 CHAR) NOT NULL,
  setting_value  DATE NULL
,CONSTRAINT pk_setting_name PRIMARY KEY (setting_name)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SNAPGROUP

--METADATA NAME:SNAPGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPGROUP(
  snap_group_id  number(10) NOT NULL,
  snap_group_name  varchar2(60 CHAR) NOT NULL,
  snap_group_desc  varchar2(255 CHAR) NOT NULL,
  snap_interval  varchar2(20 CHAR) DEFAULT 'SG_Weekly' NOT NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  create_date  DATE DEFAULT sysdate NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_snapgroup PRIMARY KEY (snap_group_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SNAPPROJ

--METADATA NAME:SNAPPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPPROJ(
  snap_group_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_snapproj PRIMARY KEY (snap_group_id,proj_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SNAPSHOT

--METADATA NAME:SNAPSHOT TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPSHOT(
  snapshot_id  number(10) NOT NULL,
  snapshot_name  varchar2(60 CHAR) NOT NULL,
  snapshot_date  DATE NOT NULL,
  snap_group_id  number(10) NOT NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  create_date  DATE DEFAULT sysdate NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_snapshot PRIMARY KEY (snapshot_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKACTVX

--METADATA NAME:TASKACTVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKACTVX(
  task_id  number(10) NOT NULL,
  actv_code_type_id  number(10) NOT NULL,
  activitycodedescription  varchar2(255 CHAR) NULL,
  activitycodetypename  varchar2(255 CHAR) NULL,
  activitycodetypescope  varchar2(255 CHAR) NULL,
  activitycodevalue  varchar2(255 CHAR) NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activitycodeassignmentx PRIMARY KEY (task_id,actv_code_type_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKCBSX

--METADATA NAME:TASKCBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKCBSX(
  proj_id  number(10) NOT NULL,
  cbs_id  number(10) NOT NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  remain_start_date  DATE NULL,
  remain_end_date  DATE NULL,
  total_drtn_hr_cnt  number(17,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  act_drtn_hr_cnt  number(17,6) NULL,
  total_percent_complete  number(10,2) NULL
,CONSTRAINT pk_taskcbsx PRIMARY KEY (proj_id,cbs_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKDOCX

--METADATA NAME:TASKDOCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKDOCX(
  taskdoc_id  number(10) NOT NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  documenttitle  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectdocumentx PRIMARY KEY (taskdoc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKFINX

--METADATA NAME:TASKFINX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFINX(
  fin_dates_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activityperiodactualx PRIMARY KEY (fin_dates_id,task_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKMEMOX

--METADATA NAME:TASKMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKMEMOX(
  memo_id  number(10) NOT NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  notebooktopicname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  rawtextnote  CLOB NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activitynotex PRIMARY KEY (memo_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rawtextnote) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
NOLOGGING

/

prompt Creating table TASKPREDX

--METADATA NAME:TASKPREDX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPREDX(
  task_pred_id  number(10) NOT NULL,
  predecessoractivityid  varchar2(255 CHAR) NULL,
  predecessoractivityname  varchar2(255 CHAR) NULL,
  predecessorprojectid  varchar2(255 CHAR) NULL,
  successoractivityid  varchar2(255 CHAR) NULL,
  successoractivityname  varchar2(255 CHAR) NULL,
  successorprojectid  varchar2(255 CHAR) NULL,
  driving  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_relationshipx PRIMARY KEY (task_pred_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKPROCX

--METADATA NAME:TASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPROCX(
  proc_id  number(10) NOT NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  wbsobjectid  number(10) NULL,
  weightpercent  NUMBER NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activitystepx PRIMARY KEY (proc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKRISKX

--METADATA NAME:TASKRISKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRISKX(
  task_id  number(10) NOT NULL,
  risk_id  number(10) NOT NULL,
  projectid  varchar2(40 CHAR) NULL,
  projectname  varchar2(100 CHAR) NULL,
  activityid  varchar2(40 CHAR) NULL,
  activityname  varchar2(125 CHAR) NULL,
  riskname  varchar2(200 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activityriskx PRIMARY KEY (task_id,risk_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKRSRCX

--METADATA NAME:TASKRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRSRCX(
  taskrsrc_id  number(10) NOT NULL,
  proficiency  varchar2(24 CHAR) NULL,
  remaininglag  NUMBER NULL,
  activityid  varchar2(255 CHAR) NULL,
  activityname  varchar2(255 CHAR) NULL,
  actualcost  NUMBER NULL,
  actualduration  NUMBER NULL,
  actualunits  NUMBER NULL,
  atcompletioncost  NUMBER NULL,
  atcompletionduration  NUMBER NULL,
  atcompletionunits  NUMBER NULL,
  autocomputeactuals  varchar2(1 CHAR) NULL,
  calendarname  varchar2(255 CHAR) NULL,
  calendarobjectid  number(10) NULL,
  costaccountid  varchar2(255 CHAR) NULL,
  costaccountname  varchar2(255 CHAR) NULL,
  finishdate  DATE NULL,
  isactive  varchar2(1 CHAR) NULL,
  isovertimeallowed  varchar2(1 CHAR) NULL,
  isprimaryresource  varchar2(1 CHAR) NULL,
  plannedduration  NUMBER NULL,
  priceperunit  NUMBER NULL,
  projectid  varchar2(255 CHAR) NULL,
  remainingduration  NUMBER NULL,
  resourcecalendarname  varchar2(255 CHAR) NULL,
  resourcecurvename  varchar2(255 CHAR) NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  roleid  varchar2(255 CHAR) NULL,
  rolename  varchar2(255 CHAR) NULL,
  staffedremainingcost  NUMBER NULL,
  staffedremainingunits  NUMBER NULL,
  startdate  DATE NULL,
  unitspercentcomplete  NUMBER NULL,
  unstaffedremainingcost  NUMBER NULL,
  unstaffedremainingunits  NUMBER NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resourceassignmentx PRIMARY KEY (taskrsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TASKX

--METADATA NAME:TASKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKX(
  task_id  number(10) NOT NULL,
  accountingvariance  NUMBER NULL,
  accountingvariancelaborunits  NUMBER NULL,
  actualduration  NUMBER NULL,
  actualexpensecost  NUMBER NULL,
  actuallaborcost  NUMBER NULL,
  actualmaterialcost  NUMBER NULL,
  actualnonlaborcost  NUMBER NULL,
  actualthisperiodlaborcost  NUMBER NULL,
  actualthisperiodmaterialcost  NUMBER NULL,
  actualthisperiodnonlaborcost  NUMBER NULL,
  actualtotalcost  NUMBER NULL,
  actualtotalunits  NUMBER NULL,
  atcompletionduration  NUMBER NULL,
  atcompletionexpensecost  NUMBER NULL,
  atcompletionlaborcost  NUMBER NULL,
  atcompletionlaborunits  NUMBER NULL,
  atcompletionlaborunitsvariance  NUMBER NULL,
  atcompletionmaterialcost  NUMBER NULL,
  atcompletionnonlaborcost  NUMBER NULL,
  atcompletionnonlaborunits  NUMBER NULL,
  atcompletiontotalcost  NUMBER NULL,
  atcompletiontotalunits  NUMBER NULL,
  atcompletionvariance  NUMBER NULL,
  baselineduration  NUMBER NULL,
  baselinefinishdate  DATE NULL,
  baselineplannedduration  NUMBER NULL,
  baselineplannedexpensecost  NUMBER NULL,
  baselineplannedlaborcost  NUMBER NULL,
  baselineplannedlaborunits  NUMBER NULL,
  baselineplannedmaterialcost  NUMBER NULL,
  baselineplannednonlaborcost  NUMBER NULL,
  baselineplannednonlaborunits  NUMBER NULL,
  baselineplannedtotalcost  NUMBER NULL,
  baselinestartdate  DATE NULL,
  baselinelatestartdate  DATE NULL,
  baseline1latestartdate  DATE NULL,
  baselinelatefinishdate  DATE NULL,
  baseline1latefinishdate  DATE NULL,
  budgetatcompletion  NUMBER NULL,
  calendarname  varchar2(255 CHAR) NULL,
  costpercentcomplete  NUMBER NULL,
  costpercentofplanned  NUMBER NULL,
  costperformanceindex  NUMBER NULL,
  costperformanceindexlaborunits  NUMBER NULL,
  costvariance  NUMBER NULL,
  costvarianceindex  NUMBER NULL,
  costvarianceindexlaborunits  NUMBER NULL,
  costvariancelaborunits  NUMBER NULL,
  datadate  DATE NULL,
  duration1variance  NUMBER NULL,
  durationpercentcomplete  NUMBER NULL,
  durationpercentofplanned  NUMBER NULL,
  durationvariance  NUMBER NULL,
  earnedvaluecost  NUMBER NULL,
  earnedvaluelaborunits  NUMBER NULL,
  estimateatcompletioncost  NUMBER NULL,
  estimateatcompletionlaborunits  NUMBER NULL,
  estimatetocomplete  NUMBER NULL,
  estimatetocompletelaborunits  NUMBER NULL,
  expensecost1variance  NUMBER NULL,
  expensecostpercentcomplete  NUMBER NULL,
  expensecostvariance  NUMBER NULL,
  finishdate  DATE NULL,
  finishdate1variance  NUMBER NULL,
  finishdatevariance  NUMBER NULL,
  iscritical  varchar2(1 CHAR) NULL,
  laborcost1variance  NUMBER NULL,
  laborcostpercentcomplete  NUMBER NULL,
  laborcostvariance  NUMBER NULL,
  laborunits1variance  NUMBER NULL,
  laborunitspercentcomplete  NUMBER NULL,
  laborunitsvariance  NUMBER NULL,
  materialcost1variance  NUMBER NULL,
  materialcostpercentcomplete  NUMBER NULL,
  materialcostvariance  NUMBER NULL,
  nonlaborcost1variance  NUMBER NULL,
  nonlaborcostpercentcomplete  NUMBER NULL,
  nonlaborcostvariance  NUMBER NULL,
  nonlaborunits1variance  NUMBER NULL,
  nonlaborunitspercentcomplete  NUMBER NULL,
  nonlaborunitsvariance  NUMBER NULL,
  percentcomplete  NUMBER NULL,
  performancepercentcomplete  NUMBER NULL,
  physicalpercentcomplete  NUMBER NULL,
  plannedexpensecost  NUMBER NULL,
  plannedlaborcost  NUMBER NULL,
  plannedmaterialcost  NUMBER NULL,
  plannednonlaborcost  NUMBER NULL,
  plannedtotalcost  NUMBER NULL,
  plannedtotalunits  NUMBER NULL,
  plannedvaluecost  NUMBER NULL,
  plannedvaluelaborunits  NUMBER NULL,
  primaryresourceid  varchar2(255 CHAR) NULL,
  primaryresourcename  varchar2(255 CHAR) NULL,
  remainingexpensecost  NUMBER NULL,
  remainingfloat  NUMBER NULL,
  remaininglaborcost  NUMBER NULL,
  remainingmaterialcost  NUMBER NULL,
  remainingnonlaborcost  NUMBER NULL,
  remainingtotalcost  NUMBER NULL,
  remainingtotalunits  NUMBER NULL,
  schedulepercentcomplete  NUMBER NULL,
  scheduleperfindexlaborunits  NUMBER NULL,
  scheduleperformanceindex  NUMBER NULL,
  schedulevariance  NUMBER NULL,
  schedulevarianceindex  NUMBER NULL,
  schedulevariancelaborunits  NUMBER NULL,
  schedulevarindexlaborunits  NUMBER NULL,
  startdate  DATE NULL,
  startdate1variance  NUMBER NULL,
  startdatevariance  NUMBER NULL,
  tocompleteperformanceindex  NUMBER NULL,
  totalcost1variance  NUMBER NULL,
  totalcostvariance  NUMBER NULL,
  unitspercentcomplete  NUMBER NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  activityownerobjectid  number(10) NULL,
  activityowner  varchar2(255 CHAR) NULL,
  actualprogressdate  DATE NULL,
  locationname  varchar2(255 CHAR) NULL,
  cbscode  varchar2(120 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_activityx PRIMARY KEY (task_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TIMESHTX

--METADATA NAME:TIMESHTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TIMESHTX(
  ts_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  resourceid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_timesheetx PRIMARY KEY (ts_id,rsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TRACKOFFLINEUSER

--METADATA NAME:TRACKOFFLINEUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRACKOFFLINEUSER(
  trackofflineuser_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  status  varchar2(20 CHAR) NULL,
  offline_date  DATE NOT NULL,
  last_online_date  DATE NULL,
  hard_drive_code  varchar2(40 CHAR) NOT NULL,
  offline_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_trackofflineuser PRIMARY KEY (trackofflineuser_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(offline_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TRSRCFINX

--METADATA NAME:TRSRCFINX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCFINX(
  fin_dates_id  number(10) NOT NULL,
  taskrsrc_id  number(10) NOT NULL,
  resourcetype  varchar2(24 CHAR) NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_resassignmentperiodactualx PRIMARY KEY (fin_dates_id,taskrsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table TSAPPROVERS

--METADATA NAME:TSAPPROVERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSAPPROVERS(
  ts_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tsapprovers PRIMARY KEY (ts_id,rsrc_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UDFCODEX

--METADATA NAME:UDFCODEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFCODEX(
  udf_code_id  number(10) NOT NULL,
  codetypetitle  varchar2(255 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_udfcodex PRIMARY KEY (udf_code_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table UDFVALUEX

--METADATA NAME:UDFVALUEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFVALUEX(
  udf_type_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  subjectarea  varchar2(48 CHAR) NULL,
  datatype  varchar2(24 CHAR) NULL,
  issecurecode  varchar2(1 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_udfvaluex PRIMARY KEY (udf_type_id,fk_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table USEROBSX

--METADATA NAME:USEROBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROBSX(
  user_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL,
  obsname  varchar2(255 CHAR) NULL,
  profilename  varchar2(255 CHAR) NULL,
  username  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_userobsx PRIMARY KEY (user_id,obs_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table USERSX

--METADATA NAME:USERSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERSX(
  user_id  number(10) NOT NULL,
  respectactivitydurationtype  varchar2(255 CHAR) NULL,
  assignmentstaffingpreference  varchar2(33 CHAR) NULL,
  currencyid  varchar2(255 CHAR) NULL,
  currencyname  varchar2(255 CHAR) NULL,
  financialperiodendobjectid  number(10) NULL,
  financialperiodstartobjectid  number(10) NULL,
  newprojectdurationtype  varchar2(33 CHAR) NULL,
  ratesourcepreference  varchar2(33 CHAR) NULL,
  lastprojectsecuritydate  DATE NULL,
  lastresourcesecuritydate  DATE NULL,
  lastglobalsecuritydate  DATE NULL,
  issuperuser  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_usersx PRIMARY KEY (user_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table WBSBUDGX

--METADATA NAME:WBSBUDGX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSBUDGX(
  wbs_budg_id  number(10) NOT NULL,
  epsid  varchar2(255 CHAR) NULL,
  epsname  varchar2(255 CHAR) NULL,
  epsobjectid  number(10) NULL,
  projectid  varchar2(255 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectspendingplanx PRIMARY KEY (wbs_budg_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table WBSHIERARCHY

--METADATA NAME:WBSHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSHIERARCHY(
  parentobjectid  number(10) NULL,
  parentprojectid  number(10) NULL,
  parentsequencenumber  number(10) NULL,
  parentname  varchar2(100 CHAR) NULL,
  parentid  varchar2(40 CHAR) NULL,
  childobjectid  number(10) NULL,
  childprojectid  number(10) NULL,
  childsequencenumber  number(10) NULL,
  childname  varchar2(100 CHAR) NULL,
  childid  varchar2(40 CHAR) NULL,
  parentlevelsbelowroot  number(10) NOT NULL,
  childlevelsbelowroot  number(10) NOT NULL,
  levelsbetween  number(10) NOT NULL,
  childhaschildren  varchar2(1 CHAR) NULL,
  fullpathname  varchar2(4000 CHAR) NULL,
  update_date  DATE DEFAULT sysdate NOT NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSMEMOX

--METADATA NAME:WBSMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSMEMOX(
  wbs_memo_id  number(10) NOT NULL,
  epsid  varchar2(255 CHAR) NULL,
  epsname  varchar2(255 CHAR) NULL,
  epsobjectid  number(10) NULL,
  notebooktopicname  varchar2(255 CHAR) NULL,
  projectid  varchar2(255 CHAR) NULL,
  rawtextnote  CLOB NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectnotex PRIMARY KEY (wbs_memo_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rawtextnote) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
NOLOGGING

/

prompt Creating table WBSREVIEWERS

--METADATA NAME:WBSREVIEWERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSREVIEWERS(
  wbsreviewers_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  status_reviewer  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_wbsreviewers PRIMARY KEY (wbsreviewers_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSREVIEWSTATUS

--METADATA NAME:WBSREVIEWSTATUS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSREVIEWSTATUS(
  wbsreviewstatus_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  status_reviewer  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  table_name  varchar2(30 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_wbsreviewstatus PRIMARY KEY (wbsreviewstatus_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSRSRCX

--METADATA NAME:WBSRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRCX(
  wbsrsrc_id  number(10) NOT NULL,
  projectid  varchar2(255 CHAR) NULL,
  resourcename  varchar2(255 CHAR) NULL,
  rolename  varchar2(255 CHAR) NULL,
  status  varchar2(24 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectresourcex PRIMARY KEY (wbsrsrc_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table WBSRSRC_QTYX

--METADATA NAME:WBSRSRC_QTYX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC_QTYX(
  wbsrsrc_id  number(10) NOT NULL,
  week_start  DATE NOT NULL,
  month_start  DATE NOT NULL,
  committedflag  varchar2(1 CHAR) NULL,
  projectobjectid  number(10) NULL,
  resourceobjectid  number(10) NULL,
  wbsobjectid  number(10) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_projectresourcequantityx PRIMARY KEY (wbsrsrc_id,week_start,month_start)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSSPREAD

--METADATA NAME:WBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSPREAD(
  objectid  number(10) NULL,
  parentobjectid  number(10) NULL,
  code  varchar2(40 CHAR) NULL,
  name  varchar2(100 CHAR) NULL,
  projectobjectid  number(10) NULL,
  obsobjectid  number(10) NULL,
  obsname  varchar2(100 CHAR) NULL,
  startdate  DATE NULL,
  enddate  DATE NULL,
  actuallaborunits  number(23,6) NULL,
  actualnonlaborunits  number(23,6) NULL,
  atcompletionlaborunits  number(23,6) NULL,
  atcompletionnonlaborunits  number(23,6) NULL,
  baselineplannedlaborunits  number(23,6) NULL,
  baselineplannednonlaborunits  number(23,6) NULL,
  earnedvaluelaborunits  number(23,6) NULL,
  estimateatcompletionlaborunits  number(23,6) NULL,
  estimatetocompletelaborunits  number(23,6) NULL,
  plannedlaborunits  number(23,6) NULL,
  plannednonlaborunits  number(23,6) NULL,
  plannedvaluelaborunits  number(23,6) NULL,
  remaininglaborunits  number(23,6) NULL,
  remainingnonlaborunits  number(23,6) NULL,
  actualcost  number(23,6) NULL,
  actualexpensecost  number(23,6) NULL,
  actuallaborcost  number(23,6) NULL,
  actualmaterialcost  number(23,6) NULL,
  actualnonlaborcost  number(23,6) NULL,
  actualtotalcost  number(23,6) NULL,
  atcompletionexpensecost  number(23,6) NULL,
  atcompletionlaborcost  number(23,6) NULL,
  atcompletionmaterialcost  number(23,6) NULL,
  atcompletionnonlaborcost  number(23,6) NULL,
  atcompletiontotalcost  number(23,6) NULL,
  baselineplannedexpensecost  number(23,6) NULL,
  baselineplannedlaborcost  number(23,6) NULL,
  baselineplannedmaterialcost  number(23,6) NULL,
  baselineplannednonlaborcost  number(23,6) NULL,
  baselineplannedtotalcost  number(23,6) NULL,
  earnedvaluecost  number(23,6) NULL,
  estimateatcompletioncost  number(23,6) NULL,
  estimatetocompletecost  number(23,6) NULL,
  plannedexpensecost  number(23,6) NULL,
  plannedlaborcost  number(23,6) NULL,
  plannedmaterialcost  number(23,6) NULL,
  plannednonlaborcost  number(23,6) NULL,
  plannedtotalcost  number(23,6) NULL,
  plannedvaluecost  number(23,6) NULL,
  remainingexpensecost  number(23,6) NULL,
  remaininglaborcost  number(23,6) NULL,
  remainingmaterialcost  number(23,6) NULL,
  remainingnonlaborcost  number(23,6) NULL,
  remainingtotalcost  number(23,6) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSSTEPX

--METADATA NAME:WBSSTEPX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSTEPX(
  wbs_step_id  number(10) NOT NULL,
  projectid  varchar2(255 CHAR) NULL,
  wbscode  varchar2(255 CHAR) NULL,
  wbsname  varchar2(255 CHAR) NULL,
  create_date  DATE DEFAULT sysdate NULL,
  update_date  DATE DEFAULT sysdate NULL
,CONSTRAINT pk_wbsmilestonex PRIMARY KEY (wbs_step_id)  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
NOLOGGING

/

prompt Creating table WRK_LOG_RESULTS

--METADATA NAME:WRK_LOG_RESULTS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WRK_LOG_RESULTS(
  spid  number(10) NULL,
  seq_num  number(10) NULL,
  log_message  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_PX_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/
	 
--METADATA NAME:is_rejected TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   is_rejected  varchar2(1 CHAR) NULL
/
	 
--METADATA NAME:rej_dis_data TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   rej_dis_data  BLOB NULL
/
	 
--METADATA NAME:assignment_id TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   assignment_id  number(10) NULL
/
	 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   proj_id  number(10)
/

--METADATA  TYPE:ADHOC_SQL
UPDATE DISCUSSION D SET D.PROJ_ID = (SELECT T.PROJ_ID FROM TASK T WHERE T.TASK_ID = D.TASK_ID)
/
--METADATA  TYPE:ADHOC_SQL
ALTER TABLE DISCUSSION MODIFY PROJ_ID NOT NULL
/
	 
--METADATA NAME:delete_user TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   delete_user  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:job_type_key TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   job_type_key  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:job_data_x TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   job_data_x  BLOB NULL
/
	 
--METADATA NAME:worker_host TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   worker_host  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:repaving_update_date TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   repaving_update_date  DATE NULL
/
	 
--METADATA NAME:datasource_id TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER 
  add   datasource_id  number(10) NULL
/
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST 
  add   cbs_id  number(10) NULL
/
	 
--METADATA NAME:rsrc_self_add_out_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   rsrc_self_add_out_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL
/
	 
--METADATA NAME:px_last_update_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   px_last_update_date  DATE NULL
/
	 
--METADATA NAME:px_priority TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   px_priority  number(3,0) DEFAULT 50 NULL
/
	 
--METADATA NAME:px_next_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   px_next_date  DATE NULL
/
	 
--METADATA NAME:px_enable_publication_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   px_enable_publication_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL
/
	 
--METADATA NAME:last_level_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   last_level_date  DATE NULL
/
	 
--METADATA NAME:px_safety_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   px_safety_date  DATE NULL
/
	 
--METADATA NAME:schedule_type TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   schedule_type  varchar2(40 CHAR) NULL
/
	 
--METADATA NAME:pre_pess_start_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   pre_pess_start_date  DATE NULL
/
	 
--METADATA NAME:pre_pess_finish_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   pre_pess_finish_date  DATE NULL
/
	 
--METADATA NAME:post_pess_start_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   post_pess_start_date  DATE NULL
/
	 
--METADATA NAME:post_pess_finish_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   post_pess_finish_date  DATE NULL
/
	 
--METADATA NAME:allow_update_date_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   allow_update_date_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL
/
	 
--METADATA NAME:proj_update_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   proj_update_date  DATE NULL
/
	 
--METADATA NAME:publish_spread_assign_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   publish_spread_assign_level  varchar2(12 CHAR) DEFAULT 'SL_Taskrsrc' NULL
/
	 
--METADATA NAME:etl_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   etl_interval  number(10) DEFAULT 24 NOT NULL
/
	 
--METADATA NAME:etl_hour TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   etl_hour  number(10) DEFAULT 0 NOT NULL
/
	 
--METADATA NAME:enable_prime_sync_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   enable_prime_sync_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   wbs_id  number(10)
	NULL
    
/
	 
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   priority_type  varchar2(12 CHAR)
	NULL
    
/
	 
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   obs_id  number(10) NULL
/
	 
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   prbly_pct  number(10) NULL
/
	 
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   impact_work_qty  number(17,6) NULL
/
	 
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   impact_equip_qty  number(17,6) NULL
/
	 
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   impact_expense_cost  number(23,6) NULL
/
	 
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   impact_date  DATE NULL
/
	 
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   impact_mat_qty  number(17,6) NULL
/
	 
--METADATA NAME:intg_wbs TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   intg_wbs  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:workpackage_flag TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   workpackage_flag  varchar2(1 CHAR) DEFAULT 'N' NULL
/
	 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   review_type  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:last_sum_date TYPE:FIELD TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES 
  add   last_sum_date  DATE NULL
/
	 
--METADATA NAME:last_sum_date TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC 
  add   last_sum_date  DATE NULL
/
	 
--METADATA NAME:seq_num TYPE:FIELD TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC 
  add   seq_num  number(10) DEFAULT 10 NOT NULL
/
	 
--METADATA NAME:setting_id TYPE:FIELD TABLE_NAME:SETTINGS CHANGE:CREATE
ALTER TABLE SETTINGS 
  add   setting_id  number(10) NULL
/
	 
--METADATA NAME:audit_ext_old TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP 
  add   audit_ext_old  BLOB NULL
/
	 
--METADATA NAME:audit_ext_new TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP 
  add   audit_ext_new  BLOB NULL
/
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   starred_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:cbs_code TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   cbs_code  varchar2(1024 CHAR) NULL
/
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   cbs_id  number(10) NULL
/
	 
--METADATA NAME:act_min_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   act_min_drtn  number(17,6) NULL
/
	 
--METADATA NAME:act_prob_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   act_prob_drtn  number(17,6) NULL
/
	 
--METADATA NAME:act_max_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   act_max_drtn  number(17,6) NULL
/
	 
--METADATA NAME:pre_pess_start_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   pre_pess_start_date  DATE NULL
/
	 
--METADATA NAME:pre_pess_finish_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   pre_pess_finish_date  DATE NULL
/
	 
--METADATA NAME:post_pess_start_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   post_pess_start_date  DATE NULL
/
	 
--METADATA NAME:post_pess_finish_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   post_pess_finish_date  DATE NULL
/
	 
--METADATA NAME:task_status_ind TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   task_status_ind  varchar2(1 CHAR) NULL
/
	 
--METADATA NAME:task_status_dts TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   task_status_dts  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:task_status_cmpl TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   task_status_cmpl  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:scp_pct_complete TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   scp_pct_complete  number(10,2) DEFAULT 0 NOT NULL
/
	 
--METADATA NAME:wrk_pkg_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   wrk_pkg_id  varchar2(60 CHAR) NULL
/
	 
--METADATA NAME:wrk_pkg_name TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   wrk_pkg_name  varchar2(255 CHAR) NULL
/
	 
--METADATA NAME:pre_criticality_index TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   pre_criticality_index  number(10,2) NULL
/
	 
--METADATA NAME:post_criticality_index TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   post_criticality_index  number(10,2) NULL
/
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   starred_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   cbs_id  number(10) NULL
/
	 
--METADATA NAME:prev_cost_per_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   prev_cost_per_qty  varchar2(22 CHAR) NULL
/
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER 
  add   starred_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:systemuser TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS 
  add   systemuser  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:remote_client_ip TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:CREATE
ALTER TABLE USESSAUD 
  add   remote_client_ip  varchar2(40 CHAR) NULL
/
	 
--METADATA NAME:force_logout_flag TYPE:FIELD TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION 
  add   force_logout_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL
/
	 
--METADATA NAME:remote_client_ip TYPE:FIELD TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION 
  add   remote_client_ip  varchar2(40 CHAR) NULL
/

prompt Creating constraint fk_addtaskproc_header on table ADDTASKPROC


--METADATA NAME:fk_addtaskproc_header TYPE:CONSTRAINT TABLE_NAME:ADDTASKPROC CHANGE:CREATE
ALTER TABLE ADDTASKPROC
ADD CONSTRAINT fk_addtaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_addtaskproc_task on table ADDTASKPROC


--METADATA NAME:fk_addtaskproc_task TYPE:CONSTRAINT TABLE_NAME:ADDTASKPROC CHANGE:CREATE
ALTER TABLE ADDTASKPROC
ADD CONSTRAINT fk_addtaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_addtrsrc_header on table ADDTRSRC


--METADATA NAME:fk_addtrsrc_header TYPE:CONSTRAINT TABLE_NAME:ADDTRSRC CHANGE:CREATE
ALTER TABLE ADDTRSRC
ADD CONSTRAINT fk_addtrsrc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_addtrsrc_task on table ADDTRSRC


--METADATA NAME:fk_addtrsrc_task TYPE:CONSTRAINT TABLE_NAME:ADDTRSRC CHANGE:CREATE
ALTER TABLE ADDTRSRC
ADD CONSTRAINT fk_addtrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_alert_users on table ALERT


--METADATA NAME:fk_alert_users TYPE:CONSTRAINT TABLE_NAME:ALERT CHANGE:CREATE
ALTER TABLE ALERT
ADD CONSTRAINT fk_alert_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_alertparam_alert on table ALERTPARAM


--METADATA NAME:fk_alertparam_alert TYPE:CONSTRAINT TABLE_NAME:ALERTPARAM CHANGE:CREATE
ALTER TABLE ALERTPARAM
ADD CONSTRAINT fk_alertparam_alert FOREIGN KEY (alert_id)
REFERENCES ALERT (alert_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_announcement_user_user_id on table ANNOUNCEMENT_USER


--METADATA NAME:fk_announcement_user_user_id TYPE:CONSTRAINT TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE
ALTER TABLE ANNOUNCEMENT_USER
ADD CONSTRAINT fk_announcement_user_user_id FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_announcement_user_ancmnt_id on table ANNOUNCEMENT_USER


--METADATA NAME:fk_announcement_user_ancmnt_id TYPE:CONSTRAINT TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE
ALTER TABLE ANNOUNCEMENT_USER
ADD CONSTRAINT fk_announcement_user_ancmnt_id FOREIGN KEY (announcement_id)
REFERENCES ANNOUNCEMENT (announcement_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_cbs_project on table CBS


--METADATA NAME:fk_cbs_project TYPE:CONSTRAINT TABLE_NAME:CBS CHANGE:CREATE
ALTER TABLE CBS
ADD CONSTRAINT fk_cbs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtask_header on table CHGTASK


--METADATA NAME:fk_chgtask_header TYPE:CONSTRAINT TABLE_NAME:CHGTASK CHANGE:CREATE
ALTER TABLE CHGTASK
ADD CONSTRAINT fk_chgtask_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtask_task on table CHGTASK


--METADATA NAME:fk_chgtask_task TYPE:CONSTRAINT TABLE_NAME:CHGTASK CHANGE:CREATE
ALTER TABLE CHGTASK
ADD CONSTRAINT fk_chgtask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskactv_header on table CHGTASKACTV


--METADATA NAME:fk_chgtaskactv_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
ADD CONSTRAINT fk_chgtaskactv_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskactv_proj on table CHGTASKACTV


--METADATA NAME:fk_chgtaskactv_proj TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
ADD CONSTRAINT fk_chgtaskactv_proj FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskactv_actvtype on table CHGTASKACTV


--METADATA NAME:fk_chgtaskactv_actvtype TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
ADD CONSTRAINT fk_chgtaskactv_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskactv_task on table CHGTASKACTV


--METADATA NAME:fk_chgtaskactv_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
ADD CONSTRAINT fk_chgtaskactv_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskmemo_header on table CHGTASKMEMO


--METADATA NAME:fk_chgtaskmemo_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
ADD CONSTRAINT fk_chgtaskmemo_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskmemo_taskmemo on table CHGTASKMEMO


--METADATA NAME:fk_chgtaskmemo_taskmemo TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
ADD CONSTRAINT fk_chgtaskmemo_taskmemo FOREIGN KEY (memo_id)
REFERENCES TASKMEMO (memo_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskmemo_task on table CHGTASKMEMO


--METADATA NAME:fk_chgtaskmemo_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
ADD CONSTRAINT fk_chgtaskmemo_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskproc_header on table CHGTASKPROC


--METADATA NAME:fk_chgtaskproc_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
ADD CONSTRAINT fk_chgtaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskproc_task on table CHGTASKPROC


--METADATA NAME:fk_chgtaskproc_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
ADD CONSTRAINT fk_chgtaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtaskproc_taskproc on table CHGTASKPROC


--METADATA NAME:fk_chgtaskproc_taskproc TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
ADD CONSTRAINT fk_chgtaskproc_taskproc FOREIGN KEY (proc_id)
REFERENCES TASKPROC (proc_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtrsrc_header on table CHGTRSRC


--METADATA NAME:fk_chgtrsrc_header TYPE:CONSTRAINT TABLE_NAME:CHGTRSRC CHANGE:CREATE
ALTER TABLE CHGTRSRC
ADD CONSTRAINT fk_chgtrsrc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgtrsrc_task on table CHGTRSRC


--METADATA NAME:fk_chgtrsrc_task TYPE:CONSTRAINT TABLE_NAME:CHGTRSRC CHANGE:CREATE
ALTER TABLE CHGTRSRC
ADD CONSTRAINT fk_chgtrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgudfvalue_header on table CHGUDFVALUE


--METADATA NAME:fk_chgudfvalue_header TYPE:CONSTRAINT TABLE_NAME:CHGUDFVALUE CHANGE:CREATE
ALTER TABLE CHGUDFVALUE
ADD CONSTRAINT fk_chgudfvalue_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_chgudfvalue_udftype on table CHGUDFVALUE


--METADATA NAME:fk_chgudfvalue_udftype TYPE:CONSTRAINT TABLE_NAME:CHGUDFVALUE CHANGE:CREATE
ALTER TABLE CHGUDFVALUE
ADD CONSTRAINT fk_chgudfvalue_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_deltaskproc_header on table DELTASKPROC


--METADATA NAME:fk_deltaskproc_header TYPE:CONSTRAINT TABLE_NAME:DELTASKPROC CHANGE:CREATE
ALTER TABLE DELTASKPROC
ADD CONSTRAINT fk_deltaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_deltaskproc_task on table DELTASKPROC


--METADATA NAME:fk_deltaskproc_task TYPE:CONSTRAINT TABLE_NAME:DELTASKPROC CHANGE:CREATE
ALTER TABLE DELTASKPROC
ADD CONSTRAINT fk_deltaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_discussion_project on table DISCUSSION


--METADATA NAME:fk_discussion_project TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_dm_attr_attr_master on table DM_ATTR


--METADATA NAME:fk_dm_attr_attr_master TYPE:CONSTRAINT TABLE_NAME:DM_ATTR CHANGE:CREATE
ALTER TABLE DM_ATTR
ADD CONSTRAINT fk_dm_attr_attr_master FOREIGN KEY (attr_id)
REFERENCES ATTR_MASTER (attr_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_doc_docfolder on table DOC


--METADATA NAME:fk_doc_docfolder TYPE:CONSTRAINT TABLE_NAME:DOC CHANGE:CREATE
ALTER TABLE DOC
ADD CONSTRAINT fk_doc_docfolder FOREIGN KEY (doc_folder_id)
REFERENCES DOC_FOLDER (doc_folder_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_docrecent_docfolder on table DOC_RECENT


--METADATA NAME:fk_docrecent_docfolder TYPE:CONSTRAINT TABLE_NAME:DOC_RECENT CHANGE:CREATE
ALTER TABLE DOC_RECENT
ADD CONSTRAINT fk_docrecent_docfolder FOREIGN KEY (doc_folder_id)
REFERENCES DOC_FOLDER (doc_folder_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_docrecent_doc on table DOC_RECENT


--METADATA NAME:fk_docrecent_doc TYPE:CONSTRAINT TABLE_NAME:DOC_RECENT CHANGE:CREATE
ALTER TABLE DOC_RECENT
ADD CONSTRAINT fk_docrecent_doc FOREIGN KEY (doc_id)
REFERENCES DOC (doc_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_provider_id on table GATEWAYDEPLOYMENT


--METADATA NAME:fk_provider_id TYPE:CONSTRAINT TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE
ALTER TABLE GATEWAYDEPLOYMENT
ADD CONSTRAINT fk_provider_id FOREIGN KEY (provider_id)
REFERENCES GATEWAYPROVIDER (provider_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_gs_deployment_id on table GATEWAYSYNCACTION


--METADATA NAME:fk_gs_deployment_id TYPE:CONSTRAINT TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE
ALTER TABLE GATEWAYSYNCACTION
ADD CONSTRAINT fk_gs_deployment_id FOREIGN KEY (deplmnt_id)
REFERENCES GATEWAYDEPLOYMENT (deplmnt_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_itertask_iteration on table ITERTASK


--METADATA NAME:fk_itertask_iteration TYPE:CONSTRAINT TABLE_NAME:ITERTASK CHANGE:CREATE
ALTER TABLE ITERTASK
ADD CONSTRAINT fk_itertask_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_itertask_task on table ITERTASK


--METADATA NAME:fk_itertask_task TYPE:CONSTRAINT TABLE_NAME:ITERTASK CHANGE:CREATE
ALTER TABLE ITERTASK
ADD CONSTRAINT fk_itertask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_iterteam_iteration on table ITERTEAM


--METADATA NAME:fk_iterteam_iteration TYPE:CONSTRAINT TABLE_NAME:ITERTEAM CHANGE:CREATE
ALTER TABLE ITERTEAM
ADD CONSTRAINT fk_iterteam_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_iterteam_rfolio on table ITERTEAM


--METADATA NAME:fk_iterteam_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERTEAM CHANGE:CREATE
ALTER TABLE ITERTEAM
ADD CONSTRAINT fk_iterteam_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_jobproj_jobsvc on table JOBPROJ_LKP


--METADATA NAME:fk_jobproj_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBPROJ_LKP CHANGE:CREATE
ALTER TABLE JOBPROJ_LKP
ADD CONSTRAINT fk_jobproj_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_jobset_jobsvc on table JOBSET


--METADATA NAME:fk_jobset_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBSET CHANGE:CREATE
ALTER TABLE JOBSET
ADD CONSTRAINT fk_jobset_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_leantask_project on table LEANTASK


--METADATA NAME:fk_leantask_project TYPE:CONSTRAINT TABLE_NAME:LEANTASK CHANGE:CREATE
ALTER TABLE LEANTASK
ADD CONSTRAINT fk_leantask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_leantask_task on table LEANTASK


--METADATA NAME:fk_leantask_task TYPE:CONSTRAINT TABLE_NAME:LEANTASK CHANGE:CREATE
ALTER TABLE LEANTASK
ADD CONSTRAINT fk_leantask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_mtxscrtyp_matrix on table MTXSCRTYP


--METADATA NAME:fk_mtxscrtyp_matrix TYPE:CONSTRAINT TABLE_NAME:MTXSCRTYP CHANGE:CREATE
ALTER TABLE MTXSCRTYP
ADD CONSTRAINT fk_mtxscrtyp_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_mtxscrtyp_type on table MTXSCRTYP


--METADATA NAME:fk_mtxscrtyp_type TYPE:CONSTRAINT TABLE_NAME:MTXSCRTYP CHANGE:CREATE
ALTER TABLE MTXSCRTYP
ADD CONSTRAINT fk_mtxscrtyp_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_projcost_cbs on table PROJCOST


--METADATA NAME:fk_projcost_cbs TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_pdp_proj_id on table PROJDEPLMENT


--METADATA NAME:fk_pdp_proj_id TYPE:CONSTRAINT TABLE_NAME:PROJDEPLMENT CHANGE:CREATE
ALTER TABLE PROJDEPLMENT
ADD CONSTRAINT fk_pdp_proj_id FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_dplmnt_id on table PROJDEPLMENT


--METADATA NAME:fk_dplmnt_id TYPE:CONSTRAINT TABLE_NAME:PROJDEPLMENT CHANGE:CREATE
ALTER TABLE PROJDEPLMENT
ADD CONSTRAINT fk_dplmnt_id FOREIGN KEY (deplmnt_id)
REFERENCES GATEWAYDEPLOYMENT (deplmnt_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_project_matrix on table PROJECT


--METADATA NAME:fk_project_matrix TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_project_location on table PROJECT


--METADATA NAME:fk_project_location TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_projcostcbsspread_cost on table PROJECTCOSTCBSSPREAD


--METADATA NAME:fk_projcostcbsspread_cost TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
ADD CONSTRAINT fk_projcostcbsspread_cost FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_projcostcbsspread_project on table PROJECTCOSTCBSSPREAD


--METADATA NAME:fk_projcostcbsspread_project TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
ADD CONSTRAINT fk_projcostcbsspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_projcostcbsspread_cbs on table PROJECTCOSTCBSSPREAD


--METADATA NAME:fk_projcostcbsspread_cbs TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
ADD CONSTRAINT fk_projcostcbsspread_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_proj_project_etl_list on table PROJECT_ETL_LIST


--METADATA NAME:fk_proj_project_etl_list TYPE:CONSTRAINT TABLE_NAME:PROJECT_ETL_LIST CHANGE:CREATE
ALTER TABLE PROJECT_ETL_LIST
ADD CONSTRAINT fk_proj_project_etl_list FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_projset_project on table PROJSET


--METADATA NAME:fk_projset_project TYPE:CONSTRAINT TABLE_NAME:PROJSET CHANGE:CREATE
ALTER TABLE PROJSET
ADD CONSTRAINT fk_projset_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_reliter_release on table RELITER


--METADATA NAME:fk_reliter_release TYPE:CONSTRAINT TABLE_NAME:RELITER CHANGE:CREATE
ALTER TABLE RELITER
ADD CONSTRAINT fk_reliter_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_reliter_iteration on table RELITER


--METADATA NAME:fk_reliter_iteration TYPE:CONSTRAINT TABLE_NAME:RELITER CHANGE:CREATE
ALTER TABLE RELITER
ADD CONSTRAINT fk_reliter_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_relproj_release on table RELPROJ


--METADATA NAME:fk_relproj_release TYPE:CONSTRAINT TABLE_NAME:RELPROJ CHANGE:CREATE
ALTER TABLE RELPROJ
ADD CONSTRAINT fk_relproj_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_relproj_project on table RELPROJ


--METADATA NAME:fk_relproj_project TYPE:CONSTRAINT TABLE_NAME:RELPROJ CHANGE:CREATE
ALTER TABLE RELPROJ
ADD CONSTRAINT fk_relproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_rascbsspread_rsrc on table RESOURCEASSIGNMENTCBSSPREAD


--METADATA NAME:fk_rascbsspread_rsrc TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
ADD CONSTRAINT fk_rascbsspread_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_rascbsspread_project on table RESOURCEASSIGNMENTCBSSPREAD


--METADATA NAME:fk_rascbsspread_project TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
ADD CONSTRAINT fk_rascbsspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_rascbsspread_cbs on table RESOURCEASSIGNMENTCBSSPREAD


--METADATA NAME:fk_rascbsspread_cbs TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
ADD CONSTRAINT fk_rascbsspread_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_risk_project on table RISK


--METADATA NAME:fk_risk_project TYPE:CONSTRAINT TABLE_NAME:RISK CHANGE:CREATE
ALTER TABLE RISK
ADD CONSTRAINT fk_risk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_risk_resource on table RISK


--METADATA NAME:fk_risk_resource TYPE:CONSTRAINT TABLE_NAME:RISK CHANGE:CREATE
ALTER TABLE RISK
ADD CONSTRAINT fk_risk_resource FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskimpact_risk on table RISKIMPACT


--METADATA NAME:fk_riskimpact_risk TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
ADD CONSTRAINT fk_riskimpact_risk FOREIGN KEY (risk_id)
REFERENCES RISK (risk_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskimpact_type on table RISKIMPACT


--METADATA NAME:fk_riskimpact_type TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
ADD CONSTRAINT fk_riskimpact_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskimpact_project on table RISKIMPACT


--METADATA NAME:fk_riskimpact_project TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
ADD CONSTRAINT fk_riskimpact_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmit_response on table RISKMIT


--METADATA NAME:fk_riskmit_response TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
ADD CONSTRAINT fk_riskmit_response FOREIGN KEY (response_id)
REFERENCES RISKRSPPLN (response_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmit_project on table RISKMIT


--METADATA NAME:fk_riskmit_project TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
ADD CONSTRAINT fk_riskmit_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmit_task on table RISKMIT


--METADATA NAME:fk_riskmit_task TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
ADD CONSTRAINT fk_riskmit_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmitimp_mitigation on table RISKMITIMP


--METADATA NAME:fk_riskmitimp_mitigation TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
ADD CONSTRAINT fk_riskmitimp_mitigation FOREIGN KEY (mitigation_id)
REFERENCES RISKMIT (mitigation_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmitimp_type on table RISKMITIMP


--METADATA NAME:fk_riskmitimp_type TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
ADD CONSTRAINT fk_riskmitimp_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmitimp_proj on table RISKMITIMP


--METADATA NAME:fk_riskmitimp_proj TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
ADD CONSTRAINT fk_riskmitimp_proj FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskmtxscr_matrix on table RISKMTXSCR


--METADATA NAME:fk_riskmtxscr_matrix TYPE:CONSTRAINT TABLE_NAME:RISKMTXSCR CHANGE:CREATE
ALTER TABLE RISKMTXSCR
ADD CONSTRAINT fk_riskmtxscr_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskrsppln_risk on table RISKRSPPLN


--METADATA NAME:fk_riskrsppln_risk TYPE:CONSTRAINT TABLE_NAME:RISKRSPPLN CHANGE:CREATE
ALTER TABLE RISKRSPPLN
ADD CONSTRAINT fk_riskrsppln_risk FOREIGN KEY (risk_id)
REFERENCES RISK (risk_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskrsppln_project on table RISKRSPPLN


--METADATA NAME:fk_riskrsppln_project TYPE:CONSTRAINT TABLE_NAME:RISKRSPPLN CHANGE:CREATE
ALTER TABLE RISKRSPPLN
ADD CONSTRAINT fk_riskrsppln_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_riskscrthr_type on table RISKSCRTHR


--METADATA NAME:fk_riskscrthr_type TYPE:CONSTRAINT TABLE_NAME:RISKSCRTHR CHANGE:CREATE
ALTER TABLE RISKSCRTHR
ADD CONSTRAINT fk_riskscrthr_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_rsrc_location on table RSRC


--METADATA NAME:fk_rsrc_location TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_rsrcloc_rsrc on table RSRCLOC


--METADATA NAME:fk_rsrcloc_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCLOC CHANGE:CREATE
ALTER TABLE RSRCLOC
ADD CONSTRAINT fk_rsrcloc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_rsrcrolespread_project on table RSRCROLEASGNMENTSPREAD


--METADATA NAME:fk_rsrcrolespread_project TYPE:CONSTRAINT TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE
ALTER TABLE RSRCROLEASGNMENTSPREAD
ADD CONSTRAINT fk_rsrcrolespread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_snapproj_group on table SNAPPROJ


--METADATA NAME:fk_snapproj_group TYPE:CONSTRAINT TABLE_NAME:SNAPPROJ CHANGE:CREATE
ALTER TABLE SNAPPROJ
ADD CONSTRAINT fk_snapproj_group FOREIGN KEY (snap_group_id)
REFERENCES SNAPGROUP (snap_group_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_snapproj_project on table SNAPPROJ


--METADATA NAME:fk_snapproj_project TYPE:CONSTRAINT TABLE_NAME:SNAPPROJ CHANGE:CREATE
ALTER TABLE SNAPPROJ
ADD CONSTRAINT fk_snapproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_snapshot_group on table SNAPSHOT


--METADATA NAME:fk_snapshot_group TYPE:CONSTRAINT TABLE_NAME:SNAPSHOT CHANGE:CREATE
ALTER TABLE SNAPSHOT
ADD CONSTRAINT fk_snapshot_group FOREIGN KEY (snap_group_id)
REFERENCES SNAPGROUP (snap_group_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_task_cbs on table TASK


--METADATA NAME:fk_task_cbs TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_task_location on table TASK


--METADATA NAME:fk_task_location TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_taskcbsx_project on table TASKCBSX


--METADATA NAME:fk_taskcbsx_project TYPE:CONSTRAINT TABLE_NAME:TASKCBSX CHANGE:CREATE
ALTER TABLE TASKCBSX
ADD CONSTRAINT fk_taskcbsx_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_taskcbsx_cbs on table TASKCBSX


--METADATA NAME:fk_taskcbsx_cbs TYPE:CONSTRAINT TABLE_NAME:TASKCBSX CHANGE:CREATE
ALTER TABLE TASKCBSX
ADD CONSTRAINT fk_taskcbsx_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_taskrsrc_cbs on table TASKRSRC


--METADATA NAME:fk_taskrsrc_cbs TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_timesht_rsrc on table TIMESHT


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT fk_timesht_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_timesht_tsdates on table TIMESHT


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT fk_timesht_tsdates FOREIGN KEY (ts_id)
REFERENCES TSDATES (ts_id) 

ENABLE NOVALIDATE
/

prompt Creating constraint fk_trackofflineuser_users on table TRACKOFFLINEUSER


--METADATA NAME:fk_trackofflineuser_users TYPE:CONSTRAINT TABLE_NAME:TRACKOFFLINEUSER CHANGE:CREATE
ALTER TABLE TRACKOFFLINEUSER
ADD CONSTRAINT fk_trackofflineuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_ts_appr_rsrc on table TSAPPROVERS


--METADATA NAME:fk_ts_appr_rsrc TYPE:CONSTRAINT TABLE_NAME:TSAPPROVERS CHANGE:CREATE
ALTER TABLE TSAPPROVERS
ADD CONSTRAINT fk_ts_appr_rsrc FOREIGN KEY (ts_id,rsrc_id)
REFERENCES TIMESHT (ts_id,rsrc_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_wbsreviewers_projwbs on table WBSREVIEWERS


--METADATA NAME:fk_wbsreviewers_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWERS CHANGE:CREATE
ALTER TABLE WBSREVIEWERS
ADD CONSTRAINT fk_wbsreviewers_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_wbsreviewers_users on table WBSREVIEWERS


--METADATA NAME:fk_wbsreviewers_users TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWERS CHANGE:CREATE
ALTER TABLE WBSREVIEWERS
ADD CONSTRAINT fk_wbsreviewers_users FOREIGN KEY (status_reviewer)
REFERENCES USERS (user_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_wbsreviewstatus_users on table WBSREVIEWSTATUS


--METADATA NAME:fk_wbsreviewstatus_users TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE
ALTER TABLE WBSREVIEWSTATUS
ADD CONSTRAINT fk_wbsreviewstatus_users FOREIGN KEY (status_reviewer)
REFERENCES USERS (user_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

prompt Creating constraint fk_wbsreviewstatus_projwbs on table WBSREVIEWSTATUS


--METADATA NAME:fk_wbsreviewstatus_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE
ALTER TABLE WBSREVIEWSTATUS
ADD CONSTRAINT fk_wbsreviewstatus_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
 ON DELETE CASCADE 
ENABLE NOVALIDATE
/

--METADATA NAME:exp_user_name TYPE:FIELD TABLE_NAME:EXPPROJ CHANGE:ALTER
ALTER TABLE EXPPROJ modify exp_user_name varchar2(255 CHAR)
/

--METADATA NAME:app_user_name TYPE:FIELD TABLE_NAME:EXTAPP CHANGE:ALTER
ALTER TABLE EXTAPP modify app_user_name varchar2(255 CHAR)
/
 
--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
declare 
is_not_null integer:=0;
BEGIN

begin
select 1 into is_not_null from user_tab_columns where table_name=upper('JOBSVC') and nullable='N' and column_name =upper('user_id');
if  is_not_null = 1 then 
 EXECUTE IMMEDIATE 'ALTER TABLE JOBSVC modify user_id  NULL';
end if;
exception when NO_DATA_FOUND then
  null;
end; 

END; 
/
 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
declare 
is_not_null integer:=0;
BEGIN

begin
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('add_date');
if  is_not_null = 1 then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify add_date  NOT NULL  ENABLE NOVALIDATE';
end if;
exception when NO_DATA_FOUND then
  null;
end; 

END; 
/

--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK modify risk_name varchar2(120 CHAR)
/

--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify email_addr varchar2(255 CHAR)
/

--METADATA NAME:email_srv_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify email_srv_user_name varchar2(255 CHAR)
/

--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify email_addr varchar2(255 CHAR)
/

prompt Creating index ndx_actvcodehier_type on table ACTIVITYCODEHIERARCHY

--METADATA NAME:ndx_actvcodehier_type TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_type
ON ACTIVITYCODEHIERARCHY (codetypeobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcodehier_parent on table ACTIVITYCODEHIERARCHY

--METADATA NAME:ndx_actvcodehier_parent TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_parent
ON ACTIVITYCODEHIERARCHY (parentcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcodehier_child on table ACTIVITYCODEHIERARCHY

--METADATA NAME:ndx_actvcodehier_child TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_child
ON ACTIVITYCODEHIERARCHY (childcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_actvcodehier_projid on table ACTIVITYCODEHIERARCHY

--METADATA NAME:ndx_actvcodehier_projid TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_projid
ON ACTIVITYCODEHIERARCHY (codetypeprojectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pk_ActvityTypeSecurity on table ACTIVITYCODETYPESECURITY

--METADATA NAME:ndx_pk_ActvityTypeSecurity TYPE:INDEX TABLE_NAME:ACTIVITYCODETYPESECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_ActvityTypeSecurity
ON ACTIVITYCODETYPESECURITY (rdbmsuserid,projectobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_activityspread_project on table ACTIVITYSPREAD

--METADATA NAME:ndx_activityspread_project TYPE:INDEX TABLE_NAME:ACTIVITYSPREAD CHANGE:CREATE      
CREATE INDEX ndx_activityspread_project
ON ACTIVITYSPREAD (projectobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_activityspread on table ACTIVITYSPREAD

--METADATA NAME:ndx_activityspread TYPE:INDEX TABLE_NAME:ACTIVITYSPREAD CHANGE:CREATE      
CREATE INDEX ndx_activityspread
ON ACTIVITYSPREAD (activityobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtaskproc_project on table ADDTASKPROC

--METADATA NAME:ndx_addtaskproc_project TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_project
ON ADDTASKPROC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtaskproc_task on table ADDTASKPROC

--METADATA NAME:ndx_addtaskproc_task TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_task
ON ADDTASKPROC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtaskproc_chghead on table ADDTASKPROC

--METADATA NAME:ndx_addtaskproc_chghead TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_chghead
ON ADDTASKPROC (transaction_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtaskproc_dsi on table ADDTASKPROC

--METADATA NAME:ndx_addtaskproc_dsi TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_dsi
ON ADDTASKPROC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtrsrc_header on table ADDTRSRC

--METADATA NAME:ndx_addtrsrc_header TYPE:INDEX TABLE_NAME:ADDTRSRC CHANGE:CREATE      
CREATE INDEX ndx_addtrsrc_header
ON ADDTRSRC (transaction_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_addtrsrc_task on table ADDTRSRC

--METADATA NAME:ndx_addtrsrc_task TYPE:INDEX TABLE_NAME:ADDTRSRC CHANGE:CREATE      
CREATE INDEX ndx_addtrsrc_task
ON ADDTRSRC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_alert_users on table ALERT

--METADATA NAME:ndx_alert_users TYPE:INDEX TABLE_NAME:ALERT CHANGE:CREATE      
CREATE INDEX ndx_alert_users
ON ALERT (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_announcement_user_status on table ANNOUNCEMENT_USER

--METADATA NAME:ndx_announcement_user_status TYPE:INDEX TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE      
CREATE INDEX ndx_announcement_user_status
ON ANNOUNCEMENT_USER (status_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_assgnmntcodehier_type on table ASSIGNMENTCODEHIERARCHY

--METADATA NAME:ndx_assgnmntcodehier_type TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_type
ON ASSIGNMENTCODEHIERARCHY (codetypeobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_assgnmntcodehier_parent on table ASSIGNMENTCODEHIERARCHY

--METADATA NAME:ndx_assgnmntcodehier_parent TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_parent
ON ASSIGNMENTCODEHIERARCHY (parentcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_assgnmntcodehier_child on table ASSIGNMENTCODEHIERARCHY

--METADATA NAME:ndx_assgnmntcodehier_child TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_child
ON ASSIGNMENTCODEHIERARCHY (childcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_attr_master_dsi on table ATTR_MASTER

--METADATA NAME:ndx_attr_master_dsi TYPE:INDEX TABLE_NAME:ATTR_MASTER CHANGE:CREATE      
CREATE INDEX ndx_attr_master_dsi
ON ATTR_MASTER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_attr_master_upd on table ATTR_MASTER

--METADATA NAME:ndx_attr_master_upd TYPE:INDEX TABLE_NAME:ATTR_MASTER CHANGE:CREATE      
CREATE INDEX ndx_attr_master_upd
ON ATTR_MASTER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_bodeflabels_source on table BODEFLABELS

--METADATA NAME:ndx_bodeflabels_source TYPE:INDEX TABLE_NAME:BODEFLABELS CHANGE:CREATE      
CREATE INDEX ndx_bodeflabels_source
ON BODEFLABELS (source_table_name,source_column_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_calendar_default_flag on table CALENDAR

--METADATA NAME:ndx_calendar_default_flag TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE      
CREATE INDEX ndx_calendar_default_flag
ON CALENDAR (default_flag)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_calendar_clndr_type on table CALENDAR

--METADATA NAME:ndx_calendar_clndr_type TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE      
CREATE INDEX ndx_calendar_clndr_type
ON CALENDAR (clndr_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_cbs_project on table CBS

--METADATA NAME:ndx_cbs_project TYPE:INDEX TABLE_NAME:CBS CHANGE:CREATE      
CREATE INDEX ndx_cbs_project
ON CBS (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chghead_dsi on table CHGHEAD

--METADATA NAME:ndx_chghead_dsi TYPE:INDEX TABLE_NAME:CHGHEAD CHANGE:CREATE      
CREATE INDEX ndx_chghead_dsi
ON CHGHEAD (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtask_task on table CHGTASK

--METADATA NAME:ndx_chgtask_task TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_task
ON CHGTASK (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtask_project on table CHGTASK

--METADATA NAME:ndx_chgtask_project TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_project
ON CHGTASK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtask_dsi on table CHGTASK

--METADATA NAME:ndx_chgtask_dsi TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_dsi
ON CHGTASK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskactv_task on table CHGTASKACTV

--METADATA NAME:ndx_chgtaskactv_task TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_task
ON CHGTASKACTV (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskactv_project on table CHGTASKACTV

--METADATA NAME:ndx_chgtaskactv_project TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_project
ON CHGTASKACTV (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskactv_actvcode on table CHGTASKACTV

--METADATA NAME:ndx_chgtaskactv_actvcode TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_actvcode
ON CHGTASKACTV (actv_code_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskactv_dsi on table CHGTASKACTV

--METADATA NAME:ndx_chgtaskactv_dsi TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_dsi
ON CHGTASKACTV (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskmemo_taskmemo on table CHGTASKMEMO

--METADATA NAME:ndx_chgtaskmemo_taskmemo TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_taskmemo
ON CHGTASKMEMO (memo_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskmemo_task on table CHGTASKMEMO

--METADATA NAME:ndx_chgtaskmemo_task TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_task
ON CHGTASKMEMO (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskmemo_dsi on table CHGTASKMEMO

--METADATA NAME:ndx_chgtaskmemo_dsi TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_dsi
ON CHGTASKMEMO (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskproc_taskproc on table CHGTASKPROC

--METADATA NAME:ndx_chgtaskproc_taskproc TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_taskproc
ON CHGTASKPROC (proc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskproc_project on table CHGTASKPROC

--METADATA NAME:ndx_chgtaskproc_project TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_project
ON CHGTASKPROC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskproc_task on table CHGTASKPROC

--METADATA NAME:ndx_chgtaskproc_task TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_task
ON CHGTASKPROC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtaskproc_dsi on table CHGTASKPROC

--METADATA NAME:ndx_chgtaskproc_dsi TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_dsi
ON CHGTASKPROC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtrsrc_taskrsrc on table CHGTRSRC

--METADATA NAME:ndx_chgtrsrc_taskrsrc TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_taskrsrc
ON CHGTRSRC (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtrsrc_task on table CHGTRSRC

--METADATA NAME:ndx_chgtrsrc_task TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_task
ON CHGTRSRC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgtrsrc_dsi on table CHGTRSRC

--METADATA NAME:ndx_chgtrsrc_dsi TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_dsi
ON CHGTRSRC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgudfvalue_udfvalue on table CHGUDFVALUE

--METADATA NAME:ndx_chgudfvalue_udfvalue TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_udfvalue
ON CHGUDFVALUE (fk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgudfvalue_udftype on table CHGUDFVALUE

--METADATA NAME:ndx_chgudfvalue_udftype TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_udftype
ON CHGUDFVALUE (udf_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgudfvalue_project on table CHGUDFVALUE

--METADATA NAME:ndx_chgudfvalue_project TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_project
ON CHGUDFVALUE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_chgudfvalue_dsi on table CHGUDFVALUE

--METADATA NAME:ndx_chgudfvalue_dsi TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_dsi
ON CHGUDFVALUE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_costaccthier_parentobj on table COSTACCOUNTHIERARCHY

--METADATA NAME:ndx_costaccthier_parentobj TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_parentobj
ON COSTACCOUNTHIERARCHY (parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_costaccthier_parent on table COSTACCOUNTHIERARCHY

--METADATA NAME:ndx_costaccthier_parent TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_parent
ON COSTACCOUNTHIERARCHY (parentid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_costaccthier_child on table COSTACCOUNTHIERARCHY

--METADATA NAME:ndx_costaccthier_child TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_child
ON COSTACCOUNTHIERARCHY (childobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pk_CostSecurity on table COSTSECURITY

--METADATA NAME:ndx_pk_CostSecurity TYPE:INDEX TABLE_NAME:COSTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_CostSecurity
ON COSTSECURITY (rdbmsuserid,projectobjectid,wholeprojectflag)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deltaskproc_taskproc on table DELTASKPROC

--METADATA NAME:ndx_deltaskproc_taskproc TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_taskproc
ON DELTASKPROC (proc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deltaskproc_project on table DELTASKPROC

--METADATA NAME:ndx_deltaskproc_project TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_project
ON DELTASKPROC (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deltaskproc_task on table DELTASKPROC

--METADATA NAME:ndx_deltaskproc_task TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_task
ON DELTASKPROC (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deltaskproc_dsi on table DELTASKPROC

--METADATA NAME:ndx_deltaskproc_dsi TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_dsi
ON DELTASKPROC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_project on table DISCUSSION

--METADATA NAME:ndx_discussion_project TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE      
CREATE INDEX ndx_discussion_project
ON DISCUSSION (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_read_users on table DISCUSSION_READ

--METADATA NAME:ndx_discussion_read_users TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE      
CREATE INDEX ndx_discussion_read_users
ON DISCUSSION_READ (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dm_attr_guid on table DM_ATTR

--METADATA NAME:ndx_dm_attr_guid TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_guid
ON DM_ATTR (attr_id,guid)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 64k next 64k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dm_attr_dsi on table DM_ATTR

--METADATA NAME:ndx_dm_attr_dsi TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_dsi
ON DM_ATTR (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_dm_attr_upd on table DM_ATTR

--METADATA NAME:ndx_dm_attr_upd TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_upd
ON DM_ATTR (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_dsi on table DOC

--METADATA NAME:ndx_doc_dsi TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_dsi
ON DOC (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_upd on table DOC

--METADATA NAME:ndx_doc_upd TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_upd
ON DOC (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_1 on table DOC

--METADATA NAME:ndx_doc_1 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_1
ON DOC (doc_folder_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_2 on table DOC

--METADATA NAME:ndx_doc_2 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_2
ON DOC (doc_uuid)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_3 on table DOC

--METADATA NAME:ndx_doc_3 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_3
ON DOC (file_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_folder_dsi on table DOC_FOLDER

--METADATA NAME:ndx_doc_folder_dsi TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_dsi
ON DOC_FOLDER (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_folder_upd on table DOC_FOLDER

--METADATA NAME:ndx_doc_folder_upd TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_upd
ON DOC_FOLDER (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_folder_1 on table DOC_FOLDER

--METADATA NAME:ndx_doc_folder_1 TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_1
ON DOC_FOLDER (parent_folder_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_folder_2 on table DOC_FOLDER

--METADATA NAME:ndx_doc_folder_2 TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_2
ON DOC_FOLDER (doc_folder_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_recent_doc_folder on table DOC_RECENT

--METADATA NAME:ndx_doc_recent_doc_folder TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_doc_folder
ON DOC_RECENT (doc_folder_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_recent_doc on table DOC_RECENT

--METADATA NAME:ndx_doc_recent_doc TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_doc
ON DOC_RECENT (doc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_recent_dsi on table DOC_RECENT

--METADATA NAME:ndx_doc_recent_dsi TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_dsi
ON DOC_RECENT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_recent_upd on table DOC_RECENT

--METADATA NAME:ndx_doc_recent_upd TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_upd
ON DOC_RECENT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_recent_1 on table DOC_RECENT

--METADATA NAME:ndx_doc_recent_1 TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_1
ON DOC_RECENT (doc_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_version_dsi on table DOC_VERSION

--METADATA NAME:ndx_doc_version_dsi TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_dsi
ON DOC_VERSION (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_version_upd on table DOC_VERSION

--METADATA NAME:ndx_doc_version_upd TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_upd
ON DOC_VERSION (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_version_1 on table DOC_VERSION

--METADATA NAME:ndx_doc_version_1 TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_1
ON DOC_VERSION (doc_uuid,version)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_doc_version_2 on table DOC_VERSION

--METADATA NAME:ndx_doc_version_2 TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_2
ON DOC_VERSION (doc_id,version)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epshier_parentobj on table EPSHIERARCHY

--METADATA NAME:ndx_epshier_parentobj TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parentobj
ON EPSHIERARCHY (parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epshier_parent on table EPSHIERARCHY

--METADATA NAME:ndx_epshier_parent TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parent
ON EPSHIERARCHY (parentid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epshier_childobj on table EPSHIERARCHY

--METADATA NAME:ndx_epshier_childobj TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_childobj
ON EPSHIERARCHY (childobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epshier_parentprojid on table EPSHIERARCHY

--METADATA NAME:ndx_epshier_parentprojid TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parentprojid
ON EPSHIERARCHY (parentprojectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epshier_childprojid on table EPSHIERARCHY

--METADATA NAME:ndx_epshier_childprojid TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_childprojid
ON EPSHIERARCHY (childprojectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epsspread_objid on table EPSSPREAD

--METADATA NAME:ndx_epsspread_objid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_objid
ON EPSSPREAD (objectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epsspread_parentobjid on table EPSSPREAD

--METADATA NAME:ndx_epsspread_parentobjid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_parentobjid
ON EPSSPREAD (parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_epsspread_obsid on table EPSSPREAD

--METADATA NAME:ndx_epsspread_obsid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_obsid
ON EPSSPREAD (obsobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_filtprop_rpt on table FILTPROP

--METADATA NAME:ndx_filtprop_rpt TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE      
CREATE INDEX ndx_filtprop_rpt
ON FILTPROP (rpt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deplmnt_name_provider_id on table GATEWAYDEPLOYMENT

--METADATA NAME:ndx_deplmnt_name_provider_id TYPE:INDEX TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_deplmnt_name_provider_id
ON GATEWAYDEPLOYMENT (deployment_name,provider_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_deplmnt_gatewayprov on table GATEWAYDEPLOYMENT

--METADATA NAME:ndx_deplmnt_gatewayprov TYPE:INDEX TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE      
CREATE INDEX ndx_deplmnt_gatewayprov
ON GATEWAYDEPLOYMENT (provider_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_provider_name on table GATEWAYPROVIDER

--METADATA NAME:ndx_provider_name TYPE:INDEX TABLE_NAME:GATEWAYPROVIDER CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_provider_name
ON GATEWAYPROVIDER (provider_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_action_name on table GATEWAYSYNCACTION

--METADATA NAME:ndx_action_name TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_action_name
ON GATEWAYSYNCACTION (action_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_gatewaysync_gatewaydepl on table GATEWAYSYNCACTION

--METADATA NAME:ndx_gatewaysync_gatewaydepl TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE INDEX ndx_gatewaysync_gatewaydepl
ON GATEWAYSYNCACTION (deplmnt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sync_typ_name_deplmnt_id on table GATEWAYSYNCACTION

--METADATA NAME:ndx_sync_typ_name_deplmnt_id TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_sync_typ_name_deplmnt_id
ON GATEWAYSYNCACTION (sync_type,sync_name,deplmnt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pk_globasecurity on table GLOBALSECURITY

--METADATA NAME:ndx_pk_globasecurity TYPE:INDEX TABLE_NAME:GLOBALSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_globasecurity
ON GLOBALSECURITY (rdbmsuserid,securecodeflag,resourcecostflag,proficiencyflag,auditdataflag)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index gtt_pklist_idx on table GTT_PKLIST

--METADATA NAME:gtt_pklist_idx TYPE:INDEX TABLE_NAME:GTT_PKLIST CHANGE:CREATE      
CREATE INDEX gtt_pklist_idx
ON GTT_PKLIST (pk_id)

/

prompt Creating index ndx_iteration_name on table ITERATION

--METADATA NAME:ndx_iteration_name TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE      
CREATE INDEX ndx_iteration_name
ON ITERATION (iteration_name,iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_itertask_task on table ITERTASK

--METADATA NAME:ndx_itertask_task TYPE:INDEX TABLE_NAME:ITERTASK CHANGE:CREATE      
CREATE INDEX ndx_itertask_task
ON ITERTASK (task_id,iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_iterteam_rfolio on table ITERTEAM

--METADATA NAME:ndx_iterteam_rfolio TYPE:INDEX TABLE_NAME:ITERTEAM CHANGE:CREATE      
CREATE INDEX ndx_iterteam_rfolio
ON ITERTEAM (rfolio_id,iteration_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_jobproj_lkp_jobsvc on table JOBPROJ_LKP

--METADATA NAME:ndx_jobproj_lkp_jobsvc TYPE:INDEX TABLE_NAME:JOBPROJ_LKP CHANGE:CREATE      
CREATE INDEX ndx_jobproj_lkp_jobsvc
ON JOBPROJ_LKP (job_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobset_dsi on table JOBSET

--METADATA NAME:ndx_jobset_dsi TYPE:INDEX TABLE_NAME:JOBSET CHANGE:CREATE      
CREATE INDEX ndx_jobset_dsi
ON JOBSET (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_jobsvc_logical_type_key on table JOBSVC

--METADATA NAME:ndx_jobsvc_logical_type_key TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE      
CREATE INDEX ndx_jobsvc_logical_type_key
ON JOBSVC (job_type,job_type_key,status_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_leantask_task_id on table LEANTASK

--METADATA NAME:ndx_leantask_task_id TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_task_id
ON LEANTASK (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_leantask_proj_id on table LEANTASK

--METADATA NAME:ndx_leantask_proj_id TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_proj_id
ON LEANTASK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_leantask_dsi on table LEANTASK

--METADATA NAME:ndx_leantask_dsi TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_dsi
ON LEANTASK (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_mtxscrtyp_scoretype on table MTXSCRTYP

--METADATA NAME:ndx_mtxscrtyp_scoretype TYPE:INDEX TABLE_NAME:MTXSCRTYP CHANGE:CREATE      
CREATE INDEX ndx_mtxscrtyp_scoretype
ON MTXSCRTYP (scoretype_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_paudit_audit_ts on table PAUDIT

--METADATA NAME:ndx_paudit_audit_ts TYPE:INDEX TABLE_NAME:PAUDIT CHANGE:CREATE      
CREATE INDEX ndx_paudit_audit_ts
ON PAUDIT (audit_ts)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pauditx_audit_ts on table PAUDITX

--METADATA NAME:ndx_pauditx_audit_ts TYPE:INDEX TABLE_NAME:PAUDITX CHANGE:CREATE      
CREATE INDEX ndx_pauditx_audit_ts
ON PAUDITX (audit_ts)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pauditx_table_name_proj_id on table PAUDITX

--METADATA NAME:ndx_pauditx_table_name_proj_id TYPE:INDEX TABLE_NAME:PAUDITX CHANGE:CREATE      
CREATE INDEX ndx_pauditx_table_name_proj_id
ON PAUDITX (table_name,proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pckeyxref_1 on table PC_KEY_XREF

--METADATA NAME:ndx_pckeyxref_1 TYPE:INDEX TABLE_NAME:PC_KEY_XREF CHANGE:CREATE      
CREATE INDEX ndx_pckeyxref_1
ON PC_KEY_XREF (execution_id,ref_table,source_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pc_process_stat_dsi on table PC_PROCESS_STAT

--METADATA NAME:ndx_pc_process_stat_dsi TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_dsi
ON PC_PROCESS_STAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pc_process_stat_upd on table PC_PROCESS_STAT

--METADATA NAME:ndx_pc_process_stat_upd TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_upd
ON PC_PROCESS_STAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pc_process_stat_1 on table PC_PROCESS_STAT

--METADATA NAME:ndx_pc_process_stat_1 TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_1
ON PC_PROCESS_STAT (execution_id,process_name,step_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_prefer_currtype on table PREFER

--METADATA NAME:ndx_prefer_currtype TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE      
CREATE INDEX ndx_prefer_currtype
ON PREFER (curr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 32k next 32k minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcost_cbs on table PROJCOST

--METADATA NAME:ndx_projcost_cbs TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE      
CREATE INDEX ndx_projcost_cbs
ON PROJCOST (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projdeplment_project on table PROJDEPLMENT

--METADATA NAME:ndx_projdeplment_project TYPE:INDEX TABLE_NAME:PROJDEPLMENT CHANGE:CREATE      
CREATE INDEX ndx_projdeplment_project
ON PROJDEPLMENT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projdeplment_gatewaydepl on table PROJDEPLMENT

--METADATA NAME:ndx_projdeplment_gatewaydepl TYPE:INDEX TABLE_NAME:PROJDEPLMENT CHANGE:CREATE      
CREATE INDEX ndx_projdeplment_gatewaydepl
ON PROJDEPLMENT (deplmnt_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_location on table PROJECT

--METADATA NAME:ndx_project_location TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE      
CREATE INDEX ndx_project_location
ON PROJECT (location_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_project_flag on table PROJECT

--METADATA NAME:ndx_project_project_flag TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE      
CREATE INDEX ndx_project_project_flag
ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcodehier_type on table PROJECTCODEHIERARCHY

--METADATA NAME:ndx_projcodehier_type TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_type
ON PROJECTCODEHIERARCHY (codetypeobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcodehier_parent on table PROJECTCODEHIERARCHY

--METADATA NAME:ndx_projcodehier_parent TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_parent
ON PROJECTCODEHIERARCHY (parentcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcodehier_child on table PROJECTCODEHIERARCHY

--METADATA NAME:ndx_projcodehier_child TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_child
ON PROJECTCODEHIERARCHY (childcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcostcbsspread_cost on table PROJECTCOSTCBSSPREAD

--METADATA NAME:ndx_projcostcbsspread_cost TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_cost
ON PROJECTCOSTCBSSPREAD (cost_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcostcbsspread_proj on table PROJECTCOSTCBSSPREAD

--METADATA NAME:ndx_projcostcbsspread_proj TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_proj
ON PROJECTCOSTCBSSPREAD (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projcostcbsspread_cbs on table PROJECTCOSTCBSSPREAD

--METADATA NAME:ndx_projcostcbsspread_cbs TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_cbs
ON PROJECTCOSTCBSSPREAD (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_pk_ProjectSecurity on table PROJECTSECURITY

--METADATA NAME:ndx_pk_ProjectSecurity TYPE:INDEX TABLE_NAME:PROJECTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_ProjectSecurity
ON PROJECTSECURITY (rdbmsuserid,projectobjectid,costflag)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projsec_projobjid on table PROJECTSECURITY

--METADATA NAME:ndx_projsec_projobjid TYPE:INDEX TABLE_NAME:PROJECTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_projsec_projobjid
ON PROJECTSECURITY (projectobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projspread_objid on table PROJECTSPREAD

--METADATA NAME:ndx_projspread_objid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_objid
ON PROJECTSPREAD (objectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projspread_parentepsid on table PROJECTSPREAD

--METADATA NAME:ndx_projspread_parentepsid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_parentepsid
ON PROJECTSPREAD (parentepsobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projspread_obsid on table PROJECTSPREAD

--METADATA NAME:ndx_projspread_obsid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_obsid
ON PROJECTSPREAD (obsobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_etl_list_project on table PROJECT_ETL_LIST

--METADATA NAME:ndx_project_etl_list_project TYPE:INDEX TABLE_NAME:PROJECT_ETL_LIST CHANGE:CREATE      
CREATE INDEX ndx_project_etl_list_project
ON PROJECT_ETL_LIST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcat_project on table PROJPCAT

--METADATA NAME:ndx_projpcat_project TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE      
CREATE INDEX ndx_projpcat_project
ON PROJPCAT (DELETE_SESSION_ID,PROJ_ID,PROJ_CATG_TYPE_ID)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcatx_project on table PROJPCATX

--METADATA NAME:ndx_projpcatx_project TYPE:INDEX TABLE_NAME:PROJPCATX CHANGE:CREATE      
CREATE INDEX ndx_projpcatx_project
ON PROJPCATX (UPPER("PROJECTCODETYPENAME"),UPPER("PROJECTCODEVALUE"),ISSECURECODE,PROJ_ID,PROJ_CATG_TYPE_ID)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projpcatx_pcv on table PROJPCATX

--METADATA NAME:ndx_projpcatx_pcv TYPE:INDEX TABLE_NAME:PROJPCATX CHANGE:CREATE      
CREATE INDEX ndx_projpcatx_pcv
ON PROJPCATX (NVL("PROJECTCODEVALUE",'N'),UPPER("PROJECTCODETYPENAME"),"ISSECURECODE")
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_obs on table PROJRISK

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE      
CREATE INDEX ndx_projrisk_obs
ON PROJRISK (obs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projrisk_projwbs on table PROJRISK

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE      
CREATE INDEX ndx_projrisk_projwbs
ON PROJRISK (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projset_dsi on table PROJSET

--METADATA NAME:ndx_projset_dsi TYPE:INDEX TABLE_NAME:PROJSET CHANGE:CREATE      
CREATE INDEX ndx_projset_dsi
ON PROJSET (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projset_project on table PROJSET

--METADATA NAME:ndx_projset_project TYPE:INDEX TABLE_NAME:PROJSET CHANGE:CREATE      
CREATE INDEX ndx_projset_project
ON PROJSET (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projshar_proj_id on table PROJSHAR

--METADATA NAME:ndx_projshar_proj_id TYPE:INDEX TABLE_NAME:PROJSHAR CHANGE:CREATE      
CREATE INDEX ndx_projshar_proj_id
ON PROJSHAR (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_projwbs_status_code on table PROJWBS

--METADATA NAME:ndx_projwbs_status_code TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE      
CREATE INDEX ndx_projwbs_status_code
ON PROJWBS (proj_id,status_code,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_release_name on table RELEASE

--METADATA NAME:ndx_release_name TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE      
CREATE INDEX ndx_release_name
ON RELEASE (release_name,release_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_reliter_iteration on table RELITER

--METADATA NAME:ndx_reliter_iteration TYPE:INDEX TABLE_NAME:RELITER CHANGE:CREATE      
CREATE INDEX ndx_reliter_iteration
ON RELITER (iteration_id,release_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_relproj_project on table RELPROJ

--METADATA NAME:ndx_relproj_project TYPE:INDEX TABLE_NAME:RELPROJ CHANGE:CREATE      
CREATE INDEX ndx_relproj_project
ON RELPROJ (proj_id,release_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_rascbsspread_rsrc on table RESOURCEASSIGNMENTCBSSPREAD

--METADATA NAME:ndx_rascbsspread_rsrc TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_rsrc
ON RESOURCEASSIGNMENTCBSSPREAD (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rascbsspread_proj on table RESOURCEASSIGNMENTCBSSPREAD

--METADATA NAME:ndx_rascbsspread_proj TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_proj
ON RESOURCEASSIGNMENTCBSSPREAD (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rascbsspread_cbs on table RESOURCEASSIGNMENTCBSSPREAD

--METADATA NAME:ndx_rascbsspread_cbs TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_cbs
ON RESOURCEASSIGNMENTCBSSPREAD (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index idx_comp_rsrcasgnmntcbssprd on table RESOURCEASSIGNMENTCBSSPREAD

--METADATA NAME:idx_comp_rsrcasgnmntcbssprd TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX idx_comp_rsrcasgnmntcbssprd
ON RESOURCEASSIGNMENTCBSSPREAD (proj_id,rsrc_id,cbs_id,spread_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_raspread_project on table RESOURCEASSIGNMENTSPREAD

--METADATA NAME:ndx_raspread_project TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_project
ON RESOURCEASSIGNMENTSPREAD (projectobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_raspread on table RESOURCEASSIGNMENTSPREAD

--METADATA NAME:ndx_raspread TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread
ON RESOURCEASSIGNMENTSPREAD (activityobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_raspread_objid on table RESOURCEASSIGNMENTSPREAD

--METADATA NAME:ndx_raspread_objid TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_objid
ON RESOURCEASSIGNMENTSPREAD (resourceassignmentobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_raspread_rsrcobjid on table RESOURCEASSIGNMENTSPREAD

--METADATA NAME:ndx_raspread_rsrcobjid TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_rsrcobjid
ON RESOURCEASSIGNMENTSPREAD (resourceobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 1M next 1M  minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrccodehier_type on table RESOURCECODEHIERARCHY

--METADATA NAME:ndx_rsrccodehier_type TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_type
ON RESOURCECODEHIERARCHY (codetypeobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrccodehier_parent on table RESOURCECODEHIERARCHY

--METADATA NAME:ndx_rsrccodehier_parent TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_parent
ON RESOURCECODEHIERARCHY (parentcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrccodehier_child on table RESOURCECODEHIERARCHY

--METADATA NAME:ndx_rsrccodehier_child TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_child
ON RESOURCECODEHIERARCHY (childcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchier_parentobj on table RESOURCEHIERARCHY

--METADATA NAME:ndx_rsrchier_parentobj TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_parentobj
ON RESOURCEHIERARCHY (parentobjectid,childobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchier_parent on table RESOURCEHIERARCHY

--METADATA NAME:ndx_rsrchier_parent TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_parent
ON RESOURCEHIERARCHY (parentid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchier_child on table RESOURCEHIERARCHY

--METADATA NAME:ndx_rsrchier_child TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_child
ON RESOURCEHIERARCHY (childobjectid,parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_risk_project on table RISK

--METADATA NAME:ndx_risk_project TYPE:INDEX TABLE_NAME:RISK CHANGE:CREATE      
CREATE INDEX ndx_risk_project
ON RISK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_risk_rsrc on table RISK

--METADATA NAME:ndx_risk_rsrc TYPE:INDEX TABLE_NAME:RISK CHANGE:CREATE      
CREATE INDEX ndx_risk_rsrc
ON RISK (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskimpact_project on table RISKIMPACT

--METADATA NAME:ndx_riskimpact_project TYPE:INDEX TABLE_NAME:RISKIMPACT CHANGE:CREATE      
CREATE INDEX ndx_riskimpact_project
ON RISKIMPACT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskimpact_scoretype on table RISKIMPACT

--METADATA NAME:ndx_riskimpact_scoretype TYPE:INDEX TABLE_NAME:RISKIMPACT CHANGE:CREATE      
CREATE INDEX ndx_riskimpact_scoretype
ON RISKIMPACT (scoretype_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmit_response on table RISKMIT

--METADATA NAME:ndx_riskmit_response TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_response
ON RISKMIT (response_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmit_task on table RISKMIT

--METADATA NAME:ndx_riskmit_task TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_task
ON RISKMIT (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmit_project on table RISKMIT

--METADATA NAME:ndx_riskmit_project TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_project
ON RISKMIT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmitimp_proj on table RISKMITIMP

--METADATA NAME:ndx_riskmitimp_proj TYPE:INDEX TABLE_NAME:RISKMITIMP CHANGE:CREATE      
CREATE INDEX ndx_riskmitimp_proj
ON RISKMITIMP (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmitimp_scoretype on table RISKMITIMP

--METADATA NAME:ndx_riskmitimp_scoretype TYPE:INDEX TABLE_NAME:RISKMITIMP CHANGE:CREATE      
CREATE INDEX ndx_riskmitimp_scoretype
ON RISKMITIMP (scoretype_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskmtxscr_matrix on table RISKMTXSCR

--METADATA NAME:ndx_riskmtxscr_matrix TYPE:INDEX TABLE_NAME:RISKMTXSCR CHANGE:CREATE      
CREATE INDEX ndx_riskmtxscr_matrix
ON RISKMTXSCR (matrix_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskrsppln_risk on table RISKRSPPLN

--METADATA NAME:ndx_riskrsppln_risk TYPE:INDEX TABLE_NAME:RISKRSPPLN CHANGE:CREATE      
CREATE INDEX ndx_riskrsppln_risk
ON RISKRSPPLN (risk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskrsppln_project on table RISKRSPPLN

--METADATA NAME:ndx_riskrsppln_project TYPE:INDEX TABLE_NAME:RISKRSPPLN CHANGE:CREATE      
CREATE INDEX ndx_riskrsppln_project
ON RISKRSPPLN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_riskscrthr_type on table RISKSCRTHR

--METADATA NAME:ndx_riskscrthr_type TYPE:INDEX TABLE_NAME:RISKSCRTHR CHANGE:CREATE      
CREATE INDEX ndx_riskscrthr_type
ON RISKSCRTHR (scoretype_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecodehier_type on table ROLECODEHIERARCHY

--METADATA NAME:ndx_rolecodehier_type TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_type
ON ROLECODEHIERARCHY (codetypeobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecodehier_parent on table ROLECODEHIERARCHY

--METADATA NAME:ndx_rolecodehier_parent TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_parent
ON ROLECODEHIERARCHY (parentcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecodehier_child on table ROLECODEHIERARCHY

--METADATA NAME:ndx_rolecodehier_child TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_child
ON ROLECODEHIERARCHY (childcodevalueobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rpt_users on table RPT

--METADATA NAME:ndx_rpt_users TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE      
CREATE INDEX ndx_rpt_users
ON RPT (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_location on table RSRC

--METADATA NAME:ndx_rsrc_location TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE      
CREATE INDEX ndx_rsrc_location
ON RSRC (location_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_act_req on table RSRCHOUR

--METADATA NAME:ndx_act_req TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE      
CREATE INDEX ndx_act_req
ON RSRCHOUR (status_code,rsrc_id,ts_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcloc_rsrc on table RSRCLOC

--METADATA NAME:ndx_rsrcloc_rsrc TYPE:INDEX TABLE_NAME:RSRCLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcloc_rsrc
ON RSRCLOC (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcoveralloc_rsrc_id on table RSRCOVERALLOC

--METADATA NAME:ndx_rsrcoveralloc_rsrc_id TYPE:INDEX TABLE_NAME:RSRCOVERALLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcoveralloc_rsrc_id
ON RSRCOVERALLOC (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcoveralloc_role_id on table RSRCOVERALLOC

--METADATA NAME:ndx_rsrcoveralloc_role_id TYPE:INDEX TABLE_NAME:RSRCOVERALLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcoveralloc_role_id
ON RSRCOVERALLOC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcroleasgnmntsprd_proj on table RSRCROLEASGNMENTSPREAD

--METADATA NAME:ndx_rsrcroleasgnmntsprd_proj TYPE:INDEX TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rsrcroleasgnmntsprd_proj
ON RSRCROLEASGNMENTSPREAD (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrlasgnmntsprd_rl_id on table RSRCROLEASGNMENTSPREAD

--METADATA NAME:ndx_rsrcrlasgnmntsprd_rl_id TYPE:INDEX TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rsrcrlasgnmntsprd_rl_id
ON RSRCROLEASGNMENTSPREAD (role_id,spread_start_date,spread_end_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrcrlasgnmntsprd_rsrc_id on table RSRCROLEASGNMENTSPREAD

--METADATA NAME:ndx_rsrcrlasgnmntsprd_rsrc_id TYPE:INDEX TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rsrcrlasgnmntsprd_rsrc_id
ON RSRCROLEASGNMENTSPREAD (rsrc_id,spread_start_date,spread_end_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_setting_id on table SETTINGS

--METADATA NAME:ndx_setting_id TYPE:INDEX TABLE_NAME:SETTINGS CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_setting_id
ON SETTINGS (setting_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_snapgroup_name on table SNAPGROUP

--METADATA NAME:ndx_snapgroup_name TYPE:INDEX TABLE_NAME:SNAPGROUP CHANGE:CREATE      
CREATE INDEX ndx_snapgroup_name
ON SNAPGROUP (snap_group_name,snap_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_snapgroup_dsi on table SNAPGROUP

--METADATA NAME:ndx_snapgroup_dsi TYPE:INDEX TABLE_NAME:SNAPGROUP CHANGE:CREATE      
CREATE INDEX ndx_snapgroup_dsi
ON SNAPGROUP (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_snapproj_project on table SNAPPROJ

--METADATA NAME:ndx_snapproj_project TYPE:INDEX TABLE_NAME:SNAPPROJ CHANGE:CREATE      
CREATE INDEX ndx_snapproj_project
ON SNAPPROJ (proj_id,snap_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 50)
/

prompt Creating index ndx_snapshot_name on table SNAPSHOT

--METADATA NAME:ndx_snapshot_name TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_name
ON SNAPSHOT (snapshot_name,snapshot_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_snapshot_group on table SNAPSHOT

--METADATA NAME:ndx_snapshot_group TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_group
ON SNAPSHOT (snap_group_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_snapshot_dsi on table SNAPSHOT

--METADATA NAME:ndx_snapshot_dsi TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_dsi
ON SNAPSHOT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 1M minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_role on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_role TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE      
CREATE INDEX ndx_sumtrsrc_role
ON SUMTRSRC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_perf on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_perf TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE      
CREATE INDEX ndx_sumtrsrc_perf
ON SUMTRSRC (role_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_cbs on table TASK

--METADATA NAME:ndx_task_cbs TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_cbs
ON TASK (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_code on table TASK

--METADATA NAME:ndx_task_code TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_code
ON TASK (proj_id,task_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500k next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_update_date on table TASK

--METADATA NAME:ndx_task_update_date TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_update_date
ON TASK (proj_id,update_date,task_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_location on table TASK

--METADATA NAME:ndx_task_location TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_location
ON TASK (location_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_upd on table TASK

--METADATA NAME:ndx_task_upd TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_upd
ON TASK (update_date,delete_session_id,proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_upd on table TASKACTV

--METADATA NAME:ndx_taskactv_upd TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE      
CREATE INDEX ndx_taskactv_upd
ON TASKACTV (update_date,delete_session_id,proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskcbsx_project on table TASKCBSX

--METADATA NAME:ndx_taskcbsx_project TYPE:INDEX TABLE_NAME:TASKCBSX CHANGE:CREATE      
CREATE INDEX ndx_taskcbsx_project
ON TASKCBSX (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskcbsx_cbs on table TASKCBSX

--METADATA NAME:ndx_taskcbsx_cbs TYPE:INDEX TABLE_NAME:TASKCBSX CHANGE:CREATE      
CREATE INDEX ndx_taskcbsx_cbs
ON TASKCBSX (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_plus_update_date on table TASKPRED

--METADATA NAME:ndx_taskpred_plus_update_date TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE      
CREATE INDEX ndx_taskpred_plus_update_date
ON TASKPRED (update_date,proj_id,pred_proj_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_cbs on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_cbs TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE      
CREATE INDEX ndx_taskrsrc_cbs
ON TASKRSRC (cbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_plus_update_date on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_plus_update_date TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE      
CREATE INDEX ndx_taskrsrc_plus_update_date
ON TASKRSRC (update_date,proj_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_timesht_scode on table TIMESHT

--METADATA NAME:ndx_timesht_scode TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE      
CREATE INDEX ndx_timesht_scode
ON TIMESHT (status_code,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trackofflineuser_users on table TRACKOFFLINEUSER

--METADATA NAME:ndx_trackofflineuser_users TYPE:INDEX TABLE_NAME:TRACKOFFLINEUSER CHANGE:CREATE      
CREATE INDEX ndx_trackofflineuser_users
ON TRACKOFFLINEUSER (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uk_trackofflineuser on table TRACKOFFLINEUSER

--METADATA NAME:ndx_uk_trackofflineuser TYPE:INDEX TABLE_NAME:TRACKOFFLINEUSER CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_uk_trackofflineuser
ON TRACKOFFLINEUSER (user_id,offline_date,hard_drive_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsapprovers_dsi on table TSAPPROVERS

--METADATA NAME:ndx_tsapprovers_dsi TYPE:INDEX TABLE_NAME:TSAPPROVERS CHANGE:CREATE      
CREATE INDEX ndx_tsapprovers_dsi
ON TSAPPROVERS (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_perf on table USERS

--METADATA NAME:ndx_users_perf TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE      
CREATE INDEX ndx_users_perf
ON USERS(lower(user_name))
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbshier_parentobj on table WBSHIERARCHY

--METADATA NAME:ndx_wbshier_parentobj TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parentobj
ON WBSHIERARCHY (parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbshier_parent on table WBSHIERARCHY

--METADATA NAME:ndx_wbshier_parent TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parent
ON WBSHIERARCHY (parentid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbshier_childobj on table WBSHIERARCHY

--METADATA NAME:ndx_wbshier_childobj TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_childobj
ON WBSHIERARCHY (childobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbshier_parentprojid on table WBSHIERARCHY

--METADATA NAME:ndx_wbshier_parentprojid TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parentprojid
ON WBSHIERARCHY (parentprojectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbshier_childprojid on table WBSHIERARCHY

--METADATA NAME:ndx_wbshier_childprojid TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_childprojid
ON WBSHIERARCHY (childprojectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uk_wbsreviewers on table WBSREVIEWERS

--METADATA NAME:ndx_uk_wbsreviewers TYPE:INDEX TABLE_NAME:WBSREVIEWERS CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_uk_wbsreviewers
ON WBSREVIEWERS (wbs_id,status_reviewer)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_uk_wbsreviewstatus on table WBSREVIEWSTATUS

--METADATA NAME:ndx_uk_wbsreviewstatus TYPE:INDEX TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_uk_wbsreviewstatus
ON WBSREVIEWSTATUS (wbs_id,status_reviewer,fk_id,table_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsspread_objid on table WBSSPREAD

--METADATA NAME:ndx_wbsspread_objid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_objid
ON WBSSPREAD (objectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsspread_parentobjid on table WBSSPREAD

--METADATA NAME:ndx_wbsspread_parentobjid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_parentobjid
ON WBSSPREAD (parentobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsspread_obsid on table WBSSPREAD

--METADATA NAME:ndx_wbsspread_obsid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_obsid
ON WBSSPREAD (obsobjectid)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsspread_projid on table WBSSPREAD

--METADATA NAME:ndx_wbsspread_projid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_projid
ON WBSSPREAD (projectobjectid,startdate)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wrk_log_results on table WRK_LOG_RESULTS

--METADATA NAME:ndx_wrk_log_results TYPE:INDEX TABLE_NAME:WRK_LOG_RESULTS CHANGE:CREATE      
CREATE INDEX ndx_wrk_log_results
ON WRK_LOG_RESULTS (spid,seq_num)
TABLESPACE PMDB_PX_DAT1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ACTVCODEX_actv_code_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ACTVCODEX_actv_code_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTASKPROC_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTASKPROC_proc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTASKPROCX_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTASKPROCX_proc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTRSRC_addtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTRSRC_addtrsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ALERT_alert_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ALERT_alert_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ANNOUNCEMENT_announcement_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ANNOUNCEMENT_announcement_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVALX_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVALX_asgnmnt_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ATTR_MASTER_attr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ATTR_MASTER_attr_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('AUTOVUE_ATTR_property_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('AUTOVUE_ATTR_property_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('BODEFLABELS_bodeflabels_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('BODEFLABELS_bodeflabels_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('BUDGCHNGX_budg_chng_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('BUDGCHNGX_budg_chng_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CBS_cbs_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CBS_cbs_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CHGHEAD_transaction_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CHGHEAD_transaction_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CURRTYPEX_curr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CURRTYPEX_curr_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DBERRLOG_log_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DBERRLOG_log_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DM_ATTR_dm_attr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DM_ATTR_dm_attr_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_doc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCUMENTX_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCUMENTX_doc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCUMENT_MAPPER_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCUMENT_MAPPER_doc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_FOLDER_doc_folder_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_FOLDER_doc_folder_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_RECENT_doc_recent_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_RECENT_doc_recent_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_VERSION_doc_version_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_VERSION_doc_version_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYDEPLOYMENT_deplmnt_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYDEPLOYMENT_deplmnt_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYPROVIDER_provider_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYPROVIDER_provider_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYSYNCACTION_action_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYSYNCACTION_action_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GREPLACE_greplace_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GREPLACE_greplace_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LEANTASK_lean_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LEANTASK_lean_task_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PCATVALX_proj_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PCATVALX_proj_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PFOLIOX_pfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PFOLIOX_pfolio_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PLPROJREF_proj_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PLPROJREF_proj_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJCOSTX_cost_item_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJCOSTX_cost_item_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJDEPLMENT_proj_deplmnt_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJDEPLMENT_proj_deplmnt_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJECTX_proj_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJECTX_proj_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJECT_ETL_LIST_etl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJECT_ETL_LIST_etl_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJFUNDX_proj_fund_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJFUNDX_proj_fund_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJISSUX_issue_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJISSUX_issue_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJWBSX_wbs_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJWBSX_wbs_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PXJOBRUN_jobrun_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PXJOBRUN_jobrun_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RCATVALX_rsrc_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RCATVALX_rsrc_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RFOLIOX_rfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RFOLIOX_rfolio_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISK_risk_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISK_risk_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMIT_mitigation_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMIT_mitigation_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMITX_mitigation_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMITX_mitigation_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMTXSCR_score_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMTXSCR_score_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKRSPPLN_response_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKRSPPLN_response_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKRSPPLNX_response_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKRSPPLNX_response_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRMTX_matrix_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRMTX_matrix_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRTHR_threshold_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRTHR_threshold_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRTYP_scoretype_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRTYP_scoretype_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKX_risk_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKX_risk_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RLFOLIOX_rlfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RLFOLIOX_rlfolio_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVALX_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVALX_role_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLERATEX_role_rate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLERATEX_role_rate_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCCURVX_curv_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCCURVX_curv_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCHOURX_rsrc_hr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCHOURX_rsrc_hr_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCLOC_rsrc_loc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCLOC_rsrc_loc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCRATEX_rsrc_rate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCRATEX_rsrc_rate_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCX_rsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCX_rsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SNAPGROUP_snap_group_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SNAPGROUP_snap_group_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SNAPSHOT_snapshot_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SNAPSHOT_snapshot_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKDOCX_taskdoc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKDOCX_taskdoc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKMEMOX_memo_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKMEMOX_memo_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKPREDX_task_pred_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKPREDX_task_pred_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKPROCX_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKPROCX_proc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKRSRCX_taskrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKRSRCX_taskrsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKX_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKX_task_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TRACKOFFLINEUSER_trackofflineuser_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TRACKOFFLINEUSER_trackofflineuser_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('UDFCODEX_udf_code_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('UDFCODEX_udf_code_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('USERSX_user_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('USERSX_user_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSBUDGX_wbs_budg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSBUDGX_wbs_budg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSMEMOX_wbs_memo_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSMEMOX_wbs_memo_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSREVIEWERS_wbsreviewers_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSREVIEWERS_wbsreviewers_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSREVIEWSTATUS_wbsreviewstatus_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSREVIEWSTATUS_wbsreviewstatus_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSRSRCX_wbsrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSRSRCX_wbsrsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSSTEPX_wbs_step_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSSTEPX_wbs_step_id')) 
/

--EPPM Base Upgrade Scripts
--Run Script as     
SET DEFINE OFF

prompt Dropping index ndx_iteration_release on table ITERATION

--METADATA NAME:ndx_iteration_release TYPE:INDEX TABLE_NAME:ITERATION CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_iteration_release');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_iteration_release';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping constraint fk_iteration_release on table ITERATION


--METADATA NAME:fk_iteration_release TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iteration_release');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iteration_release') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iteration_release') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERATION DROP CONSTRAINT fk_iteration_release';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping index ndx_iterdays_project on table ITERDAYS

--METADATA NAME:ndx_iterdays_project TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_iterdays_project');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_iterdays_project';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_iterdays_iteration on table ITERDAYS

--METADATA NAME:ndx_iterdays_iteration TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_iterdays_iteration');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_iterdays_iteration';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_iterdays_task on table ITERDAYS

--METADATA NAME:ndx_iterdays_task TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_iterdays_task');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_iterdays_task';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_iterdays_dsi on table ITERDAYS

--METADATA NAME:ndx_iterdays_dsi TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_iterdays_dsi');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_iterdays_dsi';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping constraint pk_iterdays on table ITERDAYS


--METADATA NAME:pk_iterdays TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('pk_iterdays');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('pk_iterdays') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('pk_iterdays') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT pk_iterdays';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_iterdays_project on table ITERDAYS


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_project');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_project') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_project') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_project';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_iterdays_iteration on table ITERDAYS


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_iteration');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_iteration') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_iteration') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_iteration';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_iterdays_task on table ITERDAYS


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_task');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_task') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_task') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_task';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping index ndx_itergoal_iteration on table ITERGOAL

--METADATA NAME:ndx_itergoal_iteration TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_itergoal_iteration');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_itergoal_iteration';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_itergoal_rfolio on table ITERGOAL

--METADATA NAME:ndx_itergoal_rfolio TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_itergoal_rfolio');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_itergoal_rfolio';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_itergoal_dsi on table ITERGOAL

--METADATA NAME:ndx_itergoal_dsi TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_itergoal_dsi');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_itergoal_dsi';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping constraint pk_itergoal on table ITERGOAL


--METADATA NAME:pk_itergoal TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('pk_itergoal');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('pk_itergoal') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('pk_itergoal') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL DROP CONSTRAINT pk_itergoal';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_itergoal_iteration on table ITERGOAL


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_itergoal_iteration');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_itergoal_iteration') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_itergoal_iteration') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_iteration';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_itergoal_rfolio on table ITERGOAL


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_itergoal_rfolio');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_itergoal_rfolio') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_itergoal_rfolio') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_rfolio';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping index ndx_prmaudit_audit_date on table PRMAUDIT

--METADATA NAME:ndx_prmaudit_audit_date TYPE:INDEX TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_prmaudit_audit_date');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_prmaudit_audit_date';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_project_update_date1 on table PROJECT

--METADATA NAME:ndx_project_update_date1 TYPE:INDEX TABLE_NAME:PROJECT CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_project_update_date1');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_project_update_date1';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_projwbs_update_date1 on table PROJWBS

--METADATA NAME:ndx_projwbs_update_date1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_projwbs_update_date1');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_projwbs_update_date1';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_release_rfolio on table RELEASE

--METADATA NAME:ndx_release_rfolio TYPE:INDEX TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_release_rfolio');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_release_rfolio';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_release_project on table RELEASE

--METADATA NAME:ndx_release_project TYPE:INDEX TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_release_project');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_release_project';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping constraint fk_release_rfolio on table RELEASE


--METADATA NAME:fk_release_rfolio TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_release_rfolio');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_release_rfolio') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_release_rfolio') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RELEASE DROP CONSTRAINT fk_release_rfolio';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_release_proj_id on table RELEASE


--METADATA NAME:fk_release_proj_id TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_release_proj_id');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_release_proj_id') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_release_proj_id') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RELEASE DROP CONSTRAINT fk_release_proj_id';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping index ndx_task_1 on table TASK

--METADATA NAME:ndx_task_1 TYPE:INDEX TABLE_NAME:TASK CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_task_1');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_task_1';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_taskpred_1 on table TASKPRED

--METADATA NAME:ndx_taskpred_1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_taskpred_1');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_taskpred_1';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_taskrsrc_1 on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_1 TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_taskrsrc_1');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_taskrsrc_1';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_usropnval_user_open_id on table USROPNVAL

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_usropnval_user_open_id');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_usropnval_user_open_id';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_usropnval_dsi on table USROPNVAL

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_usropnval_dsi');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_usropnval_dsi';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping index ndx_usropnval_upd on table USROPNVAL

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT 1 INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_usropnval_upd');
  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_usropnval_upd';
  END IF;
exception when NO_DATA_FOUND then
  null;
END;
      /

prompt Dropping constraint fk_iterdays_project on table ITERDAYS


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_project');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_project') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_project') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_project';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_iterdays_iteration on table ITERDAYS


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_iteration');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_iteration') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_iteration') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_iteration';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_iterdays_task on table ITERDAYS


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_iterdays_task');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_iterdays_task') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_iterdays_task') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_task';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_itergoal_iteration on table ITERGOAL


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_itergoal_iteration');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_itergoal_iteration') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_itergoal_iteration') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_iteration';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

prompt Dropping constraint fk_itergoal_rfolio on table ITERGOAL


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
  ispk integer;
  type rec_typ is record (table_name varchar2(30),constraint_name varchar2(30));
  v_rec_typ rec_typ;  
BEGIN
  SELECT 1 INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_itergoal_rfolio');
  begin
  select 1 into ispk from user_constraints where constraint_name = UPPER('fk_itergoal_rfolio') and constraint_type='P';
  if ispk > 0 then
   for v_rec_typ in (select table_name,constraint_name from user_constraints where constraint_type='R' and r_constraint_name = UPPER('fk_itergoal_rfolio') )
    loop
      execute immediate 'ALTER TABLE '||v_rec_typ.table_name||' DROP CONSTRAINT '|| v_rec_typ.constraint_name;
     end loop;
   end if; 
   exception when NO_DATA_FOUND then
     null;
   end;   
  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_rfolio';
  END IF;
exception when NO_DATA_FOUND then
     null;  
END;
  /

--METADATA NAME:PRM_AUDIT TYPE:PACKAGE TARGET_OBJECT:PRM_AUDIT CHANGE:DROP
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRM_AUDIT') and object_type='PACKAGE' AND object_name !='PRM_AUDIT';
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PACKAGE PRM_AUDIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
  NULL;  
END;
  
/
--METADATA NAME:PRMAUDIT_CLEANUP TYPE:PROCEDURE TARGET_OBJECT:PRMAUDIT_CLEANUP CHANGE:DROP
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRMAUDIT_CLEANUP');
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PROCEDURE PRMAUDIT_CLEANUP';
  END IF;
EXCEPTION when NO_DATA_FOUND then
    NULL;
END;
  
/
--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:PROCEDURE TARGET_OBJECT:CHECK_DB_SIZE_LIMIT CHANGE:DROP
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('CHECK_DB_SIZE_LIMIT');
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PROCEDURE CHECK_DB_SIZE_LIMIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
    NULL;
END;
  
/ 
--METADATA NAME:release_id TYPE:FIELD TABLE_NAME:ITERATION CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERATION') and dic.column_name= UPPER('release_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERATION') and dic.column_name= UPPER('release_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERATION');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERATION') and column_name = UPPER('release_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERATION');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERATION drop column  release_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:task_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('task_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('task_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('task_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  task_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:day_number TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('day_number');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('day_number');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('day_number') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  day_number CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('proj_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('proj_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('proj_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  proj_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:iteration_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('iteration_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('iteration_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('iteration_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  iteration_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:act_work_qty TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('act_work_qty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('act_work_qty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('act_work_qty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  act_work_qty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:remain_work_qty TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('remain_work_qty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('remain_work_qty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('remain_work_qty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  remain_work_qty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:update_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('update_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('update_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('update_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  update_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:update_user TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('update_user');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('update_user');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('update_user') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  update_user CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:create_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('create_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('create_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('create_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  create_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:create_user TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('create_user');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('create_user');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('create_user') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  create_user CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:delete_session_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('delete_session_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('delete_session_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('delete_session_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  delete_session_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:delete_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('delete_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERDAYS') and dic.column_name= UPPER('delete_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERDAYS') and column_name = UPPER('delete_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERDAYS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERDAYS drop column  delete_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:iter_goal_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('iter_goal_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('iter_goal_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('iter_goal_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  iter_goal_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:iteration_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('iteration_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('iteration_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('iteration_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  iteration_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:goal_name TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('goal_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('goal_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('goal_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  goal_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:goal_descr TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('goal_descr');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('goal_descr');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('goal_descr') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  goal_descr CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:status_code TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('status_code');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('status_code');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('status_code') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  status_code CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:rfolio_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('rfolio_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('rfolio_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('rfolio_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  rfolio_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:update_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('update_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('update_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('update_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  update_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:update_user TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('update_user');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('update_user');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('update_user') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  update_user CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:create_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('create_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('create_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('create_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  create_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:create_user TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('create_user');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('create_user');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('create_user') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  create_user CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:delete_session_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('delete_session_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('delete_session_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('delete_session_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  delete_session_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:delete_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('delete_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('ITERGOAL') and dic.column_name= UPPER('delete_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('ITERGOAL') and column_name = UPPER('delete_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('ITERGOAL');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE ITERGOAL drop column  delete_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:audit_date TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_date');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_date');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('audit_date') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  audit_date CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:table_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('table_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('table_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('table_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  table_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pk1 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk1');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk1');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('pk1') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  pk1 CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pk2 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk2');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk2');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('pk2') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  pk2 CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pk3 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk3');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk3');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('pk3') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  pk3 CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pk4 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk4');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('pk4');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('pk4') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  pk4 CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:oper TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('oper');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('oper');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('oper') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  oper CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('prm_user_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('prm_user_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('prm_user_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  prm_user_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:audit_info TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_info');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_info');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('audit_info') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  audit_info CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:audit_info_extended TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_info_extended');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('audit_info_extended');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('audit_info_extended') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  audit_info_extended CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:logical_delete_flag TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('logical_delete_flag');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('logical_delete_flag');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('logical_delete_flag') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  logical_delete_flag CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:rdbms_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('rdbms_user_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('rdbms_user_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('rdbms_user_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  rdbms_user_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('os_user_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('os_user_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('os_user_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  os_user_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:program TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('program');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('program');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('program') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  program CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:host_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('host_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('host_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('host_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  host_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:app_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('app_name');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('app_name');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('app_name') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  app_name CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('netaddress');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PRMAUDIT') and dic.column_name= UPPER('netaddress');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PRMAUDIT') and column_name = UPPER('netaddress') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PRMAUDIT');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PRMAUDIT drop column  netaddress CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_to_type');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_to_type');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('risk_to_type') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  risk_to_type CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('identified_by_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('identified_by_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('identified_by_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  identified_by_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('response_type');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('response_type');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('response_type') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  response_type CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('response_text');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('response_text');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('response_text') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  response_text CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('pre_rsp_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  pre_rsp_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_schd_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_schd_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('pre_rsp_schd_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  pre_rsp_schd_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_cost_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('pre_rsp_cost_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('pre_rsp_cost_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  pre_rsp_cost_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('post_rsp_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  post_rsp_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_schd_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_schd_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('post_rsp_schd_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  post_rsp_schd_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_cost_prblty');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('post_rsp_cost_prblty');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('post_rsp_cost_prblty') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  post_rsp_cost_prblty CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_cause');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_cause');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('risk_cause') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  risk_cause CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_effect');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_effect');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('risk_effect') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  risk_effect CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('notes');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('notes');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('notes') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  notes CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_code');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_code');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('risk_code') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  risk_code CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_desc');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJRISK') and dic.column_name= UPPER('risk_desc');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJRISK');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJRISK') and column_name = UPPER('risk_desc') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJRISK');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK drop column  risk_desc CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJWBS') and dic.column_name= UPPER('status_reviewer');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('PROJWBS') and dic.column_name= UPPER('status_reviewer');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PROJWBS');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('PROJWBS') and column_name = UPPER('status_reviewer') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('PROJWBS');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJWBS drop column  status_reviewer CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:rfolio_id TYPE:FIELD TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('RELEASE') and dic.column_name= UPPER('rfolio_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('RELEASE') and dic.column_name= UPPER('rfolio_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('RELEASE');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('RELEASE') and column_name = UPPER('rfolio_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('RELEASE');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RELEASE drop column  rfolio_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:RELEASE CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('RELEASE') and dic.column_name= UPPER('proj_id');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('RELEASE') and dic.column_name= UPPER('proj_id');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('RELEASE');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('RELEASE') and column_name = UPPER('proj_id') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('RELEASE');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RELEASE drop column  proj_id CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/
 
--METADATA NAME:audit_info_extended TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
  clm_cnt INTEGER;
  clm_exists INTEGER;
  domain_idx_exists INTEGER:=0;
  v_domain_idx VARCHAR2(30) := '';  
BEGIN
  begin
  select 1 into domain_idx_exists from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('SPIDMAP') and dic.column_name= UPPER('audit_info_extended');
  IF domain_idx_exists > 0 then
      select di.index_name into v_domain_idx from dba_indexes di,dba_ind_columns dic
      where di.owner=dic.index_owner and di.index_name=dic.index_name and
	  di.index_type='DOMAIN' and di.owner =upper('ADMUSER') and di.table_name=UPPER('SPIDMAP') and dic.column_name= UPPER('audit_info_extended');      
      EXECUTE IMMEDIATE 'drop index ADMUSER.'||v_domain_idx ;
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
  begin
  SELECT 1 INTO tbl_exists FROM user_tables WHERE table_name = UPPER('SPIDMAP');
  select 1 into clm_exists from user_tab_cols where table_name = UPPER('SPIDMAP') and column_name = UPPER('audit_info_extended') ;
  select count(*) into clm_cnt from user_tab_cols where table_name = UPPER('SPIDMAP');
  IF (tbl_exists > 0) and (clm_exists = 1) and (clm_cnt >1) 
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE SPIDMAP drop column  audit_info_extended CASCADE CONSTRAINTS';
  END IF;
  exception when NO_DATA_FOUND then
      null;
  end;
END;
/

--METADATA NAME:ITERDAYS TYPE:TABLE CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERDAYS');
  IF tbl_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE ITERDAYS CASCADE CONSTRAINTS PURGE';
  END IF;
EXCEPTION when NO_DATA_FOUND then
    NULL;  
END;
/

--METADATA NAME:ITERGOAL TYPE:TABLE CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO tbl_exists FROM user_tables WHERE table_name = UPPER('ITERGOAL');
  IF tbl_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE ITERGOAL CASCADE CONSTRAINTS PURGE';
  END IF;
EXCEPTION when NO_DATA_FOUND then
    NULL;  
END;
/

--METADATA NAME:PRMAUDIT TYPE:TABLE CHANGE:DROP
DECLARE
  tbl_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO tbl_exists FROM user_tables WHERE table_name = UPPER('PRMAUDIT');
  IF tbl_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE PRMAUDIT CASCADE CONSTRAINTS PURGE';
  END IF;
EXCEPTION when NO_DATA_FOUND then
    NULL;  
END;
/

--EPPM Base data Update Scripts

--METADATA TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA 
declare
  pret_val number;
  pret_msg varchar2(255);
  lobd     BLOB;
  pattern1 VARCHAR2(30) := 'GroupByTableName';
  tabname  varchar2(32);
  position INTEGER := 1;
  buf      varchar2(32767);
  cursor rptcur is
    select rpt_id from rpt;
BEGIN
  -- get the LOB locator
  for rptrec in rptcur loop
    SELECT rpt_data INTO lobd FROM rpt WHERE rpt_id = rptrec.rpt_id;
    position := DBMS_LOB.INSTR(lobd, UTL_RAW.cast_to_raw(pattern1), 1, 1);
    IF position = 0 THEN
      update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
    ELSE
      buf     := UTL_RAW.cast_to_varchar2(DBMS_LOB.SUBSTR(lobd,
                                                          2000,
                                                          position));
      tabname := substr(buf,
                        instr(buf, '''', 1, 1) + 1,
                        instr(buf, '''', 1, 2) - instr(buf, '''', 1, 1) - 1);
      if tabname is not null then
        update rpt set rpt_area = tabname where rpt_id = rptrec.rpt_id;
      else
        update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
      end if;
    end if;
  end loop;
  commit;
    pret_val := 0;
    pret_msg := 'Update RPT_AREA in RPT table successful' ;
   dbms_output.put_line(pret_msg);  
exception
  when value_error then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg); 
  when others then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg);
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA
--METADATA TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW 
declare

   TYPE nv_type IS REF CURSOR;
   TYPE nd_type IS REF CURSOR;
   nv nv_type; 
   nd nd_type;

  vkeys pls_integer; 
  vstartkey number(10);
  existing_naviview_name varchar2(255);
  existing_user_id pls_integer;
  existing_naviview_data varchar2(4000);
  existing_default_flag char(1);
  existing_naviview_id varchar2(4000);
  TimesheetApproval varchar2(4000);
  ProjectTimesheetApproval varchar2(4000);
  ApproveTimesheets varchar2(4000);
  start_pos pls_integer;
  end_pos pls_integer;
  tempstr varchar2(255);
  done pls_integer;
  vwprefkey varchar2(255);
  vwprefkey_val varchar2(40);
  vwprefkeyseq_val varchar2(40);
  dashboardid pls_integer;
  seqnum pls_integer;
  tableexist   pls_integer;
  dyn_sql_string varchar2(4000);

BEGIN
  SELECT COUNT(1)
  INTO tableexist
  FROM user_tables
  WHERE table_name = 'NAVIVIEW';

  IF tableexist = 1 THEN

    -- Get nextkeys for INSERTs
    dyn_sql_string := 'SELECT count(*) ' ||
                      'FROM naviview ';
    EXECUTE IMMEDIATE dyn_sql_string
                      INTO vkeys; 

    IF vkeys > 0 THEN
      getnextkeys('viewpref_view_pref_id', vkeys, vstartkey);
      COMMIT;
    END IF;

    --Process rows in naviview table
    OPEN nv FOR
      'SELECT navi_view_id ' || 
      'FROM naviview';

    LOOP
      FETCH nv INTO existing_naviview_id;
      EXIT WHEN nv%NOTFOUND;

      dyn_sql_string := 'SELECT navi_view_name, user_id, navi_view_data, default_flag ' ||
                        'FROM naviview ' ||
                        'WHERE navi_view_id = :1 ';
      EXECUTE IMMEDIATE dyn_sql_string
                        INTO existing_naviview_name, existing_user_id, existing_naviview_data, existing_default_flag  
                        USING existing_naviview_id;
   
      --Add row to ViewPref
      dyn_sql_string := 'INSERT INTO viewpref (view_pref_id, view_pref_name, view_pref_type, user_id ) ' ||
                        'VALUES (:1, :2, :3, :4) ';
      EXECUTE IMMEDIATE dyn_sql_string
                        USING vstartkey, existing_naviview_name, 'VT_UIVIEW', existing_user_id;

      --Add rows to VWPREFDATA for each value in NAVIVIEW.navi_view_data
      start_pos := INSTR(existing_naviview_data, '<NavigationViewContentData>');
      existing_naviview_data := SUBSTR(existing_naviview_data, start_pos + LENGTH('<NavigationViewContentData>') );
        
      LOOP
          start_pos := INSTR(existing_naviview_data, '<');
          end_pos := INSTR(existing_naviview_data, '/>');
          IF (end_pos = 0) or (start_pos = 0) THEN
		  EXIT;
          ELSE
            tempstr := SUBSTR(existing_naviview_data, start_pos+1, end_pos-start_pos-1);
            existing_naviview_data := SUBSTR(existing_naviview_data, end_pos + 2);
            vwprefkey := RTRIM(SUBSTR(tempstr, 1, INSTR(tempstr, ' ')));
            start_pos := INSTR(tempstr, 'value="') + 7;
            vwprefkey_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
          

          
            dyn_sql_string := 'UPDATE users SET ui_view_pref_id =  :1' ||
                              'WHERE navi_view_id =  :2';
            EXECUTE IMMEDIATE dyn_sql_string
                              USING vstartkey, existing_naviview_id;
          

          IF vwprefkey = 'ProjectTimesheetApproval' THEN
            ProjectTimesheetApproval := vwprefkey_val;
          ELSIF vwprefkey = 'ApproveTimesheets' THEN
            ApproveTimesheets := vwprefkey_val;
          ELSE
            dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey, vwprefkey_val;

            start_pos := INSTR(tempstr,'sequenceNum="');
            IF start_pos > 0 THEN
              start_pos := start_pos + 13;
              vwprefkeyseq_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
	    dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey || 'Seq', vwprefkeyseq_val;
            END IF;

          END IF;
        END IF;

        IF (TRIM(existing_naviview_data) = '</NavigationViewContentData>') THEN
	  EXIT;
        END IF;
      END LOOP; 

      --Create new combo key for ProjectTimesheetApproval and ApprovedTimesheets
      TimesheetApproval := 'true';
      IF (LOWER(ProjectTimesheetApproval)='false') AND (LOWER(ApproveTimesheets)='false') THEN
        TimesheetApproval := 'false';
      END IF;
      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApproval', TimesheetApproval;

      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApprovalSeq', '3';

      --Populate VWPREFDASH
      OPEN nd FOR
        'SELECT dashboard_id, seq_num ' ||
        'FROM navidash ' ||
        'WHERE navi_view_id = ' || existing_naviview_id;
      LOOP
        FETCH nd INTO dashboardid, seqnum;
        EXIT WHEN nd%NOTFOUND;
        dyn_sql_string := 'INSERT INTO vwprefdash (dashboard_id, seq_num, view_pref_id) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING dashboardid, seqnum, vstartkey;
      END LOOP;
      CLOSE nd;

      --Update Settings table with default view
      IF existing_default_flag = 'Y' THEN
        dyn_sql_string := 'INSERT INTO settings (namespace, setting_name, setting_value) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING 'VT_UIVIEW', 'UIView.DefaultViewId', vstartkey;
      END IF;

      vstartkey := vstartkey + 1;

    END LOOP;
    CLOSE nv;
  
  EXECUTE IMMEDIATE 'DROP TABLE navidash';
  EXECUTE IMMEDIATE 'DROP TABLE naviview';
  EXECUTE IMMEDIATE 'DROP VIEW privuser.navidash';
  EXECUTE IMMEDIATE 'DROP VIEW privuser.naviview';

  END IF; --NAVIVIEW exists
  COMMIT;
  
 
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
 vwkeys:=varray_type('UIView.DeleteProject','UIView.DeleteProjectSeq','UIView.ManagePortfoliosPort','UIView.ManagePortfoliosPortSeq','UIView.OpenPortfolios','UIView.OpenPortfoliosSeq','UIView.OpenProject','UIView.OpenProjectSeq');
 vwvalues:=varray_type('true','5','true','4','true','3','true','4');
--delete rows for VWPREFDATA
delete from VWPREFDATA where VIEW_PREF_KEY in ('UIView.ApproveTimesheets','UIView.ApproveTimesheetsSeq','UIView.CreatePortfolio','UIView.CreatePortfolioSeq','UIView.InitiateProjectProcess','UIView.InitiateProjectProcessSeq','UIView.ProjectTimesheetApproval','UIView.ProjectTimesheetApprovalSeq');  
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;

END;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG 
begin
UPDATE TASKRSRC set act_this_per_qty=0.0 where act_this_per_qty is null;
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS';
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS 
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Table_Settings', 'udfvalue_denorm',
'N' from settings where not exists ( select 1 from settings where namespace='Table_Settings' and setting_name =
'udfvalue_denorm' );

insert into settings (namespace, setting_name, setting_value) select distinct 'Query_Settings',
'tasksum_query_split', 'N' from settings where not exists ( select 1 from settings where namespace='Query_Settings'
and setting_name = 'tasksum_query_split' );
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA 
declare
  cursor cur_vpdata is
  select DISTINCT view_pref_id 
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
  or    upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType');
  v_firstbardisptype varchar2(255);
 v_secondbardisptype varchar2(255);
begin
  for r_vpdata in cur_vpdata loop
  
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select r_vpdata.view_pref_id view_pref_id, 'VT_ACTIVITY.BarDisplayTypes' view_pref_key, 'NORMAL_BAR' view_pref_value
from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes') and view_pref_id = r_vpdata.view_pref_id)
and rownum < 2;

select upper(view_pref_value) into v_firstbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.FirstBarDisplayType');
begin      
select upper(view_pref_value) into v_secondbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType');
 
exception
 when no_data_found then  v_secondbardisptype:=null;
 end;
 
update VWPREFDATA
set view_pref_value = v_firstbardisptype || 
			decode(nvl(v_secondbardisptype, ''), 'NO_BAR', '', '', '', ',' ||case when v_secondbardisptype='BASELINE_BAR' then 'PRIMARY_BASELINE_BAR' else v_secondbardisptype end) 
where view_pref_id = r_vpdata.view_pref_id 
and   upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes');


delete from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and (upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
      or    
      upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType')
    );

commit;

end loop;
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(t1.view_pref_id),'UIView.ImportExportProject','Y' from viewpref t1 where t1.view_pref_type='VT_UIVIEW'
and not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'UIView.ImportExportProject' and t2.view_pref_id = t1.view_pref_id); 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(t1.view_pref_id),'UIView.ImportExportProjectSeq','5' from viewpref t1 where t1.view_pref_type='VT_UIVIEW' 
and not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'UIView.ImportExportProjectSeq' and t2.view_pref_id = t1.view_pref_id); 
end; 


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS 
declare
db_version varchar2(255);
begin
select database_version into db_version from prefer;
if substr(db_version, length ('PMDB,') + 1, 4) >'0600' then
execute immediate('begin drop_background_procs;end;');
end if;
delete from settings where namespace='database.background.Damon';
delete from settings where namespace='database.background.Symon';
commit;
end;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG 
declare 
cursor usercur is select user_id from users where prof_id=12;
vusereng_id  usereng.user_eng_id%TYPE;
TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
cnt pls_integer;
engtype varray_type;
dyn_sql_string varchar2(4000);
begin 
engtype:=varray_type('PM','TS','WEB_PM','WEB_RM','WU','TS_ONLY');
select key_seq_num into vusereng_id from nextkey where key_name='usereng_user_eng_id';
for userrec in usercur loop
for i in engtype.FIRST..engtype.LAST
loop
begin
cnt:=0;
select 1 into cnt from usereng where db_engine_type=engtype(i) and user_id=userrec.user_id and rownum < 2;
exception when no_data_found then 
 null;
end;
if cnt=0 then 
dyn_sql_string:='insert into usereng(user_eng_id,user_id,db_engine_type) values (:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vusereng_id,userrec.user_id,engtype(i);
vusereng_id:=vusereng_id+1; 
end if;
end loop;
end loop;
update nextkey set key_seq_num=vusereng_id where key_name='usereng_user_eng_id';  
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG
--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare
vprefid viewpref.view_pref_id%TYPE;
max_view_pref_id viewpref.view_pref_id%TYPE;
CURSOR cur_vpdata IS
SELECT DISTINCT view_pref_id
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_ACTIVITY.Filter')
 AND UPPER(view_pref_value) LIKE UPPER('CustomFilter');
CURSOR cur_vpfilterdata IS
SELECT DISTINCT view_pref_id,
  view_pref_value
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_FILTER.FilterCriteria');
BEGIN
  SELECT key_seq_num
  INTO vprefid
  FROM nextkey
  WHERE key_name = 'viewpref_view_pref_id';
  SELECT MAX(view_pref_id)
  INTO max_view_pref_id
  FROM viewpref;

  IF(vprefid <= max_view_pref_id) THEN
    vprefid := max_view_pref_id + 1;
  END IF;

  FOR r_vpdata IN cur_vpdata
  LOOP
    INSERT
    INTO viewpref(view_pref_id,   view_pref_name,   view_pref_type,   user_id)
    SELECT vprefid,
      view_pref_name,
      'VT_FILTER',
      user_id
    FROM viewpref
    WHERE view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT vprefid,
      'VT_FILTER.FilterCriteria',
      view_pref_value
    FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria')
     AND NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_FILTER.FilterCriteria')
       AND view_pref_id = vprefid)
    AND rownum < 2;
    INSERT
    INTO vwprefuser(view_pref_id,   user_id)
    SELECT vprefid,
      user_id
    FROM vwprefuser
    WHERE view_pref_id = r_vpdata.view_pref_id;

    UPDATE vwprefdata
    SET view_pref_value = 'TreeFilter'
    WHERE view_pref_key = 'VT_ACTIVITY.Filter'
     AND view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT r_vpdata.view_pref_id,
      'VT_ACTIVITY.FiltersList',
      vprefid
    FROM dual
    WHERE NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FiltersList')
       AND view_pref_id = r_vpdata.view_pref_id)
    AND rownum < 2;

    DELETE FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria');
    vprefid := vprefid + 1;
  END LOOP;

  UPDATE nextkey
  SET key_seq_num = vprefid
  WHERE key_name = 'viewpref_view_pref_id';
  COMMIT;
  FOR r_vpfilterdata IN cur_vpfilterdata
  LOOP
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   'UDF:') > 0 THEN
        r_vpfilterdata.view_pref_value:=REPLACE(r_vpfilterdata.view_pref_value,   'UDF:',   'UDF_');
    END IF;
  
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   UPPER('ActivityCodeTypeId:')) > 0 THEN
       r_vpfilterdata.view_pref_value:= REPLACE(r_vpfilterdata.view_pref_value,   'ActivityCodeTypeId:',   'ActivityCodeTypeId_');
    END IF;
    
    UPDATE vwprefdata
      SET view_pref_value = r_vpfilterdata.view_pref_value
      WHERE view_pref_id = r_vpfilterdata.view_pref_id;
  END LOOP;

EXCEPTION
WHEN others THEN
  DBMS_OUTPUT.PUT_LINE('Error while migrating filters');
END;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(2) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,decode(p.prof_id,12,'Y','N'), sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
 vwkeys:=varray_type('UIView.CreateTemplateProject','UIView.CreateTemplateProjectSeq');
 vwvalues:=varray_type('true','6');
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
declare
earnedValue INTEGER:=0;
blobField BLOB;
valuePatternAtCompl VARCHAR2(30) := 'EV_AtCompl';
valuePatternBudgCur VARCHAR2(30) := 'EV_Budg_With_Start_Dates';
valuePatternBudg VARCHAR2(30) := 'EV_Budg';
settingsName VARCHAR2(30):= 'EVCalculation';
insertValueAtCompl VARCHAR2(30):= 'EV_AtCompl';
insertValueBudgCur VARCHAR2(30):= 'EV_BudgCur';
insertValueBudg    VARCHAR2(30):= 'EV_Budg';
begin

  begin
    select 1 into earnedValue from settings where setting_name='EVCalculation';
    exception when no_data_found then
      null;
  end;

  if earnedValue=0 then
    
    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternAtCompl), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueAtCompl);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudgCur), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudgCur);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudg), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudg);
    end if;
  end if;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
declare
blobField BLOB;
valuePattern VARCHAR2(30) := 'pvurl';
begin
  begin

    UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines';

    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePattern), 1, 1) != 0 then
      insert into settings(namespace, setting_name) 
      values('Administrator_Settings', 'WebAccessURL');
    end if;
  end;

  UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
  UPDATE project set sum_only_flag = 'N', msp_managed_flag = 'N' where sum_only_flag != 'N' or msp_managed_flag != 'N';

end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
  insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160);

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end;


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS 
begin
 drop_background_procs();
 begin
  DBMS_SCHEDULER.disable(name=>'SYMON', force => TRUE);
  exception when others then null;
  end;
 begin
  DBMS_SCHEDULER.disable(name=>'DAMON', force => TRUE);
   exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'SYMON', force => TRUE);
 exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'DAMON', force => TRUE); 
 exception when others then null;
 end;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
Declare
    Type Priskarray Is Record 
    (Risk_id Dbms_sql.Number_table,Proj_id Dbms_sql.Number_table,Wbs_name Dbms_sql.Varchar2_table,Add_date Dbms_sql.Date_table,Priority_type Dbms_sql.Varchar2_table,Status_code Dbms_sql.Varchar2_table,Risk_name Dbms_sql.Varchar2_table,
     Risk_type_id dbms_sql.number_table, Rsrc_id Dbms_sql.Number_table,Prbly_pct dbms_sql.number_table,Impact_work_qty dbms_sql.number_table ,Impact_equip_qty dbms_sql.number_table,Impact_expense_cost dbms_sql.number_table,Impact_date dbms_sql.date_table,Impact_mat_qty dbms_sql.number_table,description dbms_sql.Blob_table,note dbms_sql.Blob_table, Obs_name dbms_sql.varchar2_table,Rsrc_name dbms_sql.varchar2_table);
   Cursor Priskcur  Is 
  Select
  P.Risk_id,P.Proj_id,Pw.Wbs_name,P.Add_date,
  P.Priority_type,decode(P.Status_code, 'RS_Closed', 'RS_Manage', P.Status_code), P.Risk_name,
  P.Risk_type_id,P.Rsrc_id, P.Prbly_pct,
  P.Impact_work_qty,P.Impact_equip_qty,P.Impact_expense_cost,P.Impact_date,P.Impact_mat_qty,p.risk_descr,rc.risk_control,O.Obs_name,R.Rsrc_name From  Projrisk P Left outer join Riskctrl rc on p.risk_id=rc.risk_id left outer join projwbs pw on p.wbs_id=pw.wbs_id  Left Outer Join Obs O On P.Obs_id=O.Obs_id Left Outer Join  Rsrc R On P.Rsrc_id=R.Rsrc_id ;
 priskrec  Priskarray;
 Begin
 Open Priskcur;
 Loop
   Fetch Priskcur 
   Bulk Collect Into Priskrec.Risk_id,Priskrec.Proj_id,Priskrec.Wbs_name,Priskrec.Add_date,Priskrec.Priority_type,Priskrec.Status_code,Priskrec.Risk_name,Priskrec.Risk_type_id,Priskrec.Rsrc_id,Priskrec.Prbly_pct,Priskrec.Impact_work_qty,Priskrec.Impact_equip_qty,Priskrec.Impact_expense_cost,Priskrec.Impact_date,Priskrec.Impact_mat_qty,Priskrec.description,Priskrec.note,Priskrec.Obs_name,Priskrec.Rsrc_name  Limit 1000;
      ForALL I In 1..Priskrec.Risk_id.Count
          Insert Into Risk(risk_id,proj_id,id,name,rsrc_id,status,category_id,type,total_cost,cause,description,note,create_date,create_user,update_date,update_user) Values (Priskrec.Risk_id(i),Priskrec.Proj_id(i),Priskrec.Risk_id(i),Priskrec.Risk_name(i),Priskrec.Rsrc_id(i),Priskrec.Status_code(i),Priskrec.Risk_type_id(i),'RT_Threat',0,'Applies to WBS-'|| priskrec.WBS_name(i)|| chr(13) ||'Applies to Resource-' ||priskrec.rsrc_name(i)|| chr(13)|| 'Responsible Manager-'|| priskrec.obs_name(i) || chr(13) ||'Priority-'|| priskrec.priority_type(i) || chr(13)|| 'Date Identified-' || to_char(priskrec.add_date(i),'mon-dd-yyyy hh:mi:ss') || chr(13)|| 'Impact Date-'|| to_char(priskrec.impact_date(i),'mon-dd-yyyy hh:mi:ss') || chr(13)||'Probability-' ||priskrec.prbly_pct(i) || chr(13)||'Impact - Labor Units-'||priskrec.impact_work_qty(i) || chr(13)||'Impact - Nonlabor Units-'||priskrec.impact_equip_qty(i) || chr(13)||'Impact - Material Units-' ||priskrec.impact_mat_qty(i) || chr(13) || 'Impact - Expenses-'|| priskrec.impact_expense_cost(i) || chr(13),utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.description(i),2000,1)) || utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.description(i),2000,2001)),utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.note(i),2000,1)) || utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.note(i),2000,2001)),sysdate,sys_context('USERENV','CURRENT_SCHEMA'),sysdate,sys_context('USERENV','CURRENT_SCHEMA'));
       EXIT WHEN priskcur%NOTFOUND;
End Loop;
update nextkey set key_seq_num=(select key_seq_num from nextkey where KEY_NAME='projrisk_risk_id') where KEY_NAME='risk_risk_id';
Update Udftype Set Table_name='RISK',update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') Where Table_name='PROJRISK';
update calendar set rsrc_private = 'N' where rsrc_private != 'N';

update calendar set rsrc_private = 'Y'
where clndr_id in (select c.clndr_id 
                      from rsrc r,calendar c 
                      where r.clndr_id=c.clndr_id and c.clndr_type='CA_Rsrc' 
                      group by c.clndr_id having count(1) = 1)
  and clndr_id in (select c.clndr_id 
                      from users u,profpriv p, rsrc r, calendar c 
                      where u.prof_id=p.prof_id and p.priv_num=100 and p.allow_flag='Y' 
                      and r.user_id = u.user_id and r.clndr_id= c.clndr_id);

commit;
End;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0);
  commit;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
declare
vprefid pls_integer;
BEGIN
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
  
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MyActivities','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;

  commit;
END;
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=to_number(view_pref_value)+1,update_date=sysdate where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and to_number(view_pref_value)>=1
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 
DECLARE
  v_id_list VWPREFDATA.VIEW_PREF_VALUE%TYPE;
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select *
                   from vwprefdata vw
                   where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
 select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');

 SELECT MIN(view_pref_id)||','|| MAX(view_pref_id)  INTO v_id_list
 FROM VIEWPREF 
 WHERE view_pref_name IN ('InProgressActivitiesOnly','NotStartedActivitiesOnly') ;
    
 FOR cur_id IN (select view_pref_id from vwprefdata where view_pref_key='VT_ACTIVITY.Filter' and view_pref_value='NotFinishedActivitiesOnly')
 LOOP
   UPDATE VWPREFDATA SET view_pref_value='TreeFilter' WHERE view_pref_key='VT_ACTIVITY.Filter' AND view_pref_id=cur_id.view_pref_id; 
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) select cur_id.view_pref_id, 'VT_ACTIVITY.FiltersList', v_id_list from dual
   where  not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'VT_ACTIVITY.FiltersList' and t2.view_pref_id = cur_id.view_pref_id);
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) select cur_id.view_pref_id, 'VT_ACTIVITY.FiltersOperator', 'OR' from dual
   where  not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'VT_ACTIVITY.FiltersList' and t2.view_pref_id = cur_id.view_pref_id); 
 END LOOP;
    
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
DELETE from usereng
where db_engine_type ='TS' 
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS')
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM 
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM
BEGIN
  insert into usereng 
  (user_eng_id, user_id, db_engine_type)
  select copy_utils.Get_Next_Key('usereng_user_eng_id'), user_id, 'WEB_PM'
  from users
  where prof_id = 12 and user_id not in (
	  select e.user_id 
	  from usereng e, users u
	  where e.user_id = u.user_id and 
	        u.prof_id = 12 and e.db_engine_type = 'WEB_PM');
    
  commit;
END;
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
/


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES

Update vwprefdata set view_pref_value = 'Name' where view_pref_value = 'ActivityName' and view_pref_key = 'VT_PROJECT.LabelField'
/

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,168,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=168)
/
/ 
--END TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from user_tab_columns where table_name='SETTINGS' and column_name='SETTING_ID';
if v_no_data_found > 0 then
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id) 
 select 'Administrator_Settings','AlwaysLaunchOnlineHelp','Y',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
else
insert into settings(namespace,setting_name,setting_value)  
select 'Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/' from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
end if;
commit;
end;
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (1,'UserId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (2,'AuthorId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (3,'ProjectId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (4,'LocalFilePath','String')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (5,'SecurityPolicy','String')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (6,'WorkflowId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (7,'CheckedOutUserId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (8,'WorkgroupId','int')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (9,'CheckedOutDate','Date')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (10,'Template','boolean')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (11,'WorkflowStatus','String')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (12,'WorkflowAction','String')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (13,'IsReviewAttachment','boolean')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (14,'CheckedOutGuid','String')
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
update PROJECT set px_enable_publication_flag = 'N' where orig_proj_id IS NOT NULL
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
update (select v.table_name w, t.table_name c from udfvalue v join udftype t on v.udf_type_id = t.udf_type_id where v.table_name <> t.table_name or v.table_name is NULL) set w = c
/
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N')
/

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

  declare
  vpropid pls_integer;
  BEGIN
      vpropid:= copy_utils.Get_Next_Key('viewprop_view_id');
      insert into viewprop(VIEW_ID,VIEW_NAME,VIEW_TYPE) select vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
      from dual
      where not exists ( select view_id from viewprop where VIEW_NAME = 'Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ;

        commit;
  END;


/ 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES

insert into nextkey select  lower('PC_KEY_XREF_execution_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PC_KEY_XREF_execution_id')) 
/



/ 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update PROFILE set prof_name = 'Timesheets only' where prof_name = 'Progress Reporters / Timesheets only'
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value)
values('Administrator_Settings','AlwaysLaunchOnlineHelp','Y')
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

declare cursor uid_cur  
is 
select ue1.user_id
from usereng ue1
where ue1.user_id = 25 
and  ue1.db_engine_type = 'PM'
and  not exists (
   select 1 
   from usereng ue2
   where ue2.user_id = ue1.user_id
   and  ue2.db_engine_type = 'TM'
);
v_user_eng_id number;
v_userid number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'TM');
  end loop;
  commit;
end;
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

declare cursor uid_cur  
is 
select ue1.user_id
from usereng ue1
where ue1.user_id = 91 
and  ue1.db_engine_type = 'PM'
and  not exists (
   select 1 
   from usereng ue2
   where ue2.user_id = ue1.user_id
   and  ue2.db_engine_type = 'TM'
);
v_user_eng_id number;
v_userid number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'TM');
  end loop;
  commit;
end;
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

update RSRC set timesheet_flag = 'Y' where user_id = (select user_id from users where user_name = 'admin')
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

update settings set setting_value = 'http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES

declare
  ts_count number;
  tm_count  number;
  ts_flag_count number;
  v_user_eng_id number;
cursor user  
is 
select user_id from users;
begin
  for users_cur in user loop
    select nvl(count(*),0) into ts_count from usereng where db_engine_type = 'TS_ONLY' and user_id = users_cur.user_id;
    select nvl(count(*),0) into tm_count from usereng where db_engine_type = 'TM' and user_id = users_cur.user_id;
    select nvl(count(*),0) into ts_flag_count from rsrc where user_id = users_cur.user_id and timesheet_flag = 'Y';
    if(ts_count > 0) then
      if(tm_count > 0 and ts_flag_count = 0) then
          delete from usereng where db_engine_type = 'TS_ONLY' and user_id = users_cur.user_id;
      elsif(tm_count = 0 and ts_flag_count > 0) then
          getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
          insert into usereng (user_eng_id,user_id,db_engine_type) values (v_user_eng_id, users_cur.user_id, 'TM');
      elsif(tm_count = 0 and ts_flag_count = 0) then
          delete from usereng where db_engine_type = 'TS_ONLY' and user_id = users_cur.user_id;
          getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
          insert into usereng (user_eng_id,user_id,db_engine_type) values (v_user_eng_id, users_cur.user_id, 'TM');
      end if;
    end if;
  end loop;
  commit;
end;
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,171,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=171)  
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,172,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=172) 
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,173,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=173)  
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,174,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=174)  
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,175,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=175)   
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,170,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') 
from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=170)
/
/ 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')) 
/

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare 
cursor uid_cur is 
 select distinct ue1.user_id from usereng ue1
   where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM');
v_user_eng_id number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'VIS');
  end loop;
  commit; 
end;
/
/ 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
DECLARE trigger_exist pls_integer;
BEGIN 
SELECT count(*) INTO trigger_exist FROM user_triggers WHERE trigger_name = 'RT_USESSION_DEL';
IF trigger_exist=1
THEN EXECUTE IMMEDIATE 'DROP TRIGGER RT_USESSION_DEL' ;
END IF;
EXCEPTION WHEN no_data_found THEN NULL;
END;
/

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_USESSION
BEFORE UPDATE OR INSERT ON USESSION
FOR EACH ROW
BEGIN
  if dbms_reputil.from_remote = true then   return; end if;
  
  :NEW.update_date := SYSDATE;
  
  :NEW.update_user := prm_audit.g_prm_user_name;

  IF INSERTING THEN
	:NEW.create_user := prm_audit.g_prm_user_name;
	:NEW.create_date := SYSDATE;
  END IF;		
end; 
/
show err
/ 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION GETNEXTKEY
( tabcol IN VARCHAR2  , numkeys IN NUMBER)
RETURN NUMBER
IS
  PRAGMA AUTONOMOUS_TRANSACTION;
 startkey  number;
BEGIN
  UPDATE nextkey SET key_seq_num = (key_seq_num + numKeys) WHERE key_name = tabcol
  returning (key_seq_num - numkeys) into startkey;
  COMMIT;
  RETURN startkey;
EXCEPTION
  WHEN OTHERS THEN
    startkey := -1;
END;
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare 
v_setting_id settings.setting_id%type;
v_cnt number :=0;
begin
select count(*) into v_cnt from settings 
where namespace = 'database.audit' and setting_name = 'Enabled' ;
if v_cnt = 0 then 
getnextkeys ('settings_setting_id', 1, v_setting_id);
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.audit','Enabled','false',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
end if; 
 commit; 
end;
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
Delete from vwprefdata where view_pref_key IN ('VT_ACTIVITY.DetailWindowPositions' ,'VT_PROJECT.DetailWindowPositions')
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update prefer set phase_label='WBS Catagories'
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)select distinct p.prof_id,176,'N', sysdate, sys_context('userenv','current_schema') 
from profpriv p,profile pf  where lower(scope_type)='st_project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=176) 
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare 
type typ_view_pref_id is table of number
index by pls_integer;
v_view_pref_id typ_view_pref_id;
begin
select view_pref_id   bulk collect into v_view_pref_id from vwprefdata 
where view_pref_id in (select view_pref_id from viewpref where view_pref_type = 'vt_uiview')
and view_pref_key = 'uiview.projectactivities' and upper(view_pref_value) in ('FALSE','N');
for indx in 1..v_view_pref_id.count loop
dbms_output.put_line(v_view_pref_id(indx));
insert into vwprefdata   (view_pref_id,view_pref_key,view_pref_value) select v_view_pref_id(indx),'uiview.projectactivitiesclassicview','n'  from dual
   where  not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'uiview.projectactivitiesclassicview' and t2.view_pref_id = v_view_pref_id(indx));
insert into vwprefdata  (view_pref_id,view_pref_key,view_pref_value) select v_view_pref_id(indx),'uiview.projectactivitiesclassicviewdefault','n'  from dual
   where  not exists (select 1 from vwprefdata t2 where t2.view_pref_key = 'uiview.projectactivitiesclassicviewdefault' and t2.view_pref_id = v_view_pref_id(indx));
commit;
end loop;
end;
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
/
/ 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
begin
update project set publish_spread_assign_level='SL_Taskrsrc';
commit;
end;
/

--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
begin
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select getnextkey('viewpref_view_pref_id', 1), 'WBSOnly', 'VT_FILTER_STANDARD' from dual
where not exists( select 1 from viewpref where view_pref_name= 'WBSOnly' and  view_pref_type='VT_FILTER_STANDARD');
commit;
end;
/
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
begin
delete from settings where lower(setting_name) in( 'usermiforapi' ,'rmiurl');
commit;
end;
/
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
begin
update doc set doc_update_date=update_date where doc_update_date is null;
commit;
end;
/

--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
declare 
type typ_view_pref_id is table of number
index by pls_integer;
v_view_pref_id typ_view_pref_id;
begin
for v_view in (select 'EPS' as view_type from dual union select 'Activities' as view_type from dual) loop
begin
select view_pref_id bulk collect into v_view_pref_id from vwprefdata 
where view_pref_id in (select view_pref_id from viewpref where view_pref_type = 'VT_UIVIEW')
and view_pref_key = 'UIView.Project' || v_view.view_type  and upper(view_pref_value) in ('TRUE','Y');
for indx in 1..v_view_pref_id.count loop
for v_key in (select 'UIView.Project'|| v_view.view_type || 'ClassicView' as key from dual union select 'UIView.Project'|| v_view.view_type || 'BasicView' as key from dual union select  'UIView.Project'|| v_view.view_type || 'BasicViewDefault' as key from dual) loop
begin
insert into vwprefdata (view_pref_id,view_pref_key,view_pref_value) values(v_view_pref_id(indx),v_key.key,'Y');
exception
when DUP_VAL_ON_INDEX then
update vwprefdata set view_pref_value = 'Y' where view_pref_id = v_view_pref_id(indx) and view_pref_key = v_key.key;
end;
end loop;
begin
insert into vwprefdata (view_pref_id,view_pref_key,view_pref_value) values(v_view_pref_id(indx),'UIView.Project'|| v_view.view_type || 'ClassicViewDefault','N');
exception
when DUP_VAL_ON_INDEX then
update vwprefdata set view_pref_value = 'N' where view_pref_id = v_view_pref_id(indx) and view_pref_key = 'UIView.Project'|| v_view.view_type || 'ClassicViewDefault';
end;
end loop;
end;
end loop;
commit;
exception when others then
null;
end;
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare 
v_setting_id settings.setting_id%type;
v_cnt number :=0;
begin
select count(*) into v_cnt from settings 
where namespace = 'PxService.Project.Arbiter' AND setting_name = 'PublishRsrcRoleSpread';
if v_cnt = 0 then 
getnextkeys ('settings_setting_id', 1, v_setting_id);
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.Project.Arbiter','PublishRsrcRoleSpread','N',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
end if; 
 commit; 
end;
/

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
begin
update settings set setting_value='XX'
where namespace='database.background.Damon' and setting_name='Interval';
commit;
end;
/
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
begin
UPDATE PROJECT SET etl_interval  = 24;
commit;
end;
/

--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
begin
UPDATE PROJECT SET etl_hour  = 0;
commit;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_cnt from settings
   where namespace='PxService.TimeDistribution';
if  v_cnt = 0  then
select max(setting_id) into v_setting_id from settings;
v_setting_id:=v_setting_id+1;
update nextkey set key_seq_num = v_setting_id + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.TimeDistribution','Interval','SBT_WEEK',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_cnt from settings
   where namespace='database.proc';
if  v_cnt = 0  then
select max(setting_id) into v_setting_id from settings;
v_setting_id:=v_setting_id+1;
update nextkey set key_seq_num = v_setting_id + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/



/ 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
insert into nextkey select 'project_etl_list_etl_id',1 from dual where not exists (select * from nextkey where key_name=lower('project_etl_list_etl_id')) 
/
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
declare
type typ_project_proj_id is table of number
index by pls_integer;
v_project_proj_id typ_project_proj_id;
v_etl_id project_etl_list.etl_id%type;
begin
select proj_id bulk collect into v_project_proj_id from project where px_enable_publication_flag ='Y';
for indx in 1..v_project_proj_id.count loop
getnextkeys ('project_etl_list_etl_id', 1, v_etl_id);
insert into project_etl_list (etl_id,proj_id)values(v_etl_id,v_project_proj_id(indx));
commit;
end loop;
exception when others then
null;
end;
/
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
declare
 v_attr_id attr_master.attr_id%type;
 val_exists number;
begin
 getnextkeys ('attr_master_attr_id', 1,v_attr_id);
 select 1 into val_exists from attr_master where attr_id = v_attr_id;
 while  val_exists >= 1 loop 
  getnextkeys ('attr_master_attr_id', 1,v_attr_id);
  select 1 into val_exists from attr_master where attr_id = v_attr_id;
 end loop;
 Dbms_Output.Put_Line(v_attr_id);
 exception when no_data_found then
 Insert into attr_master(attr_id,attr_name,attr_type)
 select v_attr_id,'LastAccessedTime','Date' from ADMUSER.prefer where not exists (select * from ADMUSER.attr_master where attr_id=v_attr_id and attr_name='LastAccessedTime' and attr_type='Date');
end;
/
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
update project set etl_interval=24 where etl_interval=-1
/
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
update vwprefdata set view_pref_value = 'DEFAULT_LANDING_PAGE_URL' 
where view_pref_key = 'UIView.DefaultLandingPage' 
and view_pref_id in (select view_pref_id from vwprefdata where view_pref_key = 'UIView.DefaultLandingPage' and view_pref_value = '/action/home?globalscheduledservices')
/
/ 
--END TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from dual where not exists (select * from nextkey where lower(key_name)='settings_setting_id')
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_cnt from settings
   where namespace='database.proc';
if  v_cnt = 0  then
select nvl(max(setting_id),0) into v_setting_id from settings;
v_setting_id:=v_setting_id+1;
update nextkey set key_seq_num = v_setting_id
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJECT';
select count(1) into v_disabled from user_tables where table_name='PROJECT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table project enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PAUDIT';
select count(1) into v_disabled from user_tables where table_name='PAUDIT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table paudit enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='REFRDEL';
select count(1) into v_disabled from user_tables where table_name='REFRDEL' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table refrdel enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJWBS';
select count(1) into v_disabled from user_tables where table_name='PROJWBS' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table projwbs enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='UDFVALUE';
select count(1) into v_disabled from user_tables where table_name='UDFVALUE' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table udfvalue enable row movement';
end if;
end;
/

/ 
--END TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from dual where not exists (select * from nextkey where lower(key_name)='settings_setting_id')
/
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJECT';
select count(1) into v_disabled from user_tables where table_name='PROJECT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table project enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PAUDIT';
select count(1) into v_disabled from user_tables where table_name='PAUDIT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table paudit enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='REFRDEL';
select count(1) into v_disabled from user_tables where table_name='REFRDEL' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table refrdel enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJWBS';
select count(1) into v_disabled from user_tables where table_name='PROJWBS' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table projwbs enable row movement';
end if;
end;
/
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='UDFVALUE';
select count(1) into v_disabled from user_tables where table_name='UDFVALUE' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table udfvalue enable row movement';
end if;
end;
/

/ 
--END TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
alter table sumtrsrc nologging
/

/ 
--END TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:175to176 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:175to176 NAME:MISC_UPDATES
declare
 v_lmt number := 10000;
 cursor cur_getrows is select rowid from project where hist_interval ='Daily' ;
 type rowid_tbl_type is table of rowid;
 rowid_tbl     rowid_tbl_type;
begin

  open cur_getrows;
  loop
    fetch cur_getrows bulk collect into rowid_tbl limit v_lmt;
    exit when rowid_tbl.count = 0;

    forall i in rowid_tbl.first..rowid_tbl.last
      update project set hist_interval = 'Month' where rowid = rowid_tbl(i);
	  
  end loop;
  close cur_getrows;
  
exception when others then
null;
end;
/
/ 
--END TYPE:UP2 GROUP:175to176 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) SELECT 16,'OutsideInConversionStatus','String' FROM DUAL WHERE NOT EXISTS
(SELECT * FROM ATTR_MASTER WHERE ATTR_ID=16 AND ATTR_NAME ='OutsideInConversionStatus' AND ATTR_TYPE='String' )
/

/ 
--END TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update profpriv set AllOW_FLAG='Y' where priv_num=176 and prof_id=23
/
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update profpriv set Allow_FLAG='Y' where prof_id=12 and allow_flag='N'
/
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
DECLARE 
  CURSOR auditing_cur 
  IS 
    select setting_id, namespace, setting_name 
    from settings where namespace like 'database.audit%' and setting_id is null; 
  v_settings_setting_id NUMBER; 
  v_count   NUMBER :=0; 
BEGIN 
  FOR r_auditing_cur IN auditing_cur 
  LOOP 
    getnextkeys('settings_setting_id', 1, v_settings_setting_id); 
    v_settings_setting_id:=v_settings_setting_id;
    update settings set setting_id = v_settings_setting_id 
    where namespace=r_auditing_cur.namespace and 
	setting_name=r_auditing_cur.setting_name; 
  END LOOP; 
  COMMIT; 
END; 
/

--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
insert into nextkey select 'rsrcroleasgnmentspread_id',1 from dual where not exists (select * from nextkey where key_name=lower('rsrcroleasgnmentspread_id')) 
/

/ 
--END TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1710to1711 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update project set proj_short_name=trim(proj_short_name)
/
commit
/

update projwbs set wbs_short_name=trim(wbs_short_name) where proj_node_flag='Y'
/
commit
/
/ 
--END TYPE:UP2 GROUP:1710to1711 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
declare
cursor tab_rec is
select table_name from user_tables where table_name in('ACTVCODEX','BUDGCHNGX',
'CHGTASKX',
'CHGTASKPROCX',
'CHGTRSRCX',
'DOCUMENTX',
'PCATUSERX',
'PCATVALX',
'PFOLIOX',
'PROJCOSTX',
'PROJFUNDX',
'PROJISSUX',
'PROJPCATX',
'PROJWBSX',
'RCATVALX',
'RFOLIOX',
'RLFOLIOX',
'ROLERATEX',
'RSRCX',
'RSRCHOURX',
'RSRCRATEX',
'RSRCRCATX',
'RSRCROLEX',
'RSRCSECX',
'TASKX',
'TASKACTVX',
'TASKDOCX',
'TASKFINX',
'TASKMEMOX',
'TASKPREDX',
'TASKPROCX',
'TASKRISKX',
'TASKRSRCX',
'TIMESHTX',
'TRSRCFINX',
'UDFCODEX',
'UDFVALUEX',
'USEROBSX',
'USERSX',
'WBSBUDGX',
'WBSMEMOX',
'WBSRSRCX',
'WBSSTEPX',
'RSRCROLEASGNMENTSPREAD') ;
begin
for i in tab_rec loop
	execute immediate 'alter table '|| i.table_name|| ' nologging'; 
end loop;
end;
/

--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
update profpriv a set a.priv_num=60 
where not exists (select 1 from profpriv b where b.prof_id=a.prof_id and b.priv_num =60 ) and  a.priv_num=58
/
--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
delete from profpriv where priv_num=58
/
/ 
--END TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
declare
	type rc is ref cursor;
    l_cursor rc;
	v_blob_col_val BLOB;
    v_rowid_val rowid;
    v_len number;
    v_start_point number;
	v_final blob;
	v_loc_point number;
	v_clobber_point number;
  BEGIN
    open l_cursor for SELECT ROWID,view_data  FROM VIEWPROP WHERE view_type like 'VP_XML_IMP%';
    LOOP
	  --dbms_lob.createtemporary(v_blob_col_val, true);
      FETCH l_cursor INTO v_rowid_val,v_blob_col_val ;
      EXIT WHEN l_cursor%NOTFOUND;
	  v_len := dbms_lob.getlength(v_blob_col_val) ;
	  --dbms_output.put_line('v_len----'||v_len);
	  if (v_len is not null and v_len > 0) then
	  v_clobber_point := dbms_lob.instr(v_blob_col_val,utl_raw.cast_to_raw ('ClobberOptions')) ;
      --dbms_output.put_line(v_clobber_point);
	  if (v_clobber_point is not null and v_clobber_point > 0) then	  
	  v_loc_point := dbms_lob.instr(v_blob_col_val,utl_raw.cast_to_raw ('G_LOCATION')) ;
	  if (v_loc_point is not null and v_loc_point =0 ) then
	  v_start_point := dbms_lob.instr(v_blob_col_val,utl_raw.cast_to_raw ('P_CALENDAR')) ;
	   if (v_start_point is not null and v_start_point > 0) then
	      dbms_lob.createtemporary(v_final, TRUE);
	      DBMS_LOB.APPEND(v_final,dbms_lob.substr(v_blob_col_val,(v_start_point-5),1));
	      DBMS_LOB.APPEND(v_final,utl_raw.cast_to_raw ('(0||G_LOCATION(import_option|X|delete_unref|N)())'));
	      DBMS_LOB.APPEND(v_final,dbms_lob.substr(v_blob_col_val,v_len,(v_start_point-4)));
          execute immediate 'UPDATE VIEWPROP SET view_data = :1 where rowid= :2' using v_final , v_rowid_val;
          commit;
       end if;
	  end if;
	  end if;
	  end if;
	end loop;
 exception when others then
   null;	
 END;
 /
/ 
--END TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
update prefer set license_data=null
/
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
DROP INDEX ndx_fn_task_code
/
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
CREATE INDEX ndx_fn_task_code ON TASK (LOWER(task_code)) TABLESPACE PMDB_NDX1
/
/ 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
insert into nextkey select 'leantask_lean_task_id',1 from dual where not exists (select * from nextkey where key_name=lower('leantask_lean_task_id')) 
/
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=177;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=177;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=177;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'N');
end if;
end;
end loop;
end;
/
/ 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update prefer set ts_rsrc_def_asgn_out_actv_flag= 'N' where ts_rsrc_def_asgn_actv_flag= 'N'
/

--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update project set rsrc_self_add_out_flag = 'N' where rsrc_self_add_flag = 'N'
/
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
/
/ 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES
DELETE  from vwprefdata where view_pref_id = 513 and  view_pref_key like 'PortfolioView.ColumnGroupByLwf'
/
/ 
--END TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
v_no_data_found number;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','IsAppletFree','Y',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='IsAppletFree');
end;
/
/ 
--END TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
insert into nextkey select 'jobproj_lkp_jobproj_lkp_id',1 from dual where not exists (select * from nextkey where key_name=lower('jobproj_lkp_jobproj_lkp_id')) 
/
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
DECLARE
  tbl_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO tbl_exists FROM user_tables WHERE table_name = UPPER('JOBPROJ_LKP');
  IF tbl_exists > 0
  THEN
   EXECUTE IMMEDIATE 'alter table jobproj_lkp drop constraint fk_jobproj_jobsvc';
   EXECUTE IMMEDIATE 'alter table jobproj_lkp add constraint fk_jobproj_jobsvc foreign key (job_id) references JOBSVC (job_id) on delete cascade';
  END IF;
END;
/

/ 
--END TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES
insert into nextkey select 'announcement_announcement_id',1 from dual where not exists (select * from nextkey where key_name=lower('announcement_announcement_id')) 
/

/ 
--END TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1901to1902 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1901to1902 NAME:MISC_UPDATES
insert /*+append */into rsrcoveralloc(rsrc_id,overalloc_date)
select  /*+parallel(16)*/ distinct rsrc_id,overalloc_date 
from rsrcroleasgnmentspread
where proj_id IS NULL AND rsrc_id IS NOT NULL and overalloc_date IS NOT NULL
/
/ 
--END TYPE:UP2 GROUP:1901to1902 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
merge into profpriv pp
    using (select prof_id ,'179' as priv_num,'N' as allow_flag from profile where scope_type='ST_Project') p
    on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag)
/

/ 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
declare 
lview_pref_id int;
begin
getnextkeys ('viewpref_view_pref_id',1,lview_pref_id);
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select lview_pref_id,'ResourceId','VT_FILTER_STANDARD' from dual where not exists( select 1 from viewpref where view_pref_name='ResourceId' and  view_pref_type='VT_FILTER_STANDARD');
getnextkeys ('viewpref_view_pref_id',1,lview_pref_id);
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select lview_pref_id,'RoleId','VT_FILTER_STANDARD' from dual where not exists( select 1 from viewpref where view_pref_name='RoleId' and  view_pref_type='VT_FILTER_STANDARD');
end;
/
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
merge into profpriv pp
 using (select prof_id ,'178' as priv_num,'Y' as allow_flag from profile where scope_type='ST_Project') p
    on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag)
/
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
insert /*+append */into rsrcoveralloc(rsrc_id,overalloc_date)
select   /*+parallel(16)*/ distinct rs.rsrc_id,rs.overalloc_date 
from rsrcroleasgnmentspread rs
where rs.rsrc_id IS NOT NULL and rs.rsrc_id <> 'RSRC'and rs.role_id IS NULL and not exists ( select 1 from rsrcoveralloc ro where ro.rsrc_id =rs.rsrc_id)
/
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
insert /*+append */into rsrcoveralloc(role_id)
select /*+parallel(16)*/  distinct rs.role_id
from rsrcroleasgnmentspread rs
where rs.role_id IS NOT NULL and rs.role_id <> 'ROLE' and not exists ( select 1 from rsrcoveralloc ro where ro.role_id =rs.role_id)
/

/ 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES
declare
cursor tab_rec is
select table_name from user_tables where table_name in('CALENDARX');
begin
for i in tab_rec loop
	execute immediate 'alter table '|| i.table_name|| ' nologging'; 
end loop;
end;
/
/ 
--END TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE GATEWAYPROVIDER SET PROVIDER_NAME='Primavera Cloud Provider' WHERE PROVIDER_NAME='Prime Provider'
/
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
merge into profpriv pp
 using (select prof_id ,'180' as priv_num,'N' as allow_flag from profile where scope_type='ST_Project') p
    on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag)
/

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE GATEWAYDEPLOYMENT SET DEPLOYMENT_NAME='Primavera Cloud Deployment' WHERE DEPLOYMENT_NAME='Prime Deployment'
/
/ 
--END TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
DECLARE
  trg_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO trg_exists FROM user_triggers WHERE trigger_name = 'TR_RSRCROLEASGNMENTSPREAD';
  IF trg_exists > 0
  THEN
   EXECUTE IMMEDIATE 'DROP TRIGGER TR_RSRCROLEASGNMENTSPREAD';
  END IF;
END;
/

/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
       if instr(i.image_name,'.')>0 then
       execute immediate 'update imagedata set image_name = :1, image_extension = :2 where image_id=:3' 
             using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),
                       SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),
                       i.image_id;
       end if;
    exception when others then 
       null;
    end;
   end loop;
  end if;
EXCEPTION when others then 
  null;
 END;
 /
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
 v_blob_col_val BLOB;
 v_rowid_val ROWID;
 v_len NUMBER;
 v_start_point NUMBER;
 v_final BLOB;
 v_loc_point NUMBER;
 v_loc_point1 NUMBER;
 v_clobber_point NUMBER;
 v_schedoption_exists number;
BEGIN
 SELECT rowid,view_data INTO v_rowid_val, v_blob_col_val
 FROM viewprop
 WHERE view_name = 'Default Import Template';
 v_len := dbms_lob.getlength(v_blob_col_val);
if(v_len IS NOT NULL AND v_len > 0) THEN
 v_clobber_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('ClobberOptions') );
 IF
  ( v_clobber_point IS NOT NULL AND v_clobber_point > 0 )
 THEN
  v_loc_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_PROJISSU') );
  IF
   ( v_loc_point IS NOT NULL AND v_loc_point >0 )
  THEN
   v_start_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_PROJISSU') ) + 49;
   v_schedoption_exists := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_SCHEDOPTIONS') );
   IF
    ( v_start_point IS NOT NULL AND v_start_point > 0 and v_schedoption_exists = 0)
   THEN
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.append(v_final, dbms_lob.substr(v_blob_col_val, (v_start_point - 5), 1) );
    dbms_lob.append(v_final, utl_raw.cast_to_raw('(0||P_SCHEDOPTIONS(import_option|K|delete_unref|N)())') );
    dbms_lob.append(v_final, dbms_lob.substr(v_blob_col_val, v_len, (v_start_point - 4) ) );
    EXECUTE IMMEDIATE 'UPDATE VIEWPROP SET view_data = :1 where rowid= :2'
    USING v_final, v_rowid_val;
    COMMIT;
   END IF;
  END IF;
 END IF;
 END IF;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
END;
/

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
v_blob_col_val blob;
v_rowid_val rowid;
v_len number;
v_start_point number;
v_final blob;
v_rem blob;
v_loadedresources_exists number;
begin
select rowid,config_data into v_rowid_val, v_blob_col_val
from admin_config
where config_name = 'myprimavera.bre.Primavera P6 Configuration';
v_len := dbms_lob.getlength(v_blob_col_val);
if(v_len is not null and v_len > 0) then
v_start_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('MaxPortletsPerDashboard'))-2;
v_loadedresources_exists := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('MaxLoadedResourcesAndRolesInTeamUsageAndResourceAnalysis'));
if ( v_start_point is not null and v_start_point > 0 and v_loadedresources_exists = 0) then
  dbms_lob.createtemporary(v_rem, true);
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.copy (v_rem,v_blob_col_val,(v_len-v_start_point+1),1,v_start_point);
  dbms_lob.append(v_final, dbms_lob.substr(v_blob_col_val, v_start_point, 1));
  dbms_lob.append(v_final, utl_raw.cast_to_raw('<MaxLoadedResourcesAndRolesInTeamUsageAndResourceAnalysis desc="SET_MAX_LOADED_RESOURCES_AND_ROLES_IN_TEAM_USAGE_AND_RESOURCE_ANALYSIS" max="5000" min="1" type="java.lang.Integer">1000</MaxLoadedResourcesAndRolesInTeamUsageAndResourceAnalysis>'));
  dbms_lob.append(v_final, utl_raw.cast_to_raw(chr(10)||'       '));
  dbms_lob.append(v_final, v_rem);
 execute immediate 'update admin_config set config_data = :1 where rowid= :2' using v_final, v_rowid_val;
 commit;
end if;
end if;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VSAFETY_REFRESH_DATE' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VSAFETY_REFRESH_DATE')
/

--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VLAST_SETTINGS_READTIME' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VLAST_SETTINGS_READTIME')
/

--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VSAFETY_DATE' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VSAFETY_DATE')
/


/ 
--END TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
BEGIN
settings_write_string('604800','database.background.Statmon','maint_threshold_secs');
END;
/

--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('pre_criticality_index');
  if col_exists > 0
  then
    execute immediate 'ALTER TABLE TASK modify   pre_criticality_index  number(10,2)';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('post_criticality_index');
  if col_exists > 0
  then
    execute immediate 'ALTER TABLE TASK modify   post_criticality_index  number(10,2)';
  end if;
END;         
/
/ 
--END TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/

--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update udftype
set SUMMARY_METHOD='NONE'
where table_name='PROJECT'
and LOGICAL_DATA_TYPE not in ('FT_TEXT','FT_STATICTYPE') and SUMMARY_METHOD='None'
/

--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
declare
type typ_rec is record (discussion_id number,rej_dis_data blob);
type typ_tbl is table of typ_rec; 
v_typ_tbl typ_tbl;
v_blob_col_len number;
v_sp_tag1 number;
v_search_string1 number;
v_search_string2 number;
v_search_string3 number;
v_update_users blob;
v_update_users_len number;
v_submit_users blob;
v_submit_users_len number;
v_rem blob;
v_final blob;
v_post blob;
  begin
   select discussion_id,rej_dis_data bulk collect into v_typ_tbl from discussion
     where delete_session_id is null 
   order by discussion_id;

   if v_typ_tbl.count >0 then
    for rec in v_typ_tbl.first..v_typ_tbl.last loop
     v_blob_col_len := dbms_lob.getlength(v_typ_tbl(rec).rej_dis_data);
     if(v_blob_col_len is not null and v_blob_col_len > 0) then
       v_sp_tag1 := dbms_lob.instr(v_typ_tbl(rec).rej_dis_data, utl_raw.cast_to_raw('commentHeader'));
       v_search_string3 := dbms_lob.instr(v_typ_tbl(rec).rej_dis_data, utl_raw.cast_to_raw('was rejected'));
       if(v_sp_tag1 is not null and v_sp_tag1 > 0) then
          dbms_lob.createtemporary(v_final, true);
          dbms_lob.copy (v_final,v_typ_tbl(rec).rej_dis_data,(v_sp_tag1+14));
          
          
          v_search_string1 := dbms_lob.instr(v_typ_tbl(rec).rej_dis_data, utl_raw.cast_to_raw('update for'));
          v_search_string2 := dbms_lob.instr(v_typ_tbl(rec).rej_dis_data, utl_raw.cast_to_raw('submitted by'));
          case when (v_search_string1 > 0 and v_search_string2 > 0 ) then
                       dbms_lob.append(v_final, utl_raw.cast_to_raw('['||chr(34))); 
                       v_update_users_len := (v_search_string2-1) - (v_search_string1+11);
                       dbms_lob.createtemporary(v_update_users, true);
                       dbms_lob.copy (v_update_users,v_typ_tbl(rec).rej_dis_data,v_update_users_len,1,(v_search_string1+11));
                       dbms_lob.append(v_final,v_update_users);
                       dbms_lob.append(v_final,utl_raw.cast_to_raw(chr(34)||','||chr(34)));
                       v_submit_users_len := (v_search_string3-1) - (v_search_string2+13);
                       dbms_lob.createtemporary(v_submit_users, true);
                       dbms_lob.copy (v_submit_users,v_typ_tbl(rec).rej_dis_data,v_submit_users_len,1,(v_search_string2+13));
                       dbms_lob.append(v_final,v_submit_users);
                       dbms_lob.append(v_final,utl_raw.cast_to_raw(chr(34)||']'));
                       dbms_lob.createtemporary(v_post, true);
                       dbms_lob.copy (v_post,v_typ_tbl(rec).rej_dis_data,(v_blob_col_len - (v_search_string3+12)),1,(v_search_string3+13));
                       dbms_lob.append(v_final,v_post);
                       update discussion set rej_dis_data = v_final where discussion_id = v_typ_tbl(rec).discussion_id;
                       commit;
                      
                   when (v_search_string2 > 0 ) then
                       dbms_lob.append(v_final, utl_raw.cast_to_raw('['||chr(34)));
                       v_submit_users_len := (v_search_string3-1) - (v_search_string2+13);
                       dbms_lob.createtemporary(v_submit_users, true);
                       dbms_lob.copy (v_submit_users,v_typ_tbl(rec).rej_dis_data,v_submit_users_len,1,(v_search_string2+13));
                       dbms_lob.append(v_final,v_submit_users);
                       dbms_lob.append(v_final,utl_raw.cast_to_raw(chr(34)||']'));
                       dbms_lob.createtemporary(v_post, true);
                       dbms_lob.copy (v_post,v_typ_tbl(rec).rej_dis_data,(v_blob_col_len - (v_search_string3+12)),1,(v_search_string3+14));
                       dbms_lob.append(v_final,v_post);
                       update discussion set rej_dis_data = v_final where discussion_id = v_typ_tbl(rec).discussion_id;
                       commit;
                      
                  when (v_search_string1 = 0 and v_search_string2 = 0 ) then
                       dbms_lob.createtemporary(v_update_users, true);
                       dbms_lob.createtemporary(v_submit_users, true);
                       dbms_lob.createtemporary(v_rem, true);
					   dbms_lob.copy (v_update_users,v_typ_tbl(rec).rej_dis_data,v_blob_col_len,1,v_sp_tag1+15);
					   v_update_users_len:=dbms_lob.getlength(v_update_users);
                       v_submit_users_len:=dbms_lob.instr(v_update_users,utl_raw.cast_to_raw('"'),1,2);
                       dbms_lob.copy (v_submit_users,v_update_users,v_submit_users_len);
                       dbms_lob.copy (v_rem,v_update_users,v_update_users_len,1,v_submit_users_len+1);

                       dbms_lob.append(v_final,utl_raw.cast_to_raw('['));
                       dbms_lob.append(v_final,v_submit_users);
                       dbms_lob.append(v_final,utl_raw.cast_to_raw(','||'true'||']'));
                       dbms_lob.append(v_final,v_rem);

                       update discussion set rej_dis_data = v_final where discussion_id = v_typ_tbl(rec).discussion_id;
                       commit;             
          end case;
       end if;
     end if;
     end loop;
      dbms_lob.close(v_submit_users);
       dbms_lob.freetemporary(v_submit_users);
       dbms_lob.close(v_update_users);
       dbms_lob.freetemporary(v_update_users);
       dbms_lob.close(v_rem);
       dbms_lob.freetemporary(v_rem);
       dbms_lob.close(v_post);
       dbms_lob.freetemporary(v_post);
       dbms_lob.close(v_final);
       dbms_lob.freetemporary(v_final);
  end if;
  exception
    when others then
    NULL;
  end;
/
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES
update udftype
set SUMMARY_METHOD='NONE'
where table_name='PROJECT'
and SUMMARY_METHOD='None'
/





/ 
--END TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=184;
if v_prof_id =12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=184;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=184;
end if;
exception when no_data_found then
if v_cur.prof_id =12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,184,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,184,'N');
end if;
end;
end if;
end loop;
end;
/

--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
DECLARE 
    v_len           NUMBER; 
    v_str1          NUMBER; 
    v_str2          NUMBER; 
    v_namespace     VARCHAR2(100); 
    v_setting_name  VARCHAR2(100); 
    v_setting_value VARCHAR2(100); 
    v_initial       BLOB; 
    v_final         BLOB; 
    v_count         NUMBER; 
    v_check         NUMBER; 
    CURSOR c IS 
      SELECT user_data_id,user_id,topic_name,user_data 
      FROM   userdata 
      WHERE  user_data IS NOT NULL 
             AND topic_name = 'pm_settings'; 
BEGIN 
    SELECT 1,namespace,setting_name,setting_value 
    INTO   v_count, v_namespace, v_setting_name, v_setting_value 
    FROM   settings 
    WHERE  namespace = 'Administrator_Settings' 
           AND setting_name = 'DisplayCodeValueName'; 

    IF v_count > 0 THEN 
      FOR rec IN c LOOP 
          v_len := dbms_lob.getlength(rec.user_data); 

          v_check :=dbms_lob.instr(rec.user_data,utl_raw.cast_to_raw('DisplayCodeValue')); 
          v_str1 := dbms_lob.instr(rec.user_data,utl_raw.cast_to_raw('(0||UserSettings()(')); 
          v_str2 := dbms_lob.instr(rec.user_data,utl_raw.cast_to_raw('(0||UserSettings(isLoaded|Y)(')); 
		  
      IF( v_len IS NOT NULL AND v_len > 0 AND v_check = 0 ) THEN 
          dbms_lob.createtemporary(v_initial, TRUE); 
          dbms_lob.createtemporary(v_final, TRUE); 
		  
       CASE WHEN ( v_str1 IS NOT NULL AND v_str1 > 0 ) THEN 
            dbms_lob.copy (v_final,rec.user_data, v_len - ( v_str1 + 18 ), 1, v_str1 + 19); 
            dbms_lob.append(v_initial, utl_raw.cast_to_raw('(0||UserSettings()('));
			
            WHEN ( v_str2 IS NOT NULL AND v_str2 > 0 ) THEN 
            dbms_lob.copy (v_final,rec.user_data, v_len - ( v_str2 + 28 ), 1, v_str2 + 29); 
            dbms_lob.append(v_initial,utl_raw.cast_to_raw('(0||UserSettings(isLoaded|Y)(')); 
			
            ELSE 
             NULL; 
       END CASE; 
          dbms_lob.append(v_initial, 
          utl_raw.cast_to_raw('(0||DisplayCodeValue(DisplayAsName|'|| v_setting_value||')())')); 
          dbms_lob.append(v_initial, v_final); 
          EXECUTE IMMEDIATE 'update userdata set user_data = :1 where topic_name= :2 and user_id= :3' 
                  USING v_initial, rec.topic_name, rec.user_id; 
          DELETE FROM settings WHERE  namespace = 'Administrator_Settings' 
		  AND setting_name = 'DisplayCodeValueName'; 
        COMMIT;  
      END IF; 
     END LOOP; 
    END IF; 
dbms_lob.freetemporary(v_initial); 
dbms_lob.CLOSE(v_initial); 
dbms_lob.freetemporary(v_final); 
dbms_lob.CLOSE(v_final); 
EXCEPTION 
    WHEN no_data_found THEN 
      NULL; 
    WHEN OTHERS THEN 
      NULL; 
END; 
/ 

--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','IsOfflineModeSupported', 'N' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='IsOfflineModeSupported' AND NAMESPACE='Administrator_Settings')
/

--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/




/ 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
DECLARE 
    v_count          NUMBER; 
    v_no_data_found  NUMBER;
    v_start_date     rolelimit.start_date%TYPE; 
    v_max_qty_per_hr rolelimit.max_qty_per_hr%TYPE; 
    v_role_rate_id   rolerate.role_rate_id%TYPE; 
    CURSOR rolerate_cur IS SELECT * FROM rolerate 
      WHERE role_id IS NOT NULL; 
    CURSOR rolelimit_cur(p_role_id IN NUMBER) IS 
      SELECT role_id,rolelimit_id,start_date,max_qty_per_hr 
      FROM rolelimit WHERE  role_id = p_role_id; 
BEGIN 
    FOR v_cur IN rolerate_cur LOOP 
       SELECT count(*) INTO v_count 
        FROM rolelimit WHERE  role_id = v_cur.role_id; 
        CASE WHEN v_count >= 1 THEN 
            FOR v_cur1 IN rolelimit_cur(v_cur.role_id) LOOP 
                DELETE FROM rolerate WHERE role_rate_id = v_cur.role_rate_id; 
                SELECT COUNT(*) INTO v_no_data_found FROM nextkey
                WHERE key_name='rolerate_role_rate_id';
                IF  v_no_data_found = 0 THEN
                INSERT INTO nextkey SELECT 'rolerate_role_rate_id',1 FROM dual 
                WHERE NOT EXISTS (SELECT * FROM nextkey WHERE key_name=lower('rolerate_role_rate_id')); 
                COMMIT;
                END IF;
                SELECT key_seq_num INTO v_role_rate_id 
                FROM  nextkey WHERE  key_name = 'rolerate_role_rate_id'; 
                UPDATE nextkey SET key_seq_num = key_seq_num + 1 
                WHERE  key_name = 'rolerate_role_rate_id'; 
                INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5,update_date,update_user,create_date,create_user,delete_session_id,delete_date)
                VALUES (v_role_rate_id,v_cur.role_id,v_cur1.start_date,v_cur1.max_qty_per_hr,v_cur.cost_per_qty, 
                            v_cur.cost_per_qty2,v_cur.cost_per_qty3,v_cur.cost_per_qty4,v_cur.cost_per_qty5, 
                            v_cur.update_date,v_cur.update_user,v_cur.create_date,v_cur.create_user, 
                            v_cur.delete_session_id,v_cur.delete_date); 
            END LOOP; 
          WHEN v_count = 0 THEN 
            UPDATE rolerate SET max_qty_per_hr = 0 , start_date=to_date('01-JAN-1976','DD-MON-YYYY')
            WHERE  role_id = v_cur.role_id; 
          ELSE 
            NULL; 
        END CASE; 
		COMMIT;
    END LOOP; 
    DELETE FROM rolelimit; 
EXCEPTION 
    WHEN OTHERS THEN 
      NULL; 
END; 
/ 
/ 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE
CURSOR cur_rr_rl IS
SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
             rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5
FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id
 WHERE  rr.role_id IS NOT NULL
ORDER BY 3 NULLS LAST;
v_role_rate_id   rolerate.role_rate_id%TYPE;
v_commit_point number := 0;
BEGIN
  FOR v_cur_rec IN cur_rr_rl LOOP
    IF v_cur_rec.rolelimit_id is NOT NULL THEN
       DELETE FROM rolerate WHERE role_rate_id = v_cur_rec.role_rate_id;
       getnextkeys('rolerate_role_rate_id', 1, v_role_rate_id);
       INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (v_role_rate_id,v_cur_rec.role_id,v_cur_rec.start_date,v_cur_rec.max_qty_per_hr,v_cur_rec.cost_per_qty,v_cur_rec.cost_per_qty2,
                          v_cur_rec.cost_per_qty3,v_cur_rec.cost_per_qty4,v_cur_rec.cost_per_qty5); 
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    ELSE
       UPDATE rolerate SET max_qty_per_hr = 0 , start_date=trunc(SYSDATE,'YEAR') WHERE  role_id = v_cur_rec.role_id and start_date=to_date('01-JAN-1976','DD-MON-YYYY');
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    END IF;
    IF mod (v_commit_point,1000) = 0 THEN
       COMMIT;
    END IF;
  END LOOP;
  DELETE FROM rolelimit;
  COMMIT;
EXCEPTION 
    WHEN OTHERS THEN 
      NULL;  
END;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecatvalx_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatvalx_role_catg_id',1)
/


--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 181..183 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

--METADATA TYPE:UP2 GROUP:19123to19124 NAME:MISC_UPDATES
DECLARE
    v_cnt        NUMBER;
    v_indx_cnt   NUMBER;
BEGIN
    WITH v (
        column_name,
        column_position
    ) AS (
        SELECT
            'UPDATE_DATE',
            1
        FROM
            dual
        UNION ALL
        SELECT
            'DELETE_SESSION_ID',
            2
        FROM
            dual
        UNION ALL
        SELECT
            'PROJ_ID',
            3
        FROM
            dual
    )
    SELECT
        COUNT(*)
    INTO v_cnt
    FROM
        user_ind_columns t,
        v
    WHERE
        t.column_name = v.column_name
        AND t.column_position = v.column_position
        AND t.table_name = 'TASKACTV';

    IF v_cnt <> 3 THEN
        SELECT
            COUNT(1)
        INTO v_indx_cnt
        FROM
            user_indexes
        WHERE
            index_name = 'NDX_TASKACTV_UPD';

        IF v_indx_cnt = 1 THEN
            EXECUTE IMMEDIATE 'DROP INDEX NDX_TASKACTV_UPD';
        END IF;
        EXECUTE IMMEDIATE 'CREATE INDEX ndx_taskactv_upd 
                       ON TASKACTV (update_date, delete_session_id, proj_id) 
                       TABLESPACE PMDB_NDX1 
                       PCTFREE 10 
                       STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)'
        ;
    END IF;

END;
/

/ 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
ALTER SESSION ENABLE PARALLEL DML
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
CREATE TABLE RSRCROLEASGNMENTSPREAD_BKP
(id  number(10) NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  spread_start_date  DATE NULL,
  spread_end_date  DATE NULL,
  plan_start_date  DATE NULL,
  plan_end_date  DATE NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  rem_start_date  DATE NULL,
  rem_end_date  DATE NULL,
  plan_qty  number(22,6) NULL,
  staffed_act_qty  number(22,6) NULL,
  unstaffed_act_qty  number(22,6) NULL,
  act_this_per_qty  number(22,6) NULL,
  staffed_remain_qty  number(22,6) NULL,
  unstaffed_remain_qty  number(22,6) NULL,
  staffed_total_qty  number(22,6) NULL,
  unstaffed_total_qty  number(22,6) NULL,
  total_period_qty  number(22,6) NULL,
  plan_cost  number(25,6) NULL,
  staffed_act_cost  number(25,6) NULL,
  unstaffed_act_cost  number(25,6) NULL,
  act_this_period_cost  number(25,6) NULL,
  staffed_remain_cost  number(25,6) NULL,
  unstaffed_remain_cost  number(25,6) NULL,
  staffed_total_cost  number(25,6) NULL,
  unstaffed_total_cost  number(25,6) NULL,
  total_period_cost  number(25,6) NULL,
  rolledup_record  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL,
  overalloc_date  DATE NULL
  )
  TABLESPACE PMDB_DAT1
  STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
  NOLOGGING
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
begin
INSERT /*+append */ INTO RSRCROLEASGNMENTSPREAD_BKP
SELECT /*+parallel(16)*/ * FROM RSRCROLEASGNMENTSPREAD 
WHERE (REGEXP_LIKE (rsrc_id,'^[[:digit:]]+$') or rsrc_id is NULL)
AND (REGEXP_LIKE (role_id,'^[[:digit:]]+$') or role_id is NULL);
commit;
end;
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
drop table RSRCROLEASGNMENTSPREAD
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table RSRCROLEASGNMENTSPREAD_BKP rename to RSRCROLEASGNMENTSPREAD
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
DECLARE
  tab_exists integer;
BEGIN
  select count(*) into tab_exists from user_objects where object_name = upper('RSRCROLEASGNMENTSPREAD') and object_type = upper('TABLE');
  if tab_exists <> 0
  then
    execute immediate 'delete from RSRCROLEASGNMENTSPREAD where proj_id not in(select proj_id from project)';
  end if;
END;
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('RSRCROLEASGNMENTSPREAD') and constraint_name=upper('fk_rsrcrolespread_project');
  if constraint_exists = 0
  then
    EXECUTE IMMEDIATE 'ALTER TABLE RSRCROLEASGNMENTSPREAD
    ADD CONSTRAINT fk_rsrcrolespread_project FOREIGN KEY (proj_id)
    REFERENCES PROJECT (proj_id) ON DELETE CASCADE';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('RSRCROLEASGNMENTSPREAD') and index_name=upper('ndx_rsrcroleasgnmntsprd_proj');
  if index_exists = 0
  then
    execute immediate 'CREATE INDEX ndx_rsrcroleasgnmntsprd_proj
    ON RSRCROLEASGNMENTSPREAD (proj_id)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
ALTER SESSION DISABLE PARALLEL DML
/

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table rsrchour 
  modify (pend_hr_cnt number(14, 6), hr_cnt number(14, 6),
  pend_ot_hr_cnt number (14, 6), ot_hr_cnt number(14, 6))
/




/ 
--END TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
UPDATE (
    SELECT
        p.proj_id,
        p.proj_short_name,
        p.sum_base_proj_id
    FROM
        project p
    WHERE
        p.orig_proj_id IS NULL
        AND p.project_flag = 'Y'
        AND p.sum_base_proj_id IS NOT NULL
        AND EXISTS (
            SELECT
                1
            FROM
                project b
            WHERE
                p.sum_base_proj_id = b.proj_id
                AND p.proj_id <> b.orig_proj_id
        )
) ilv
SET
    ilv.sum_base_proj_id = NULL
/


--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
UPDATE project
SET
    sum_base_proj_id = NULL
WHERE
    orig_proj_id IS NOT NULL
    AND sum_base_proj_id IS NOT NULL
/
--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('RSRCROLEASGNMENTSPREAD') and index_name=upper('ndx_rsrcrlasgnmntsprd_rl_id');
  if index_exists = 0
  then
    execute immediate 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rl_id
    ON RSRCROLEASGNMENTSPREAD (role_id,spread_start_date,spread_end_date)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
END;
/

--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('RSRCROLEASGNMENTSPREAD') and index_name=upper('ndx_rsrcrlasgnmntsprd_rsrc_id');
  if index_exists = 0
  then
    execute immediate 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rsrc_id
    ON RSRCROLEASGNMENTSPREAD (rsrc_id,spread_start_date,spread_end_date)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
END;
/
/ 
--END TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES

declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile where scope_type='ST_Global';
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=188;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=188;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=188;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,188,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,188,'N');
end if;
end;
end if;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
declare
v_count number;
begin
select count(*) into v_count from user_tab_columns where table_name = upper('DBERRLOG');
if v_count = 0 then
execute immediate 'CREATE TABLE DBERRLOG(
  log_id  number(10) GENERATED ALWAYS AS IDENTITY NOT NULL,
  created_on  DATE NULL,
  created_by  varchar2(3000 CHAR) NULL,
  errorcode  number(10) NULL,
  callstack  varchar2(3000 CHAR) NULL,
  errorstack  varchar2(3000 CHAR) NULL,
  backtrace  varchar2(3000 CHAR) NULL,
  error_info  varchar2(3000 CHAR) NULL
,CONSTRAINT pk_dberrlog PRIMARY KEY (log_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)';
else
execute immediate 'DROP TABLE DBERRLOG';
execute immediate 'CREATE TABLE DBERRLOG(
  log_id  number(10) GENERATED ALWAYS AS IDENTITY NOT NULL,
  created_on  DATE NULL,
  created_by  varchar2(3000 CHAR) NULL,
  errorcode  number(10) NULL,
  callstack  varchar2(3000 CHAR) NULL,
  errorstack  varchar2(3000 CHAR) NULL,
  backtrace  varchar2(3000 CHAR) NULL,
  error_info  varchar2(3000 CHAR) NULL
,CONSTRAINT pk_dberrlog PRIMARY KEY (log_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)';
end if;
end;
/

--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
ALTER TABLE LEANTASK MODIFY DURATION NUMBER
/


/ 
--END TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
insert into nextkey select 'wbsreviewers_wbsreviewers_id',1 from dual 
where not exists (select * from nextkey where key_name=lower('wbsreviewers_wbsreviewers_id')) 
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
insert into nextkey select 'wbsreviewstatus_wbsreviewstatus_id',1 from dual 
where not exists (select * from nextkey where key_name=lower('wbsreviewstatus_wbsreviewstatus_id')) 
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
  vkey              NUMBER; 
  v_cnt             NUMBER; 
  v_wbs_id          NUMBER; 
  v_proj_id         NUMBER; 
  v_status_reviewer NUMBER; 
  v_str             VARCHAR2(500) := 'SELECT pw.wbs_id, pw.proj_id, pw.status_reviewer 
                                      FROM projwbs pw, project p WHERE pw.proj_id = p.proj_id 
									  AND p.project_flag=''Y'' 
									  AND p.control_updates_flag = ''Y'' 
									  AND p.orig_proj_id IS NULL
									  AND exists (select 1 from users u
									  where u.user_id=pw.status_reviewer)';
  cur_projwbs       SYS_REFCURSOR; 
BEGIN 
    SELECT count(*) INTO v_cnt 
    FROM   user_tab_columns 
    WHERE  table_name = 'PROJWBS' AND column_name = 'STATUS_REVIEWER'; 

    IF v_cnt > 0 THEN 
      OPEN cur_projwbs FOR v_str; 

      LOOP 
          FETCH cur_projwbs INTO v_wbs_id, v_proj_id, v_status_reviewer; 
          exit WHEN cur_projwbs%NOTFOUND; 

          UPDATE projwbs 
          SET    review_type = 'Review_Any' 
          WHERE  wbs_id = v_wbs_id AND proj_id = v_proj_id; 

          getnextkeys ('wbsreviewers_wbsreviewers_id', 1, vkey); 
          INSERT INTO wbsreviewers (wbsreviewers_id, wbs_id, status_reviewer) 
          SELECT vkey, v_wbs_id, v_status_reviewer FROM dual 
          WHERE  NOT EXISTS (SELECT * FROM wbsreviewers 
                             WHERE  wbs_id = v_wbs_id AND status_reviewer = v_status_reviewer); 
      END LOOP; 

      CLOSE cur_projwbs; 
      COMMIT; 
    END IF; 
EXCEPTION 
  WHEN OTHERS THEN 
dbms_output.put_line('Error in wbs status reviewer migrate process'); 
END; 
/


--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE)
Select (select nvl(max(fintmpl_id),0)+1 from fintmpl), 'Default Calendar', 'Y', SYSDATE, SYSDATE FROM DUAL
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE DEFAULT_FLAG='Y')
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = (SELECT FINTMPL_ID FROM FINTMPL WHERE DEFAULT_FLAG = 'Y') WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=(select max(fintmpl_id)+1 from fintmpl)
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2)
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
          getnextkeys('findates_fin_dates_id', 1, v_fin_dates_id); 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
declare
v_rpt_id number;
v_rpt_group_id number;
v_text blob := utl_raw.cast_to_raw('object TCVReport
  Width = 942
  Height = 583
  ParentFont = False
  Color = clWhite
  Title = ''Offline Working Status''
  ReportName = ''Offline Working Status''
  VDBEngineName = ''VDBORION''
  PageSettingsList.Strings = (
    
      ''(0||(layout_type|none)((40000001||header()((0||section_list(sect'' +
      ''ion_count|3|item_index|0)((0||item1(section_type|text_logo|legen'' +
      ''d_type|none)((0||revision_box(title|)((0||revision_item_list(cou'' +
      ''nt|4)())(0||font(font_name|Arial|color|0|height|-11|style||CharS'' +
      ''et|1)())(0||table_head()((0||font(font_name|Arial|color|0|height'' +
      ''|-11|style||CharSet|1)())(0||columns(count|4)((0||item1(width|16'' +
      '')())(0||item2(width|52)())(0||item3(width|16)())(0||item4(width|'' +
      ''16)())))))))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff>'' +
      ''<P align=left><FONT face=Arial size=1>[project_name]</FONT></P><'' +
      ''/BODY></HTML>)())))(0||item2(section_type|text_logo|legend_type|'' +
      ''none)((0||revision_box(title|)((0||revision_item_list(count|4)()'' +
      '')(0||font(font_name|Arial|color|0|height|-11|style||CharSet|1)()'' +
      '')(0||table_head()((0||font(font_name|Arial|color|0|height|-11|st'' +
      ''yle||CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0|'' +
      ''|item2(width|52)())(0||item3(width|16)())(0||item4(width|16)()))'' +
      '')))))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P alig'' +
      ''n=center><FONT face=Arial size=1>[layout_name]</FONT></P></BODY>'' +
      ''</HTML>)())))(0||item3(section_type|text_logo|legend_type|none)('' +
      ''(0||revision_box(title|)((0||revision_item_list(count|4)())(0||f'' +
      ''ont(font_name|Arial|color|0|height|-11|style||CharSet|1)())(0||t'' +
      ''able_head()((0||font(font_name|Arial|color|0|height|-11|style||C'' +
      ''harSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||item2'' +
      ''(width|52)())(0||item3(width|16)())(0||item4(width|16)())))))))('' +
      ''0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align=righ'' +
      ''t><FONT face=Arial size=1>[date] [time]</FONT></P></BODY></HTML>'' +
      '')())))))))(40000001||footer()((0||section_list(section_count|3|i'' +
      ''tem_index|0)((0||item1(section_type|text_logo|legend_type|none)('' +
      ''(0||revision_box(title|)((0||revision_item_list(count|4)())(0||f'' +
      ''ont(font_name|Arial|color|0|height|-11|style||CharSet|1)())(0||t'' +
      ''able_head()((0||font(font_name|Arial|color|0|height|-11|style||C'' +
      ''harSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||item2'' +
      ''(width|52)())(0||item3(width|16)())(0||item4(width|16)())))))))('' +
      ''0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align=left'' +
      ''><FONT face=Arial size=1>&copy; Oracle Corporation</FONT></P></B'' +
      ''ODY></HTML>)())))(0||item2(section_type|text_logo|legend_type|no'' +
      ''ne)((0||revision_box(title|)((0||revision_item_list(count|4)())('' +
      ''0||font(font_name|Arial|color|0|height|-11|style||CharSet|1)())('' +
      ''0||table_head()((0||font(font_name|Arial|color|0|height|-11|styl'' +
      ''e||CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||i'' +
      ''tem2(width|52)())(0||item3(width|16)())(0||item4(width|16)()))))'' +
      '')))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align='' +
      ''center><FONT face=Arial size=1>Page [page_number] of [total_page'' +
      ''s]</FONT></P></BODY></HTML>)())))(0||item3(section_type|text_log'' +
      ''o|legend_type|none)((0||revision_box(title|)((0||revision_item_l'' +
      ''ist(count|4)())(0||font(font_name|Arial|color|0|height|-11|style'' +
      ''||CharSet|1)())(0||table_head()((0||font(font_name|Arial|color|0'' +
      ''|height|-11|style||CharSet|1)())(0||columns(count|4)((0||item1(w'' +
      ''idth|16)())(0||item2(width|52)())(0||item3(width|16)())(0||item4'' +
      ''(width|16)())))))))(0||text_logo(memo_text|<HTML><BODY bgColor=#'' +
      ''ffffff><P align=left><FONT face=Arial size=1></FONT></P></BODY><'' +
      ''/HTML>)())))))))(40000001||margins(left|0.5|right|0.5|top|0.5|bo'' +
      ''ttom|0.5|left_margin|0.5|right_margin|0.5|top_margin|0.5|bottom_'' +
      ''margin|0.5|printable_offset_left|0|printable_offset_top|0|printa'' +
      ''ble_offset_right|0|printable_offset_bottom|0)())(0||page(orienta'' +
      ''tion|2|paper_size|9|length|8.5|width|11|printername||scale|100|f'' +
      ''it_to_x|0|fit_to_y|0|fit_to_page|0|Copies|1|Source|0|PrintQualit'' +
      ''y|0|Color|0|Duplex|0|YResolution|0|TTOption|0|CollatedCopies|N|l'' +
      ''egend_mode|F)())(0||legend()((0||left(text||image_file_name||mod'' +
      ''e|T)((0||font(font_name|Arial|color|0|size|10|style||CharSet|1)('' +
      ''))))(0||middle(text||image_file_name||mode|T)((0||font(font_name'' +
      ''|Arial|color|0|size|10|style||CharSet|1)())))(0||right(text||ima'' +
      ''ge_file_name||mode|T)((0||font(font_name|Arial|color|0|size|10|s'' +
      ''tyle||CharSet|1)())))))(0||CustomSettings()())))'')
  SourceSettings.Strings = (
    
      ''(0||Current View(table_name|TRACKOFFLINEUSER|column_index|-2||-1'' +
      ''|grid_index|-1|filter_index|0|groupby_index|0|dategrid_index|-1|'' +
      ''show_date_range|N|view_options_name|TrackOfflineUser|table_title'' +
      ''|Offline Working|ReportTitle|Offline Working Status)((0||Columns'' +
      ''(selected_column|0|Report Columns|Y|Timesheet Report Columns|N|l'' +
      ''eft|398|top|217|width|570|height|334)((0||login_name(width|100|c'' +
      ''olumn_title|Login Name)())(0||personal_name(width|150|column_tit'' +
      ''le|Personal Name)())(0||status(width|50|column_title|Status|alig'' +
      ''nment|L)())(0||last_online_date(width|100|column_title|Online Da'' +
      ''te|alignment|L)())(0||offline_date(width|100|column_title|Offlin'' +
      ''e Date|alignment|L)())(0||global_profile(width|150|column_title|'' +
      ''Global Profile|alignment|L)())(0||user_email(width|150|column_ti'' +
      ''tle|User Email Address|alignment|L)())))(0||GroupSortBy(show_tot'' +
      ''al|N)((0||Levels()())(0||SortBys()())(0||GroupBys(hide_base_grou'' +
      ''pby|N)())))(0||GridSettings()())(0||Filter()())(0||ReportPageSet'' +
      ''tings(layout_type|none)((40000001||header()((0||section_list(sec'' +
      ''tion_count|3|item_index|0)((0||item1(section_type|text_logo|lege'' +
      ''nd_type|none)((0||revision_box(title|)((0||revision_item_list(co'' +
      ''unt|4)())(0||font(font_name|Arial|color|0|height|-11|style||Char'' +
      ''Set|1)())(0||table_head()((0||font(font_name|Arial|color|0|heigh'' +
      ''t|-11|style||CharSet|1)())(0||columns(count|4)((0||item1(width|1'' +
      ''6)())(0||item2(width|52)())(0||item3(width|16)())(0||item4(width'' +
      ''|16)())))))))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff'' +
      ''><P align=left><FONT face=Arial size=1>[project_name]</FONT></P>'' +
      ''</BODY></HTML>)())))(0||item2(section_type|text_logo|legend_type'' +
      ''|none)((0||revision_box(title|)((0||revision_item_list(count|4)('' +
      ''))(0||font(font_name|Arial|color|0|height|-11|style||CharSet|1)('' +
      ''))(0||table_head()((0||font(font_name|Arial|color|0|height|-11|s'' +
      ''tyle||CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0'' +
      ''||item2(width|52)())(0||item3(width|16)())(0||item4(width|16)())'' +
      ''))))))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P ali'' +
      ''gn=center><FONT face=Arial size=1>[layout_name]</FONT></P></BODY'' +
      ''></HTML>)())))(0||item3(section_type|text_logo|legend_type|none)'' +
      ''((0||revision_box(title|)((0||revision_item_list(count|4)())(0||'' +
      ''font(font_name|Arial|color|0|height|-11|style||CharSet|1)())(0||'' +
      ''table_head()((0||font(font_name|Arial|color|0|height|-11|style||'' +
      ''CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||item'' +
      ''2(width|52)())(0||item3(width|16)())(0||item4(width|16)())))))))'' +
      ''(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align=rig'' +
      ''ht><FONT face=Arial size=1>[date] [time]</FONT></P></BODY></HTML'' +
      ''>)())))))))(40000001||footer()((0||section_list(section_count|3|'' +
      ''item_index|0)((0||item1(section_type|text_logo|legend_type|none)'' +
      ''((0||revision_box(title|)((0||revision_item_list(count|4)())(0||'' +
      ''font(font_name|Arial|color|0|height|-11|style||CharSet|1)())(0||'' +
      ''table_head()((0||font(font_name|Arial|color|0|height|-11|style||'' +
      ''CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||item'' +
      ''2(width|52)())(0||item3(width|16)())(0||item4(width|16)())))))))'' +
      ''(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align=lef'' +
      ''t><FONT face=Arial size=1>&copy; Oracle Corporation</FONT></P></'' +
      ''BODY></HTML>)())))(0||item2(section_type|text_logo|legend_type|n'' +
      ''one)((0||revision_box(title|)((0||revision_item_list(count|4)())'' +
      ''(0||font(font_name|Arial|color|0|height|-11|style||CharSet|1)())'' +
      ''(0||table_head()((0||font(font_name|Arial|color|0|height|-11|sty'' +
      ''le||CharSet|1)())(0||columns(count|4)((0||item1(width|16)())(0||'' +
      ''item2(width|52)())(0||item3(width|16)())(0||item4(width|16)())))'' +
      ''))))(0||text_logo(memo_text|<HTML><BODY bgColor=#ffffff><P align'' +
      ''=center><FONT face=Arial size=1>Page [page_number] of [total_pag'' +
      ''es]</FONT></P></BODY></HTML>)())))(0||item3(section_type|text_lo'' +
      ''go|legend_type|none)((0||revision_box(title|)((0||revision_item_'' +
      ''list(count|4)())(0||font(font_name|Arial|color|0|height|-11|styl'' +
      ''e||CharSet|1)())(0||table_head()((0||font(font_name|Arial|color|'' +
      ''0|height|-11|style||CharSet|1)())(0||columns(count|4)((0||item1('' +
      ''width|16)())(0||item2(width|52)())(0||item3(width|16)())(0||item'' +
      ''4(width|16)())))))))(0||text_logo(memo_text|<HTML><BODY bgColor='' +
      ''#ffffff><P align=left><FONT face=Arial size=1></FONT></P></BODY>'' +
      ''</HTML>)())))))))(40000001||margins(left|0.5|right|0.5|top|0.5|b'' +
      ''ottom|0.5|left_margin|0.5|right_margin|0.5|top_margin|0.5|bottom'' +
      ''_margin|0.5|printable_offset_left|0|printable_offset_top|0|print'' +
      ''able_offset_right|0|printable_offset_bottom|0)())(0||page(orient'' +
      ''ation|2|paper_size|9|length|8.5|width|11|printername||scale|100|'' +
      ''fit_to_x|0|fit_to_y|0|fit_to_page|0|Copies|1|Source|0|PrintQuali'' +
      ''ty|0|Color|0|Duplex|0|YResolution|0|TTOption|0|CollatedCopies|N|'' +
      ''legend_mode|F)())(0||legend()((0||left(text||image_file_name||mo'' +
      ''de|T)((0||font(font_name|Arial|color|0|size|10|style||CharSet|1)'' +
      ''())))(0||middle(text||image_file_name||mode|T)((0||font(font_nam'' +
      ''e|Arial|color|0|size|10|style||CharSet|1)())))(0||right(text||im'' +
      ''age_file_name||mode|T)((0||font(font_name|Arial|color|0|size|10|'' +
      ''style||CharSet|1)())))))(0||CustomSettings()())))(0||ReportOptio'' +
      ''ns(format_floats|Y)())(0||DateGridFields(show_time_dist|Y|show_p'' +
      ''rior|N|show_period|Y|show_post|N|show_total|N)())))'')
  FontHeading1.Charset = DEFAULT_CHARSET
  FontHeading1.Color = clBlack
  FontHeading1.Height = -19
  FontHeading1.Name = ''Arial''
  FontHeading1.Style = [fsBold]
  FontHeading2.Charset = DEFAULT_CHARSET
  FontHeading2.Color = clBlack
  FontHeading2.Height = -12
  FontHeading2.Name = ''Arial''
  FontHeading2.Style = [fsBold]
  FontHeading3.Charset = DEFAULT_CHARSET
  FontHeading3.Color = clBlack
  FontHeading3.Height = -12
  FontHeading3.Name = ''Arial''
  FontHeading3.Style = [fsBold]
  FontHeading4.Charset = DEFAULT_CHARSET
  FontHeading4.Color = clBlack
  FontHeading4.Height = -11
  FontHeading4.Name = ''Arial''
  FontHeading4.Style = [fsUnderline]
  FontBody1.Charset = DEFAULT_CHARSET
  FontBody1.Color = clBlack
  FontBody1.Height = -11
  FontBody1.Name = ''Arial''
  FontBody1.Style = []
  FontBody2.Charset = DEFAULT_CHARSET
  FontBody2.Color = clBlack
  FontBody2.Height = -11
  FontBody2.Name = ''Arial''
  FontBody2.Style = [fsBold]
  FontBody3.Charset = DEFAULT_CHARSET
  FontBody3.Color = clBlack
  FontBody3.Height = -11
  FontBody3.Name = ''Arial''
  FontBody3.Style = [fsBold]
  Image.SaveFormat = bsvGIF
  Version.MajorVersion = 3
  Version.MinorVersion = 5
  TimesheetReportSettings.TimesheetReportRangeType = unknownRange
  TimesheetReportSettings.PastTimesheetPeriods = 0
  TimesheetReportSettings.FutureTimesheetPeriods = 0
  TimesheetReportSettings.FromStartPeriodId = 0
  TimesheetReportSettings.ToFinishPeriodId = 0
  object TCVReportRowContainer
    Left = 48
    Top = 180
    Width = 844
    Height = 48
    ContainerAlign = alcTop
    ContainerType = rctReportHeader
    ExplicitLeft = 0
    ExplicitTop = 0
    ExplicitWidth = 185
  end
  object TCVReportRowContainer
    Left = 48
    Top = 49
    Width = 844
    Height = 131
    ContainerAlign = alcTop
    ContainerType = rctPageHeader
    object TCVReportRow
      Top = 1
      Width = 844
      Height = 30
      Color = clWhite
      ContainerAlign = alcTop
      ExplicitWidth = 718
      object TCVReportTextCell
        Width = 844
        Height = 29
        ParentFont = False
        Color = clWhite
        CellAlign = caCenter
        AutoAlignment = False
        CellType = ctVariable
        FontStyle = rfsHeading1
        VariableField = ''[title]''
        FieldTitle = ''Report Title''
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clWindowText
        Font.Height = -19
        Font.Name = ''Helvetica''
        Font.Style = []
        FieldTypeID = 0
        ExplicitWidth = 200
      end
    end
    object TCVReportRow
      Top = 31
      Width = 844
      Height = 20
      Color = clWhite
      ContainerAlign = alcTop
      ExplicitWidth = 718
      object TCVReportTextCell
        Width = 844
        Height = 19
        Color = clWhite
        CellAlign = caCenter
        AutoAlignment = False
        CellType = ctVariable
        VariableField = ''[notes]''
        FieldTitle = ''Notes''
        FieldTypeID = 0
        ExplicitWidth = 200
      end
    end
    object TCVReportRow
      Top = 51
      Width = 844
      Height = 20
      Color = clWhite
      ContainerAlign = alcTop
      ExplicitTop = 81
      ExplicitWidth = 718
    end
    object TCVReportRow
      Top = 71
      Width = 844
      Height = 20
      Color = clWhite
      WizardDefined = True
      ContainerAlign = alcTop
      ExplicitWidth = 718
      object TCVReportTextCell
        Width = 100
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Login Name''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 106
        Width = 150
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Personal Name''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 262
        Width = 50
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Status''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 318
        Width = 100
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Online Date''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 424
        Width = 100
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Offline Date''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 530
        Width = 150
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''Global Profile''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
      object TCVReportTextCell
        Left = 686
        Width = 150
        Height = 19
        ParentFont = False
        Color = clWhite
        AutoAlignment = False
        CellType = ctCustomText
        FontStyle = rfsHeading2
        SummaryGroupByPath = ''TRACKOFFLINEUSER''
        Text = ''User Email Address''
        Alignment = taLeftJustify
        Font.Charset = DEFAULT_CHARSET
        Font.Color = clBlack
        Font.Height = -12
        Font.Name = ''Arial''
        Font.Style = [fsBold]
        FieldTypeID = 0
      end
    end
    object TCVReportRow
      Top = 91
      Width = 844
      Height = 10
      Color = clWhite
      WizardDefined = True
      ContainerAlign = alcTop
      object TCVReportLineCell
        Width = 844
        Height = 9
        Color = clWhite
        CellAlign = caCenter
        ExplicitWidth = 836
      end
    end
  end
  object TCVReportSectionContainer
    Left = 48
    Top = 228
    Width = 844
    Height = 208
    ContainerAlign = alcClient
    ContainerType = rctDetail
    ExplicitTop = 178
    ExplicitWidth = 718
    object TCVReportGroupBy
      Top = 1
      Width = 844
      Height = 149
      ContainerAlign = alcTop
      GroupByTableName = ''TRACKOFFLINEUSER''
      Filter.Strings = (
        ''#begin_and''
        ''#end'')
      IncludeParents = True
      HideSubjectArea = False
      HasJoinToResource = False
      object TCVReportRowContainer
        Top = 1
        Width = 844
        Height = 48
        ContainerAlign = alcTop
        ContainerType = rctGroupByHeader
        ExplicitTop = 0
        ExplicitWidth = 185
      end
      object TCVReportSectionContainer
        Top = 49
        Width = 844
        Height = 51
        ContainerAlign = alcClient
        ContainerType = rctDetail
        object TCVReportRow
          Top = 1
          Width = 844
          Height = 20
          Color = clWhite
          ContainerAlign = alcTop
          object TCVReportTextCell
            Width = 100
            Height = 19
            ParentFont = False
            Color = clWhite
            ShowIndent = True
            AutoAlignment = False
            DataField = ''login_name''
            FieldTitle = ''Login Name''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 106
            Width = 150
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''personal_name''
            FieldTitle = ''Personal Name''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 262
            Width = 50
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''status''
            FieldTitle = ''Status''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 318
            Width = 100
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''last_online_date''
            FieldTitle = ''Online Date''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 424
            Width = 100
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''offline_date''
            FieldTitle = ''Offline Date''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 530
            Width = 150
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''global_profile''
            FieldTitle = ''Global Profile''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
          object TCVReportTextCell
            Left = 686
            Width = 150
            Height = 19
            ParentFont = False
            Color = clWhite
            AutoAlignment = False
            DataField = ''user_email''
            FieldTitle = ''User Email Address''
            Alignment = taLeftJustify
            Font.Charset = DEFAULT_CHARSET
            Font.Color = clBlack
            Font.Height = -11
            Font.Name = ''Arial''
            Font.Style = []
            FieldTypeID = 0
          end
        end
      end
      object TCVReportRowContainer
        Top = 100
        Width = 844
        Height = 48
        ContainerAlign = alcBottom
        ContainerType = rctGroupbyFooter
        ExplicitTop = 0
        ExplicitWidth = 185
      end
    end
  end
  object TCVReportRowContainer
    Left = 48
    Top = 484
    Width = 844
    Height = 48
    ContainerAlign = alcBottom
    ContainerType = rctPageFooter
    ExplicitLeft = 0
    ExplicitTop = 0
    ExplicitWidth = 185
  end
  object TCVReportRowContainer
    Left = 48
    Top = 436
    Width = 844
    Height = 48
    ContainerAlign = alcBottom
    ContainerType = rctReportFooter
    ExplicitLeft = 0
    ExplicitTop = 0
    ExplicitWidth = 185
  end
end');
begin 
    begin 
        select rpt_group_id into v_rpt_group_id 
        from   rptgroup 
        where  rpt_group_name = 'Administration & Security'; 
    exception 
        when no_data_found then 
          getnextkeys('rptgroup_rpt_group_id', 1, v_rpt_group_id); 

          insert into rptgroup (rpt_group_id, rpt_group_seq_num, 
                       rpt_group_name, parent_group_id) 
          select v_rpt_group_id,10000,'Administration & Security',40 from dual 
          where  not exists (select * from   rptgroup 
                             where  rpt_group_id = v_rpt_group_id 
                                    and rpt_group_seq_num = 10000 
                                    and rpt_group_name = 'Administration & Security'); 
    end; 

    getnextkeys('rpt_rpt_id', 1, v_rpt_id); 
    insert into rpt (rpt_id, global_flag, rpt_type, rpt_name, rpt_area, 
	                 rpt_group_id, rpt_state, rpt_data) 
    select v_rpt_id, 'N', 'RP_U_PM_Only', 'Offline Working Status', 
           'TRACKOFFLINEUSER', v_rpt_group_id, 'PS_Wiz', v_text from dual 
    where  not exists (select * from rpt where  rpt_type = 'RP_U_PM_Only' 
                              and rpt_area = 'TRACKOFFLINEUSER' 
                              and rpt_group_id = v_rpt_group_id 
                              and rpt_state = 'PS_Wiz'); 
    commit; 
exception 
    when others then 
      null; 
end; 
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE
  tab_exists integer;
BEGIN
  select count(*) into tab_exists from user_objects where object_name = upper('RSRCROLEASGNMENTSPREAD') and object_type = upper('TABLE');
  if tab_exists <> 0
  then
    execute immediate 'delete from RSRCROLEASGNMENTSPREAD where proj_id not in(select proj_id from project)';
  end if;
END;
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('RSRCROLEASGNMENTSPREAD') and constraint_name=upper('fk_rsrcrolespread_project') and delete_rule='NO ACTION';
  if constraint_exists = 1
  then
  delete from RSRCROLEASGNMENTSPREAD where PROJ_ID not in (select PROJ_ID from PROJECT);
    EXECUTE IMMEDIATE 'ALTER TABLE RSRCROLEASGNMENTSPREAD DROP CONSTRAINT fk_rsrcrolespread_project';
    EXECUTE IMMEDIATE 'ALTER TABLE RSRCROLEASGNMENTSPREAD
    ADD CONSTRAINT fk_rsrcrolespread_project FOREIGN KEY (proj_id)
    REFERENCES PROJECT (proj_id) ON DELETE CASCADE';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
v_no_data_found number;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'database.batchdml.publication','rsrcrole_role_delete','10000',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='database.batchdml.publication' and setting_name='rsrcrole_role_delete');
end;
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
v_no_data_found number;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'database.batchdml.publication','rsrcrole_rsrc_delete','10000',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='database.batchdml.publication' and setting_name='rsrcrole_rsrc_delete');
end;
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
v_no_data_found number;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'database.cleanoption.publication','rsrcrole_spread_delete','0',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='database.cleanoption.publication' and setting_name='rsrcrole_spread_delete');
end;
/
/ 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 185..187 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',21)
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',56)
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcatvalx_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatvalx_asgnmnt_catg_id',1)
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE
  trigger_exists integer;
BEGIN
  select count(*) into trigger_exists from user_triggers where table_name = upper('TIMESHT') and trigger_name=upper('TR_TIMESHT');
  if trigger_exists = 1
  then
    EXECUTE IMMEDIATE 'DROP TRIGGER TR_TIMESHT';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('CHGTASKACTV') and constraint_name=upper('fk_chgtaskactv_actvtype') and delete_rule='NO ACTION';
  if constraint_exists > 0
  then
  delete from CHGTASKACTV where actv_code_type_id not in (select actv_code_type_id from actvtype);
    EXECUTE IMMEDIATE 'ALTER TABLE CHGTASKACTV DROP CONSTRAINT fk_chgtaskactv_actvtype';
    EXECUTE IMMEDIATE 'ALTER TABLE CHGTASKACTV
    ADD CONSTRAINT fk_chgtaskactv_actvtype FOREIGN KEY (actv_code_type_id)
    REFERENCES ACTVTYPE (actv_code_type_id) ON DELETE CASCADE';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('TRACKOFFLINEUSER') and constraint_name=upper('fk_trackofflineuser_users') and delete_rule='NO ACTION';
  if constraint_exists > 0
  then
  delete from TRACKOFFLINEUSER where user_id not in (select user_id from USERS);
    EXECUTE IMMEDIATE 'ALTER TABLE TRACKOFFLINEUSER DROP CONSTRAINT fk_trackofflineuser_users';
    EXECUTE IMMEDIATE 'ALTER TABLE TRACKOFFLINEUSER
    ADD CONSTRAINT fk_trackofflineuser_users FOREIGN KEY (user_id)
    REFERENCES USERS (user_id) ON DELETE CASCADE';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
insert into nextkey select 'trackofflineuser_trackofflineuser_id',1 from dual 
where not exists (select * from nextkey where key_name=lower('trackofflineuser_trackofflineuser_id')) 
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
  constraint_exists integer;
  col_exists integer;
begin
  select count(*) into constraint_exists from user_constraints 
  where table_name = upper('TRACKOFFLINEUSER') and constraint_name=upper('pk_trackofflineuser');
  select count(*) into col_exists from user_tab_columns 
  where table_name = upper('TRACKOFFLINEUSER') and column_name=upper('trackofflineuser_id');
  if constraint_exists <> 0 then
  execute immediate 'alter table TRACKOFFLINEUSER drop CONSTRAINT PK_TRACKOFFLINEUSER';
  end if;
  if col_exists = 0 then
  execute immediate 'alter table TRACKOFFLINEUSER add trackofflineuser_id number(10)';
  end if;
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare
  constraint_exists integer;
  col_exists integer;
  vkey integer;
  cursor track_cur is select user_id, status,
  offline_date, hard_drive_code
  from trackofflineuser where trackofflineuser_id is null;
BEGIN
  select count(*) into constraint_exists from user_constraints 
  where table_name = upper('TRACKOFFLINEUSER') and constraint_name=upper('pk_trackofflineuser');
  select count(*) into col_exists from user_tab_columns 
  where table_name = upper('TRACKOFFLINEUSER') and column_name=upper('trackofflineuser_id');
  if constraint_exists = 0 and col_exists <> 0
  then
  for rec in track_cur loop
    getnextkeys ('trackofflineuser_trackofflineuser_id', 1, vkey); 
    update trackofflineuser set trackofflineuser_id = vkey
    where user_id = rec.user_id and offline_date = rec.offline_date
    and hard_drive_code = rec.hard_drive_code and status = rec.status;
  end loop;
  commit;
  execute immediate 'ALTER TABLE TRACKOFFLINEUSER
                     ADD CONSTRAINT pk_trackofflineuser PRIMARY KEY (trackofflineuser_id)
                     USING INDEX TABLESPACE PMDB_NDX1 PCTFREE 10
                     STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
  END;
/
 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_uk_trackofflineuser');
  IF index_exists = 0
  THEN
    EXECUTE IMMEDIATE 'CREATE UNIQUE INDEX ndx_uk_trackofflineuser
                       ON TRACKOFFLINEUSER (user_id,offline_date,hard_drive_code)
                       TABLESPACE PMDB_NDX1
                       PCTFREE 10
                       STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)';
  END IF;
END;
/
 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'database.cleanup.Trackofflineuser','KeepInterval','50d',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='database.cleanup.Trackofflineuser' 
 and setting_name='KeepInterval');
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','formattedassignmentexceloutput','0',v_nxt_key from dual
 where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='formattedassignmentexceloutput');
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
  if col_exists > 0
  then
    execute immediate 'ALTER TABLE PROJWBS drop column status_reviewer CASCADE CONSTRAINTS';
  end if;
END; 
/
/ 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION blob_to_clob (
    l_blob          BLOB,
    p_src_chr_set   VARCHAR2
) RETURN CLOB IS

    l_clob           CLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_clob, true);
    dbms_lob.converttoclob(dest_lob => l_clob, src_blob => l_blob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_clob;
END;
/

--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION clob_to_blob (
    l_clob          CLOB,
    p_src_chr_set   VARCHAR2
) RETURN BLOB IS

    l_blob           BLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_blob, true);
    dbms_lob.converttoblob(dest_lob => l_blob, src_clob => l_clob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_blob;
END;
/

--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
declare
v_chr_set VARCHAR2(64);
begin
SELECT value into v_chr_set FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET';
UPDATE admin_config
SET
    config_data = clob_to_blob(replace(blob_to_clob(config_data, v_chr_set), '>0</MinRepavingTime>', '>300000</MinRepavingTime>'),v_chr_set)
WHERE
    config_type = 'BRE';
end;
/

--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
DROP FUNCTION blob_to_clob
/

--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
DROP FUNCTION clob_to_blob
/

--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
begin
getnextkeys('settings_setting_id',1,v_nxt_key);
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','PrivateIPAllowList','144.25.17.232,144.25.19.182,144.25.19.58,144.25.16.116,144.25.17.50,144.25.18.65',v_nxt_key from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='PrivateIPAllowList');
end;
/



/ 
--END TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
/
/ 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 124 AND allow_flag='Y'
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 146 AND allow_flag='Y'
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 147 AND allow_flag='Y'
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_ind_columns WHERE index_name = UPPER('ndx_projwbs_1');
  IF index_exists = 0
  THEN
    EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
                       ON PROJWBS (proj_id, delete_session_id)
                       TABLESPACE PMDB_NDX1
                       PCTFREE 10
                       STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)';
  ELSE
	IF index_exists <> 2
	THEN
		EXECUTE IMMEDIATE 'DROP INDEX ndx_projwbs_1';
		EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
                       ON PROJWBS (proj_id, delete_session_id)
                       TABLESPACE PMDB_NDX1
                       PCTFREE 10
                       STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)';
	END IF;
  END IF;
END;
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_timesht_scode');
  IF index_exists = 0
  THEN
    EXECUTE IMMEDIATE 'CREATE INDEX ndx_timesht_scode
                       ON TIMESHT (status_code, delete_session_id)
                       TABLESPACE PMDB_NDX1
                       PCTFREE 10
                       STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)';
  END IF;
END;
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_act_req');
  IF index_exists = 0
  THEN
    EXECUTE IMMEDIATE 'CREATE INDEX ndx_act_req
                       ON RSRCHOUR (status_code, rsrc_id, ts_id, delete_session_id)
                       TABLESPACE PMDB_NDX1
                       PCTFREE 10
                       STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)';
  END IF;
END;
/

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
declare
 v_len NUMBER;
 v_import_point_web NUMBER;
 v_import_point_pro NUMBER;
 v_delete_point_web NUMBER;
 v_delete_point_pro NUMBER;
 v_delete_point NUMBER;
 v_extdep_point NUMBER;
 v_import_value blob;
 v_delete_value blob;
 v_start blob;
 v_end blob;
 v_final blob;
 cursor v is select view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
BEGIN
 for rec in v loop
 v_len := dbms_lob.getlength(rec.view_data);
 if(v_len is not null and v_len > 0) then
  v_extdep_point := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('P_EXTDEP') );
  if (v_extdep_point is null or v_extdep_point = 0) then
   v_import_point_web := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(import_option|') );
   v_delete_point_pro := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(delete_unref|') );

   if(v_import_point_web is not null and v_import_point_web > 0) then
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_import_point_web+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_import_point_web+49 ) );
	
	v_delete_point_web := v_import_point_web+44;
   
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_web+29) ;
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_web) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	
	elsif(v_delete_point_pro is not null and v_delete_point_pro > 0) then
	dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_delete_point_pro+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_delete_point_pro+49 ) );
	
    v_import_point_pro := v_delete_point_pro+44;
   
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_pro+28) ;
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_pro) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	end if;    
    commit;
  end if;
 end if;
end loop;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/

/ 
--END TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
select 1 from prefer
/
/ 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
begin
getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'CompletedActivitiesOnly','VT_TM_ACT_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'NotStartedActivitiesOnly','VT_TM_ACT_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'InProgressActivitiesOnly','VT_TM_ACT_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'CompletedActivitiesOnly','VT_TM_TS_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'NotStartedActivitiesOnly','VT_TM_TS_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'InProgressActivitiesOnly','VT_TM_TS_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);

end;
/
/ 
--END TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
declare
 v_len NUMBER;
 v_import_point_web NUMBER;
 v_import_point_pro NUMBER;
 v_delete_point_web NUMBER;
 v_delete_point_pro NUMBER;
 v_delete_point NUMBER;
 v_actveps_point NUMBER;
 v_import_value blob;
 v_delete_value blob;
 v_start blob;
 v_end blob;
 v_final blob;
 cursor v is select view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
BEGIN
 for rec in v loop
 v_len := dbms_lob.getlength(rec.view_data);
 if(v_len is not null and v_len > 0) then
  v_actveps_point := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('G_ACTVTYPEEPS') );
  if (v_actveps_point is null or v_actveps_point = 0) then
   v_import_point_web := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||G_ACTVTYPE(import_option|') );
   v_delete_point_pro := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||G_ACTVTYPE(delete_unref|') );

   if(v_import_point_web is not null and v_import_point_web > 0) then
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_import_point_web+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_import_point_web+49 ) );
	
	v_delete_point_web := v_import_point_web+44;
   
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_web+29) ;
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_web) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||G_ACTVTYPEEPS(import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())(0||G_OBS(import_option|K|delete_unref|N)())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	
	elsif(v_delete_point_pro is not null and v_delete_point_pro > 0) then
	dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_delete_point_pro+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_delete_point_pro+49 ) );
	
    v_import_point_pro := v_delete_point_pro+44;
   
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_pro+28) ;
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_pro) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||G_ACTVTYPEEPS(delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())(0||G_OBS(delete_unref|N|import_option|K)())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	end if;    
    commit;
  end if;
 end if;
end loop;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
DECLARE
    index_exists   INTEGER;
    pcount         INTEGER;
BEGIN
    SELECT
        COUNT(*)
    INTO index_exists
    FROM
        user_indexes
    WHERE
        table_name = upper('RSRCROLEASGNMENTSPREAD')
        AND index_name = upper('ndx_rsrcrlasgnmntsprd_rl_id');

    IF index_exists = 0 THEN
        SELECT
            COUNT(*)
        INTO pcount
        FROM
            user_tab_partitions
        WHERE
            table_name = 'RSRCROLEASGNMENTSPREAD';

        IF pcount = 0 THEN
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rl_id
            ON RSRCROLEASGNMENTSPREAD
(role_id,spread_start_date,spread_end_date)
            TABLESPACE PMDB_NDX1
            PCTFREE 10
            STORAGE (initial 50K next 50K minextents 1 maxextents unlimited
pctincrease 0)';
        ELSE
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rl_id
            ON RSRCROLEASGNMENTSPREAD
(role_id,spread_start_date,spread_end_date)
            TABLESPACE PMDB_NDX1
            PCTFREE 10
            STORAGE (initial 50K next 50K minextents 1 maxextents unlimited
pctincrease 0) LOCAL';
        END IF;
    END IF;
END;
/

--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
DECLARE
    index_exists   INTEGER;
    pcount         INTEGER;
BEGIN
    SELECT
        COUNT(*)
    INTO index_exists
    FROM
        user_indexes
    WHERE
        table_name = upper('RSRCROLEASGNMENTSPREAD')
        AND index_name = upper('ndx_rsrcrlasgnmntsprd_rsrc_id');

    IF index_exists = 0 THEN
        SELECT
            COUNT(*)
        INTO pcount
        FROM
            user_tab_partitions
        WHERE
            table_name = 'RSRCROLEASGNMENTSPREAD';

        IF pcount = 0 THEN
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rsrc_id
            ON RSRCROLEASGNMENTSPREAD
(rsrc_id,spread_start_date,spread_end_date)
            TABLESPACE PMDB_NDX1
            PCTFREE 10
            STORAGE (initial 50K next 50K minextents 1 maxextents unlimited
pctincrease 0)';
        ELSE
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_rsrcrlasgnmntsprd_rsrc_id
            ON RSRCROLEASGNMENTSPREAD
(rsrc_id,spread_start_date,spread_end_date)
            TABLESPACE PMDB_NDX1
            PCTFREE 10
            STORAGE (initial 50K next 50K minextents 1 maxextents unlimited
pctincrease 0) LOCAL';
        END IF;
    END IF;
END;
/


/ 
--END TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
ALTER SESSION ENABLE PARALLEL DML
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
CREATE TABLE RSRCOVERALLOC_BKP(
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  overalloc_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
begin
INSERT /*+append */ INTO RSRCOVERALLOC_BKP (rsrc_id, role_id, overalloc_date)
SELECT /*+parallel(16)*/ rsrc_id, role_id, overalloc_date FROM RSRCOVERALLOC 
WHERE (REGEXP_LIKE (rsrc_id,'^[[:digit:]]+$') or rsrc_id is NULL)
AND (REGEXP_LIKE (role_id,'^[[:digit:]]+$') or role_id is NULL);
commit;
end;
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
drop table RSRCOVERALLOC
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
alter table RSRCOVERALLOC_BKP rename to RSRCOVERALLOC
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('RSRCOVERALLOC') and index_name=upper('ndx_rsrcoveralloc_rsrc_id');
  if index_exists = 0
  then
    execute immediate 'CREATE INDEX ndx_rsrcoveralloc_rsrc_id
    ON RSRCOVERALLOC (rsrc_id)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('RSRCOVERALLOC') and index_name=upper('ndx_rsrcoveralloc_role_id');
  if index_exists = 0
  then
    execute immediate 'CREATE INDEX ndx_rsrcoveralloc_role_id
    ON RSRCOVERALLOC (role_id)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
ALTER SESSION DISABLE PARALLEL DML
/





/ 
--END TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
MERGE INTO calendar t
USING (
          SELECT
              r.clndr_id rsrc_clndr_id,
              nvl(r.base_clndr_id, d2.clndr_id) rsrc_base_clndr_id,
              nvl(b.clndr_data, d2.clndr_data) base_clndr_data
          FROM
              calendar   r
              LEFT OUTER JOIN calendar b
                              ON r.base_clndr_id = b.clndr_id
              JOIN (SELECT MIN(clndr_id) clndr_id
                    FROM calendar
                    WHERE default_flag = 'Y') d1 ON 1=1
              JOIN calendar d2 ON d1.clndr_id=d2.clndr_id
          WHERE
              r.clndr_type = 'CA_Rsrc'
              AND r.clndr_data IS NULL
      )
s ON ( t.clndr_id = s.rsrc_clndr_id )
WHEN MATCHED THEN UPDATE
SET t.clndr_data = s.base_clndr_data
/

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
UPDATE vwprefdata
SET
    view_pref_value = '/action/administrationstartpage'
WHERE
        view_pref_key = 'UIView.DefaultLandingPage'
    AND view_pref_value IN ( '/action/useradministration', '/action/adminpreferences', '/action/dictionaries',
                             '/action/home?globalscheduledservices',
                             '/action/managenavigationviews' )
/


--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
DECLARE
  index_exists integer;
  v_cnt number;
  v_exist_par_cnt number;
BEGIN
  select count(*) into index_exists from user_indexes where table_name = upper('PROJECT') and index_name=upper('ndx_project_project_flag');
  select count(*) into v_exist_par_cnt from user_tab_partitions where table_name='PROJECT';
  with v (
	column_name,
	column_position
	) AS (
		SELECT
			'PROJECT_FLAG',
			1
		FROM
			dual
		UNION ALL
		SELECT
			'ORIG_PROJ_ID',
			2
		FROM
			dual
		UNION ALL
		SELECT
			'DELETE_SESSION_ID',
			3
		FROM
			dual
		UNION ALL
		SELECT
			'PROJ_SHORT_NAME',
			4
		FROM
			dual
		UNION ALL
		SELECT
			'PROJ_ID',
			5
		FROM
			dual
		UNION ALL
		SELECT
			'FINTMPL_ID',
			6
		FROM
			dual
	)
	SELECT
		COUNT(*)
	INTO v_cnt
	FROM
        user_ind_columns t,
        v
    WHERE
        t.column_name = v.column_name
        AND t.column_position = v.column_position
        AND t.table_name = 'PROJECT';
  if index_exists = 0
  then
	if v_exist_par_cnt = 0
	then
		execute immediate 'CREATE INDEX ndx_project_project_flag
		ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
		TABLESPACE PMDB_NDX1
		PCTFREE 10
		STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
	else
		execute immediate 'CREATE INDEX ndx_project_project_flag
		ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
		TABLESPACE PMDB_NDX1
		PCTFREE 10
		STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';
	end if;
  else
	if v_cnt <> 6 THEN
		if index_exists = 1 THEN
			execute immediate('DROP INDEX ndx_project_project_flag');
		end if;
		if v_exist_par_cnt = 0
		then
			execute immediate 'CREATE INDEX ndx_project_project_flag
			ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
			TABLESPACE PMDB_NDX1
			PCTFREE 10
			STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
		else
			execute immediate 'CREATE INDEX ndx_project_project_flag
			ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
			TABLESPACE PMDB_NDX1
			PCTFREE 10
			STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';
		end if;
	end if;
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('PROJECT') and constraint_name=upper('CK_PROJ_RSRC_ROLE_MATCH_FLAG');
  if constraint_exists = 0
  then
    EXECUTE IMMEDIATE 'ALTER TABLE PROJECT
    ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))';
  end if;
END;         
/

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
MERGE INTO asgnmntacat t
USING (
          SELECT
              asgnmntacat.taskrsrc_id,
              asgnmntacat.asgnmnt_catg_type_id,
              asgnmntacat.asgnmnt_catg_id,
              taskrsrc.proj_id taskrsrc_proj_id
          FROM
              asgnmntacat,
              taskrsrc
          WHERE
                  asgnmntacat.taskrsrc_id = taskrsrc.taskrsrc_id
              AND asgnmntacat.proj_id != taskrsrc.proj_id
              AND asgnmntacat.delete_session_id IS NULL
   )
s ON ( t.taskrsrc_id = s.taskrsrc_id
       AND t.asgnmnt_catg_type_id = s.asgnmnt_catg_type_id
       AND t.asgnmnt_catg_id = s.asgnmnt_catg_id )
WHEN MATCHED THEN UPDATE
SET t.proj_id = s.taskrsrc_proj_id
/
/ 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
select 1 from prefer
/
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
DECLARE
 v_blob_col_val BLOB;
 v_rowid_val ROWID;
 v_len NUMBER;
 v_start_point NUMBER;
 v_final BLOB;
 v_loc_point NUMBER;
 v_loc_point1 NUMBER;
 v_clobber_point NUMBER;
 v_schedoption_start number;
BEGIN
 SELECT rowid,view_data INTO v_rowid_val, v_blob_col_val
 FROM viewprop
 WHERE view_name = 'Default Import Template' and VIEW_TYPE='VP_XML_IMP_DET_OPT';
 v_len := dbms_lob.getlength(v_blob_col_val);
if(v_len IS NOT NULL AND v_len > 0) THEN
 v_clobber_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('ClobberOptions') );
 IF
  ( v_clobber_point IS NOT NULL AND v_clobber_point > 0 )
 THEN
  v_loc_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_PROJISSU') );
  IF
   ( v_loc_point IS NOT NULL AND v_loc_point >0 )
  THEN
   v_start_point := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_PROJISSU') ) + 54;
   v_schedoption_start := dbms_lob.instr(v_blob_col_val, utl_raw.cast_to_raw('P_SCHEDOPTIONS') );
   IF
    ( v_start_point > 0 AND v_schedoption_start > 0 AND (v_start_point=v_schedoption_start OR v_len=v_schedoption_start+49))
   THEN
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.append(v_final, dbms_lob.substr(v_blob_col_val, (v_schedoption_start - 5), 1) );
    dbms_lob.append(v_final, dbms_lob.substr(v_blob_col_val, v_len, (v_schedoption_start + 49) ) );
    EXECUTE IMMEDIATE 'UPDATE VIEWPROP SET view_data = :1 where rowid= :2'
    USING v_final, v_rowid_val;
    COMMIT;
   END IF;
  END IF;
 END IF;
 END IF;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
END;
/
/ 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
merge into profpriv pp
    using (select prof_id ,'124' as priv_num,'Y' as allow_flag from profile where scope_type='ST_Project' and prof_id=51) p
    on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = 'Y'
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num,'Y')
/

--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
declare 
v_nxt_key nextkey.key_seq_num%type;
begin
getnextkeys('viewpref_view_pref_id',1,v_nxt_key); 
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select v_nxt_key,'ActivityOwner','VT_TM_ACT_STAND' from dual
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='ActivityOwner' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select v_nxt_key,'VT_FILTER.ShowInToolbar','false' from dual
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=v_nxt_key);
end;
/
/ 
--END TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES
MERGE INTO vwprefdata t
USING (
         SELECT
              d.view_pref_id,
              d.view_pref_key,
              regexp_replace(regexp_replace(regexp_replace(d.view_pref_value,
                                                           'UPPER\((ActivityCodeTypeId_[0-9]+)\)(\=)UPPER\(([0-9]+)\)',
                                                           '\1\2\3'),
                                            'UPPER\((ResourceCodeTypeId_[0-9]+)\)(\=)UPPER\(([0-9]+)\)',
                                            '\1\2\3'),
                             'UPPER\((ProjectCodeId_[0-9]+)\)(\=)UPPER\(([0-9]+)\)',
                             '\1\2\3') view_pref_value
          FROM
              vwprefdata d
          WHERE
                  d.view_pref_key = 'VT_FILTER.FilterCriteria'
              AND ( d.view_pref_value LIKE '%UPPER(ActivityCodeTypeId%'
                    OR d.view_pref_value LIKE '%UPPER(ResourceCodeTypeId%'
                    OR d.view_pref_value LIKE '%UPPER(ProjectCodeId%' )
      )
s ON ( t.view_pref_id = s.view_pref_id
       AND t.view_pref_key = s.view_pref_key )
WHEN MATCHED THEN UPDATE
SET t.view_pref_value = s.view_pref_value
/ 

--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES
DECLARE
    CURSOR uiv_cur IS
      SELECT view_pref_id,
             view_pref_type
      FROM   viewpref
      WHERE  view_pref_type = 'VT_UIVIEW';
BEGIN
    FOR v_cur IN uiv_cur LOOP
        UPDATE vwprefdata
        SET    view_pref_value = 'Y'
        WHERE  view_pref_key = 'UIView.HighLevelPlanning'
               AND view_pref_id = v_cur.view_pref_id
               AND EXISTS (SELECT 1
                           FROM   vwprefdata
                           WHERE  view_pref_key = 'UIView.DetailedPlanning'
                                  AND upper(view_pref_value) in ('TRUE','Y')
                                  AND view_pref_id = v_cur.view_pref_id);
    END LOOP;
EXCEPTION
    WHEN OTHERS THEN
      NULL;
END; 
/
/ 
--END TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
DECLARE
    index_exists    INTEGER;
    v_cnt           NUMBER;
    v_exist_par_cnt NUMBER;
    v_index_par_cnt NUMBER;
BEGIN
    SELECT
        COUNT(*)
    INTO index_exists
    FROM
        user_indexes
    WHERE
            table_name = upper('PROJWBS')
        AND index_name = upper('ndx_projwbs_1');

    SELECT
        COUNT(*)
    INTO v_exist_par_cnt
    FROM
        user_tab_partitions
    WHERE
        table_name = 'PROJWBS';

    WITH v (
        column_name,
        column_position
    ) AS (
        SELECT
            'PROJ_ID',
            1
        FROM
            dual
        UNION ALL
        SELECT
            'DELETE_SESSION_ID',
            2
        FROM
            dual
    )
    SELECT
        COUNT(*)
    INTO v_cnt
    FROM
        user_ind_columns t,
        v
    WHERE
            t.column_name = v.column_name
        AND t.column_position = v.column_position
        AND t.table_name = 'PROJWBS'
        AND t.index_name = 'NDX_PROJWBS_1';

    IF index_exists = 0 THEN
        IF v_exist_par_cnt = 0 THEN
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
		ON PROJWBS (PROJ_ID,DELETE_SESSION_ID)
		TABLESPACE PMDB_NDX1
		PCTFREE 10
		STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
        ELSE
            EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
		ON PROJWBS (PROJ_ID,DELETE_SESSION_ID)
		TABLESPACE PMDB_NDX1
		PCTFREE 10
		STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';
        END IF;
    ELSE
        IF v_cnt <> 2 THEN
            IF index_exists = 1 THEN
                EXECUTE IMMEDIATE ( 'DROP INDEX ndx_projwbs_1' );
            END IF;
            IF v_exist_par_cnt = 0 THEN
                EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
			ON PROJWBS (PROJ_ID,DELETE_SESSION_ID)
			TABLESPACE PMDB_NDX1
			PCTFREE 10
			STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';
            ELSE
                EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
			ON PROJWBS (PROJ_ID,DELETE_SESSION_ID)
			TABLESPACE PMDB_NDX1
			PCTFREE 10
			STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';
            END IF;
        ELSE
            SELECT
                COUNT(*)
            INTO v_index_par_cnt
            FROM
                user_ind_partitions
            WHERE
                index_name = 'NDX_PROJWBS_1';

            IF v_index_par_cnt = 0 THEN
                IF v_exist_par_cnt <> 0 THEN
                    EXECUTE IMMEDIATE ( 'DROP INDEX ndx_projwbs_1' );
                    EXECUTE IMMEDIATE 'CREATE INDEX ndx_projwbs_1
				ON PROJWBS (PROJ_ID,DELETE_SESSION_ID)
				TABLESPACE PMDB_NDX1
				PCTFREE 10
				STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';
                END IF;

            END IF;

        END IF;
    END IF;

END;
/
/ 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES
DECLARE
  v_exist_par_cnt NUMBER;
  v_index_exists INTEGER;
  v_cnt NUMBER;
  v_index_par_cnt NUMBER;
  v_index_sql VARCHAR2(500);
  v_index_sql_par VARCHAR2(500);
  v_index_drop_sql VARCHAR2(140);
  v_custom_idx_name VARCHAR2(128);
  columns_indexed EXCEPTION;
  PRAGMA exception_init ( columns_indexed, -1408 );

BEGIN
  v_index_sql := 'CREATE INDEX NDX_PROJWBS_STATUS_CODE '
                  ||'ON PROJWBS (proj_id,status_code,delete_session_id) '
                  ||'TABLESPACE PMDB_NDX1 '
                  ||'PCTFREE 10 '
                  ||'STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';

  v_index_sql_par := 'CREATE INDEX NDX_PROJWBS_STATUS_CODE '
                  ||'ON PROJWBS (proj_id,status_code,delete_session_id) '
                  ||'TABLESPACE PMDB_NDX1 '
                  ||'PCTFREE 10 '
                  ||'STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0) LOCAL';

  v_index_drop_sql := 'DROP INDEX NDX_PROJWBS_STATUS_CODE';

  SELECT COUNT(*) INTO v_exist_par_cnt
  FROM user_tab_partitions
  WHERE table_name = 'PROJWBS';

  SELECT count(*) INTO v_index_exists
  FROM user_indexes
  WHERE table_name = 'PROJWBS'
    AND index_name = 'NDX_PROJWBS_STATUS_CODE';

  IF v_index_exists = 0 THEN

   BEGIN
    IF v_exist_par_cnt = 0 THEN
      EXECUTE IMMEDIATE v_index_sql;
    ELSE
      EXECUTE IMMEDIATE v_index_sql_par;
    END IF;
   EXCEPTION
    WHEN columns_indexed THEN 
    WITH v (column_name,column_position) AS (
    SELECT 'PROJ_ID', 1 FROM DUAL 
    UNION ALL 
    SELECT 'STATUS_CODE', 2 FROM DUAL 
    UNION ALL 
    SELECT 'DELETE_SESSION_ID', 3 FROM DUAL 
          )
    SELECT index_name into v_custom_idx_name
    FROM user_ind_columns t, v
    WHERE t.column_name = v.column_name
    AND t.column_position = v.column_position
    AND t.table_name = 'PROJWBS'
    GROUP BY index_name 
    HAVING COUNT(*) = 3;

    EXECUTE IMMEDIATE 'DROP INDEX ' || v_custom_idx_name;
    IF v_exist_par_cnt = 0 THEN
      EXECUTE IMMEDIATE v_index_sql;
    ELSE
      EXECUTE IMMEDIATE v_index_sql_par;
    END IF;
   END;

  ELSE
    WITH v (column_name,column_position) AS (
    SELECT 'PROJ_ID', 1 FROM DUAL 
    UNION ALL 
    SELECT 'STATUS_CODE', 2 FROM DUAL 
    UNION ALL 
    SELECT 'DELETE_SESSION_ID', 3 FROM DUAL 
    )
    SELECT COUNT(*) INTO v_cnt
    FROM user_ind_columns t, v
    WHERE t.column_name = v.column_name
        AND t.column_position = v.column_position
        AND t.table_name = 'PROJWBS'
        AND t.index_name = 'NDX_PROJWBS_STATUS_CODE';

    IF v_cnt != 3 THEN
      IF v_index_exists = 1 THEN
          EXECUTE IMMEDIATE v_index_drop_sql;
      END IF;
      IF v_exist_par_cnt = 0 THEN
        EXECUTE IMMEDIATE v_index_sql;
      ELSE
        EXECUTE IMMEDIATE v_index_sql_par;
      END IF;
    ELSE
      SELECT COUNT(*) INTO v_index_par_cnt
      FROM user_ind_partitions
      WHERE index_name = 'NDX_PROJWBS_STATUS_CODE';

      IF v_index_par_cnt = 0 THEN
        IF v_exist_par_cnt != 0 THEN
            EXECUTE IMMEDIATE v_index_drop_sql;
            EXECUTE IMMEDIATE v_index_sql_par;
        END IF;
      END IF;
    END IF;
  END IF;
END;
/

/ 
--END TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
UPDATE project SET last_recalc_date = plan_start_date
WHERE project_flag = 'Y' AND plan_start_date IS NOT NULL AND last_recalc_date < plan_start_date
/

--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chghead set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtask set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtrsrc set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtaskactv set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtaskproc set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgudfvalue set delete_session_id = 0, delete_date = sysdate where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
BEGIN
    EXECUTE IMMEDIATE 'UPDATE findates t SET end_date = trunc(end_date) WHERE
EXISTS (SELECT 1 FROM findates s WHERE t.fin_dates_id = s.fin_dates_id AND
to_char(s.end_date, ''HH24:MI:SS'') != ''00:00:00'')';
    COMMIT;
EXCEPTION
    WHEN OTHERS THEN
        NULL;
END;
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
/

/ 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION blob_to_clob (
    l_blob          BLOB,
    p_src_chr_set   VARCHAR2
) RETURN CLOB IS

    l_clob           CLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_clob, true);
    dbms_lob.converttoclob(dest_lob => l_clob, src_blob => l_blob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_clob;
END;
/

--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION clob_to_blob (
    l_clob          CLOB,
    p_src_chr_set   VARCHAR2
) RETURN BLOB IS

    l_blob           BLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_blob, true);
    dbms_lob.converttoblob(dest_lob => l_blob, src_clob => l_clob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_blob;
END;
/

--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
declare
v_chr_set VARCHAR2(64);
begin
SELECT value into v_chr_set FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET';
UPDATE admin_config
SET
    config_data = clob_to_blob(replace(blob_to_clob(config_data, v_chr_set), '</MaxConnections>
<FetchSize min="0" type="java.lang.Integer" max="2147483647" desc="SET_CONNECTION_POOL_FETCHSIZE">120</FetchSize>', '</MaxConnections>
<FetchSize min="0" type="java.lang.Integer" max="2147483647" desc="SET_CONNECTION_POOL_FETCHSIZE">8192</FetchSize>'),v_chr_set)
WHERE
    config_type = 'BRE';
end;
/

--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
DROP FUNCTION blob_to_clob
/

--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
DROP FUNCTION clob_to_blob
/

--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
DECLARE
    tbl_exists INTEGER;
    tbl_name   VARCHAR2(30);
BEGIN
    SELECT
        COUNT(*)
    INTO tbl_exists
    FROM
        user_tables
    WHERE
        table_name = upper('project_bkp');

    IF tbl_exists = 0 THEN
        tbl_name := 'project_bkp';
    ELSE
        tbl_name := 'project_bkp_' || to_char(sysdate, 'yyyymmddhh24miss');
    END IF;

    EXECUTE IMMEDIATE 'CREATE TABLE '
                      || tbl_name
                      || '(proj_id,px_priority) AS SELECT proj_id,px_priority FROM project';

    UPDATE project
    SET
        px_priority = NULL;

    EXECUTE IMMEDIATE 'ALTER TABLE project MODIFY px_priority number(3,0) DEFAULT 50';
    EXECUTE IMMEDIATE 'UPDATE PROJECT p'
                      || ' SET p.px_priority = (SELECT i.px_priority FROM '
                      || tbl_name
                      || ' i WHERE i.proj_id = p.proj_id)'
                      || ' WHERE EXISTS (SELECT 1 FROM '
                      || tbl_name
                      || ' o WHERE o.proj_id = p.proj_id)';

    EXECUTE IMMEDIATE 'DROP TABLE ' || tbl_name;
END;
/
/ 
--END TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 

getnextkeys('settings_setting_id', 1, v_setting_id);
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='P6OGLAppId')
when matched then
update set setting_value='VJeWIBIxQUW3FTuzAIEMFg'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','P6OGLAppId','VJeWIBIxQUW3FTuzAIEMFg',v_setting_id);

getnextkeys('settings_setting_id', 1, v_setting_id);
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='TMOGLAppId')
when matched then
update set setting_value='lJT0GTABRvKnAZ5Dt8Ynqw'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','TMOGLAppId','lJT0GTABRvKnAZ5Dt8Ynqw',v_setting_id);

getnextkeys('settings_setting_id', 1, v_setting_id);
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='EnableOGLContent')
when matched then
update set setting_value='false'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','EnableOGLContent','false',v_setting_id);

end;
/


--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION blob_to_clob (
    l_blob          BLOB,
    p_src_chr_set   VARCHAR2
) RETURN CLOB IS

    l_clob           CLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_clob, true);
    dbms_lob.converttoclob(dest_lob => l_clob, src_blob => l_blob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_clob;
END;
/

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
CREATE OR REPLACE FUNCTION clob_to_blob (
    l_clob          CLOB,
    p_src_chr_set   VARCHAR2
) RETURN BLOB IS

    l_blob           BLOB;
    l_dest_offset    NUMBER := 1;
    l_src_offset     NUMBER := 1;
    l_lang_context   NUMBER := dbms_lob.default_lang_ctx;
    l_warning        NUMBER;
BEGIN
    dbms_lob.createtemporary(l_blob, true);
    dbms_lob.converttoblob(dest_lob => l_blob, src_clob => l_clob, amount => dbms_lob.lobmaxsize, dest_offset => l_dest_offset, src_offset
    => l_src_offset,
                           blob_csid => nls_charset_id(p_src_chr_set), lang_context => l_lang_context, warning => l_warning);

    RETURN l_blob;
END;
/

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
declare
v_chr_set VARCHAR2(64);
begin
SELECT value into v_chr_set FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET';
UPDATE admin_config
SET
    config_data = clob_to_blob(replace(blob_to_clob(config_data, v_chr_set), '>120</FetchSize>', '>8192</FetchSize>'),v_chr_set)
WHERE
    config_type = 'BRE';
end;
/

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
DROP FUNCTION blob_to_clob
/

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
DROP FUNCTION clob_to_blob
/

/ 
--END TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES
DELETE FROM jobsvc a
      WHERE
        a.job_type = 'JT_RsrcRoleSpread'
        AND a.status_code = 'JS_Pending'
        AND a.rowid > ANY (
          SELECT
            b.rowid
          FROM
            jobsvc b
          WHERE
           a.job_type = b.job_type
            AND a.status_code = b.status_code
            AND a.job_type_key = b.job_type_key
        )
/
/ 
--END TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
declare
v_tbs varchar2(40);
begin
select tablespace_name into v_tbs from user_ts_quotas where tablespace_name like '%NDX%' and rownum =1;

execute immediate 'ALTER TABLE TASKUSER DROP CONSTRAINT PK_TASKUSER' ;

execute immediate 'ALTER TABLE TASKUSER ADD CONSTRAINT PK_TASKUSER PRIMARY KEY (task_id) USING INDEX TABLESPACE '||v_tbs ;

exception when others then
null;
end;
/

--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
DECLARE
v_num number;
BEGIN
getnextkeys('settings_setting_id', 1, v_num);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','EnablePublicationOnBaselineCreation','N',v_num from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='EnablePublicationOnBaselineCreation');
END;
/ 
/ 
--END TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2302to2303 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2302to2303 NAME:MISC_UPDATES
declare
v_trg_exists number(1);
begin
select count(*) into v_trg_exists from user_triggers
where trigger_name = 'RT_USROPNVAL_INS';
if v_trg_exists > 0 then
    execute immediate 'drop trigger rt_usropnval_ins';
end if;
exception
    when others then
        null;
end;
/

--METADATA TYPE:UP2 GROUP:2302to2303 NAME:MISC_UPDATES
declare
v_trg_exists number(1);
begin
select count(*) into v_trg_exists from user_triggers
where trigger_name = 'RT_USROPNVAL_UPD';
if v_trg_exists > 0 then
    execute immediate 'drop trigger rt_usropnval_upd';
end if;
exception
    when others then
        null;
end;
/

--METADATA TYPE:UP2 GROUP:2302to2303 NAME:MISC_UPDATES
declare
v_prc_exists number(1);
begin
select count(*) into v_prc_exists from user_objects
where object_type = 'PROCEDURE' and object_name = 'PV_INSERT_USROPNVAL';
if v_prc_exists > 0 then
    execute immediate 'drop procedure pv_insert_usropnval';
end if;
exception
    when others then
        null;
end;
/
/ 
--END TYPE:UP2 GROUP:2302to2303 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2304to2305 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2304to2305 NAME:MISC_UPDATES
declare
v_trg_exists number(1);
begin
select count(*) into v_trg_exists from user_triggers
where trigger_name = 'RT_USROPNVAL';
if v_trg_exists > 0 then
    execute immediate 'drop trigger rt_usropnval';
end if;
exception
    when others then
        null;
end;
/

/ 
--END TYPE:UP2 GROUP:2304to2305 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2309to2310 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2309to2310 NAME:MISC_UPDATES
declare 
    v_setting_id settings.setting_id%type;
    v_no_data_found number;
begin
    select count(*) into v_no_data_found from nextkey
    where key_name='settings_setting_id';
    
    if  v_no_data_found = 0 then
        insert into nextkey select 'settings_setting_id',1 from dual 
            where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
        commit;
    end if; 

    getnextkeys('settings_setting_id', 1, v_setting_id);

    merge into settings ss using dual
        on ( namespace='Administrator_Settings' 
         and setting_name='CopyEPSProjectPreferencesForAddProject')
    when matched then
        update set setting_value='Y'
    when not matched then
        insert (namespace,setting_name,setting_value,setting_id)
        values('Administrator_Settings','CopyEPSProjectPreferencesForAddProject','Y',v_setting_id);

end;
/

/ 
--END TYPE:UP2 GROUP:2309to2310 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
/

/ 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74773_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2402to2404 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2402to2404 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88966_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:2402to2404 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2404to2405 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2401to2402 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:2404to2405 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2406to2407 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2406to2407 NAME:MISC_UPDATES
DECLARE
v_num number;
BEGIN
getnextkeys('settings_setting_id', 1, v_num);
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','TeamMemberDisplayP6Mobile','Y',v_num from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='TeamMemberDisplayP6Mobile');
END;
/ 
/ 
--END TYPE:UP2 GROUP:2406to2407 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/G18296_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2412to2501 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:2412to241201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:241201to241202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F88968_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:241202to241203 NAME:MISC_UPDATES
--EPPM Version update Scripts
--METADATA TYPE:VERSION_UPDATE DBTYPE:PMDB FROM:2412.0005.0000.0000 TO:2412.0005.0000.0000	  
declare
trigger_enabled number;
begin
select count(*) into trigger_enabled  from user_triggers where trigger_name='RT_PREFER' and status = 'ENABLED';
if trigger_enabled >= 1 then
execute immediate 'alter trigger RT_PREFER disable';
end if;
select count(*) into trigger_enabled  from dba_triggers where trigger_name='PRMAUD_PREFER' and status = 'ENABLED';
if trigger_enabled >= 1 then
execute immediate 'alter trigger PRMAUD_PREFER disable';
end if;	  
update prefer set database_version='PMDB,2412.0005.0000.0000' ;
execute immediate 'alter trigger RT_PREFER enable';
execute immediate 'alter trigger PRMAUD_PREFER enable';
end;
/
commit
/
--METADATA NAME:orpm_dbcrudseq TYPE:EXEC
declare 
vcnt pls_integer:=0;
begin 
select count(1) into vcnt from user_sequences where sequence_name='PC_PROCESS_STAT_SEQ';
if vcnt=0 then 
   execute immediate 'create sequence pc_process_stat_seq  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1';
   execute immediate 'grant select on pc_process_stat_seq  to PRIVUSER';
end if;
end;
/
--METADATA NAME:SECPAC TYPE:PACKAGE SET:SECPAC CHANGE:CREATE
CREATE OR REPLACE PACKAGE secpac
as
  procedure set_user(pusername IN varchar2);
  function set_bip_user(pusername IN varchar2) return boolean;  
  procedure set_logon_context;
  
  function get_security_id return number;
END;
/
show err

--METADATA NAME:SECPAC TYPE:PACKAGE_BODY SET:SECPAC CHANGE:CREATE
CREATE OR REPLACE PACKAGE BODY secpac
as
  VREPORT_CONTEXT_NAME varchar2(40) := 'P6_RPT_ADMUSER';
  procedure set_p6_rpt_context 
  (puser_id IN number, psec_id IN number, pprof_id IN number, puser_name IN varchar2)
  as
  begin
    dbms_session.set_context(VREPORT_CONTEXT_NAME, 'user_id', puser_id);
    dbms_session.set_context(VREPORT_CONTEXT_NAME, 'sec_id', psec_id);
    dbms_session.set_context(VREPORT_CONTEXT_NAME, 'prof_id', pprof_id);
    dbms_session.set_context(VREPORT_CONTEXT_NAME, 'user_name', puser_name);
 
  end;
  
  procedure set_user(pusername IN varchar2)
  as
    vuser_id users.user_id%type;
    vuser_name users.user_name%type;
    vprof_id users.prof_id%type;
    vsec_id pls_integer;
  begin
    begin
      select user_id, prof_id,user_name
      into vuser_id,vprof_id,vuser_name
      from users
      where lower(user_name) = lower(pusername);
      
      if vprof_id = 12 then
        vsec_id := 0;
      else 
        vsec_id := vuser_id;
      end if;
    exception
      when no_data_found then
        vuser_id:=-1;
    end;
    set_p6_rpt_context(vuser_id,vsec_id,vprof_id,vuser_name);
  end;

  function set_bip_user(pusername IN varchar2) return boolean
  as
  begin
    set_user(pusername);
    return true;
  end;

  procedure set_logon_context
  as
    vdb_user varchar2(255);
  begin
    vdb_user := sys_context('userenv', 'session_user');
    
    --NOTE: This may look odd, but these values are replace if using not default user
    if vdb_user in (upper('PXRPTUSER'),upper('ADMUSER'),'SYS','SYSTEM') then
      set_p6_rpt_context(0,0,12,vdb_user);
    else
      set_user(vdb_user);
    end if;
  end;

  function get_security_id return number
  as
  begin
    return sys_context(VREPORT_CONTEXT_NAME,'sec_id');
  end;

END;
/
show err

--METADATA NAME:SECPAC TYPE:GRANT TABLE_NAME:SECPAC CHANGE:CREATE
GRANT EXECUTE ON SECPAC TO PRIVUSER
/
--METADATA NAME:SECPAC TYPE:GRANT TABLE_NAME:SECPAC CHANGE:CREATE
GRANT EXECUTE ON SECPAC TO PXRPTUSER
/

--METADATA NAME:P6_RPT TYPE:CONTEXT SET:CONTEXT CHANGE:CREATE
CREATE OR REPLACE CONTEXT P6_RPT_ADMUSER 
USING secpac
/
--METADATA NAME:orpm_ctxindex TYPE:EXEC
declare
vcnt pls_integer:=0;
begin
select count(1) into vcnt from CTX_USER_PREFERENCES where pre_name='GLOBAL_LEXER';
if vcnt=0 then
        ctx_ddl.create_preference('global_lexer', 'WORLD_LEXER');
end if;
end;
/

--METADATA NAME:orpm_ctxindex TYPE:EXEC
declare
vcnt pls_integer:=0;
begin
select count(1) into vcnt from CTX_USER_PREFERENCES where pre_name='MYWORDLIST';
if vcnt=0 then
        ctx_ddl.create_preference('mywordlist', 'BASIC_WORDLIST');
end if;
end;
/

--METADATA NAME:orpm_ctxindex TYPE:EXEC
declare
vcnt pls_integer:=0;
begin
select count(1) into vcnt from CTX_USER_PREFERENCE_VALUES where prv_preference='MYWORDLIST' and prv_attribute='PREFIX_INDEX';
if vcnt=0 then
        ctx_ddl.set_attribute('mywordlist','PREFIX_INDEX','TRUE');
end if;
end;
/

--METADATA NAME:orpm_ctxindex TYPE:EXEC
declare
vcnt pls_integer:=0;
begin
select count(1) into vcnt from CTX_USER_PREFERENCE_VALUES where prv_preference='MYWORDLIST' and prv_attribute='SUBSTRING_INDEX';
if vcnt=0 then
        ctx_ddl.set_attribute('mywordlist','SUBSTRING_INDEX', 'FALSE');
end if;
end;
/

--METADATA NAME:orpm_ctxindex TYPE:EXEC
declare 
vcnt pls_integer:=0;
begin 
select count(1) into vcnt from user_indexes where index_name='DOCVER_DOCDATA_QSI';
if vcnt=0 then 
   execute immediate 'CREATE INDEX DOCVER_DOCDATA_QSI on DOC_VERSION(doc_data)INDEXTYPE IS CTXSYS.CONTEXT parameters(''lexer global_lexer wordlist mywordlist sync (on commit)'')';
end if;
end;
/
--METADATA NAME:P6_RPT_CONTEXT TYPE:TRIGGER SET:LOGON_TRIGGER CHANGE:CREATE
--CREATE OR REPLACE TRIGGER ADMUSER.P6_RPT_CONTEXT
--AFTER LOGON
--ON DATABASE
--BEGIN
  --ADMUSER.SECPAC.SET_LOGON_CONTEXT;
--END;
--/
--METADATA NAME:P6_RESETRUNNINGJOBS TYPE:TRIGGER SET:LOGON_TRIGGER CHANGE:CREATE
CREATE OR REPLACE TRIGGER ADMUSER.P6_RESETRUNNINGJOBS 
AFTER STARTUP ON DATABASE
BEGIN
	UPDATE ADMUSER.JOBSVC SET STATUS_CODE = 'JS_Pending' WHERE STATUS_CODE = 'JS_Running';
END;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Table_Settings','udfvalue_denorm','N',v_setting_id);
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','OnlineHelpRootUrl','https://docs.oracle.com/cd/F88968_01/client_help/',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='OnlineHelpRootUrl');
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id) 
 select 'Administrator_Settings','AlwaysLaunchOnlineHelp','Y',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp');
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id) 
 select 'Administrator_Settings','DisallowedDocumentTypes','.exe,.com,.bat,.cmd,.vbs,.js,.msi',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='DisallowedDocumentTypes');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','IsOfflineModeSupported','N',v_setting_id from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='IsOfflineModeSupported');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','MaxRoleCodeTreeLevelCnt','20',v_setting_id from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxRoleCodeTreeLevelCnt');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt','20',v_setting_id from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='MaxAssignmentCodeTreeLevelCnt');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'database.cleanup.Trackofflineuser','KeepInterval','50d',v_setting_id from dual
where not exists (select 1 from settings where namespace='database.cleanup.Trackofflineuser' and setting_name='KeepInterval');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','formattedassignmentexceloutput','0',v_setting_id from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='formattedassignmentexceloutput');
select key_seq_num into v_setting_id from nextkey
where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
where key_name ='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','PrivateIPAllowList','144.25.17.232,144.25.19.182,144.25.19.58,144.25.16.116,144.25.17.50,144.25.18.65',v_setting_id from dual
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='PrivateIPAllowList');
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','EnablePublicationOnBaselineCreation','N',v_setting_id from dual
  where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='EnablePublicationOnBaselineCreation');
commit;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select count(*) into v_cnt from settings
   where namespace='database.audit';
if  v_cnt = 0  then
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.audit','Enabled','false',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select count(*) into v_cnt from settings
   where namespace='PxService.Project.Arbiter';
if  v_cnt = 0  then
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.Project.Arbiter','PublishRsrcRoleSpread','N',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_cnt from settings
   where namespace='PxService.TimeDistribution';
if  v_cnt = 0  then
select max(setting_id) into v_setting_id from settings;
v_setting_id:=v_setting_id+1;
update nextkey set key_seq_num = v_setting_id + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.TimeDistribution','Interval','SBT_WEEK',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
v_cnt number;
begin
select count(*) into v_cnt from settings
   where namespace='database.proc';
if  v_cnt = 0  then
select max(setting_id) into v_setting_id from settings;
v_setting_id:=v_setting_id+1;
update nextkey set key_seq_num = v_setting_id + 1
  where key_name='settings_setting_id';
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
  commit; 
end if;  
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='IsAppletFree')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','IsAppletFree','Y',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='database.batchdml.publication' and setting_name='rsrcrole_role_delete')
when matched then
update set setting_value='10000'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('database.batchdml.publication','rsrcrole_role_delete','10000',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='database.batchdml.publication' and setting_name='rsrcrole_rsrc_delete')
when matched then
update set setting_value='10000'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('database.batchdml.publication','rsrcrole_rsrc_delete','10000',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='database.cleanoption.publication' and setting_name='rsrcrole_spread_delete')
when matched then
update set setting_value='0'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('database.cleanoption.publication','rsrcrole_spread_delete','0',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJECT';
select count(1) into v_disabled from user_tables where table_name='PROJECT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table project enable row movement';
end if;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PAUDIT';
select count(1) into v_disabled from user_tables where table_name='PAUDIT' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table paudit enable row movement';
end if;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='REFRDEL';
select count(1) into v_disabled from user_tables where table_name='REFRDEL' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table refrdel enable row movement';
end if;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='PROJWBS';
select count(1) into v_disabled from user_tables where table_name='PROJWBS' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table projwbs enable row movement';
end if;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare
v_exist_cnt number := 0;
v_disabled number := 0;
begin
select count(1) into v_exist_cnt from user_tab_partitions where table_name='UDFVALUE';
select count(1) into v_disabled from user_tables where table_name='UDFVALUE' and row_movement ='DISABLED';
if (v_exist_cnt > 0) and  (v_disabled > 0) then
execute immediate 'alter table udfvalue enable row movement';
end if;
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')) 
/

--METADATA NAME:orpm_settings_safetydate TYPE:INSERT
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VSAFETY_REFRESH_DATE' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VSAFETY_REFRESH_DATE')
/

--METADATA TYPE:orpm_settings_safetydate NAME:INSERT
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VLAST_SETTINGS_READTIME' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VLAST_SETTINGS_READTIME')
/

--METADATA TYPE:orpm_settings_safetydate NAME:INSERT
INSERT INTO SAFETYDATE (SETTING_NAME) SELECT 'VSAFETY_DATE' FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM SAFETYDATE WHERE SETTING_NAME='VSAFETY_DATE')
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_cnt number;
begin
	select count(*) into v_cnt from settings where namespace='PxService.DateRange' and setting_name='RollingCount';
	if  v_cnt = 0  then
		select max(setting_id) into v_setting_id from settings;
		v_setting_id:=v_setting_id+1;
		update nextkey set key_seq_num = v_setting_id + 1 where key_name='settings_setting_id';
		insert into settings (namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id) values ('PxService.DateRange','RollingCount',2,null,sysdate,'admin',sysdate,'admin',null,null,v_setting_id);
		commit; 
	end if;  
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
	v_no_data_found NUMBER;
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
		  select count(*) into v_no_data_found from nextkey
          where key_name='findates_fin_dates_id';
          if  v_no_data_found = 0 then
           insert into nextkey select 'findates_fin_dates_id',1 from dual where not exists (select * from nextkey where key_name=lower('findates_fin_dates_id')); 
          commit;
          end if; 
          select key_seq_num into v_fin_dates_id from nextkey
          where key_name='findates_fin_dates_id';
          update nextkey set key_seq_num = key_seq_num + 1
          where key_name='findates_fin_dates_id'; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='P6OGLAppId')
when matched then
update set setting_value='VJeWIBIxQUW3FTuzAIEMFg'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','P6OGLAppId','VJeWIBIxQUW3FTuzAIEMFg',v_setting_id);
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='TMOGLAppId')
when matched then
update set setting_value='lJT0GTABRvKnAZ5Dt8Ynqw'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','TMOGLAppId','lJT0GTABRvKnAZ5Dt8Ynqw',v_setting_id);
end;
/

--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='EnableOGLContent')
when matched then
update set setting_value='false'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','EnableOGLContent','false',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='CopyEPSProjectPreferencesForAddProject')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','CopyEPSProjectPreferencesForAddProject','Y',v_setting_id);
end;
/
--METADATA NAME:orpm_settings TYPE:EXEC
declare 
v_setting_id settings.setting_id%type;
v_no_data_found number;
begin
select count(*) into v_no_data_found from nextkey
  where key_name='settings_setting_id';
if  v_no_data_found = 0 then
insert into nextkey select 'settings_setting_id',1 from dual where not exists (select * from nextkey where key_name=lower('settings_setting_id')); 
commit;
end if; 
select key_seq_num into v_setting_id from nextkey
  where key_name='settings_setting_id';
update nextkey set key_seq_num = key_seq_num + 1
  where key_name='settings_setting_id';   
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='TeamMemberDisplayP6Mobile')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value,setting_id)
values('Administrator_Settings','TeamMemberDisplayP6Mobile','Y',v_setting_id);
end;
/
--METADATA NAME:GETNEXTKEY TYPE:FUNCTION TARGET_OBJECT:GETNEXTKEY CHANGE:CREATE
CREATE OR REPLACE FUNCTION GETNEXTKEY
( tabcol IN VARCHAR2  , numkeys IN NUMBER)
RETURN NUMBER
IS
  PRAGMA AUTONOMOUS_TRANSACTION;
 startkey  number;
BEGIN
  UPDATE nextkey SET key_seq_num = (key_seq_num + numKeys) WHERE key_name = tabcol
  returning (key_seq_num - numkeys) into startkey;
  COMMIT;
  RETURN startkey;
EXCEPTION
  WHEN OTHERS THEN
    startkey := -1;
END;
/
 
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:CREATE
create or replace synonym privuser.initialize_background_procs for ADMUSER.initialize_background_procs
/
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
CURSOR CUR_PROJRISK_PROJ_ID IS SELECT DISTINCT PROJ_ID FROM PROJRISK;
V_WBS_ID INTEGER;
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
FOR V_REC IN CUR_PROJRISK_PROJ_ID LOOP
select WBS_ID INTO V_WBS_ID from ADMUSER.PROJWBS where proj_id= V_REC.PROJ_ID AND PROJ_NODE_FLAG='Y';
UPDATE PROJRISK SET WBS_ID=V_WBS_ID WHERE PROJ_ID=V_REC.PROJ_ID;
COMMIT;
END LOOP;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('WBS_ID');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%WBS_ID%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify WBS_ID NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%WBS_ID%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/  
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJRISK SET ADD_DATE=sysdate;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('ADD_DATE');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%ADD_DATE%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify ADD_DATE NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and validated='NOT VALIDATED' and search_condition_vc like '%ADD_DATE%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJRISK SET PRIORITY_TYPE='PT_Normal';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('PRIORITY_TYPE');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%PRIORITY_TYPE%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify PRIORITY_TYPE NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%PRIORITY_TYPE%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJECT CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
end if;
UPDATE PROJECT SET PX_ENABLE_PUBLICATION_FLAG='Y';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('PX_ENABLE_PUBLICATION_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%PX_ENABLE_PUBLICATION_FLAG%NOT NULL';
if  (IS_NOT_NULL = 1 and V_CON_EXIST = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify PX_ENABLE_PUBLICATION_FLAG  DEFAULT ''Y'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%PX_ENABLE_PUBLICATION_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJWBS CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJWBS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJWBS DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJWBS SET INTG_WBS='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJWBS') and nullable='Y' and column_name =upper('INTG_WBS');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJWBS') and constraint_type='C' and SEARCH_CONDITION_VC like '%INTG_WBS%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJWBS modify INTG_WBS DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJWBS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%INTG_WBS%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*)  into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASK DISABLE ALL TRIGGERS';
END IF;
UPDATE TASK SET STARRED_FLAG='N';
COMMIT;
select count(*) into is_not_null from user_tab_columns where table_name=upper('TASK') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASK') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE TASK modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASKRSRC CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASKRSRC' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASKRSRC DISABLE ALL TRIGGERS';
END IF;
UPDATE TASKRSRC SET STARRED_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('TASKRSRC') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASKRSRC') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then
 EXECUTE IMMEDIATE 'ALTER TABLE TASKRSRC modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASKRSRC') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASKUSER CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASKUSER' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASKUSER DISABLE ALL TRIGGERS';
END IF;
UPDATE TASKUSER SET STARRED_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('TASKUSER') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASKUSER') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then
 EXECUTE IMMEDIATE 'ALTER TABLE TASKUSER modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASKUSER') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE TASKUSER modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:PROFPRIV CHANGE:UPDATE
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)select distinct p.prof_id,176,'N', sysdate, sys_context('userenv','current_schema') 
from profpriv p,profile pf  where lower(scope_type)='st_project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=176) 
/
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISKSCRMTX CHANGE:INSERT
declare
   TYPE typ_riskscrmtx_matrix_id IS TABLE OF NUMBER
       INDEX BY PLS_INTEGER;
    v_typ_riskscrmtx_matrix_id  typ_riskscrmtx_matrix_id;
BEGIN
   SELECT MATRIX_ID BULK COLLECT INTO v_typ_riskscrmtx_matrix_id from project where MATRIX_ID is not null ;
   FORALL indx IN 1 .. v_typ_riskscrmtx_matrix_id.COUNT
     Insert into riskscrmtx (MATRIX_ID,NAME,DESCRIPTION,METHOD,IMPACT_LEVELS,PROBABILITY_LEVELS)
	    select v_typ_riskscrmtx_matrix_id(indx),'Inserted by Migration Process',null,'SM_High',3,3 from dual
      where not exists (select 1 from riskscrmtx where matrix_id = v_typ_riskscrmtx_matrix_id(indx));
	 commit;
END;
/
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISK CHANGE:INSERT
insert into risk(risk_id,id,proj_id,total_cost,type,status,name)
select v.risk_id,'Risk_Mig_'||rn,v.proj_id,0,v.priority_type,v.status_code,v.risk_name from (select risk_id,proj_id,priority_type,status_code,risk_name,rownum as rn from projrisk) v
where not exists ( select 1 from risk r where r.risk_id=v.risk_id)
/
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:DELETE
ALTER TABLE taskrisk DROP CONSTRAINT FK_RISK_RISKID
/
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:CREATE
alter table taskrisk add  constraint FK_RISK_RISKID foreign key (risk_id) REFERENCES RISK (RISK_ID)
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRM_AUDIT') and object_type='PACKAGE' ;
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PACKAGE PRM_AUDIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
  NULL;  
END;
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRMAUDIT') and object_type='TABLE' ;
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE PRMAUDIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
  NULL;  
END;
/
--METADATA TYPE:MIGRATE NAME:MISC_UPDATES 
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from dual where not exists (select * from nextkey where lower(key_name)='settings_setting_id')
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ETL_INTERVAL=24;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ETL_INTERVAL');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ETL_INTERVAL%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ETL_INTERVAL NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ETL_INTERVAL%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ETL_HOUR=0;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ETL_HOUR');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ETL_HOUR%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ETL_HOUR NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ETL_HOUR%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ENABLE_PRIME_SYNC_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ENABLE_PRIME_SYNC_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ENABLE_PRIME_SYNC_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ENABLE_PRIME_SYNC_FLAG NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ENABLE_PRIME_SYNC_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
/*declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='USERS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS DISABLE ALL TRIGGERS';
END IF;
select 1 into is_not_null from user_tab_columns where table_name=upper('USERS') and nullable='Y' and column_name =upper('STATUS');
select count(*) into v_con_exist   from user_constraints where table_name=upper('USERS') and constraint_type='C' and SEARCH_CONDITION_VC like '%STATUS%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
UPDATE USERS SET STATUS='Y';
COMMIT;
EXECUTE IMMEDIATE 'ALTER TABLE USERS modify STATUS NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('USERS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STATUS%NOT NULL';
UPDATE USERS SET STATUS='Y';
COMMIT;
execute immediate 'ALTER TABLE USERS modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
*/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='USERS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS DISABLE ALL TRIGGERS';
END IF;
UPDATE USERS SET SYSTEMUSER='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('USERS') and nullable='Y' and column_name =upper('SYSTEMUSER');
select count(*) into v_con_exist   from user_constraints where table_name=upper('USERS') and constraint_type='C' and SEARCH_CONDITION_VC like '%SYSTEMUSER%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE USERS modify SYSTEMUSER NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('USERS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%SYSTEMUSER%NOT NULL';
execute immediate 'ALTER TABLE USERS modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:GATHER_STATISTICS CHANGE:CREATE
create or replace synonym bgjobuser.GATHER_STATISTICS for ADMUSER.GATHER_STATISTICS
/
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:REBUILD_INDEX CHANGE:CREATE
create or replace synonym bgjobuser.REBUILD_INDEX for ADMUSER.REBUILD_INDEX
/
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:STATISTICS_MONITOR CHANGE:CREATE
create or replace synonym bgjobuser.STATISTICS_MONITOR for ADMUSER.STATISTICS_MONITOR
/

--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:GATHER_FLUX_STATISTICS CHANGE:CREATE
create or replace synonym bgjobuser.GATHER_FLUX_STATISTICS for ADMUSER.GATHER_FLUX_STATISTICS
/

--METADATA NAME:MISC_UPDATES TYPE:VIEW TARGET_OBJECT:ITERDAYS CHANGE:DROP
DROP VIEW PRIVUSER.ITERDAYS
/

--METADATA NAME:MISC_UPDATES TYPE:VIEW TARGET_OBJECT:ITERGOAL CHANGE:DROP
DROP VIEW PRIVUSER.ITERGOAL
/

--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:CHECK_DB_SIZE_LIMIT CHANGE:DROP
drop SYNONYM PRIVUSER.CHECK_DB_SIZE_LIMIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:DROP
drop SYNONYM PRIVUSER.INITIALIZE_BACKGROUND_PROCS
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRMAUDIT CHANGE:DROP
drop SYNONYM PRIVUSER.PRMAUDIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRMAUDIT_CLEANUP CHANGE:DROP
drop SYNONYM PRIVUSER.PRMAUDIT_CLEANUP
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRM_AUDIT CHANGE:DROP
drop SYNONYM PRIVUSER.PRM_AUDIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:DATA_MONITOR CHANGE:COMPILE
alter SYNONYM BGJOBUSER.DATA_MONITOR compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:GATHER_STATISTICS CHANGE:COMPILE
alter SYNONYM BGJOBUSER.GATHER_STATISTICS compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:COMPILE
alter SYNONYM BGJOBUSER.INITIALIZE_BACKGROUND_PROCS compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:REBUILD_INDEX CHANGE:COMPILE
alter SYNONYM BGJOBUSER.REBUILD_INDEX compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:SETTINGS_READ_STRING CHANGE:COMPILE
alter SYNONYM BGJOBUSER.SETTINGS_READ_STRING compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:SETTINGS_WRITE_STRING CHANGE:COMPILE
alter SYNONYM BGJOBUSER.SETTINGS_WRITE_STRING compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:STATISTICS_MONITOR CHANGE:COMPILE
alter SYNONYM BGJOBUSER.STATISTICS_MONITOR compile
/
