--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
begin
for rec in (select granted_role from dba_role_privs where grantee=upper('ADMUSER') and granted_role like 'DBA') loop
begin
 execute immediate 'revoke '||rec.granted_role ||' from ADMUSER';
exception when others then null;
end;
end loop;
end;
/

--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
declare
v_sql varchar2(2000);
v_cnt integer;
begin
select count(role) into v_cnt  from dba_roles where role = 'PM_ADM_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_ADM_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_BG_JOB_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_BG_JOB_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_PRIV_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_PRIV_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_REPORT_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_REPORT_ROLE';
end if;
select count(role) into v_cnt  from dba_roles where role = 'PM_PUBLIC_ROLE' ;
if v_cnt = 0 then
execute immediate 'create role PM_PUBLIC_ROLE';
end if;
exception when others then null;
end;
/

--METADATA TYPE:GRANT CHANGE:REVOKE NAME:ADMUSER
begin
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('ADMUSER') ) loop
  execute immediate 'revoke '||rec.privilege ||' from ADMUSER';
  execute immediate 'grant '||rec.privilege ||' to PM_ADM_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('privuser') ) loop
  execute immediate 'revoke '||rec.privilege ||' from privuser';
  execute immediate 'grant '||rec.privilege ||' to PM_PRIV_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('bgjobuser') ) loop
  execute immediate 'revoke '||rec.privilege ||' from bgjobuser';
  execute immediate 'grant '||rec.privilege ||' to PM_BG_JOB_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('PXRPTUSER') 
                   and privilege <> 'UNLIMITED TABLESPACE') loop
  execute immediate 'revoke '||rec.privilege ||' from PXRPTUSER';
  execute immediate 'grant '||rec.privilege ||' to PM_REPORT_ROLE';
end loop; 
for rec in (select privilege,grantee from dba_sys_privs where grantee = upper('pubuser') ) loop
  execute immediate 'revoke '||rec.privilege ||' from pubuser';
  execute immediate 'grant '||rec.privilege ||' to PM_PUBLIC_ROLE';
end loop; 
exception when others then null;
end;
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER 
grant CREATE SESSION,CREATE TABLE,CREATE PROCEDURE,CREATE SEQUENCE,CREATE TRIGGER,CREATE TYPE,CREATE VIEW,ADMINISTER DATABASE TRIGGER to PM_ADM_ROLE
/ 
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER 
grant PM_ADM_ROLE to ADMUSER
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:ADMUSER 
alter user ADMUSER default role PM_ADM_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant CREATE SESSION,CREATE SYNONYM,CREATE JOB to PM_BG_JOB_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant PM_BG_JOB_ROLE to BGJOBUSER
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:BGJOBUSER 
alter user BGJOBUSER default role PM_BG_JOB_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant CREATE SESSION,CREATE VIEW,CREATE SYNONYM to PM_PRIV_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant PM_PRIV_ROLE to PRIVUSER
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PRIVUSER 
alter user PRIVUSER default role PM_PRIV_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PXRPTUSER
grant CREATE SESSION,CREATE VIEW,CREATE SYNONYM to PM_REPORT_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PXRPTUSER
grant PM_REPORT_ROLE to PXRPTUSER
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PXRPTUSER 
alter user PXRPTUSER default role PM_REPORT_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER
grant CREATE SESSION,CREATE SYNONYM to PM_PUBLIC_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER 
grant PM_PUBLIC_ROLE to PUBUSER
/
--METADATA TYPE:GRANT CHANGE:ALTER PRIVILEGE GRANTEE:PUBUSER 
alter user PUBUSER default role PM_PUBLIC_ROLE
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER
grant SELECT ON SYS.DBA_VIEWS TO ADMUSER
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_DAT1
alter user admuser quota unlimited on PMDB_DAT1
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_NDX1
alter user admuser quota unlimited on PMDB_NDX1
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_LOB1
alter user admuser quota unlimited on PMDB_LOB1
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_PX_DAT1
alter user admuser quota unlimited on PMDB_PX_DAT1
/