
--Run Script as ADMUSER    
SET DEFINE OFF

prompt Creating table ACCOUNT

--METADATA NAME:ACCOUNT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACCOUNT(
  acct_id  number(10) NOT NULL,
  acct_seq_num  number(10) NOT NULL,
  acct_short_name  varchar2(40 CHAR) NOT NULL,
  acct_name  varchar2(100 CHAR) NOT NULL,
  parent_acct_id  number(10) NULL,
  acct_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(acct_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ACTVCODE

--METADATA NAME:ACTVCODE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVCODE(
  actv_code_id  number(10) NOT NULL,
  actv_code_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  short_name  varchar2(60 CHAR) NOT NULL,
  parent_actv_code_id  number(10) NULL,
  actv_code_name  varchar2(120 CHAR) NULL,
  color  varchar2(6 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ACTVTYPE

--METADATA NAME:ACTVTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVTYPE(
  actv_code_type_id  number(10) NOT NULL,
  actv_short_len  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  actv_code_type  varchar2(40 CHAR) NOT NULL,
  actv_code_type_scope  varchar2(10 CHAR) NOT NULL,
  proj_id  number(10) NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ADMIN_CONFIG

--METADATA NAME:ADMIN_CONFIG TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADMIN_CONFIG(
  config_name  varchar2(255 CHAR) NOT NULL,
  config_type  varchar2(10 CHAR) NULL,
  factory_version  varchar2(10 CHAR) NULL,
  last_change_date  DATE DEFAULT sysdate NOT NULL,
  config_value  varchar2(255 CHAR) NULL,
  config_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(config_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ASGNMNTACAT

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTACAT(
  taskrsrc_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  asgnmnt_catg_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ASGNMNTCATTYPE

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATTYPE(
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_len  number(10) NOT NULL,
  asgnmnt_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ASGNMNTCATVAL

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATVAL(
  asgnmnt_catg_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_name  varchar2(60 CHAR) NOT NULL,
  asgnmnt_catg_name  varchar2(100 CHAR) NULL,
  parent_asgnmnt_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BASETYPE

--METADATA NAME:BASETYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE BASETYPE(
  base_type_id  number(10) NOT NULL,
  base_type_seq_num  number(10) NOT NULL,
  base_type  varchar2(40 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BGPLOG

--METADATA NAME:BGPLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE BGPLOG(
  log_time  DATE DEFAULT sysdate NULL,
  source  varchar2(255 CHAR) NULL,
  type  varchar2(255 CHAR) NULL,
  description  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BRE_REGISTRY

--METADATA NAME:BRE_REGISTRY TYPE:TABLE CHANGE:CREATE

CREATE TABLE BRE_REGISTRY(
  bre_registry_id  varchar2(50 CHAR) NOT NULL,
  ip_address  varchar2(30 CHAR) NOT NULL,
  start_time  DATE NOT NULL,
  last_time  DATE NULL,
  status_code  char(1 CHAR) NOT NULL,
  torched_time  DATE NULL,
  config_name  varchar2(30 CHAR) NOT NULL,
  config_changed_flag  char(1 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table BUDGCHNG

--METADATA NAME:BUDGCHNG TYPE:TABLE CHANGE:CREATE

CREATE TABLE BUDGCHNG(
  budg_chng_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  chng_date  DATE NOT NULL,
  chng_short_name  varchar2(32 CHAR) NOT NULL,
  chng_cost  number(23,6) NULL,
  chng_by_name  varchar2(255 CHAR) NULL,
  status_code  varchar2(30 CHAR) NULL,
  chng_descr  varchar2(130 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CALENDAR

--METADATA NAME:CALENDAR TYPE:TABLE CHANGE:CREATE

CREATE TABLE CALENDAR(
  clndr_id  number(10) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_private  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  clndr_name  varchar2(255 CHAR) NOT NULL,
  proj_id  number(10) NULL,
  base_clndr_id  number(10) NULL,
  last_chng_date  DATE NULL,
  clndr_type  varchar2(16 CHAR) NULL,
  clndr_data  BLOB NULL,
  day_hr_cnt  number(10,2) NULL,
  week_hr_cnt  number(10,2) NULL,
  year_hr_cnt  number(10,2) NULL,
  month_hr_cnt  number(10,2) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(clndr_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table COSTTYPE

--METADATA NAME:COSTTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTTYPE(
  cost_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  cost_type  varchar2(36 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table CURRTYPE

--METADATA NAME:CURRTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE CURRTYPE(
  curr_id  number(10) NOT NULL,
  decimal_digit_cnt  number(10) NOT NULL,
  curr_symbol  varchar2(6 CHAR) NOT NULL,
  decimal_symbol  varchar2(6 CHAR) NOT NULL,
  digit_group_symbol  varchar2(6 CHAR) NOT NULL,
  pos_curr_fmt_type  varchar2(20 CHAR) NOT NULL,
  neg_curr_fmt_type  varchar2(20 CHAR) NOT NULL,
  curr_type  varchar2(40 CHAR) NOT NULL,
  curr_short_name  varchar2(6 CHAR) NOT NULL,
  group_digit_cnt  number(10) DEFAULT 3 NOT NULL,
  base_exch_rate  number(22,6) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DASHBOARD

--METADATA NAME:DASHBOARD TYPE:TABLE CHANGE:CREATE

CREATE TABLE DASHBOARD(
  dashboard_id  number(10) NOT NULL,
  dashboard_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  table_name  varchar2(30 CHAR) NULL,
  fk_id  number(10) NULL,
  lock_filter_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  max_rows_per_portlet  number(10) NULL,
  dashboard_layout_data  varchar2(4000 CHAR) NULL,
  portlet_settings_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(portlet_settings_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table DASHUSER

--METADATA NAME:DASHUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DASHUSER(
  dashboard_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DISCUSSION

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE DISCUSSION(
  discussion_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  discussion_value  varchar2(4000 CHAR) NULL,
  discussion_date  DATE NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DISCUSSION_READ

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE

CREATE TABLE DISCUSSION_READ(
  discussion_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DLTACCT

--METADATA NAME:DLTACCT TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTACCT(
  session_id  number(10) NOT NULL,
  acct_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTACTV

--METADATA NAME:DLTACTV TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTACTV(
  session_id  number(10) NOT NULL,
  actv_code_id  number(10) NOT NULL,
  parent_actv_code_id  number(10) NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTOBS

--METADATA NAME:DLTOBS TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTOBS(
  session_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTROLE

--METADATA NAME:DLTROLE TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTROLE(
  session_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTRSRC

--METADATA NAME:DLTRSRC TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTRSRC(
  session_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTRSRL

--METADATA NAME:DLTRSRL TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTRSRL(
  session_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DLTUSER

--METADATA NAME:DLTUSER TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE DLTUSER(
  session_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table DOCCATG

--METADATA NAME:DOCCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCCATG(
  doc_catg_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  doc_catg_name  varchar2(100 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOCREVIEW

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCREVIEW(
  doc_review_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_name  varchar2(255 CHAR) NULL,
  review_descr  varchar2(255 CHAR) NULL,
  review_type  varchar2(15 CHAR) NULL,
  due_date  DATE NULL,
  status  varchar2(15 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOCREVIEWTASK

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCREVIEWTASK(
  review_task_id  number(10) NOT NULL,
  doc_review_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_date  DATE NULL,
  comments  varchar2(4000 CHAR) NULL,
  priority  number(10) NULL,
  status  varchar2(15 CHAR) NULL,
  attachment_uuid  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOCSTAT

--METADATA NAME:DOCSTAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCSTAT(
  doc_status_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  doc_status_code  varchar2(36 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table DOCUMENT

--METADATA NAME:DOCUMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENT(
  doc_id  number(10) NOT NULL,
  doc_seq_num  number(10) NOT NULL,
  deliv_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  doc_name  varchar2(120 CHAR) NOT NULL,
  parent_doc_id  number(10) NULL,
  proj_id  number(10) NULL,
  doc_status_id  number(10) NULL,
  doc_catg_id  number(10) NULL,
  doc_date  DATE NULL,
  version_name  varchar2(20 CHAR) DEFAULT '1' NOT NULL,
  guid  varchar2(22 CHAR) NULL,
  tmpl_guid  varchar2(22 CHAR) NULL,
  doc_short_name  varchar2(32 CHAR) NULL,
  author_name  varchar2(255 CHAR) NULL,
  private_loc  varchar2(4000 CHAR) NULL,
  public_loc  varchar2(4000 CHAR) NULL,
  doc_content  BLOB NULL,
  rsrc_id  number(10) NULL,
  doc_mgmt_type  varchar2(10 CHAR) DEFAULT 'DM_Local' NOT NULL,
  external_doc_key  varchar2(4000 CHAR) NULL,
  cr_external_doc_key  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(doc_content) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table EXPPROJ

--METADATA NAME:EXPPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE EXPPROJ(
  proj_id  number(10) NOT NULL,
  exp_group  varchar2(255 CHAR) NOT NULL,
  exp_proj_name  varchar2(24 CHAR) NOT NULL,
  login_supplied_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  exp_user_name  varchar2(40 CHAR) NULL,
  exp_passwd  varchar2(60 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table EXTAPP

--METADATA NAME:EXTAPP TYPE:TABLE CHANGE:CREATE

CREATE TABLE EXTAPP(
  app_id  number(10) NOT NULL,
  login_supply_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  app_name  varchar2(100 CHAR) NOT NULL,
  app_exe_name  varchar2(100 CHAR) NOT NULL,
  proj_id  number(10) NULL,
  app_user_name  varchar2(40 CHAR) NULL,
  app_passwd  varchar2(100 CHAR) NULL,
  app_data_name  varchar2(100 CHAR) NULL,
  app_parm_string  varchar2(255 CHAR) NULL,
  app_data_loc  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FACTOR

--METADATA NAME:FACTOR TYPE:TABLE CHANGE:CREATE

CREATE TABLE FACTOR(
  fact_id  number(10) NOT NULL,
  fact_seq_num  number(10) NOT NULL,
  fact_type  varchar2(20 CHAR) NOT NULL,
  fact_name  varchar2(100 CHAR) NOT NULL,
  def_fact_val_id  number(10) NULL,
  fact_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(fact_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table FACTVAL

--METADATA NAME:FACTVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FACTVAL(
  fact_val_id  number(10) NOT NULL,
  fact_id  number(10) NOT NULL,
  fact_value  varchar2(24 CHAR) NOT NULL,
  fact_value_descr  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FILTPROP

--METADATA NAME:FILTPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE FILTPROP(
  filter_id  number(10) NOT NULL,
  table_name  varchar2(16 CHAR) NOT NULL,
  filter_type  varchar2(20 CHAR) NOT NULL,
  filter_name  varchar2(40 CHAR) NOT NULL,
  user_id  number(10) NULL,
  filter_data  BLOB NULL,
  rpt_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(filter_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table FINDATES

--METADATA NAME:FINDATES TYPE:TABLE CHANGE:CREATE

CREATE TABLE FINDATES(
  fin_dates_id  number(10) NOT NULL,
  fin_dates_name  varchar2(60 CHAR) NOT NULL,
  start_date  DATE NOT NULL,
  end_date  DATE NOT NULL,
  fintmpl_id  number(10) DEFAULT 1 NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FINTMPL

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FINTMPL(
  fintmpl_id  number(10) NOT NULL,
  fintmpl_name  varchar2(255 CHAR) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FORMCATG

--METADATA NAME:FORMCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMCATG(
  form_catg_id  number(10) NOT NULL,
  form_catg_name  varchar2(255 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FORMPROJ

--METADATA NAME:FORMPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMPROJ(
  form_tmpl_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table FORMTMPL

--METADATA NAME:FORMTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMTMPL(
  form_tmpl_id  number(10) NOT NULL,
  form_tmpl_name  varchar2(255 CHAR) NOT NULL,
  form_tmpl_desc  varchar2(4000 CHAR) NULL,
  form_catg_id  number(10) NULL,
  form_tmpl_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(form_tmpl_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table FUNDSRC

--METADATA NAME:FUNDSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE FUNDSRC(
  fund_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  fund_name  varchar2(100 CHAR) NOT NULL,
  parent_fund_id  number(10) NULL,
  fund_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(fund_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table GCHANGE

--METADATA NAME:GCHANGE TYPE:TABLE CHANGE:CREATE

CREATE TABLE GCHANGE(
  gchange_id  number(10) NOT NULL,
  gchange_name  varchar2(40 CHAR) NOT NULL,
  gchange_data  BLOB NULL,
  user_id  number(10) NULL,
  table_name  varchar2(20 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(gchange_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table HQDATA

--METADATA NAME:HQDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE HQDATA(
  session_id  number(10) NOT NULL,
  context_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  value  number(10) NOT NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table HQUERY

--METADATA NAME:HQUERY TYPE:TABLE CHANGE:CREATE

CREATE TABLE HQUERY(
  session_id  number(10) NOT NULL,
  context_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  order_value  varchar2(4000 CHAR) NULL,
  order_ids  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table IMAGEDATA

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE IMAGEDATA(
  image_id  number(10) NOT NULL,
  image_name  varchar2(120 CHAR) NULL,
  image_data  BLOB NOT NULL,
  image_thumbnail  BLOB NOT NULL,
  image_extension  varchar2(20 CHAR) DEFAULT 'png' NOT NULL,
  default_flag  varchar2(1 CHAR) NOT NULL,
  image_purpose  varchar2(50 CHAR) NOT NULL,
  image_description  varchar2(250 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ISSUHIST

--METADATA NAME:ISSUHIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE ISSUHIST(
  issue_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  issue_history  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(issue_history) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ITERATION

--METADATA NAME:ITERATION TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERATION(
  iteration_id  number(10) NOT NULL,
  release_id  number(10) NOT NULL,
  iteration_name  varchar2(50 CHAR) NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  termination_date  DATE NULL,
  capacity_pct  number(10,2) DEFAULT 0 NULL,
  remain_qty  number(17,6) NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  create_date  DATE DEFAULT sysdate NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ITERDAYS

--METADATA NAME:ITERDAYS TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERDAYS(
  task_id  number(10) NOT NULL,
  day_number  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  iteration_id  number(10) NOT NULL,
  act_work_qty  number(17,6) NULL,
  remain_work_qty  number(17,6) NULL,
  update_date  DATE DEFAULT sysdate NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  create_date  DATE DEFAULT sysdate NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'SYSTEM' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ITERGOAL

--METADATA NAME:ITERGOAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERGOAL(
  iter_goal_id  number(10) NOT NULL,
  iteration_id  number(10) NOT NULL,
  goal_name  varchar2(255 CHAR) NOT NULL,
  goal_descr  varchar2(4000 CHAR) NOT NULL,
  status_code  varchar2(12 CHAR) DEFAULT 'IG_NotStart' NOT NULL,
  rfolio_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table JOBLOG

--METADATA NAME:JOBLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBLOG(
  job_id  number(10) NOT NULL,
  job_log_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(job_log_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table JOBRPT

--METADATA NAME:JOBRPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBRPT(
  job_id  number(10) NOT NULL,
  rpt_id  number(10) NOT NULL,
  table_name  varchar2(20 CHAR) NULL,
  fk_id  number(10) NULL,
  jobrpt_data  BLOB NULL,
  personal_portal_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(jobrpt_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table JOBSVC

--METADATA NAME:JOBSVC TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBSVC(
  job_id  number(10) NOT NULL,
  parent_job_id  number(10) NULL,
  seq_num  number(10) NOT NULL,
  audit_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  job_type  varchar2(20 CHAR) NOT NULL,
  job_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NOT NULL,
  last_run_date  DATE NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  recur_data  varchar2(255 CHAR) NULL,
  recur_type  varchar2(20 CHAR) NULL,
  submitted_date  DATE NULL,
  last_error_descr  varchar2(255 CHAR) NULL,
  audit_file_path  varchar2(255 CHAR) NULL,
  job_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(job_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table LOCATION

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE

CREATE TABLE LOCATION(
  location_id  number(10) NOT NULL,
  location_name  varchar2(255 CHAR) NOT NULL,
  location_type  varchar2(24 CHAR) NULL,
  address_line1  varchar2(200 CHAR) NULL,
  address_line2  varchar2(200 CHAR) NULL,
  address_line3  varchar2(200 CHAR) NULL,
  city_name  varchar2(200 CHAR) NULL,
  municipality_name  varchar2(200 CHAR) NULL,
  state_name  varchar2(200 CHAR) NULL,
  state_code  varchar2(2 CHAR) NULL,
  country_name  varchar2(200 CHAR) NULL,
  country_code  varchar2(3 CHAR) NULL,
  postal_code  varchar2(20 CHAR) NULL,
  longitude  NUMBER NULL,
  latitude  NUMBER NULL,
  geo_location  SDO_GEOMETRY NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table MEMOTYPE

--METADATA NAME:MEMOTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE MEMOTYPE(
  memo_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  eps_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  proj_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  wbs_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  task_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  memo_type  varchar2(40 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table NEXTKEY

--METADATA NAME:NEXTKEY TYPE:TABLE CHANGE:CREATE

CREATE TABLE NEXTKEY(
  key_name  varchar2(60 CHAR) NOT NULL,
  key_seq_num  number(10) NOT NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table NONWORK

--METADATA NAME:NONWORK TYPE:TABLE CHANGE:CREATE

CREATE TABLE NONWORK(
  nonwork_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  nonwork_code  varchar2(32 CHAR) NOT NULL,
  nonwork_type  varchar2(40 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table NOTE

--METADATA NAME:NOTE TYPE:TABLE CHANGE:CREATE

CREATE TABLE NOTE(
  note_id  number(10) NOT NULL,
  table_name  varchar2(30 CHAR) NOT NULL,
  type_name  varchar2(30 CHAR) NOT NULL,
  fk_id  number(10) NOT NULL,
  note_date  DATE NOT NULL,
  note_value  varchar2(4000 CHAR) NULL,
  user_name  varchar2(255 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table OBS

--METADATA NAME:OBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE OBS(
  obs_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  obs_name  varchar2(100 CHAR) NOT NULL,
  parent_obs_id  number(10) NULL,
  guid  varchar2(22 CHAR) NULL,
  obs_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(obs_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table OBSPROJ

--METADATA NAME:OBSPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE OBSPROJ(
  obs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PCATTYPE

--METADATA NAME:PCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATTYPE(
  proj_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  proj_catg_short_len  number(10) NOT NULL,
  proj_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  proj_catg_type_wt  number(10,2) DEFAULT 0 NULL,
  max_proj_catg_wt  number(10,2) DEFAULT 0 NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PCATUSER

--METADATA NAME:PCATUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATUSER(
  proj_catg_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PCATVAL

--METADATA NAME:PCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATVAL(
  proj_catg_id  number(10) NOT NULL,
  proj_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  proj_catg_short_name  varchar2(60 CHAR) NOT NULL,
  parent_proj_catg_id  number(10) NULL,
  proj_catg_name  varchar2(100 CHAR) NULL,
  proj_catg_wt  number(10,2) DEFAULT 0 NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PFOLIO

--METADATA NAME:PFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIO(
  pfolio_id  number(10) NOT NULL,
  closed_proj_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  whatif_proj_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  pfolio_type  varchar2(20 CHAR) NOT NULL,
  pfolio_name  varchar2(40 CHAR) NOT NULL,
  user_id  number(10) NULL,
  pfolio_descr  varchar2(255 CHAR) NULL,
  last_refresh_date  DATE NULL,
  pfolio_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(pfolio_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PHASE

--METADATA NAME:PHASE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PHASE(
  phase_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  phase_name  varchar2(100 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PKXREF

--METADATA NAME:PKXREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PKXREF(
  system_id  number(10) NULL,
  context_name  varchar2(30 CHAR) NULL,
  pk1  number(10) NULL,
  pk2  number(10) NULL,
  old_pk1  number(10) NULL,
  old_pk2  number(10) NULL,
  old_str  varchar2(40 CHAR) NULL,
  new_str  varchar2(40 CHAR) NULL,
  add_date  DATE DEFAULT sysdate NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table POBS

--METADATA NAME:POBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE POBS(
  pobs_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  pobs_name  varchar2(255 CHAR) NOT NULL,
  pobs_parent_id  number(10) NULL,
  pobs_descr  varchar2(255 CHAR) NULL,
  pobs_manager  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PREFER

--METADATA NAME:PREFER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PREFER(
  prefer_id  number(10) NOT NULL,
  hr_decimal_cnt  number(10) NOT NULL,
  xfer_complete_day_cnt  number(10) NOT NULL,
  xfer_notstart_day_cnt  number(10) NOT NULL,
  max_wbs_level_cnt  number(10) NOT NULL,
  max_rsrc_level_cnt  number(10) NOT NULL,
  max_acct_level_cnt  number(10) NOT NULL,
  max_task_actv_type_cnt  number(10) NOT NULL,
  future_ts_cnt  number(10) NOT NULL,
  max_obs_level_cnt  number(10) NOT NULL,
  week_start_day_num  number(10) NOT NULL,
  ts_approval_level  number(10) NOT NULL,
  task_code_len  number(10) NOT NULL,
  proj_short_len  number(10) NOT NULL,
  wbs_short_len  number(10) NOT NULL,
  rsrc_short_len  number(10) NOT NULL,
  acct_short_len  number(10) NOT NULL,
  role_short_len  number(10) NOT NULL,
  max_base_cnt  number(10) NOT NULL,
  def_target_drtn_hr_cnt  number(10,2) NOT NULL,
  day_hr_cnt  number(10,2) NOT NULL,
  week_hr_cnt  number(10,2) NOT NULL,
  year_hr_cnt  number(10,2) NOT NULL,
  month_hr_cnt  number(10,2) NOT NULL,
  max_actv_level_cnt  number(10) NOT NULL,
  max_eps_level_cnt  number(10) NOT NULL,
  max_pcat_level_cnt  number(10) NOT NULL,
  max_rcat_level_cnt  number(10) NOT NULL,
  complete_task_hrs_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  default_timesheet_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  future_ts_hrs_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  ev_fix_cost_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  ts_daily_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  notstart_task_hrs_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  prestart_task_hrs_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  postend_task_hrs_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  ermm_enabled_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  name_sep_char  varchar2(2 CHAR) NOT NULL,
  year_char  varchar2(4 CHAR) NOT NULL,
  month_char  varchar2(4 CHAR) NOT NULL,
  week_char  varchar2(4 CHAR) NOT NULL,
  day_char  varchar2(4 CHAR) NOT NULL,
  hour_char  varchar2(4 CHAR) NOT NULL,
  minute_char  varchar2(4 CHAR) NOT NULL,
  ts_approval_type  varchar2(20 CHAR) DEFAULT 'AT_PM_RM' NOT NULL,
  db_name  varchar2(20 CHAR) NOT NULL,
  tasksum_period_type  varchar2(20 CHAR) NOT NULL,
  trsrcsum_period_type  varchar2(20 CHAR) NOT NULL,
  database_version  varchar2(30 CHAR) NOT NULL,
  min_pro_version  varchar2(10 CHAR) NULL,
  phase_label  varchar2(40 CHAR) NOT NULL,
  ts_approve_user_id  number(10) NULL,
  curr_id  number(10) DEFAULT 1 NOT NULL,
  ev_user_pct  number(10) NULL,
  ev_etc_user_value  number(10,2) NULL,
  ev_compute_type  varchar2(20 CHAR) NULL,
  ev_etc_compute_type  varchar2(20 CHAR) NULL,
  rpt_header_1  varchar2(255 CHAR) NULL,
  rpt_header_2  varchar2(255 CHAR) NULL,
  rpt_header_3  varchar2(255 CHAR) NULL,
  rpt_footer_1  varchar2(255 CHAR) NULL,
  rpt_footer_2  varchar2(255 CHAR) NULL,
  rpt_footer_3  varchar2(255 CHAR) NULL,
  rpt_user_1  varchar2(255 CHAR) NULL,
  rpt_user_2  varchar2(255 CHAR) NULL,
  rpt_user_3  varchar2(255 CHAR) NULL,
  license_data  BLOB NULL,
  max_role_level_cnt  number(10) NOT NULL,
  past_ts_cnt  number(10) DEFAULT 4 NOT NULL,
  projinit_admin_user_id  number(10) NOT NULL,
  default_rsrc_sec_id  number(10) NULL,
  allow_user_time_period_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  exp_root_url  varchar2(255 CHAR) NULL,
  ts_rsrc_def_asgn_actv_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(license_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PRMAUDIT

--METADATA NAME:PRMAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRMAUDIT(
  audit_date  DATE NULL,
  table_name  varchar2(30 CHAR) NULL,
  pk1  varchar2(255 CHAR) NULL,
  pk2  varchar2(255 CHAR) NULL,
  pk3  varchar2(255 CHAR) NULL,
  pk4  varchar2(255 CHAR) NULL,
  oper  varchar2(1 CHAR) NULL,
  prm_user_name  varchar2(255 CHAR) NULL,
  audit_info  varchar2(4000 CHAR) NULL,
  audit_info_extended  BLOB NULL,
  logical_delete_flag  varchar2(1 CHAR) NULL,
  rdbms_user_name  varchar2(255 CHAR) NULL,
  os_user_name  varchar2(255 CHAR) NULL,
  program  varchar2(255 CHAR) NULL,
  host_name  varchar2(255 CHAR) NULL,
  app_name  varchar2(25 CHAR) NULL,
  netaddress  varchar2(64 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(audit_info_extended) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PRMQUEUE

--METADATA NAME:PRMQUEUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRMQUEUE(
  queue_name  varchar2(30 CHAR) NOT NULL,
  msg_key  varchar2(32 CHAR) NOT NULL,
  enqueue_date  DATE NOT NULL,
  enqueue_user  varchar2(255 CHAR) NULL,
  status_code  varchar2(10 CHAR) NULL,
  priority  number(10) NULL,
  sender_name  varchar2(255 CHAR) NULL,
  dequeue_date  DATE NULL,
  dequeue_user  varchar2(255 CHAR) NULL,
  retry_count  number(10) NULL,
  msg_type  varchar2(255 CHAR) NULL,
  msg_sub_type  varchar2(255 CHAR) NULL,
  key1  varchar2(255 CHAR) NULL,
  key2  varchar2(255 CHAR) NULL,
  err_msg  varchar2(4000 CHAR) NULL,
  queue_payload  varchar2(4000 CHAR) NULL,
  queue_payload_extended  BLOB NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(queue_payload_extended) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROCGROUP

--METADATA NAME:PROCGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROCGROUP(
  proc_group_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  proc_group_name  varchar2(120 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROCITEM

--METADATA NAME:PROCITEM TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROCITEM(
  proc_item_id  number(10) NOT NULL,
  proc_group_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  proc_name  varchar2(120 CHAR) NOT NULL,
  proc_wt  number(10,2) NULL,
  proc_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(proc_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROFILE

--METADATA NAME:PROFILE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFILE(
  prof_id  number(10) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  superuser_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  scope_type  varchar2(12 CHAR) NOT NULL,
  prof_name  varchar2(100 CHAR) NOT NULL,
  prof_descr  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROFPRIV

--METADATA NAME:PROFPRIV TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFPRIV(
  prof_id  number(10) NOT NULL,
  priv_num  number(10) NOT NULL,
  allow_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJCOST

--METADATA NAME:PROJCOST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJCOST(
  cost_item_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  auto_compute_act_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  cost_load_type  varchar2(12 CHAR) NOT NULL,
  acct_id  number(10) NULL,
  cost_type_id  number(10) NULL,
  target_cost  number(23,6) NULL,
  act_cost  number(23,6) NULL,
  remain_cost  number(23,6) NULL,
  qty_name  varchar2(30 CHAR) NULL,
  target_qty  number(19,6) NOT NULL,
  cost_per_qty  number(21,8) NOT NULL,
  po_number  varchar2(32 CHAR) NULL,
  vendor_name  varchar2(100 CHAR) NULL,
  cost_name  varchar2(120 CHAR) NULL,
  cost_descr  BLOB NULL,
  pobs_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(cost_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROJECT

--METADATA NAME:PROJECT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECT(
  proj_id  number(10) NOT NULL,
  fy_start_month_num  number(10) NOT NULL,
  chng_eff_cmp_pct_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_self_add_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  rsrc_role_match_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  allow_complete_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_multi_assign_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  checkout_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  project_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  step_complete_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  cost_qty_recalc_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  sum_only_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  batch_sum_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  name_sep_char  varchar2(2 CHAR) NOT NULL,
  def_complete_pct_type  varchar2(10 CHAR) DEFAULT 'CP_Drtn' NOT NULL,
  proj_short_name  varchar2(40 CHAR) NOT NULL,
  acct_id  number(10) NULL,
  orig_proj_id  number(10) NULL,
  source_proj_id  number(10) NULL,
  base_type_id  number(10) NULL,
  clndr_id  number(10) NULL,
  sum_base_proj_id  number(10) NULL,
  task_code_base  number(10) NULL,
  task_code_step  number(10) NULL,
  priority_num  number(10) NULL,
  wbs_max_sum_level  number(10) NULL,
  risk_level  number(10) NULL,
  strgy_priority_num  number(10) NULL,
  last_checksum  number(10) NULL,
  critical_drtn_hr_cnt  number(10,2) NULL,
  def_cost_per_qty  number(21,8) NULL,
  last_recalc_date  DATE NULL,
  plan_start_date  DATE NULL,
  plan_end_date  DATE NULL,
  scd_end_date  DATE NULL,
  add_date  DATE DEFAULT sysdate NOT NULL,
  sum_data_date  DATE NULL,
  last_tasksum_date  DATE NULL,
  fcst_start_date  DATE NULL,
  def_duration_type  varchar2(12 CHAR) NULL,
  task_code_prefix  varchar2(20 CHAR) NULL,
  guid  varchar2(22 CHAR) NULL,
  def_qty_type  varchar2(24 CHAR) NULL,
  add_by_name  varchar2(255 CHAR) NULL,
  web_local_root_path  varchar2(120 CHAR) NULL,
  proj_url  varchar2(200 CHAR) NULL,
  def_rate_type  varchar2(14 CHAR) NULL,
  act_this_per_link_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  def_task_type  varchar2(12 CHAR) DEFAULT 'TT_Task' NOT NULL,
  act_pct_link_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  add_act_remain_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  critical_path_type  varchar2(12 CHAR) DEFAULT 'CT_TotFloat' NOT NULL,
  task_code_prefix_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  def_rollup_dates_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  rem_target_link_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  reset_planned_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  allow_neg_act_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_id  number(10) NULL,
  msp_managed_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  msp_update_actuals_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  checkout_date  DATE NULL,
  checkout_user_id  number(10) NULL,
  sum_assign_level  varchar2(12 CHAR) DEFAULT 'SL_Taskrsrc' NULL,
  last_fin_dates_id  number(10) NULL,
  use_project_baseline_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  last_baseline_update_date  DATE NULL,
  ts_rsrc_vw_compl_asgn_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  ts_rsrc_mark_act_finish_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  ts_rsrc_vw_inact_actv_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  cr_external_key  varchar2(4000 CHAR) NULL,
  apply_actuals_date  DATE NULL,
  description  varchar2(500 CHAR) NULL,
  intg_proj_type  varchar2(7 CHAR) NULL,
  matrix_id  number(10) NULL,
  location_id  number(10) NULL,
  last_schedule_date  DATE NULL,
  control_updates_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  hist_interval  varchar2(25 CHAR) DEFAULT 'Month' NOT NULL,
  hist_level  varchar2(10 CHAR) DEFAULT 'HL_None' NOT NULL,
  fintmpl_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJEST

--METADATA NAME:PROJEST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJEST(
  proj_est_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  applied_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_type  varchar2(10 CHAR) DEFAULT 'RT_Labor' NOT NULL,
  est_type  varchar2(20 CHAR) NOT NULL,
  est_name  varchar2(120 CHAR) NOT NULL,
  rsrc_id  number(10) NULL,
  bu_cmplx_value  number(10) NULL,
  adj_mult_pct  number(10) NULL,
  fp_cnt  number(10) NULL,
  fp_cmplx_value  number(10) NULL,
  fp_unadj_cnt  number(10) NULL,
  est_task_cnt  number(10) NULL,
  fp_prod_avg_value  number(10,2) NULL,
  est_qty  number(17,6) NULL,
  est_date  DATE NULL,
  est_notes  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(est_notes) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROJFUND

--METADATA NAME:PROJFUND TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJFUND(
  proj_fund_id  number(10) NOT NULL,
  fund_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  fund_cost  number(23,6) NULL,
  fund_wt  number(10,2) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJISSU

--METADATA NAME:PROJISSU TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJISSU(
  issue_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL,
  priority_type  varchar2(12 CHAR) NOT NULL,
  status_code  varchar2(12 CHAR) NOT NULL,
  issue_name  varchar2(100 CHAR) NOT NULL,
  thresh_id  number(10) NULL,
  track_view_id  number(10) NULL,
  wbs_id  number(10) NULL,
  task_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  thresh_parm_id  number(10) NULL,
  base_proj_id  number(10) NULL,
  workspace_id  number(10) NULL,
  issue_value  number(15,2) NULL,
  lo_parm_value  number(15,2) NULL,
  hi_parm_value  number(15,2) NULL,
  add_by_name  varchar2(255 CHAR) NULL,
  resolv_date  DATE NULL,
  add_date  DATE NULL,
  issue_notes  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(issue_notes) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROJPCAT

--METADATA NAME:PROJPCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPCAT(
  proj_id  number(10) NOT NULL,
  proj_catg_type_id  number(10) NOT NULL,
  proj_catg_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJPROP

--METADATA NAME:PROJPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPROP(
  proj_id  number(10) NOT NULL,
  prop_name  varchar2(32 CHAR) NOT NULL,
  prop_value  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(prop_value) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROJRISK

--METADATA NAME:PROJRISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJRISK(
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  add_date  DATE NULL,
  status_code  varchar2(12 CHAR) NOT NULL,
  risk_name  varchar2(200 CHAR) NOT NULL,
  risk_type_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  risk_descr  BLOB NULL,
  risk_to_type  varchar2(12 CHAR) DEFAULT 'RT_Threat' NOT NULL,
  identified_by_id  number(10) NULL,
  response_type  varchar2(12 CHAR) NULL,
  response_text  varchar2(255 CHAR) NULL,
  pre_rsp_prblty  varchar2(2 CHAR) NULL,
  pre_rsp_schd_prblty  varchar2(2 CHAR) NULL,
  pre_rsp_cost_prblty  varchar2(2 CHAR) NULL,
  post_rsp_prblty  varchar2(2 CHAR) NULL,
  post_rsp_schd_prblty  varchar2(2 CHAR) NULL,
  post_rsp_cost_prblty  varchar2(2 CHAR) NULL,
  risk_cause  varchar2(4000 CHAR) NULL,
  risk_effect  varchar2(4000 CHAR) NULL,
  notes  varchar2(4000 CHAR) NULL,
  risk_code  varchar2(40 CHAR) DEFAULT 0 NOT NULL,
  risk_desc  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(risk_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table PROJSHAR

--METADATA NAME:PROJSHAR TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJSHAR(
  proj_id  number(10) NOT NULL,
  session_id  number(10) NOT NULL,
  access_level  number(10) NOT NULL,
  load_status  char(1 CHAR) DEFAULT 'L' NOT NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJTHRS

--METADATA NAME:PROJTHRS TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJTHRS(
  thresh_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL,
  thresh_parm_id  number(10) NOT NULL,
  status_code  varchar2(12 CHAR) NOT NULL,
  priority_type  varchar2(12 CHAR) DEFAULT 'PT_Normal' NOT NULL,
  thresh_type  varchar2(12 CHAR) DEFAULT 'TM_WBS' NOT NULL,
  wbs_id  number(10) NULL,
  track_view_id  number(10) NULL,
  lo_parm_value  number(15,2) NULL,
  hi_parm_value  number(15,2) NULL,
  window_start  varchar2(50 CHAR) NULL,
  window_end  varchar2(50 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJWBS

--METADATA NAME:PROJWBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWBS(
  wbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  est_wt  number(10,2) NULL,
  proj_node_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  sum_data_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  wbs_short_name  varchar2(40 CHAR) NOT NULL,
  wbs_name  varchar2(100 CHAR) NOT NULL,
  phase_id  number(10) NULL,
  parent_wbs_id  number(10) NULL,
  ev_user_pct  number(10) NULL,
  ev_etc_user_value  number(10,2) NULL,
  orig_cost  number(23,6) NULL,
  indep_remain_total_cost  number(23,6) NULL,
  ann_dscnt_rate_pct  number(18,6) NULL,
  dscnt_period_type  varchar2(20 CHAR) NULL,
  indep_remain_work_qty  number(17,6) NULL,
  anticip_start_date  DATE NULL,
  anticip_end_date  DATE NULL,
  ev_compute_type  varchar2(20 CHAR) NULL,
  ev_etc_compute_type  varchar2(20 CHAR) NULL,
  resp_team_id  number(10) NULL,
  iteration_id  number(10) NULL,
  guid  varchar2(22 CHAR) NULL,
  tmpl_guid  varchar2(22 CHAR) NULL,
  original_qty  number(17,6) NULL,
  rqmt_rem_qty  number(17,6) NULL,
  intg_type  varchar2(100 CHAR) NULL,
  status_reviewer  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PROJWSRPT

--METADATA NAME:PROJWSRPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWSRPT(
  rpt_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PRPFOLIO

--METADATA NAME:PRPFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRPFOLIO(
  pfolio_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table PUBUSER

--METADATA NAME:PUBUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PUBUSER(
  public_group_id  number(10) NOT NULL,
  private_db_user_name  varchar2(255 CHAR) NOT NULL,
  private_db_passwd  varchar2(255 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table QUERYLIB

--METADATA NAME:QUERYLIB TYPE:TABLE CHANGE:CREATE

CREATE TABLE QUERYLIB(
  query_lib_id  number(10) NOT NULL,
  app_name  varchar2(25 CHAR) NOT NULL,
  core_flag  varchar2(1 CHAR) NOT NULL,
  match_sql  varchar2(4000 CHAR) NOT NULL,
  hints  varchar2(4000 CHAR) NULL,
  replacement_sql  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RCATTYPE

--METADATA NAME:RCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATTYPE(
  rsrc_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  rsrc_catg_short_len  number(10) NOT NULL,
  rsrc_catg_type  varchar2(40 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RCATVAL

--METADATA NAME:RCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATVAL(
  rsrc_catg_id  number(10) NOT NULL,
  rsrc_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  rsrc_catg_short_name  varchar2(32 CHAR) NOT NULL,
  rsrc_catg_name  varchar2(100 CHAR) NULL,
  parent_rsrc_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table REFRDEL

--METADATA NAME:REFRDEL TYPE:TABLE CHANGE:CREATE

CREATE TABLE REFRDEL(
  delete_date  DATE DEFAULT sysdate NOT NULL,
  table_name  varchar2(30 CHAR) NOT NULL,
  pk1  varchar2(255 CHAR) NOT NULL,
  pk2  varchar2(255 CHAR) NULL,
  pk3  varchar2(255 CHAR) NULL,
  pk4  varchar2(255 CHAR) NULL,
  proj_id  number(10) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table REITTYPE

--METADATA NAME:REITTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE REITTYPE(
  related_item_type_id  number(10) NOT NULL,
  related_item  varchar2(32 CHAR) NOT NULL,
  table_name  varchar2(30 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RELEASE

--METADATA NAME:RELEASE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELEASE(
  release_id  number(10) NOT NULL,
  rfolio_id  number(10) NULL,
  release_name  varchar2(60 CHAR) NOT NULL,
  start_date  DATE NOT NULL,
  proj_id  number(10) NOT NULL,
  release_theme  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RELITEMS

--METADATA NAME:RELITEMS TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELITEMS(
  item_type_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  related_item_type_id  number(10) NOT NULL,
  related_fk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RFOLIO

--METADATA NAME:RFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RFOLIO(
  rfolio_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  rfolio_name  varchar2(40 CHAR) NOT NULL,
  rfolio_type  varchar2(20 CHAR) NOT NULL,
  rfolio_descr  varchar2(255 CHAR) NULL,
  team_capacity_pct  number(10,2) NULL,
  parent_rfolio_id  number(10) NULL,
  rfolio_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rfolio_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RISKCTRL

--METADATA NAME:RISKCTRL TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKCTRL(
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  risk_control  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(risk_control) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RISKTYPE

--METADATA NAME:RISKTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKTYPE(
  risk_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  risk_type  varchar2(40 CHAR) NOT NULL,
  parent_risk_type_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RLFOLIO

--METADATA NAME:RLFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RLFOLIO(
  rlfolio_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  rlfolio_name  varchar2(40 CHAR) NOT NULL,
  rlfolio_type  varchar2(20 CHAR) NOT NULL,
  rlfolio_descr  varchar2(255 CHAR) NULL,
  rlfolio_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rlfolio_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ROLECATTYPE

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATTYPE(
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_len  number(10) NOT NULL,
  role_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLECATVAL

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATVAL(
  role_catg_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_name  varchar2(60 CHAR) NOT NULL,
  role_catg_name  varchar2(100 CHAR) NULL,
  parent_role_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLELIMIT

--METADATA NAME:ROLELIMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLELIMIT(
  rolelimit_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  max_qty_per_hr  number(16,8) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLERATE

--METADATA NAME:ROLERATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERATE(
  role_rate_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  start_date  DATE DEFAULT sysdate NOT NULL,
  max_qty_per_hr  number(16,8) DEFAULT 1 NULL,
  cost_per_qty  number(21,8) NULL,
  cost_per_qty2  number(21,8) NULL,
  cost_per_qty3  number(21,8) NULL,
  cost_per_qty4  number(21,8) NULL,
  cost_per_qty5  number(21,8) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLERCAT

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERCAT(
  role_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  role_catg_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table ROLES

--METADATA NAME:ROLES TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLES(
  role_id  number(10) NOT NULL,
  role_short_name  varchar2(40 CHAR) NOT NULL,
  role_name  varchar2(100 CHAR) NOT NULL,
  seq_num  number(10) NOT NULL,
  parent_role_id  number(10) NULL,
  def_cost_qty_link_flag  varchar2(1 CHAR) NOT NULL,
  cost_qty_type  varchar2(24 CHAR) DEFAULT 'QT_Hour' NOT NULL,
  pobs_id  number(10) NULL,
  role_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(role_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table ROLFOLIO

--METADATA NAME:ROLFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLFOLIO(
  rlfolio_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RPT

--METADATA NAME:RPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPT(
  rpt_id  number(10) NOT NULL,
  global_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rpt_type  varchar2(12 CHAR) NOT NULL,
  rpt_name  varchar2(80 CHAR) NOT NULL,
  rpt_area  varchar2(32 CHAR) DEFAULT 'Unknown' NOT NULL,
  rpt_group_id  number(10) NULL,
  proj_id  number(10) NULL,
  rpt_state  varchar2(10 CHAR) NULL,
  rpt_data  BLOB NULL,
  last_run_date  DATE NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rpt_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RPTBATCH

--METADATA NAME:RPTBATCH TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTBATCH(
  rpt_batch_id  number(10) NOT NULL,
  rpt_batch_name  varchar2(80 CHAR) NOT NULL,
  proj_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RPTGROUP

--METADATA NAME:RPTGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTGROUP(
  rpt_group_id  number(10) NOT NULL,
  rpt_group_seq_num  number(10) NOT NULL,
  rpt_group_name  varchar2(80 CHAR) NOT NULL,
  parent_group_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RPTLIST

--METADATA NAME:RPTLIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTLIST(
  rpt_batch_id  number(10) NOT NULL,
  rpt_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRC

--METADATA NAME:RSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRC(
  rsrc_id  number(10) NOT NULL,
  clndr_id  number(10) NOT NULL,
  rsrc_seq_num  number(10) NOT NULL,
  timesheet_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  active_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  rsrc_type  varchar2(10 CHAR) DEFAULT 'RT_Labor' NOT NULL,
  auto_compute_act_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  ot_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  def_cost_qty_link_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_short_name  varchar2(255 CHAR) NOT NULL,
  rsrc_name  varchar2(255 CHAR) NOT NULL,
  parent_rsrc_id  number(10) NULL,
  xfer_complete_day_cnt  number(10) NULL,
  xfer_notstart_day_cnt  number(10) NULL,
  ts_approve_user_id  number(10) NULL,
  user_id  number(10) NULL,
  role_id  number(10) NULL,
  curr_id  number(10) DEFAULT 1 NOT NULL,
  last_checksum  number(10) NULL,
  shift_id  number(10) NULL,
  ot_factor  number(10,3) NULL,
  def_qty_per_hr  number(16,8) NULL,
  guid  varchar2(22 CHAR) NULL,
  cost_qty_type  varchar2(24 CHAR) NULL,
  office_phone  varchar2(32 CHAR) NULL,
  other_phone  varchar2(32 CHAR) NULL,
  employee_code  varchar2(40 CHAR) NULL,
  rsrc_title_name  varchar2(100 CHAR) NULL,
  email_addr  varchar2(120 CHAR) NULL,
  unit_id  number(10) NULL,
  pobs_id  number(10) NULL,
  rsrc_notes  BLOB NULL,
  intg_type  varchar2(100 CHAR) NULL,
  update_date  DATE NULL,
  location_id  number(10) NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rsrc_notes) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RSRCANDASH

--METADATA NAME:RSRCANDASH TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCANDASH(
  dashboard_id  number(10) NOT NULL,
  rsrcan_view_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCANVIEW

--METADATA NAME:RSRCANVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCANVIEW(
  rsrcan_view_id  number(10) NOT NULL,
  rsrcan_view_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  rsrcan_view_type  varchar2(20 CHAR) NULL,
  rsrcan_view_data  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCCURV

--METADATA NAME:RSRCCURV TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCCURV(
  curv_id  number(10) NOT NULL,
  curv_name  varchar2(60 CHAR) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  curv_data  BLOB NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(curv_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table RSRCHOUR

--METADATA NAME:RSRCHOUR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCHOUR(
  rsrc_hr_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  ts_id  number(10) NOT NULL,
  task_ts_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  taskrsrc_id  number(10) NULL,
  nonwork_type_id  number(10) NULL,
  proj_id  number(10) NULL,
  pend_hr_cnt  number(10,2) NULL,
  hr_cnt  number(10,2) NULL,
  pend_ot_hr_cnt  number(10,2) NULL,
  ot_hr_cnt  number(10,2) NULL,
  work_date  DATE NULL,
  status_code  varchar2(20 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCPROP

--METADATA NAME:RSRCPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCPROP(
  rsrc_id  number(10) NOT NULL,
  prop_name  varchar2(20 CHAR) NOT NULL,
  prop_value  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCRATE

--METADATA NAME:RSRCRATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRATE(
  rsrc_rate_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  shift_period_id  number(10) NULL,
  max_qty_per_hr  number(16,8) NULL,
  cost_per_qty  number(21,8) NULL,
  cost_per_qty2  number(21,8) NULL,
  cost_per_qty3  number(21,8) NULL,
  cost_per_qty4  number(21,8) NULL,
  cost_per_qty5  number(21,8) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCRCAT

--METADATA NAME:RSRCRCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRCAT(
  rsrc_id  number(10) NOT NULL,
  rsrc_catg_type_id  number(10) NOT NULL,
  rsrc_catg_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCROLE

--METADATA NAME:RSRCROLE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLE(
  rsrc_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  skill_level  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRCSEC

--METADATA NAME:RSRCSEC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCSEC(
  user_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table RSRFOLIO

--METADATA NAME:RSRFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRFOLIO(
  rfolio_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SCENARIO

--METADATA NAME:SCENARIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENARIO(
  scenario_id  number(10) NOT NULL,
  scenario_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  table_name  varchar2(30 CHAR) NULL,
  fk_id  number(10) NULL,
  scenario_type  varchar2(30 CHAR) NULL,
  view_pref_id  number(10) NULL,
  view_type  varchar2(30 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SCENPROJ

--METADATA NAME:SCENPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENPROJ(
  scenario_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  selected_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SCENROLE

--METADATA NAME:SCENROLE TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENROLE(
  scenario_id  number(10) NOT NULL,
  role_id  number(10) NOT NULL,
  selected_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SCENUSER

--METADATA NAME:SCENUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENUSER(
  scenario_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SETTINGS

--METADATA NAME:SETTINGS TYPE:TABLE CHANGE:CREATE

CREATE TABLE SETTINGS(
  namespace  varchar2(255 CHAR) NOT NULL,
  setting_name  varchar2(255 CHAR) NOT NULL,
  setting_value  varchar2(4000 CHAR) NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SHIFT

--METADATA NAME:SHIFT TYPE:TABLE CHANGE:CREATE

CREATE TABLE SHIFT(
  shift_id  number(10) NOT NULL,
  shift_name  varchar2(60 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SHIFTPER

--METADATA NAME:SHIFTPER TYPE:TABLE CHANGE:CREATE

CREATE TABLE SHIFTPER(
  shift_period_id  number(10) NOT NULL,
  shift_id  number(10) NOT NULL,
  shift_start_hr_num  number(10,3) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SPIDMAP

--METADATA NAME:SPIDMAP TYPE:TABLE CHANGE:CREATE

CREATE TABLE SPIDMAP(
  spid  number(10) NOT NULL,
  user_id  number(10) NULL,
  user_name  varchar2(255 CHAR) NULL,
  app_name  varchar2(25 CHAR) NULL,
  refrdel_project_bypass  number(10) NULL,
  audit_info_extended  BLOB NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(audit_info_extended) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table SUMPROJCOST

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMPROJCOST(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  cost_type_id  number(10) NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  act_cost  number(23,6) NULL,
  remain_cost  number(23,6) NULL,
  target_cost  number(23,6) NULL,
  total_cost  number(23,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SUMTASK

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTASK(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  complete_cnt  number(10) NULL,
  active_cnt  number(10) NULL,
  notstarted_cnt  number(10) NULL,
  base_complete_cnt  number(10) NULL,
  base_active_cnt  number(10) NULL,
  base_notstarted_cnt  number(10) NULL,
  act_drtn_hr_cnt  number(17,6) NULL,
  total_drtn_hr_cnt  number(17,6) NULL,
  base_drtn_hr_cnt  number(17,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  total_float_hr_cnt  number(17,6) NULL,
  act_end_date  DATE NULL,
  act_start_date  DATE NULL,
  base_end_date  DATE NULL,
  base_start_date  DATE NULL,
  reend_date  DATE NULL,
  restart_date  DATE NULL,
  act_this_per_work_cost  number(25,6) NULL,
  act_this_per_work_qty  number(22,6) NULL,
  act_this_per_equip_cost  number(25,6) NULL,
  act_this_per_equip_qty  number(22,6) NULL,
  act_this_per_mat_cost  number(25,6) NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  target_drtn_hr_cnt  number(17,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SUMTASKSPREAD

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTASKSPREAD(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  end_date  DATE NOT NULL,
  spread_type  varchar2(20 CHAR) NOT NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  late_remain_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  fin_period_act_work_qty  number(22,6) NULL,
  fin_period_act_work_cost  number(25,6) NULL,
  fin_period_act_equip_qty  number(22,6) NULL,
  fin_period_act_equip_cost  number(25,6) NULL,
  fin_period_act_mat_cost  number(25,6) NULL,
  fin_period_act_expense_cost  number(25,6) NULL,
  fin_period_total_work_qty  number(22,6) NULL,
  fin_period_total_work_cost  number(25,6) NULL,
  fin_period_total_equip_qty  number(22,6) NULL,
  fin_period_total_equip_cost  number(25,6) NULL,
  fin_period_total_mat_cost  number(25,6) NULL,
  fin_period_total_expense_cost  number(25,6) NULL,
  fin_period_total_cost  number(25,6) NULL,
  fin_period_act_cost  number(25,6) NULL,
  fin_period_bcwp  number(25,6) NULL,
  fin_period_perfm_work_qty  number(22,6) NULL,
  fin_period_eac  number(25,6) NULL,
  fin_period_eac_work_qty  number(22,6) NULL,
  fin_period_bcws  number(25,6) NULL,
  fin_period_sched_work_qty  number(22,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table SUMTRSRC

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTRSRC(
  sumtrsrc_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  wbs_id  number(10) NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  remain_start_date  DATE NULL,
  remain_end_date  DATE NULL,
  overalloc_date  DATE NULL,
  staffed_act_qty  number(23,6) NULL,
  unstaffed_act_qty  number(23,6) NULL,
  staffed_act_cost  number(23,6) NULL,
  unstaffed_act_cost  number(23,6) NULL,
  staffed_act_ot_qty  number(23,6) NULL,
  unstaffed_act_ot_qty  number(23,6) NULL,
  staffed_act_ot_cost  number(23,6) NULL,
  unstaffed_act_ot_cost  number(23,6) NULL,
  staffed_act_reg_cost  number(23,6) NULL,
  unstaffed_act_reg_cost  number(23,6) NULL,
  staffed_act_reg_qty  number(23,6) NULL,
  unstaffed_act_reg_qty  number(23,6) NULL,
  staffed_late_remain_qty  number(23,6) NULL,
  unstaffed_late_remain_qty  number(23,6) NULL,
  staffed_late_remain_cost  number(23,6) NULL,
  unstaffed_late_remain_cost  number(23,6) NULL,
  staffed_remain_qty  number(23,6) NULL,
  unstaffed_remain_qty  number(23,6) NULL,
  staffed_remain_cost  number(23,6) NULL,
  unstaffed_remain_cost  number(23,6) NULL,
  staffed_target_qty  number(23,6) NULL,
  unstaffed_target_qty  number(23,6) NULL,
  staffed_target_cost  number(23,6) NULL,
  unstaffed_target_cost  number(23,6) NULL,
  staffed_total_qty  number(23,6) NULL,
  unstaffed_total_qty  number(23,6) NULL,
  staffed_total_cost  number(23,6) NULL,
  unstaffed_total_cost  number(23,6) NULL,
  fin_period_act_qty  number(23,6) NULL,
  fin_period_act_cost  number(23,6) NULL,
  fin_period_total_qty  number(23,6) NULL,
  fin_period_total_cost  number(23,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASK

--METADATA NAME:TASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASK(
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  clndr_id  number(10) NOT NULL,
  est_wt  number(10,2) NULL,
  phys_complete_pct  number(10,2) DEFAULT 0 NOT NULL,
  rev_fdbk_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  lock_plan_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  auto_compute_act_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  complete_pct_type  varchar2(10 CHAR) DEFAULT 'CP_Drtn' NOT NULL,
  task_type  varchar2(10 CHAR) NOT NULL,
  duration_type  varchar2(12 CHAR) NOT NULL,
  review_type  varchar2(12 CHAR) DEFAULT 'RV_OK' NOT NULL,
  status_code  varchar2(12 CHAR) NOT NULL,
  task_code  varchar2(40 CHAR) NOT NULL,
  task_name  varchar2(120 CHAR) NOT NULL,
  rsrc_id  number(10) NULL,
  total_float_hr_cnt  number(17,6) NULL,
  free_float_hr_cnt  number(17,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  act_work_qty  number(17,6) NULL,
  remain_work_qty  number(17,6) NULL,
  target_work_qty  number(17,6) NULL,
  target_drtn_hr_cnt  number(17,6) NULL,
  target_equip_qty  number(17,6) NULL,
  act_equip_qty  number(17,6) NULL,
  remain_equip_qty  number(17,6) NULL,
  cstr_date  DATE NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  late_start_date  DATE NULL,
  late_end_date  DATE NULL,
  expect_end_date  DATE NULL,
  early_start_date  DATE NULL,
  early_end_date  DATE NULL,
  restart_date  DATE NULL,
  reend_date  DATE NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  review_end_date  DATE NULL,
  rem_late_start_date  DATE NULL,
  rem_late_end_date  DATE NULL,
  cstr_type  varchar2(12 CHAR) NULL,
  priority_type  varchar2(12 CHAR) NULL,
  guid  varchar2(22 CHAR) NULL,
  tmpl_guid  varchar2(22 CHAR) NULL,
  cstr_date2  DATE NULL,
  cstr_type2  varchar2(12 CHAR) NULL,
  float_path  number(10) NULL,
  float_path_order  number(10) NULL,
  act_this_per_work_qty  number(17,6) NULL,
  act_this_per_equip_qty  number(17,6) NULL,
  driving_path_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  suspend_date  DATE NULL,
  resume_date  DATE NULL,
  external_early_start_date  DATE NULL,
  external_late_end_date  DATE NULL,
  location_id  number(10) NULL,
  control_updates_flag  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKACTV

--METADATA NAME:TASKACTV TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKACTV(
  task_id  number(10) NOT NULL,
  actv_code_type_id  number(10) NOT NULL,
  actv_code_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKDOC

--METADATA NAME:TASKDOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKDOC(
  taskdoc_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  wp_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  task_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKFDBK

--METADATA NAME:TASKFDBK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFDBK(
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_fdbk  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(task_fdbk) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKFIN

--METADATA NAME:TASKFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFIN(
  fin_dates_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  act_work_qty  number(17,6) NULL,
  act_work_cost  number(23,6) NULL,
  act_equip_qty  number(17,6) NULL,
  act_equip_cost  number(23,6) NULL,
  act_mat_cost  number(23,6) NULL,
  act_expense_cost  number(23,6) NULL,
  bcwp  number(23,6) NULL,
  sched_work_qty  number(17,6) NULL,
  bcws  number(23,6) NULL,
  perfm_work_qty  number(17,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKMEMO

--METADATA NAME:TASKMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKMEMO(
  memo_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  memo_type_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_memo  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(task_memo) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKNOTE

--METADATA NAME:TASKNOTE TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKNOTE(
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_notes  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(task_notes) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKPRED

--METADATA NAME:TASKPRED TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPRED(
  task_pred_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  pred_task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  pred_proj_id  number(10) NOT NULL,
  pred_type  varchar2(12 CHAR) NOT NULL,
  lag_hr_cnt  number(17,6) NULL,
  comments  varchar2(250 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKPROC

--METADATA NAME:TASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPROC(
  proc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  complete_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  proc_name  varchar2(120 CHAR) NOT NULL,
  proc_wt  number(10,2) NULL,
  complete_pct  number(10,2) NULL,
  proc_descr  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(proc_descr) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKRISK

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRISK(
  task_id  number(10) NOT NULL,
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKRSRC

--METADATA NAME:TASKRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRSRC(
  taskrsrc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  rsrc_type  varchar2(10 CHAR) DEFAULT 'RT_Labor' NOT NULL,
  cost_qty_link_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  role_id  number(10) NULL,
  acct_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  pobs_id  number(10) NULL,
  skill_level  number(10) NULL,
  pend_complete_pct  number(10,2) NULL,
  remain_qty  number(17,6) NULL,
  pend_remain_qty  number(17,6) NULL,
  target_qty  number(17,6) NULL,
  remain_qty_per_hr  number(16,8) NULL,
  pend_act_reg_qty  number(17,6) NULL,
  target_lag_drtn_hr_cnt  number(17,6) NULL,
  target_qty_per_hr  number(16,8) NULL,
  act_ot_qty  number(17,6) NULL,
  pend_act_ot_qty  number(17,6) NULL,
  act_reg_qty  number(17,6) NULL,
  relag_drtn_hr_cnt  number(17,6) NULL,
  ot_factor  number(10,3) NULL,
  cost_per_qty  number(21,8) NULL,
  target_cost  number(23,6) NULL,
  act_reg_cost  number(23,6) NULL,
  act_ot_cost  number(23,6) NULL,
  remain_cost  number(23,6) NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  restart_date  DATE NULL,
  reend_date  DATE NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  rem_late_start_date  DATE NULL,
  rem_late_end_date  DATE NULL,
  guid  varchar2(22 CHAR) NULL,
  rate_type  varchar2(14 CHAR) DEFAULT 'COST_PER_QTY' NULL,
  act_this_per_cost  number(23,6) NULL,
  act_this_per_qty  number(17,6) NULL,
  curv_id  number(10) NULL,
  rollup_dates_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  cost_per_qty_source_type  varchar2(24 CHAR) DEFAULT 'ST_Rsrc' NOT NULL,
  remain_crv  varchar2(4000 CHAR) NULL,
  target_crv  varchar2(4000 CHAR) NULL,
  actual_crv  varchar2(4000 CHAR) NULL,
  rsrc_request_data  BLOB NULL,
  ts_pend_act_end_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  prior_ts_act_reg_qty  number(17,6) NULL,
  prior_ts_act_ot_qty  number(17,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(rsrc_request_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKSUM

--METADATA NAME:TASKSUM TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKSUM(
  task_sum_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  complete_cnt  number(10) NULL,
  active_cnt  number(10) NULL,
  notstarted_cnt  number(10) NULL,
  base_complete_cnt  number(10) NULL,
  base_active_cnt  number(10) NULL,
  base_notstarted_cnt  number(10) NULL,
  act_drtn_hr_cnt  number(17,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  total_drtn_hr_cnt  number(17,6) NULL,
  base_drtn_hr_cnt  number(17,6) NULL,
  base_work_qty  number(22,6) NULL,
  base_equip_qty  number(22,6) NULL,
  etc_work_qty  number(22,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  remain_work_qty  number(22,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  total_float_hr_cnt  number(17,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  bcwp  number(25,6) NULL,
  etc  number(25,6) NULL,
  bcws  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  act_end_date  DATE NULL,
  act_start_date  DATE NULL,
  base_end_date  DATE NULL,
  base_start_date  DATE NULL,
  reend_date  DATE NULL,
  restart_date  DATE NULL,
  act_this_per_work_cost  number(25,6) NULL,
  act_this_per_work_qty  number(22,6) NULL,
  act_this_per_equip_cost  number(25,6) NULL,
  act_this_per_equip_qty  number(22,6) NULL,
  base_mat_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_this_per_mat_cost  number(25,6) NULL,
  spread_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(spread_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TASKSUMFIN

--METADATA NAME:TASKSUMFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKSUMFIN(
  task_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_sum_id  number(10) NOT NULL,
  act_work_qty  number(22,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  total_work_qty  number(22,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_cost  number(23,6) NULL,
  act_cost  number(23,6) NULL,
  bcwp  number(25,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  eac  number(25,6) NULL,
  eac_work  number(22,6) NULL,
  bcws  number(25,6) NULL,
  acwp  number(25,6) NULL,
  sched_work_qty  number(22,6) NULL,
  base_cost  number(23,6) NULL,
  base_work_qty  number(22,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_expense_cost  number(25,6) NULL,
  remain_cost  number(23,6) NULL,
  remain_work_qty  number(22,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  target_cost  number(23,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_work_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_cost  number(23,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKUSER

--METADATA NAME:TASKUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKUSER(
  task_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TASKWKSP

--METADATA NAME:TASKWKSP TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKWKSP(
  workspace_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  cr_external_key  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TEMPKEYS

--METADATA NAME:TEMPKEYS TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE TEMPKEYS(
  pk1  number(10) NULL,
  pk2  number(10) NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table THRSPARM

--METADATA NAME:THRSPARM TYPE:TABLE CHANGE:CREATE

CREATE TABLE THRSPARM(
  thresh_parm_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  wbs_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  task_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  rsrc_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  thresh_parm_type  varchar2(12 CHAR) NOT NULL,
  thresh_parm_name  varchar2(80 CHAR) NOT NULL,
  thresh_field_name  varchar2(40 CHAR) NULL,
  thresh_short_name  varchar2(80 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TIMESHT

--METADATA NAME:TIMESHT TYPE:TABLE CHANGE:CREATE

CREATE TABLE TIMESHT(
  ts_id  number(10) NOT NULL,
  rsrc_id  number(10) NOT NULL,
  daily_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  status_code  varchar2(20 CHAR) NOT NULL,
  user_id  number(10) NULL,
  last_recv_date  DATE NULL,
  status_date  DATE NULL,
  ts_notes  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(ts_notes) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TMPLCATG

--METADATA NAME:TMPLCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE TMPLCATG(
  tmplcatg_catg_id  number(10) NOT NULL,
  catg_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  process_flag  varchar2(1 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TPROJMAP

--METADATA NAME:TPROJMAP TYPE:TABLE CHANGE:CREATE

CREATE GLOBAL TEMPORARY TABLE TPROJMAP(
  session_id  number(10) NOT NULL,
  context_id  number(10) NOT NULL,
  source_proj_id  number(10) NOT NULL,
  target_proj_id  number(10) NOT NULL,
  target_wbs_id  number(10) NOT NULL
  )
ON COMMIT PRESERVE ROWS
/

prompt Creating table TRAKVIEW

--METADATA NAME:TRAKVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRAKVIEW(
  track_view_id  number(10) NOT NULL,
  display_type  varchar2(12 CHAR) NOT NULL,
  track_view_name  varchar2(80 CHAR) NOT NULL,
  web_view_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  user_id  number(10) NULL,
  track_view_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(track_view_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TRSRCFIN

--METADATA NAME:TRSRCFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCFIN(
  fin_dates_id  number(10) NOT NULL,
  taskrsrc_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  act_qty  number(17,6) NULL,
  act_cost  number(23,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TRSRCSUM

--METADATA NAME:TRSRCSUM TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCSUM(
  taskrsrc_sum_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  skill_level  number(10) NULL,
  overalloc_date  DATE NULL,
  spread_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(spread_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table TRSRCSUMFN

--METADATA NAME:TRSRCSUMFN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCSUMFN(
  trsrc_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  taskrsrc_sum_id  number(10) NOT NULL,
  act_qty  number(17,6) NULL,
  act_cost  number(23,6) NULL,
  act_ot_qty  number(17,6) NULL,
  act_reg_qty  number(17,6) NULL,
  act_ot_cost  number(23,6) NULL,
  act_reg_cost  number(23,6) NULL,
  total_qty  number(22,6) NULL,
  total_cost  number(23,6) NULL,
  remain_qty  number(17,6) NULL,
  remain_cost  number(23,6) NULL,
  target_qty  number(19,6) NULL,
  target_cost  number(23,6) NULL,
  staffed_remain_qty  number(17,6) NULL,
  unstaffed_remain_qty  number(17,6) NULL,
  staffed_remain_cost  number(25,6) NULL,
  unstaffed_remain_cost  number(25,6) NULL,
  staffed_late_remain_qty  number(17,6) NULL,
  unstaffed_late_remain_qty  number(17,6) NULL,
  staffed_late_remain_cost  number(25,6) NULL,
  unstaffed_late_remain_cost  number(25,6) NULL,
  late_remain_qty  number(17,6) NULL,
  late_remain_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TSAUDIT

--METADATA NAME:TSAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSAUDIT(
  ts_audit_id  number(10) NOT NULL,
  audit_date  DATE NULL,
  rsrc_id  number(10) NULL,
  rsrc_short_name  varchar2(255 CHAR) NULL,
  rsrc_name  varchar2(255 CHAR) NULL,
  ts_status_code  varchar2(20 CHAR) NULL,
  reg_hrs  number(17,6) NULL,
  reg_ot_hrs  number(17,6) NULL,
  pend_reg_hrs  number(17,6) NULL,
  pend_reg_ot_hrs  number(17,6) NULL,
  oh_hrs  number(17,6) NULL,
  oh_ot_hrs  number(17,6) NULL,
  pend_oh_hrs  number(17,6) NULL,
  pend_oh_ot_hrs  number(17,6) NULL,
  ts_id  number(10) NULL,
  ts_start_date  DATE NULL,
  ts_end_date  DATE NULL,
  proj_id  number(10) NULL,
  proj_short_name  varchar2(40 CHAR) NULL,
  ts_task_status  varchar2(20 CHAR) NULL,
  user_id  number(10) NULL,
  user_name  varchar2(255 CHAR) NULL,
  approving_as  varchar2(50 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TSDATES

--METADATA NAME:TSDATES TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSDATES(
  ts_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  end_date  DATE NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table TSDELEGATE

--METADATA NAME:TSDELEGATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSDELEGATE(
  ts_delegate_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  ts_delegate_user_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  active_flag  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UACCESS

--METADATA NAME:UACCESS TYPE:TABLE CHANGE:CREATE

CREATE TABLE UACCESS(
  user_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  access_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  wbs_id  number(10) NULL,
  parent_wbs_id  number(10) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UDFCODE

--METADATA NAME:UDFCODE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFCODE(
  udf_code_id  number(10) NOT NULL,
  udf_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  short_name  varchar2(60 CHAR) NOT NULL,
  udf_code_name  varchar2(120 CHAR) NOT NULL,
  parent_udf_code_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UDFTYPE

--METADATA NAME:UDFTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFTYPE(
  udf_type_id  number(10) NOT NULL,
  table_name  varchar2(30 CHAR) NOT NULL,
  udf_type_name  varchar2(32 CHAR) NOT NULL,
  udf_type_label  varchar2(40 CHAR) NOT NULL,
  logical_data_type  varchar2(20 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  udf_code_short_len  number(10) NULL,
  formula  varchar2(4000 CHAR) NULL,
  indicator_expression  varchar2(4000 CHAR) NULL,
  disp_data_flag  varchar2(1 CHAR) DEFAULT 'Y' NULL,
  disp_indicator_flag  varchar2(1 CHAR) DEFAULT 'Y' NULL,
  summary_indicator_expression  varchar2(4000 CHAR) NULL,
  summary_method  varchar2(20 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UDFVALUE

--METADATA NAME:UDFVALUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFVALUE(
  udf_type_id  number(10) NOT NULL,
  fk_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  udf_date  DATE NULL,
  udf_text  varchar2(255 CHAR) NULL,
  udf_number  NUMBER NULL,
  udf_code_id  number(10) NULL,
  table_name  varchar2(30 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UEVNTREG

--METADATA NAME:UEVNTREG TYPE:TABLE CHANGE:CREATE

CREATE TABLE UEVNTREG(
  user_id  number(10) NOT NULL,
  app_name  varchar2(255 CHAR) NOT NULL,
  operation_name  varchar2(255 CHAR) NOT NULL,
  action_name  varchar2(255 CHAR) NOT NULL,
  action_level  number(10) NULL,
  user_name  varchar2(255 CHAR) NULL,
  event_reg_data  varchar2(4000 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UMEASURE

--METADATA NAME:UMEASURE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UMEASURE(
  unit_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  unit_name  varchar2(100 CHAR) NOT NULL,
  unit_abbrev  varchar2(16 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table UPKLIST

--METADATA NAME:UPKLIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE UPKLIST(
  session_id  number(10) NOT NULL,
  context_id  number(10) NULL,
  pk_id  number(10) NOT NULL,
  pk2_id  number(10) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USERCOL

--METADATA NAME:USERCOL TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERCOL(
  user_col_id  number(10) NOT NULL,
  table_name  varchar2(16 CHAR) NOT NULL,
  logical_data_type  varchar2(20 CHAR) NOT NULL,
  user_col_name  varchar2(32 CHAR) NOT NULL,
  user_col_label  varchar2(40 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USERDATA

--METADATA NAME:USERDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERDATA(
  user_data_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  topic_name  varchar2(20 CHAR) NOT NULL,
  user_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(user_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table USERENG

--METADATA NAME:USERENG TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERENG(
  user_eng_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  db_engine_type  varchar2(20 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USEROBS

--METADATA NAME:USEROBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROBS(
  user_id  number(10) NOT NULL,
  obs_id  number(10) NOT NULL,
  prof_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USEROPEN

--METADATA NAME:USEROPEN TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROPEN(
  user_open_id  number(10) NOT NULL,
  user_open_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USERS

--METADATA NAME:USERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERS(
  user_id  number(10) NOT NULL,
  global_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  email_type  varchar2(16 CHAR) DEFAULT 'ET_Internet' NOT NULL,
  user_name  varchar2(255 CHAR) NOT NULL,
  prof_id  number(10) NULL,
  curr_id  number(10) DEFAULT 1 NOT NULL,
  all_rsrc_access_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  report_user_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  guid  varchar2(22 CHAR) NULL,
  email_srv_user_name  varchar2(32 CHAR) NULL,
  office_phone  varchar2(32 CHAR) NULL,
  actual_name  varchar2(255 CHAR) NULL,
  email_send_server  varchar2(120 CHAR) NULL,
  email_addr  varchar2(120 CHAR) NULL,
  email_srv_passwd  varchar2(255 CHAR) NULL,
  passwd  varchar2(255 CHAR) NULL,
  notify_prefs  varchar2(255 CHAR) NULL,
  navi_view_id  number(10) NULL,
  override_naviview_flag  varchar2(1 CHAR) NULL,
  ui_view_pref_id  number(10) NULL,
  cr_external_key  varchar2(4000 CHAR) NULL,
  cr_user_name  varchar2(255 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL,
  failed_login_attempts_cnt  number(10) DEFAULT 0 NULL,
  global_usr_pref  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USERSET

--METADATA NAME:USERSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERSET(
  namespace  varchar2(255 CHAR) NOT NULL,
  setting_name  varchar2(255 CHAR) NOT NULL,
  setting_value  varchar2(4000 CHAR) NULL,
  user_id  number(10) NOT NULL,
  userset_blob  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(userset_blob) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table USERWKSP

--METADATA NAME:USERWKSP TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERWKSP(
  user_id  number(10) NOT NULL,
  workspace_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USER_ACCEPTANCE_CONSENT

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE USER_ACCEPTANCE_CONSENT(
  user_id  number(10) NOT NULL,
  status  number(10) NULL,
  modified_date  DATE DEFAULT sysdate NULL,
  consent_type  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USESSAUD

--METADATA NAME:USESSAUD TYPE:TABLE CHANGE:CREATE

CREATE TABLE USESSAUD(
  session_id  number(10) NULL,
  login_date  DATE NULL,
  logout_date  DATE NULL,
  last_active_time  DATE NULL,
  user_name  varchar2(255 CHAR) NULL,
  user_id  number(10) NULL,
  host_name  varchar2(50 CHAR) NULL,
  app_name  varchar2(25 CHAR) NULL,
  hard_drive_code  varchar2(40 CHAR) NULL,
  db_engine_type  varchar2(20 CHAR) NULL,
  os_user_name  varchar2(255 CHAR) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USESSION

--METADATA NAME:USESSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE USESSION(
  session_id  number(10) NOT NULL,
  login_time  DATE NOT NULL,
  last_active_time  DATE NOT NULL,
  host_name  varchar2(50 CHAR) NOT NULL,
  user_id  number(10) NULL,
  process_num  number(10) NULL,
  app_name  varchar2(25 CHAR) NULL,
  hard_drive_code  varchar2(40 CHAR) NULL,
  db_engine_type  varchar2(20 CHAR) NULL,
  os_user_name  varchar2(255 CHAR) NULL,
  vdb_instance_guid  varchar2(22 CHAR) NULL,
  spid  number(10) NULL,
  operation_name  varchar2(255 CHAR) NULL,
  operation_start_date  DATE NULL,
  long_operation_flag  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table USROPNVAL

--METADATA NAME:USROPNVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE USROPNVAL(
  user_open_id  number(10) NOT NULL,
  pk_id  number(10) NOT NULL,
  usropn_type  varchar2(20 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table VIEWPREF

--METADATA NAME:VIEWPREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE VIEWPREF(
  view_pref_id  number(10) NOT NULL,
  view_pref_name  varchar2(255 CHAR) NOT NULL,
  view_pref_type  varchar2(20 CHAR) NOT NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table VIEWPROP

--METADATA NAME:VIEWPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE VIEWPROP(
  view_id  number(10) NOT NULL,
  view_name  varchar2(40 CHAR) NOT NULL,
  user_id  number(10) NULL,
  proj_id  number(10) NULL,
  view_type  varchar2(20 CHAR) NULL,
  view_data  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(view_data) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table VWPREFDASH

--METADATA NAME:VWPREFDASH TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFDASH(
  dashboard_id  number(10) NOT NULL,
  view_pref_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table VWPREFDATA

--METADATA NAME:VWPREFDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFDATA(
  view_pref_id  number(10) NOT NULL,
  view_pref_key  varchar2(255 CHAR) NOT NULL,
  view_pref_value  varchar2(4000 CHAR) NULL,
  view_pref_value_blob  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(view_pref_value_blob) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table VWPREFUSER

--METADATA NAME:VWPREFUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFUSER(
  view_pref_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBRSCAT

--METADATA NAME:WBRSCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBRSCAT(
  wbrs_cat_id  number(10) NOT NULL,
  wbrs_cat_name  varchar2(36 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSBUDG

--METADATA NAME:WBSBUDG TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSBUDG(
  wbs_budg_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  spend_cost  number(23,6) NULL,
  benefit_cost  number(23,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSMEMO

--METADATA NAME:WBSMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSMEMO(
  wbs_memo_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  memo_type_id  number(10) NOT NULL,
  wbs_memo  BLOB NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(wbs_memo) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

prompt Creating table WBSRSRC

--METADATA NAME:WBSRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC(
  wbsrsrc_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  rsrc_id  number(10) NULL,
  proj_id  number(10) NOT NULL,
  committed_flag  varchar2(1 CHAR) DEFAULT 'Y' NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  auto_compute_dates_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  role_id  number(10) NULL,
  rsrc_request_data  varchar2(4000 CHAR) NULL,
  allocation_pct  number(10,2) NULL,
  wbrs_cat_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSRSRC_QTY

--METADATA NAME:WBSRSRC_QTY TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC_QTY(
  wbsrsrc_id  number(10) NOT NULL,
  week_start  DATE NOT NULL,
  month_start  DATE NOT NULL,
  qty  number(17,6) NOT NULL,
  fin_dates_id1  number(10) NULL,
  fin_qty1  number(17,6) NULL,
  fin_dates_id2  number(10) NULL,
  fin_qty2  number(17,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WBSSTEP

--METADATA NAME:WBSSTEP TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSTEP(
  wbs_step_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  complete_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  step_name  varchar2(120 CHAR) NOT NULL,
  step_wt  number(10,2) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WKFLTMPL

--METADATA NAME:WKFLTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE WKFLTMPL(
  wkfl_tmpl_id  number(10) NOT NULL,
  template_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  wk_external_key  varchar2(255 CHAR) NULL,
  tmplcatg_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WKFLUSER

--METADATA NAME:WKFLUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE WKFLUSER(
  work_flow_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  stage_num  number(10) NOT NULL,
  comments  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WORKFLOW

--METADATA NAME:WORKFLOW TYPE:TABLE CHANGE:CREATE

CREATE TABLE WORKFLOW(
  work_flow_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  workflow_name  varchar2(255 CHAR) NOT NULL,
  external_key  varchar2(512 CHAR) NOT NULL,
  stage_num  number(10) NOT NULL,
  status  varchar2(15 CHAR) NOT NULL,
  existing_project_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  stage_name  varchar2(255 CHAR) NOT NULL,
  stage_modified_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  initiated_date  DATE DEFAULT sysdate NOT NULL,
  workspace_id  number(10) NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
/

prompt Creating table WORKSPACE

--METADATA NAME:WORKSPACE TYPE:TABLE CHANGE:CREATE

CREATE TABLE WORKSPACE(
  workspace_id  number(10) NOT NULL,
  workspace_type  varchar2(12 CHAR) NOT NULL,
  proj_id  number(10) NOT NULL,
  workspace_name  varchar2(255 CHAR) NOT NULL,
  workspace_prefs  BLOB NULL,
  cr_external_key  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)
,LOB(workspace_prefs) store as (TABLESPACE PMDB_LOB1 storage(minextents 1 maxextents UNLIMITED) NOCACHE)
/

--METADATA NAME:ACCOUNT TYPE:GRANT TABLE_NAME:ACCOUNT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACCOUNT TO PRIVUSER
/

--METADATA NAME:ACTVCODE TYPE:GRANT TABLE_NAME:ACTVCODE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACTVCODE TO PRIVUSER
/

--METADATA NAME:ACTVTYPE TYPE:GRANT TABLE_NAME:ACTVTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACTVTYPE TO PRIVUSER
/

--METADATA NAME:ADMIN_CONFIG TYPE:GRANT TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ADMIN_CONFIG TO PRIVUSER
/

--METADATA NAME:ASGNMNTACAT TYPE:GRANT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTACAT TO PRIVUSER
/

--METADATA NAME:ASGNMNTCATTYPE TYPE:GRANT TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTCATTYPE TO PRIVUSER
/

--METADATA NAME:ASGNMNTCATVAL TYPE:GRANT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTCATVAL TO PRIVUSER
/

--METADATA NAME:BASETYPE TYPE:GRANT TABLE_NAME:BASETYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BASETYPE TO PRIVUSER
/

--METADATA NAME:BGPLOG TYPE:GRANT TABLE_NAME:BGPLOG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BGPLOG TO PRIVUSER
/

--METADATA NAME:BRE_REGISTRY TYPE:GRANT TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BRE_REGISTRY TO PRIVUSER
/

--METADATA NAME:BUDGCHNG TYPE:GRANT TABLE_NAME:BUDGCHNG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BUDGCHNG TO PRIVUSER
/

--METADATA NAME:CALENDAR TYPE:GRANT TABLE_NAME:CALENDAR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON CALENDAR TO PRIVUSER
/

--METADATA NAME:COSTTYPE TYPE:GRANT TABLE_NAME:COSTTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON COSTTYPE TO PRIVUSER
/

--METADATA NAME:CURRTYPE TYPE:GRANT TABLE_NAME:CURRTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON CURRTYPE TO PRIVUSER
/

--METADATA NAME:DASHBOARD TYPE:GRANT TABLE_NAME:DASHBOARD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DASHBOARD TO PRIVUSER
/

--METADATA NAME:DASHUSER TYPE:GRANT TABLE_NAME:DASHUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DASHUSER TO PRIVUSER
/

--METADATA NAME:DISCUSSION TYPE:GRANT TABLE_NAME:DISCUSSION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DISCUSSION TO PRIVUSER
/

--METADATA NAME:DISCUSSION_READ TYPE:GRANT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DISCUSSION_READ TO PRIVUSER
/

--METADATA NAME:DLTACCT TYPE:GRANT TABLE_NAME:DLTACCT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTACCT TO PRIVUSER
/

--METADATA NAME:DLTACTV TYPE:GRANT TABLE_NAME:DLTACTV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTACTV TO PRIVUSER
/

--METADATA NAME:DLTOBS TYPE:GRANT TABLE_NAME:DLTOBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTOBS TO PRIVUSER
/

--METADATA NAME:DLTROLE TYPE:GRANT TABLE_NAME:DLTROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTROLE TO PRIVUSER
/

--METADATA NAME:DLTRSRC TYPE:GRANT TABLE_NAME:DLTRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTRSRC TO PRIVUSER
/

--METADATA NAME:DLTRSRL TYPE:GRANT TABLE_NAME:DLTRSRL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTRSRL TO PRIVUSER
/

--METADATA NAME:DLTUSER TYPE:GRANT TABLE_NAME:DLTUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTUSER TO PRIVUSER
/

--METADATA NAME:DOCCATG TYPE:GRANT TABLE_NAME:DOCCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCCATG TO PRIVUSER
/

--METADATA NAME:DOCREVIEW TYPE:GRANT TABLE_NAME:DOCREVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCREVIEW TO PRIVUSER
/

--METADATA NAME:DOCREVIEWTASK TYPE:GRANT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCREVIEWTASK TO PRIVUSER
/

--METADATA NAME:DOCSTAT TYPE:GRANT TABLE_NAME:DOCSTAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCSTAT TO PRIVUSER
/

--METADATA NAME:DOCUMENT TYPE:GRANT TABLE_NAME:DOCUMENT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCUMENT TO PRIVUSER
/

--METADATA NAME:EXPPROJ TYPE:GRANT TABLE_NAME:EXPPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON EXPPROJ TO PRIVUSER
/

--METADATA NAME:EXTAPP TYPE:GRANT TABLE_NAME:EXTAPP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON EXTAPP TO PRIVUSER
/

--METADATA NAME:FACTOR TYPE:GRANT TABLE_NAME:FACTOR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FACTOR TO PRIVUSER
/

--METADATA NAME:FACTVAL TYPE:GRANT TABLE_NAME:FACTVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FACTVAL TO PRIVUSER
/

--METADATA NAME:FILTPROP TYPE:GRANT TABLE_NAME:FILTPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FILTPROP TO PRIVUSER
/

--METADATA NAME:FINDATES TYPE:GRANT TABLE_NAME:FINDATES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FINDATES TO PRIVUSER
/

--METADATA NAME:FINTMPL TYPE:GRANT TABLE_NAME:FINTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FINTMPL TO PRIVUSER
/

--METADATA NAME:FORMCATG TYPE:GRANT TABLE_NAME:FORMCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMCATG TO PRIVUSER
/

--METADATA NAME:FORMPROJ TYPE:GRANT TABLE_NAME:FORMPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMPROJ TO PRIVUSER
/

--METADATA NAME:FORMTMPL TYPE:GRANT TABLE_NAME:FORMTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMTMPL TO PRIVUSER
/

--METADATA NAME:FUNDSRC TYPE:GRANT TABLE_NAME:FUNDSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FUNDSRC TO PRIVUSER
/

--METADATA NAME:GCHANGE TYPE:GRANT TABLE_NAME:GCHANGE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON GCHANGE TO PRIVUSER
/

--METADATA NAME:HQDATA TYPE:GRANT TABLE_NAME:HQDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON HQDATA TO PRIVUSER
/

--METADATA NAME:HQUERY TYPE:GRANT TABLE_NAME:HQUERY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON HQUERY TO PRIVUSER
/

--METADATA NAME:IMAGEDATA TYPE:GRANT TABLE_NAME:IMAGEDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON IMAGEDATA TO PRIVUSER
/

--METADATA NAME:ISSUHIST TYPE:GRANT TABLE_NAME:ISSUHIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ISSUHIST TO PRIVUSER
/

--METADATA NAME:ITERATION TYPE:GRANT TABLE_NAME:ITERATION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERATION TO PRIVUSER
/

--METADATA NAME:ITERDAYS TYPE:GRANT TABLE_NAME:ITERDAYS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERDAYS TO PRIVUSER
/

--METADATA NAME:ITERGOAL TYPE:GRANT TABLE_NAME:ITERGOAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERGOAL TO PRIVUSER
/

--METADATA NAME:JOBLOG TYPE:GRANT TABLE_NAME:JOBLOG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBLOG TO PRIVUSER
/

--METADATA NAME:JOBRPT TYPE:GRANT TABLE_NAME:JOBRPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBRPT TO PRIVUSER
/

--METADATA NAME:JOBSVC TYPE:GRANT TABLE_NAME:JOBSVC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBSVC TO PRIVUSER
/

--METADATA NAME:LOCATION TYPE:GRANT TABLE_NAME:LOCATION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON LOCATION TO PRIVUSER
/

--METADATA NAME:MEMOTYPE TYPE:GRANT TABLE_NAME:MEMOTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON MEMOTYPE TO PRIVUSER
/

--METADATA NAME:NEXTKEY TYPE:GRANT TABLE_NAME:NEXTKEY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NEXTKEY TO PRIVUSER
/

--METADATA NAME:NONWORK TYPE:GRANT TABLE_NAME:NONWORK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NONWORK TO PRIVUSER
/

--METADATA NAME:NOTE TYPE:GRANT TABLE_NAME:NOTE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NOTE TO PRIVUSER
/

--METADATA NAME:OBS TYPE:GRANT TABLE_NAME:OBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON OBS TO PRIVUSER
/

--METADATA NAME:OBSPROJ TYPE:GRANT TABLE_NAME:OBSPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON OBSPROJ TO PRIVUSER
/

--METADATA NAME:PCATTYPE TYPE:GRANT TABLE_NAME:PCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATTYPE TO PRIVUSER
/

--METADATA NAME:PCATUSER TYPE:GRANT TABLE_NAME:PCATUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATUSER TO PRIVUSER
/

--METADATA NAME:PCATVAL TYPE:GRANT TABLE_NAME:PCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATVAL TO PRIVUSER
/

--METADATA NAME:PFOLIO TYPE:GRANT TABLE_NAME:PFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PFOLIO TO PRIVUSER
/

--METADATA NAME:PFOLIOUSER TYPE:GRANT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PFOLIOUSER TO PRIVUSER
/

--METADATA NAME:PHASE TYPE:GRANT TABLE_NAME:PHASE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PHASE TO PRIVUSER
/

--METADATA NAME:PKXREF TYPE:GRANT TABLE_NAME:PKXREF CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PKXREF TO PRIVUSER
/

--METADATA NAME:POBS TYPE:GRANT TABLE_NAME:POBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON POBS TO PRIVUSER
/

--METADATA NAME:PREFER TYPE:GRANT TABLE_NAME:PREFER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PREFER TO PRIVUSER
/

--METADATA NAME:PRMAUDIT TYPE:GRANT TABLE_NAME:PRMAUDIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRMAUDIT TO PRIVUSER
/

--METADATA NAME:PRMQUEUE TYPE:GRANT TABLE_NAME:PRMQUEUE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRMQUEUE TO PRIVUSER
/

--METADATA NAME:PROCGROUP TYPE:GRANT TABLE_NAME:PROCGROUP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROCGROUP TO PRIVUSER
/

--METADATA NAME:PROCITEM TYPE:GRANT TABLE_NAME:PROCITEM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROCITEM TO PRIVUSER
/

--METADATA NAME:PROFILE TYPE:GRANT TABLE_NAME:PROFILE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROFILE TO PRIVUSER
/

--METADATA NAME:PROFPRIV TYPE:GRANT TABLE_NAME:PROFPRIV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROFPRIV TO PRIVUSER
/

--METADATA NAME:PROJCOST TYPE:GRANT TABLE_NAME:PROJCOST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJCOST TO PRIVUSER
/

--METADATA NAME:PROJECT TYPE:GRANT TABLE_NAME:PROJECT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJECT TO PRIVUSER
/

--METADATA NAME:PROJEST TYPE:GRANT TABLE_NAME:PROJEST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJEST TO PRIVUSER
/

--METADATA NAME:PROJFUND TYPE:GRANT TABLE_NAME:PROJFUND CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJFUND TO PRIVUSER
/

--METADATA NAME:PROJISSU TYPE:GRANT TABLE_NAME:PROJISSU CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJISSU TO PRIVUSER
/

--METADATA NAME:PROJPCAT TYPE:GRANT TABLE_NAME:PROJPCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJPCAT TO PRIVUSER
/

--METADATA NAME:PROJPROP TYPE:GRANT TABLE_NAME:PROJPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJPROP TO PRIVUSER
/

--METADATA NAME:PROJRISK TYPE:GRANT TABLE_NAME:PROJRISK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJRISK TO PRIVUSER
/

--METADATA NAME:PROJSHAR TYPE:GRANT TABLE_NAME:PROJSHAR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJSHAR TO PRIVUSER
/

--METADATA NAME:PROJTHRS TYPE:GRANT TABLE_NAME:PROJTHRS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJTHRS TO PRIVUSER
/

--METADATA NAME:PROJWBS TYPE:GRANT TABLE_NAME:PROJWBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJWBS TO PRIVUSER
/

--METADATA NAME:PROJWSRPT TYPE:GRANT TABLE_NAME:PROJWSRPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJWSRPT TO PRIVUSER
/

--METADATA NAME:PRPFOLIO TYPE:GRANT TABLE_NAME:PRPFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRPFOLIO TO PRIVUSER
/

--METADATA NAME:PUBUSER TYPE:GRANT TABLE_NAME:PUBUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PUBUSER TO PRIVUSER
/

--METADATA NAME:PUBUSER TYPE:GRANT TABLE_NAME:PUBUSER CHANGE:CREATE
GRANT SELECT ON PUBUSER TO PUBUSER
/

--METADATA NAME:QUERYLIB TYPE:GRANT TABLE_NAME:QUERYLIB CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON QUERYLIB TO PRIVUSER
/

--METADATA NAME:RCATTYPE TYPE:GRANT TABLE_NAME:RCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RCATTYPE TO PRIVUSER
/

--METADATA NAME:RCATVAL TYPE:GRANT TABLE_NAME:RCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RCATVAL TO PRIVUSER
/

--METADATA NAME:REFRDEL TYPE:GRANT TABLE_NAME:REFRDEL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON REFRDEL TO PRIVUSER
/

--METADATA NAME:REITTYPE TYPE:GRANT TABLE_NAME:REITTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON REITTYPE TO PRIVUSER
/

--METADATA NAME:RELEASE TYPE:GRANT TABLE_NAME:RELEASE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RELEASE TO PRIVUSER
/

--METADATA NAME:RELITEMS TYPE:GRANT TABLE_NAME:RELITEMS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RELITEMS TO PRIVUSER
/

--METADATA NAME:RFOLIO TYPE:GRANT TABLE_NAME:RFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RFOLIO TO PRIVUSER
/

--METADATA NAME:RISKCTRL TYPE:GRANT TABLE_NAME:RISKCTRL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RISKCTRL TO PRIVUSER
/

--METADATA NAME:RISKTYPE TYPE:GRANT TABLE_NAME:RISKTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RISKTYPE TO PRIVUSER
/

--METADATA NAME:RLFOLIO TYPE:GRANT TABLE_NAME:RLFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RLFOLIO TO PRIVUSER
/

--METADATA NAME:ROLECATTYPE TYPE:GRANT TABLE_NAME:ROLECATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLECATTYPE TO PRIVUSER
/

--METADATA NAME:ROLECATVAL TYPE:GRANT TABLE_NAME:ROLECATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLECATVAL TO PRIVUSER
/

--METADATA NAME:ROLELIMIT TYPE:GRANT TABLE_NAME:ROLELIMIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLELIMIT TO PRIVUSER
/

--METADATA NAME:ROLERATE TYPE:GRANT TABLE_NAME:ROLERATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLERATE TO PRIVUSER
/

--METADATA NAME:ROLERCAT TYPE:GRANT TABLE_NAME:ROLERCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLERCAT TO PRIVUSER
/

--METADATA NAME:ROLES TYPE:GRANT TABLE_NAME:ROLES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLES TO PRIVUSER
/

--METADATA NAME:ROLFOLIO TYPE:GRANT TABLE_NAME:ROLFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLFOLIO TO PRIVUSER
/

--METADATA NAME:RPT TYPE:GRANT TABLE_NAME:RPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPT TO PRIVUSER
/

--METADATA NAME:RPTBATCH TYPE:GRANT TABLE_NAME:RPTBATCH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTBATCH TO PRIVUSER
/

--METADATA NAME:RPTGROUP TYPE:GRANT TABLE_NAME:RPTGROUP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTGROUP TO PRIVUSER
/

--METADATA NAME:RPTLIST TYPE:GRANT TABLE_NAME:RPTLIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTLIST TO PRIVUSER
/

--METADATA NAME:RSRC TYPE:GRANT TABLE_NAME:RSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRC TO PRIVUSER
/

--METADATA NAME:RSRCANDASH TYPE:GRANT TABLE_NAME:RSRCANDASH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCANDASH TO PRIVUSER
/

--METADATA NAME:RSRCANVIEW TYPE:GRANT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCANVIEW TO PRIVUSER
/

--METADATA NAME:RSRCCURV TYPE:GRANT TABLE_NAME:RSRCCURV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCCURV TO PRIVUSER
/

--METADATA NAME:RSRCHOUR TYPE:GRANT TABLE_NAME:RSRCHOUR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCHOUR TO PRIVUSER
/

--METADATA NAME:RSRCPROP TYPE:GRANT TABLE_NAME:RSRCPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCPROP TO PRIVUSER
/

--METADATA NAME:RSRCRATE TYPE:GRANT TABLE_NAME:RSRCRATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCRATE TO PRIVUSER
/

--METADATA NAME:RSRCRCAT TYPE:GRANT TABLE_NAME:RSRCRCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCRCAT TO PRIVUSER
/

--METADATA NAME:RSRCROLE TYPE:GRANT TABLE_NAME:RSRCROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCROLE TO PRIVUSER
/

--METADATA NAME:RSRCSEC TYPE:GRANT TABLE_NAME:RSRCSEC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCSEC TO PRIVUSER
/

--METADATA NAME:RSRFOLIO TYPE:GRANT TABLE_NAME:RSRFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRFOLIO TO PRIVUSER
/

--METADATA NAME:SCENARIO TYPE:GRANT TABLE_NAME:SCENARIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENARIO TO PRIVUSER
/

--METADATA NAME:SCENPROJ TYPE:GRANT TABLE_NAME:SCENPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENPROJ TO PRIVUSER
/

--METADATA NAME:SCENROLE TYPE:GRANT TABLE_NAME:SCENROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENROLE TO PRIVUSER
/

--METADATA NAME:SCENUSER TYPE:GRANT TABLE_NAME:SCENUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENUSER TO PRIVUSER
/

--METADATA NAME:SETTINGS TYPE:GRANT TABLE_NAME:SETTINGS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SETTINGS TO PRIVUSER
/

--METADATA NAME:SHIFT TYPE:GRANT TABLE_NAME:SHIFT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SHIFT TO PRIVUSER
/

--METADATA NAME:SHIFTPER TYPE:GRANT TABLE_NAME:SHIFTPER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SHIFTPER TO PRIVUSER
/

--METADATA NAME:SPIDMAP TYPE:GRANT TABLE_NAME:SPIDMAP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SPIDMAP TO PRIVUSER
/

--METADATA NAME:SUMPROJCOST TYPE:GRANT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMPROJCOST TO PRIVUSER
/

--METADATA NAME:SUMTASK TYPE:GRANT TABLE_NAME:SUMTASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTASK TO PRIVUSER
/

--METADATA NAME:SUMTASKSPREAD TYPE:GRANT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTASKSPREAD TO PRIVUSER
/

--METADATA NAME:SUMTRSRC TYPE:GRANT TABLE_NAME:SUMTRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTRSRC TO PRIVUSER
/

--METADATA NAME:TASK TYPE:GRANT TABLE_NAME:TASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASK TO PRIVUSER
/

--METADATA NAME:TASKACTV TYPE:GRANT TABLE_NAME:TASKACTV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKACTV TO PRIVUSER
/

--METADATA NAME:TASKDOC TYPE:GRANT TABLE_NAME:TASKDOC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKDOC TO PRIVUSER
/

--METADATA NAME:TASKFDBK TYPE:GRANT TABLE_NAME:TASKFDBK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKFDBK TO PRIVUSER
/

--METADATA NAME:TASKFIN TYPE:GRANT TABLE_NAME:TASKFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKFIN TO PRIVUSER
/

--METADATA NAME:TASKMEMO TYPE:GRANT TABLE_NAME:TASKMEMO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKMEMO TO PRIVUSER
/

--METADATA NAME:TASKNOTE TYPE:GRANT TABLE_NAME:TASKNOTE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKNOTE TO PRIVUSER
/

--METADATA NAME:TASKPRED TYPE:GRANT TABLE_NAME:TASKPRED CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKPRED TO PRIVUSER
/

--METADATA NAME:TASKPROC TYPE:GRANT TABLE_NAME:TASKPROC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKPROC TO PRIVUSER
/

--METADATA NAME:TASKRISK TYPE:GRANT TABLE_NAME:TASKRISK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKRISK TO PRIVUSER
/

--METADATA NAME:TASKRSRC TYPE:GRANT TABLE_NAME:TASKRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKRSRC TO PRIVUSER
/

--METADATA NAME:TASKSUM TYPE:GRANT TABLE_NAME:TASKSUM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKSUM TO PRIVUSER
/

--METADATA NAME:TASKSUMFIN TYPE:GRANT TABLE_NAME:TASKSUMFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKSUMFIN TO PRIVUSER
/

--METADATA NAME:TASKUSER TYPE:GRANT TABLE_NAME:TASKUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKUSER TO PRIVUSER
/

--METADATA NAME:TASKWKSP TYPE:GRANT TABLE_NAME:TASKWKSP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKWKSP TO PRIVUSER
/

--METADATA NAME:TEMPKEYS TYPE:GRANT TABLE_NAME:TEMPKEYS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TEMPKEYS TO PRIVUSER
/

--METADATA NAME:THRSPARM TYPE:GRANT TABLE_NAME:THRSPARM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON THRSPARM TO PRIVUSER
/

--METADATA NAME:TIMESHT TYPE:GRANT TABLE_NAME:TIMESHT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TIMESHT TO PRIVUSER
/

--METADATA NAME:TMPLCATG TYPE:GRANT TABLE_NAME:TMPLCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TMPLCATG TO PRIVUSER
/

--METADATA NAME:TPROJMAP TYPE:GRANT TABLE_NAME:TPROJMAP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TPROJMAP TO PRIVUSER
/

--METADATA NAME:TRAKVIEW TYPE:GRANT TABLE_NAME:TRAKVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRAKVIEW TO PRIVUSER
/

--METADATA NAME:TRSRCFIN TYPE:GRANT TABLE_NAME:TRSRCFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCFIN TO PRIVUSER
/

--METADATA NAME:TRSRCSUM TYPE:GRANT TABLE_NAME:TRSRCSUM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCSUM TO PRIVUSER
/

--METADATA NAME:TRSRCSUMFN TYPE:GRANT TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCSUMFN TO PRIVUSER
/

--METADATA NAME:TSAUDIT TYPE:GRANT TABLE_NAME:TSAUDIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSAUDIT TO PRIVUSER
/

--METADATA NAME:TSDATES TYPE:GRANT TABLE_NAME:TSDATES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSDATES TO PRIVUSER
/

--METADATA NAME:TSDELEGATE TYPE:GRANT TABLE_NAME:TSDELEGATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSDELEGATE TO PRIVUSER
/

--METADATA NAME:UACCESS TYPE:GRANT TABLE_NAME:UACCESS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UACCESS TO PRIVUSER
/

--METADATA NAME:UDFCODE TYPE:GRANT TABLE_NAME:UDFCODE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFCODE TO PRIVUSER
/

--METADATA NAME:UDFTYPE TYPE:GRANT TABLE_NAME:UDFTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFTYPE TO PRIVUSER
/

--METADATA NAME:UDFVALUE TYPE:GRANT TABLE_NAME:UDFVALUE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFVALUE TO PRIVUSER
/

--METADATA NAME:UEVNTREG TYPE:GRANT TABLE_NAME:UEVNTREG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UEVNTREG TO PRIVUSER
/

--METADATA NAME:UMEASURE TYPE:GRANT TABLE_NAME:UMEASURE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UMEASURE TO PRIVUSER
/

--METADATA NAME:UPKLIST TYPE:GRANT TABLE_NAME:UPKLIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UPKLIST TO PRIVUSER
/

--METADATA NAME:USERCOL TYPE:GRANT TABLE_NAME:USERCOL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERCOL TO PRIVUSER
/

--METADATA NAME:USERDATA TYPE:GRANT TABLE_NAME:USERDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERDATA TO PRIVUSER
/

--METADATA NAME:USERENG TYPE:GRANT TABLE_NAME:USERENG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERENG TO PRIVUSER
/

--METADATA NAME:USEROBS TYPE:GRANT TABLE_NAME:USEROBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USEROBS TO PRIVUSER
/

--METADATA NAME:USEROPEN TYPE:GRANT TABLE_NAME:USEROPEN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USEROPEN TO PRIVUSER
/

--METADATA NAME:USERS TYPE:GRANT TABLE_NAME:USERS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERS TO PRIVUSER
/

--METADATA NAME:USERSET TYPE:GRANT TABLE_NAME:USERSET CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERSET TO PRIVUSER
/

--METADATA NAME:USERWKSP TYPE:GRANT TABLE_NAME:USERWKSP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERWKSP TO PRIVUSER
/

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:GRANT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USER_ACCEPTANCE_CONSENT TO PRIVUSER
/

--METADATA NAME:USESSAUD TYPE:GRANT TABLE_NAME:USESSAUD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USESSAUD TO PRIVUSER
/

--METADATA NAME:USESSION TYPE:GRANT TABLE_NAME:USESSION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USESSION TO PRIVUSER
/

--METADATA NAME:USROPNVAL TYPE:GRANT TABLE_NAME:USROPNVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USROPNVAL TO PRIVUSER
/

--METADATA NAME:VIEWPREF TYPE:GRANT TABLE_NAME:VIEWPREF CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VIEWPREF TO PRIVUSER
/

--METADATA NAME:VIEWPROP TYPE:GRANT TABLE_NAME:VIEWPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VIEWPROP TO PRIVUSER
/

--METADATA NAME:VWPREFDASH TYPE:GRANT TABLE_NAME:VWPREFDASH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFDASH TO PRIVUSER
/

--METADATA NAME:VWPREFDATA TYPE:GRANT TABLE_NAME:VWPREFDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFDATA TO PRIVUSER
/

--METADATA NAME:VWPREFUSER TYPE:GRANT TABLE_NAME:VWPREFUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFUSER TO PRIVUSER
/

--METADATA NAME:WBRSCAT TYPE:GRANT TABLE_NAME:WBRSCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBRSCAT TO PRIVUSER
/

--METADATA NAME:WBSBUDG TYPE:GRANT TABLE_NAME:WBSBUDG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSBUDG TO PRIVUSER
/

--METADATA NAME:WBSMEMO TYPE:GRANT TABLE_NAME:WBSMEMO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSMEMO TO PRIVUSER
/

--METADATA NAME:WBSRSRC TYPE:GRANT TABLE_NAME:WBSRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSRSRC TO PRIVUSER
/

--METADATA NAME:WBSRSRC_QTY TYPE:GRANT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSRSRC_QTY TO PRIVUSER
/

--METADATA NAME:WBSSTEP TYPE:GRANT TABLE_NAME:WBSSTEP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSSTEP TO PRIVUSER
/

--METADATA NAME:WKFLTMPL TYPE:GRANT TABLE_NAME:WKFLTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WKFLTMPL TO PRIVUSER
/

--METADATA NAME:WKFLUSER TYPE:GRANT TABLE_NAME:WKFLUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WKFLUSER TO PRIVUSER
/

--METADATA NAME:WORKFLOW TYPE:GRANT TABLE_NAME:WORKFLOW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WORKFLOW TO PRIVUSER
/

--METADATA NAME:WORKSPACE TYPE:GRANT TABLE_NAME:WORKSPACE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WORKSPACE TO PRIVUSER
/
