--METADATA NAME:GETNEXTKEY TYPE:FUNCTION TARGET_OBJECT:GETNEXTKEY CHANGE:CREATE
CREATE OR REPLACE FUNCTION GETNEXTKEY
( tabcol IN VARCHAR2  , numkeys IN NUMBER)
RETURN NUMBER
IS
  PRAGMA AUTONOMOUS_TRANSACTION;
 startkey  number;
BEGIN
  UPDATE nextkey SET key_seq_num = (key_seq_num + numKeys) WHERE key_name = tabcol
  returning (key_seq_num - numkeys) into startkey;
  COMMIT;
  RETURN startkey;
EXCEPTION
  WHEN OTHERS THEN
    startkey := -1;
END;
/
 
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:CREATE
create or replace synonym privuser.initialize_background_procs for ADMUSER.initialize_background_procs
/
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
CURSOR CUR_PROJRISK_PROJ_ID IS SELECT DISTINCT PROJ_ID FROM PROJRISK;
V_WBS_ID INTEGER;
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
FOR V_REC IN CUR_PROJRISK_PROJ_ID LOOP
select WBS_ID INTO V_WBS_ID from ADMUSER.PROJWBS where proj_id= V_REC.PROJ_ID AND PROJ_NODE_FLAG='Y';
UPDATE PROJRISK SET WBS_ID=V_WBS_ID WHERE PROJ_ID=V_REC.PROJ_ID;
COMMIT;
END LOOP;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('WBS_ID');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%WBS_ID%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify WBS_ID NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%WBS_ID%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/  
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJRISK SET ADD_DATE=sysdate;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('ADD_DATE');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%ADD_DATE%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify ADD_DATE NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and validated='NOT VALIDATED' and search_condition_vc like '%ADD_DATE%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJRISK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJRISK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJRISK DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJRISK SET PRIORITY_TYPE='PT_Normal';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJRISK') and nullable='Y' and column_name =upper('PRIORITY_TYPE');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJRISK') and constraint_type='C' and SEARCH_CONDITION_VC like '%PRIORITY_TYPE%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK modify PRIORITY_TYPE NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJRISK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%PRIORITY_TYPE%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJECT CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
end if;
UPDATE PROJECT SET PX_ENABLE_PUBLICATION_FLAG='Y';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('PX_ENABLE_PUBLICATION_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%PX_ENABLE_PUBLICATION_FLAG%NOT NULL';
if  (IS_NOT_NULL = 1 and V_CON_EXIST = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify PX_ENABLE_PUBLICATION_FLAG  DEFAULT ''Y'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%PX_ENABLE_PUBLICATION_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:PROJWBS CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJWBS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJWBS DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJWBS SET INTG_WBS='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJWBS') and nullable='Y' and column_name =upper('INTG_WBS');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJWBS') and constraint_type='C' and SEARCH_CONDITION_VC like '%INTG_WBS%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJWBS modify INTG_WBS DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJWBS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%INTG_WBS%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASK CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*)  into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASK' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASK DISABLE ALL TRIGGERS';
END IF;
UPDATE TASK SET STARRED_FLAG='N';
COMMIT;
select count(*) into is_not_null from user_tab_columns where table_name=upper('TASK') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASK') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE TASK modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASK') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASKRSRC CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASKRSRC' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASKRSRC DISABLE ALL TRIGGERS';
END IF;
UPDATE TASKRSRC SET STARRED_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('TASKRSRC') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASKRSRC') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then
 EXECUTE IMMEDIATE 'ALTER TABLE TASKRSRC modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASKRSRC') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJRISK modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASKUSER CHANGE:CREATE
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='TASKUSER' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE TASKUSER DISABLE ALL TRIGGERS';
END IF;
UPDATE TASKUSER SET STARRED_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('TASKUSER') and nullable='Y' and column_name =upper('STARRED_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('TASKUSER') and constraint_type='C' and SEARCH_CONDITION_VC like '%STARRED_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then
 EXECUTE IMMEDIATE 'ALTER TABLE TASKUSER modify STARRED_FLAG DEFAULT ''N'' NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('TASKUSER') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STARRED_FLAG%NOT NULL';
execute immediate 'ALTER TABLE TASKUSER modify constraint '||v_constraint_name||' validate';
end if;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:PROFPRIV CHANGE:UPDATE
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)select distinct p.prof_id,176,'N', sysdate, sys_context('userenv','current_schema') 
from profpriv p,profile pf  where lower(scope_type)='st_project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=176) 
/
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISKSCRMTX CHANGE:INSERT
declare
   TYPE typ_riskscrmtx_matrix_id IS TABLE OF NUMBER
       INDEX BY PLS_INTEGER;
    v_typ_riskscrmtx_matrix_id  typ_riskscrmtx_matrix_id;
BEGIN
   SELECT MATRIX_ID BULK COLLECT INTO v_typ_riskscrmtx_matrix_id from project where MATRIX_ID is not null ;
   FORALL indx IN 1 .. v_typ_riskscrmtx_matrix_id.COUNT
     Insert into riskscrmtx (MATRIX_ID,NAME,DESCRIPTION,METHOD,IMPACT_LEVELS,PROBABILITY_LEVELS)
	    select v_typ_riskscrmtx_matrix_id(indx),'Inserted by Migration Process',null,'SM_High',3,3 from dual
      where not exists (select 1 from riskscrmtx where matrix_id = v_typ_riskscrmtx_matrix_id(indx));
	 commit;
END;
/
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISK CHANGE:INSERT
insert into risk(risk_id,id,proj_id,total_cost,type,status,name)
select v.risk_id,'Risk_Mig_'||rn,v.proj_id,0,v.priority_type,v.status_code,v.risk_name from (select risk_id,proj_id,priority_type,status_code,risk_name,rownum as rn from projrisk) v
where not exists ( select 1 from risk r where r.risk_id=v.risk_id)
/
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:DELETE
ALTER TABLE taskrisk DROP CONSTRAINT FK_RISK_RISKID
/
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:CREATE
alter table taskrisk add  constraint FK_RISK_RISKID foreign key (risk_id) REFERENCES RISK (RISK_ID)
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRM_AUDIT') and object_type='PACKAGE' ;
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP PACKAGE PRM_AUDIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
  NULL;  
END;
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
DECLARE
  obj_exists INTEGER;
BEGIN
  SELECT 1 INTO obj_exists FROM user_objects WHERE object_name = UPPER('PRMAUDIT') and object_type='TABLE' ;
  IF obj_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP TABLE PRMAUDIT';
  END IF;
EXCEPTION when NO_DATA_FOUND then
  NULL;  
END;
/
--METADATA TYPE:MIGRATE NAME:MISC_UPDATES 
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from dual where not exists (select * from nextkey where lower(key_name)='settings_setting_id')
/
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ETL_INTERVAL=24;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ETL_INTERVAL');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ETL_INTERVAL%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ETL_INTERVAL NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ETL_INTERVAL%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ETL_HOUR=0;
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ETL_HOUR');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ETL_HOUR%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ETL_HOUR NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ETL_HOUR%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='PROJECT' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT DISABLE ALL TRIGGERS';
END IF;
UPDATE PROJECT SET ENABLE_PRIME_SYNC_FLAG='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('PROJECT') and nullable='Y' and column_name =upper('ENABLE_PRIME_SYNC_FLAG');
select count(*) into v_con_exist   from user_constraints where table_name=upper('PROJECT') and constraint_type='C' and SEARCH_CONDITION_VC like '%ENABLE_PRIME_SYNC_FLAG%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE PROJECT modify ENABLE_PRIME_SYNC_FLAG NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('PROJECT') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%ENABLE_PRIME_SYNC_FLAG%NOT NULL';
execute immediate 'ALTER TABLE PROJECT modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE PROJECT ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
/*declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='USERS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS DISABLE ALL TRIGGERS';
END IF;
select 1 into is_not_null from user_tab_columns where table_name=upper('USERS') and nullable='Y' and column_name =upper('STATUS');
select count(*) into v_con_exist   from user_constraints where table_name=upper('USERS') and constraint_type='C' and SEARCH_CONDITION_VC like '%STATUS%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
UPDATE USERS SET STATUS='Y';
COMMIT;
EXECUTE IMMEDIATE 'ALTER TABLE USERS modify STATUS NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('USERS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%STATUS%NOT NULL';
UPDATE USERS SET STATUS='Y';
COMMIT;
execute immediate 'ALTER TABLE USERS modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
*/ 
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare 
is_not_null integer:=0;
v_con_exist integer:=0;
v_stat_trigg integer:=0;
v_con_exist_not_valid integer;
v_constraint_name  varchar2(30);
begin
select count(*) into v_stat_trigg  from USER_TRIGGERS where TABLE_NAME='USERS' and  STATUS ='ENABLED';
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS DISABLE ALL TRIGGERS';
END IF;
UPDATE USERS SET SYSTEMUSER='N';
COMMIT;
select 1 into is_not_null from user_tab_columns where table_name=upper('USERS') and nullable='Y' and column_name =upper('SYSTEMUSER');
select count(*) into v_con_exist   from user_constraints where table_name=upper('USERS') and constraint_type='C' and SEARCH_CONDITION_VC like '%SYSTEMUSER%NOT NULL';
if  (is_not_null = 1 and v_con_exist = 0 )then 
 EXECUTE IMMEDIATE 'ALTER TABLE USERS modify SYSTEMUSER NOT NULL';
elsif (is_not_null = 1 and v_con_exist > 0 ) then
select constraint_name into v_constraint_name from user_constraints where table_name=upper('USERS') and constraint_type='C'  and validated='NOT VALIDATED' and search_condition_vc like '%SYSTEMUSER%NOT NULL';
execute immediate 'ALTER TABLE USERS modify constraint '||v_constraint_name||' validate';
end if;
IF v_stat_trigg >=1 THEN
execute immediate 'ALTER TABLE USERS ENABLE ALL TRIGGERS';
END IF;
exception when NO_DATA_FOUND then
  null;
end;
/ 
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:GATHER_STATISTICS CHANGE:CREATE
create or replace synonym bgjobuser.GATHER_STATISTICS for ADMUSER.GATHER_STATISTICS
/
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:REBUILD_INDEX CHANGE:CREATE
create or replace synonym bgjobuser.REBUILD_INDEX for ADMUSER.REBUILD_INDEX
/
--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:STATISTICS_MONITOR CHANGE:CREATE
create or replace synonym bgjobuser.STATISTICS_MONITOR for ADMUSER.STATISTICS_MONITOR
/

--METADATA NAME:MISC_UPDATES TYPE:SYNONYM TARGET_OBJECT:GATHER_FLUX_STATISTICS CHANGE:CREATE
create or replace synonym bgjobuser.GATHER_FLUX_STATISTICS for ADMUSER.GATHER_FLUX_STATISTICS
/

--METADATA NAME:MISC_UPDATES TYPE:VIEW TARGET_OBJECT:ITERDAYS CHANGE:DROP
DROP VIEW PRIVUSER.ITERDAYS
/

--METADATA NAME:MISC_UPDATES TYPE:VIEW TARGET_OBJECT:ITERGOAL CHANGE:DROP
DROP VIEW PRIVUSER.ITERGOAL
/

--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:CHECK_DB_SIZE_LIMIT CHANGE:DROP
drop SYNONYM PRIVUSER.CHECK_DB_SIZE_LIMIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:DROP
drop SYNONYM PRIVUSER.INITIALIZE_BACKGROUND_PROCS
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRMAUDIT CHANGE:DROP
drop SYNONYM PRIVUSER.PRMAUDIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRMAUDIT_CLEANUP CHANGE:DROP
drop SYNONYM PRIVUSER.PRMAUDIT_CLEANUP
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:PRM_AUDIT CHANGE:DROP
drop SYNONYM PRIVUSER.PRM_AUDIT
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:DATA_MONITOR CHANGE:COMPILE
alter SYNONYM BGJOBUSER.DATA_MONITOR compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:GATHER_STATISTICS CHANGE:COMPILE
alter SYNONYM BGJOBUSER.GATHER_STATISTICS compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:INITIALIZE_BACKGROUND_PROCS CHANGE:COMPILE
alter SYNONYM BGJOBUSER.INITIALIZE_BACKGROUND_PROCS compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:REBUILD_INDEX CHANGE:COMPILE
alter SYNONYM BGJOBUSER.REBUILD_INDEX compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:SETTINGS_READ_STRING CHANGE:COMPILE
alter SYNONYM BGJOBUSER.SETTINGS_READ_STRING compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:SETTINGS_WRITE_STRING CHANGE:COMPILE
alter SYNONYM BGJOBUSER.SETTINGS_WRITE_STRING compile
/
--METADATA NAME:MIGRATION TYPE:VIEW TARGET_OBJECT:STATISTICS_MONITOR CHANGE:COMPILE
alter SYNONYM BGJOBUSER.STATISTICS_MONITOR compile
/