/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.labelsgenerator;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.tools.labelsgenerator.Field;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BODefLabelsSQLGenerator {
    private String boXMLDirectory;
    private String sqlOutputDirectory;
    private static final String OR_OUTPUT_FILE = "/or_bodeflabel_inserts.sql";
    private static final String SS_OUTPUT_FILE = "/ss_bodeflabel_inserts.sql";
    private static final String OR_SQL_END = ")\n/\n";
    private static final String SS_SQL_END = ")\ngo\n";
    private static final String INSERT_SQL = "INSERT INTO BODEFLABELS (bodeflabels_id, bo_name, bo_field_name, bo_field_type, source_table_name, source_column_name) \nSELECT ";
    private static final String OR_POST_INSERT_SQL = "' from dual \nwhere not exists (select 1 from BODEFLABELS where bodeflabels_id = ";
    private static final String SS_POST_INSERT_SQL = "'\nwhere not exists (select 1 from BODEFLABELS where bodeflabels_id = ";
    private static final String FIELD_SEP = "','";
    private static final List<String> BOEXCLUDELIST = Arrays.asList("BaselineProject", "EPSBudgetChangeLog", "ScheduleOption", "EPS", "EPSNote", "ActivityView", "EPSFunding", "ProjectProfile", "WBS", "EPSSpendingPlan", "StepUserDefinedValueUpdate", "GlobalProfile");
    private static final List<String> BOAUDITFIELDS = Arrays.asList("LastUpdateDate", "LastUpdateUser", "CreateDate", "CreateUser");
    private int boDefLabelsId;
    private int ssboDefLabelsId;

    public String getBoXMLDirectory() {
        return this.boXMLDirectory;
    }

    public void setBoXMLDirectory(String boXMLDirectory) {
        this.boXMLDirectory = boXMLDirectory;
    }

    public String getSqlOutputDirectory() {
        return this.sqlOutputDirectory;
    }

    public void setSqlOutputDirectory(String sqlOutputDirectory) {
        this.sqlOutputDirectory = sqlOutputDirectory;
    }

    public static void main(String[] args) {
        if (!BODefLabelsSQLGenerator.validateParameters(args)) {
            return;
        }
        BODefLabelsSQLGenerator sqlGenerator = new BODefLabelsSQLGenerator();
        sqlGenerator.setBoXMLDirectory(args[0]);
        sqlGenerator.setSqlOutputDirectory(args[1]);
        try {
            sqlGenerator.run();
            System.out.println("Process Complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Process incomplete");
        }
    }

    private static boolean validateParameters(String[] args) {
        if (args.length < 2) {
            System.out.println("BODefLabelsSQLGenerator: Must specify <boXMLDirectory> and <sqlOutputFileDirectory>.");
            return false;
        }
        if (!new File(args[0]).exists()) {
            System.out.println("Specified bo xml directory does not exist (" + args[0] + ")");
            return false;
        }
        if (!new File(args[1]).exists()) {
            System.out.println("Specified sql output file directory does not exist (" + args[1] + ")");
            return false;
        }
        return true;
    }

    public void run() throws PrimaveraDatabaseException {
        if (this.boXMLDirectory == null || this.sqlOutputDirectory == null) {
            throw new PrimaveraDatabaseException("Must specify the bo xmls directory and sqlOutputFileDirectories");
        }
        try {
            Map<String, List<Field>> boDefToFieldsMap = this.getBODefAndFieldMapFromXmls();
            File outputFile = new File(this.sqlOutputDirectory + OR_OUTPUT_FILE);
            File ssoutputFile = new File(this.sqlOutputDirectory + SS_OUTPUT_FILE);
            BufferedWriter outputFileBW = new BufferedWriter(new FileWriter(outputFile));
            BufferedWriter ssoutputFileBW = new BufferedWriter(new FileWriter(ssoutputFile));
            Iterator<Map.Entry<String, List<Field>>> boDefToFieldsEntryIter = boDefToFieldsMap.entrySet().iterator();
            this.boDefLabelsId = 1;
            this.ssboDefLabelsId = 1;
            while (boDefToFieldsEntryIter.hasNext()) {
                Map.Entry<String, List<Field>> boDefToFieldsEntry = boDefToFieldsEntryIter.next();
                StringBuilder insertSQLBuilder = this.prepareInsertSqlsForBOFile(boDefToFieldsEntry.getKey(), boDefToFieldsEntry.getValue(), true);
                outputFileBW.write(insertSQLBuilder.toString());
                insertSQLBuilder = this.prepareInsertSqlsForBOFile(boDefToFieldsEntry.getKey(), boDefToFieldsEntry.getValue(), false);
                ssoutputFileBW.write(insertSQLBuilder.toString());
            }
            outputFileBW.flush();
            outputFileBW.close();
            ssoutputFileBW.flush();
            ssoutputFileBW.close();
        }
        catch (Exception e) {
            throw new PrimaveraDatabaseException(e.getMessage());
        }
    }

    private StringBuilder prepareInsertSqlsForBOFile(String boName, List<Field> boFields, boolean isOra) {
        StringBuilder insertSQLBuilder = new StringBuilder();
        for (Field boField : boFields) {
            insertSQLBuilder.append("--METADATA NAME=BODEFLABELS TYPE=DML CHANGE=INSERT\n");
            insertSQLBuilder.append(INSERT_SQL);
            insertSQLBuilder.append(isOra ? this.boDefLabelsId : this.ssboDefLabelsId).append(",'");
            insertSQLBuilder.append(boName).append(FIELD_SEP);
            insertSQLBuilder.append(boField.getBoFieldName()).append(FIELD_SEP);
            insertSQLBuilder.append(boField.getBoFieldType()).append(FIELD_SEP);
            insertSQLBuilder.append(boField.getSrcTableName()).append(FIELD_SEP);
            insertSQLBuilder.append(boField.getSrcColumnName());
            insertSQLBuilder.append(isOra ? OR_POST_INSERT_SQL : SS_POST_INSERT_SQL).append(isOra ? this.boDefLabelsId : this.ssboDefLabelsId).append(isOra ? OR_SQL_END : SS_SQL_END);
            if (isOra) {
                ++this.boDefLabelsId;
                continue;
            }
            ++this.ssboDefLabelsId;
        }
        return insertSQLBuilder;
    }

    private Map<String, List<Field>> getBODefAndFieldMapFromXmls() throws ParserConfigurationException, SAXException, IOException {
        File[] files;
        LinkedHashMap<String, List<Field>> boDefToFieldsMap = new LinkedHashMap<String, List<Field>>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        for (File file : files = new File(this.boXMLDirectory).listFiles()) {
            String boChildNodeName;
            Node boChildNode;
            int i;
            if (file.getName().startsWith("Px") || BOEXCLUDELIST.contains(file.getName().split("\\.")[0])) continue;
            Document document = db.parse(file);
            String currBOName = null;
            String currPhyName = null;
            NodeList boChildNodes = document.getElementsByTagName("BusinessObject").item(0).getChildNodes();
            boolean auditFlag = false;
            for (i = 0; i < boChildNodes.getLength(); ++i) {
                boChildNode = boChildNodes.item(i);
                boChildNodeName = boChildNode.getNodeName();
                if (!"Field".equals(boChildNodeName)) continue;
                auditFlag = false;
                for (int ij = 0; ij < boChildNode.getChildNodes().getLength(); ++ij) {
                    Node fieldChildNode = boChildNode.getChildNodes().item(ij);
                    String fieldChildNodeName = fieldChildNode.getNodeName();
                    String fieldChildTextContent = fieldChildNode.getTextContent();
                    if (!"Name".equals(fieldChildNodeName) || !BOAUDITFIELDS.contains(fieldChildTextContent)) continue;
                    auditFlag = true;
                    break;
                }
                if (auditFlag) break;
            }
            if (!auditFlag) continue;
            for (i = 0; i < boChildNodes.getLength(); ++i) {
                boChildNode = boChildNodes.item(i);
                boChildNodeName = boChildNode.getNodeName();
                if ("Name".equals(boChildNodeName)) {
                    currBOName = boChildNode.getTextContent();
                    boDefToFieldsMap.put(currBOName, new ArrayList());
                    continue;
                }
                if ("PhysicalName".equals(boChildNodeName)) {
                    currPhyName = boChildNode.getTextContent();
                    continue;
                }
                if (!"Field".equals(boChildNodeName)) continue;
                List fieldList = (List)boDefToFieldsMap.get(currBOName);
                Field field = this.createField(boChildNode.getChildNodes(), currPhyName);
                if (field == null) continue;
                fieldList.add(field);
            }
        }
        return boDefToFieldsMap;
    }

    private Field createField(NodeList fieldChildNodes, String currPhyName) {
        Field field = new Field();
        for (int i = 0; i < fieldChildNodes.getLength(); ++i) {
            Node fieldChildNode = fieldChildNodes.item(i);
            String fieldChildNodeName = fieldChildNode.getNodeName();
            String fieldChildTextContent = fieldChildNode.getTextContent();
            if ("Name".equals(fieldChildNodeName) && (BOAUDITFIELDS.contains(fieldChildTextContent) || "UpdateDate".equals(fieldChildTextContent) || "UpdateUser".equals(fieldChildTextContent) || "AssignedBy".equals(fieldChildTextContent) || "AssignedDate".equals(fieldChildTextContent)) || "MapTo".equals(fieldChildNodeName) && fieldChildTextContent.contains("+") || "task".equals(currPhyName) && "CBSCodeId".equals(fieldChildTextContent) || "actvtype".equals(currPhyName) && "EPSId".equals(fieldChildTextContent) || "prefer".equals(currPhyName) && "MaxRSRCTreeLevels".equals(fieldChildTextContent) || "project".equals(currPhyName) && "CriticalFloatThreshold".equals(fieldChildTextContent) || "projwbs".equals(currPhyName) && "MaxSequenceNum".equals(fieldChildTextContent) || "rsrccurv".equals(currPhyName) && "AllCurveData".equals(fieldChildTextContent) || "wbsrsrc".equals(currPhyName) && "Committed".equals(fieldChildTextContent) || "udfvalue".equals(currPhyName) && "UDFEndDate".equals(fieldChildTextContent) || "udfvalue".equals(currPhyName) && "UDFInteger".equals(fieldChildTextContent) || "udfvalue".equals(currPhyName) && "UDFCost".equals(fieldChildTextContent) || "udfvalue".equals(currPhyName) && "UDFRAGType".equals(fieldChildTextContent) || "workflow".equals(currPhyName) && "ProcessFlagBoolean".equals(fieldChildTextContent) || "workflow".equals(currPhyName) && "StageModifiedFlagBoolean".equals(fieldChildTextContent) || "workflow".equals(currPhyName) && "NumericCurrentStageNumber".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "PendingUdfEndDate".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "PendingUdfCost".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "PendingUdfNumber".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "PendingUdfCost".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "PendingUDFRAGType".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "OverrideUdfEndDate".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "OverrideUdfNumber".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "OverrideUdfCost".equals(fieldChildTextContent) || "chgudfvalue".equals(currPhyName) && "OverrideUDFRAGType".equals(fieldChildTextContent)) break;
            if ("Name".equals(fieldChildNodeName)) {
                field.setBoFieldName(fieldChildTextContent);
                continue;
            }
            if ("MapTo".equals(fieldChildNodeName) && fieldChildTextContent.startsWith("=" + currPhyName + ".")) {
                field.setSrcTableName(currPhyName);
                field.setSrcColumnName(fieldChildTextContent.split("\\.")[1]);
                continue;
            }
            if (!"Type".equals(fieldChildNodeName)) continue;
            field.setBoFieldType(fieldChildTextContent);
        }
        if (field.getSrcTableName() == null) {
            return null;
        }
        return field;
    }
}

