/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.ScriptRunner;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.ScriptRunner.ErrorValidation;
import com.primavera.database.tools.ScriptRunner.ScriptEvent;
import com.primavera.database.tools.ScriptRunner.ScriptFile;
import com.primavera.database.tools.ScriptRunner.ScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptProperties;
import com.primavera.database.tools.ScriptRunner.ScriptStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ScriptRunner {
    static final String DEFAULT_PROPERTY_FILE_NAME = "scriptrunner.properties";
    static final String DBSETUP_PROPERTY = "dbinfr.tools.scriptrunner.propertyfile";
    Properties extendedProperties;
    ScriptProperties properties;
    ArrayList<ScriptListener> listeners = new ArrayList();
    DatabaseConnection dbconn;
    ScriptFile.InputStreamFactory m_inputStreamFactory;
    private int processedStatements = 0;
    private int totalStatements = 0;
    private int warnings = 0;
    private int successful = 0;
    private boolean continueOnError = false;

    public ScriptRunner() throws DatabaseToolException {
        File userHome;
        String fileName;
        File file;
        File dpfile;
        String extPropName = null;
        String dbsetup_property_file = System.getProperty(DBSETUP_PROPERTY);
        if (dbsetup_property_file != null && (dpfile = new File(dbsetup_property_file)).exists()) {
            extPropName = dbsetup_property_file;
        }
        if (extPropName == null && (file = new File(fileName = (userHome = new File(System.getProperty("user.home"))).getAbsolutePath() + File.separatorChar + DEFAULT_PROPERTY_FILE_NAME)).exists()) {
            extPropName = fileName;
        }
        Properties extended_properties = new Properties();
        if (extPropName != null) {
            try {
                extended_properties.load(new FileInputStream(new File(extPropName)));
            }
            catch (IOException e) {
                throw new DatabaseToolException(e.getMessage(), e);
            }
        }
        this.properties = new ScriptProperties(extended_properties);
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean conintueOnError) {
        this.continueOnError = conintueOnError;
    }

    public DatabaseConnection getDbconn() {
        return this.dbconn;
    }

    public void setDbconn(DatabaseConnection dbconn) {
        this.dbconn = dbconn;
    }

    public Properties getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Properties extendedProperties) throws DatabaseToolException {
        this.extendedProperties = extendedProperties;
        this.properties = new ScriptProperties(extendedProperties);
    }

    public void setScriptUrl(URL scriptUri) {
        this.m_inputStreamFactory = new ScriptFile.UrlInputStreamFactory(scriptUri);
    }

    public void setScript(String filename) throws DatabaseToolException {
        try {
            this.setScriptUrl(new File(filename).toURI().toURL());
        }
        catch (Exception e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
    }

    public void run() throws DatabaseToolException {
        ScriptStatement stmt;
        ScriptFile sf = new ScriptFile(this.m_inputStreamFactory);
        this.totalStatements = sf.getCount();
        this.processedStatements = 0;
        this.warnings = 0;
        this.successful = 0;
        this.sendScriptBegin();
        while ((stmt = sf.getNext()) != null) {
            this.runSQL(stmt);
        }
        this.sendScriptComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSQL(ScriptStatement scriptStmt) throws DatabaseToolException {
        scriptStmt.setProperties(this.properties);
        String sql = scriptStmt.getString();
        try (Statement stmt = this.dbconn.getConnection().createStatement();){
            try {
                this.sendStatementBegin(scriptStmt);
                ++this.processedStatements;
                stmt.execute(sql);
                ++this.successful;
                this.sendStatementComplete(scriptStmt);
            }
            catch (SQLException e) {
                if (!this.isSuccessfull(e, scriptStmt)) {
                    if (!this.continueOnError) {
                        throw e;
                    }
                } else {
                    ++this.warnings;
                    this.sendStatementError(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.continueOnError) {
                    throw new DatabaseToolException(e.getMessage(), e);
                }
            }
        }
        catch (DatabaseToolException te) {
            te.setSql(sql);
            throw te;
        }
        catch (SQLException e) {
            DatabaseToolException te = new DatabaseToolException(e.getMessage(), e.getErrorCode(), e.getSQLState(), e);
            te.setSql(sql);
            throw te;
        }
        catch (Throwable e) {
            e.printStackTrace();
            DatabaseToolException te = new DatabaseToolException(e.getMessage(), e);
            te.setSql(sql);
            throw te;
        }
    }

    private void sendStatementError(SQLException e) {
        ScriptEvent event = new ScriptEvent(this);
        event.setErrorNum(e.getErrorCode());
        event.setMessage(e.getMessage());
        this.setEventTotals(event);
        Iterator<ScriptListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScriptListener scriptListener;
            ScriptListener sl = scriptListener = iterator.next();
            sl.scriptEvent(event);
        }
    }

    private void sendStatementBegin(ScriptStatement stmt) {
        ScriptEvent event = new ScriptEvent(this);
        event.setScriptStatement(stmt);
        this.setEventTotals(event);
        Iterator<ScriptListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScriptListener element;
            ScriptListener sl = element = iterator.next();
            sl.statementBegin(event);
        }
    }

    private void sendStatementComplete(ScriptStatement stmt) {
        ScriptEvent event = new ScriptEvent(this);
        event.setScriptStatement(stmt);
        this.setEventTotals(event);
        Iterator<ScriptListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScriptListener element;
            ScriptListener sl = element = iterator.next();
            sl.statementComplete(event);
        }
    }

    private void sendScriptBegin() {
        ScriptEvent event = new ScriptEvent(this);
        event.setMessage("Script Begin: " + this.m_inputStreamFactory.getLocation());
        this.setEventTotals(event);
        Iterator<ScriptListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScriptListener element;
            ScriptListener sl = element = iterator.next();
            sl.scriptBegin(event);
        }
    }

    private void sendScriptComplete() {
        ScriptEvent event = new ScriptEvent(this);
        this.setEventTotals(event);
        event.setMessage("Script Complete: " + this.m_inputStreamFactory.getLocation());
        Iterator<ScriptListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScriptListener element;
            ScriptListener sl = element = iterator.next();
            sl.scriptComplete(event);
        }
    }

    private void setEventTotals(ScriptEvent event) {
        event.setProcessedStatements(this.processedStatements);
        event.setTotalStatements(this.totalStatements);
    }

    private boolean isSuccessfull(SQLException e, ScriptStatement scriptStmt) {
        return ErrorValidation.acceptable(this.dbconn.getServerType(), scriptStmt.getObjectType(), scriptStmt.getChangeType(), e.getErrorCode());
    }

    public void addListener(ScriptListener listener) {
        this.listeners.add(listener);
    }

    public void setScriptInputStreamFactory(ScriptFile.InputStreamFactory factory) {
        this.m_inputStreamFactory = factory;
    }
}

