/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader;

import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.SQLRowInserter;
import com.primavera.database.common.container.XMLRowHandler;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.Dataloader.Dataloader;
import java.sql.SQLException;

class DataLoaderDBHandler
implements XMLRowHandler {
    public SQLRowInserter inserter;
    public boolean failMetadata = false;
    public String lastMessage = null;
    public boolean failLoad = false;
    public int failedRows = 0;
    public Dataloader dataloader;

    DataLoaderDBHandler() {
    }

    @Override
    public void processMetaData(RowContainer rc) {
        try {
            this.inserter.initializeMetaData(this.dataloader.getCurrentTable(), rc);
        }
        catch (SQLException e) {
            this.failMetadata = true;
            this.lastMessage = e.getMessage();
        }
    }

    @Override
    public void processRow(RowContainer rc, int row) {
        try {
            this.dataloader.sendRowBegin();
            this.inserter.insert(rc);
            this.dataloader.sendRowComplete();
            if (row % this.dataloader.getCommitPoint() == 0) {
                this.inserter.executeBatch();
                this.dataloader.targetCommit();
                SQLRowInserter.batchRowCounter = 0;
                this.dataloader.sendTableProgress();
            }
        }
        catch (SQLException e) {
            this.logError(rc, row, e.getMessage(), e);
            e.printStackTrace();
            this.dataloader.sendDataLoadError(e);
        }
    }

    private void logError(RowContainer rc, int row, String message, Throwable e) {
        this.failMetadata = true;
        this.lastMessage = message;
        Log.error("Error: table=" + this.dataloader.getCurrentTable() + ":" + message);
    }

    @Override
    public void finishedProcessingRows() {
    }

    @Override
    public void processLeftOutRows() {
        try {
            this.inserter.executeBatch();
            this.dataloader.targetCommit();
            this.dataloader.sendTableProgress();
            SQLRowInserter.batchRowCounter = 0;
        }
        catch (SQLException e) {
            this.dataloader.sendDataLoadError(e);
        }
    }
}

