/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BlobEncodingUtil {
    public static final String UTF_8 = "UTF-8";
    public static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final Set<String> NON_HTML_BLOBS_TABLE = new HashSet<String>(Arrays.asList("RSRCCURV.CURV_DATA", "RPT.RPT_DATA", "PRMQUEUE.QUEUE_PAYLOAD_EXTENDED", "PRMAUDIT.AUDIT_INFO_EXTENDED", "PAUDIT.AUDIT_EXT_OLD", "PAUDIT.AUDIT_EXT_NEW", "PREFER.LICENSE_DATA", "PFOLIO.PFOLIO_DATA", "JOBSVC.JOB_DATA", "JOBRPT.JOBRPT_DATA", "JOBLOG.JOB_LOG_DATA", "ISSUHIST.ISSUE_HISTORY", "GCHANGE.GCHANGE_DATA", "FORMTMPL.FORM_TMPL_DATA", "FILTPROP.FILTER_DATA", "DASHBOARD.PORTLET_SETTINGS_DATA", "CALENDAR.CLNDR_DATA", "ADMIN_CONFIG.CONFIG_DATA", "WORKSPACE.WORKSPACE_PREFS", "VWPREFDATA.VIEW_PREF_VALUE_BLOB", "VIEWPROP.VIEW_DATA", "USERSET.USERSET_BLOB", "USERDATA.USER_DATA", "TRAKVIEW.TRACK_VIEW_DATA", "TIMESHT.TS_NOTES", "TASKRSRC.RSRC_REQUEST_DATA", "TASKNOTE.TASK_NOTES", "TASKFDBK.TASK_FDBK", "PROJPROP.PROP_VALUE", "OBS.OBS_DESCR"));
    private static final Set<String> IMAGE_BLOBS_TABLE = new HashSet<String>(Arrays.asList("IMAGEDATA.IMAGE_DATA", "IMAGEDATA.IMAGE_THUMBNAIL"));

    public static boolean isNonHTMLField(String tableName, String fieldName) {
        return NON_HTML_BLOBS_TABLE.contains(tableName.toUpperCase() + "." + fieldName.toUpperCase());
    }

    public static boolean isImageField(String tableName, String fieldName) {
        return IMAGE_BLOBS_TABLE.contains(tableName.toUpperCase() + "." + fieldName.toUpperCase());
    }

    public static boolean hasBOM(byte[] bytes) {
        if (bytes.length < UTF_8_BOM.length) {
            return false;
        }
        for (int i = 0; i < UTF_8_BOM.length; ++i) {
            if (bytes[i] == UTF_8_BOM[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBEncoding(Connection conn) throws SQLException {
        try (CallableStatement cs = null;){
            cs = conn.prepareCall("{call db_to_iana_charset( ? )}");
            cs.registerOutParameter(1, 1);
            cs.execute();
            String encoding = cs.getString(1);
            if (encoding == null) {
                String string = UTF_8;
                return string;
            }
            String string = encoding.toUpperCase();
            return string;
        }
    }

    public static void dbgOut(String msg) {
        DBMTLogger.info(Channel.DEV, msg);
    }

    public static void dbgBlob(byte[] blobData) {
        String blobString = "ABCDEF";
        int offset = 0;
        if (BlobEncodingUtil.hasBOM(blobData)) {
            offset = UTF_8_BOM.length;
        }
        byte[] bytes = Arrays.copyOfRange(blobData, offset, 12);
        try {
            blobString = new String(bytes, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        System.out.println(blobString);
        for (int i = 0; i < 12 + offset; ++i) {
            if (i >= blobData.length) continue;
            System.out.print(" " + blobData[i]);
        }
        System.out.println();
    }

    public static String toStringWithUTF8(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static void throwError() {
        Object b = null;
        b.toString();
    }
}

