/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.database.common.Base64;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.container.EncodingUtil;
import com.primavera.database.tools.BlobEncodingUtil;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RowElement {
    static final DateFormat DATE_FORMAT_W_DASHES = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static final DateFormat DATE_FORMAT_WO_DASHES = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private GenericDataTypes m_type = GenericDataTypes.STRING;
    private String m_data = "";
    private String m_name = "";
    private int m_size = 0;
    private byte[] m_bytes = new byte[0];
    private Object m_object = null;

    public void setName(String name) {
        this.m_name = name;
    }

    private int dataSize() {
        if (this.getType() == GenericDataTypes.BLOB) {
            return this.m_bytes.length;
        }
        return this.m_data.length();
    }

    public int getSize() {
        if (this.m_size == 0) {
            return this.dataSize();
        }
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public String getName() {
        return this.m_name;
    }

    public void setType(GenericDataTypes type) {
        this.m_type = type;
    }

    public GenericDataTypes getType() {
        return this.m_type;
    }

    private boolean isNumeric(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i)) || s.charAt(i) == 'E' || s.charAt(i) == '-' || s.charAt(i) == ',' || s.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }

    private Date parseDate(String s) throws ParseException {
        if (s.contains("T") && s.contains("-") && s.contains(":")) {
            s = s.replace('T', ' ');
            return DATE_FORMAT_W_DASHES.parse(s);
        }
        if (s.contains("T")) {
            s = s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8) + " " + s.substring(9, 17);
        } else if (s.length() == 8) {
            s = s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8) + " 0:0:0";
        }
        return DATE_FORMAT_W_DASHES.parse(s);
    }

    private String convertToString(Date d) {
        return DATE_FORMAT_W_DASHES.format(d);
    }

    private String convertToXMLSafeString(Date d) {
        String ds = DATE_FORMAT_WO_DASHES.format(d);
        return ds.replace(" ", "T") + "000";
    }

    public void setValue(String val) throws Exception {
        if (this.m_type == GenericDataTypes.INTEGER || this.m_type == GenericDataTypes.NUMBER) {
            if (!this.isNumeric(val)) {
                throw new Exception("Value not of a valid numeric type (" + val + ") for element " + this.m_name);
            }
        } else if (this.m_type == GenericDataTypes.DATE) {
            try {
                val = this.convertToString(this.parseDate(val));
            }
            catch (ParseException ex) {
                throw new Exception("Value not of a valid date string.  Type is YYYY-MM-DD HH:mm:ss.s");
            }
        } else if (this.m_type == GenericDataTypes.BLOB) {
            this.m_bytes = val.getBytes();
        } else if (this.m_type == GenericDataTypes.BINARY) {
            this.m_bytes = val.getBytes(Charset.forName("UTF-8"));
        }
        this.m_data = val;
        this.m_size = this.m_data != null ? this.m_data.length() : 0;
    }

    public String getValue() {
        if (this.m_type == GenericDataTypes.BLOB) {
            return BlobEncodingUtil.toStringWithUTF8(this.m_bytes);
        }
        if (this.m_data == null) {
            return new String();
        }
        return this.m_data;
    }

    private String xmlSafeString(String s) {
        byte[] b;
        if (s.length() == 1 && (b = s.getBytes())[0] == 0) {
            return "";
        }
        return EncodingUtil.encodeString(s.trim(), EncodingUtil.s_htmlEncodeChars);
    }

    public String getXMLSafeValue() throws Exception {
        if (this.m_type == GenericDataTypes.STRING || this.m_type == GenericDataTypes.MEMO || this.m_type == GenericDataTypes.XMLTYPE) {
            return this.xmlSafeString(this.m_data);
        }
        if (this.m_type == GenericDataTypes.BLOB || this.m_type == GenericDataTypes.IMAGE) {
            return this.getBase64();
        }
        if (this.m_type == GenericDataTypes.DATE) {
            try {
                return this.convertToXMLSafeString(this.parseDate(this.m_data));
            }
            catch (ParseException ex) {
                throw new Exception(ex.getMessage());
            }
        }
        return this.m_data;
    }

    public void setInt(int val) throws Exception {
        this.setType(GenericDataTypes.INTEGER);
        this.setValue(String.valueOf(val));
    }

    public int getInt() {
        return Integer.parseInt(this.m_data);
    }

    public void setDouble(double val) throws Exception {
        this.setType(GenericDataTypes.NUMBER);
        this.setValue(String.valueOf(val));
    }

    public double getDouble() {
        return Double.parseDouble(this.m_data);
    }

    public void setDate(Date val) throws Exception {
        this.setType(GenericDataTypes.DATE);
        this.setValue(this.convertToString(val));
    }

    public Date getDate() throws Exception {
        try {
            return this.parseDate(this.m_data);
        }
        catch (ParseException ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void setBytes(byte[] bytes) {
        this.setType(GenericDataTypes.BLOB);
        this.m_bytes = bytes;
        this.m_size = bytes.length;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public void setObject(Object obj) {
        this.m_object = obj;
    }

    public Object getObject() {
        return this.m_object;
    }

    public String getBase64() {
        if (this.m_type == GenericDataTypes.BLOB || this.m_type == GenericDataTypes.IMAGE) {
            return Base64.encodeBytes(this.m_bytes);
        }
        return Base64.encodeBytes(this.m_data.getBytes());
    }

    public boolean isNull(boolean treatEmptyStringsAsNull) {
        if (this.m_type == GenericDataTypes.BLOB || this.m_type == GenericDataTypes.IMAGE || this.m_type == GenericDataTypes.BINARY) {
            if (this.m_bytes == null) {
                return true;
            }
            return treatEmptyStringsAsNull && this.m_bytes.length == 0;
        }
        if (this.m_data == null) {
            return true;
        }
        return treatEmptyStringsAsNull && this.m_data.length() == 0;
    }

    public void setEmpty() {
        this.m_data = "";
        this.m_bytes = new byte[0];
        this.m_size = 0;
        this.m_object = null;
    }
}

