/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.DynamicClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TestRuntimeClasspathManipulation {
    private static final String PARAM_NAME_ADD_JAR = "--ADD";
    private static final String s_classToLoad = System.getProperty("class.to.load", "com.primavera.er.deploy.CustomSubstitution");
    private final List<String> m_jarFiles = new ArrayList<String>();

    public void processCommandLine(String[] args) throws UsageError {
        int i = 0;
        while (i < args.length) {
            if (!PARAM_NAME_ADD_JAR.equals(args[i].toUpperCase())) continue;
            if (++i >= args.length) {
                throw new CommandLineParameterValueNotSpecified(PARAM_NAME_ADD_JAR);
            }
            this.m_jarFiles.add(args[i]);
            ++i;
        }
    }

    public void doTest() throws Exception {
        System.out.println("There were " + this.m_jarFiles.size() + " Jar files specified");
        for (String jarName : this.m_jarFiles) {
            System.out.println("\t" + jarName);
        }
        String className = s_classToLoad;
        String methodName = "getConfigPrefix";
        System.out.println("Before adding jar files, attempting to load " + className);
        boolean exceptionThrown = false;
        try {
            this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            exceptionThrown = true;
        }
        if (!exceptionThrown) {
            System.err.println("Hmmm, unexpectedly able to find class");
        }
        for (String jarName : this.m_jarFiles) {
            DynamicClassLoader.addFile(jarName);
            System.out.println("Added " + jarName);
        }
        Class<?> dynamicallyLoadedClass = this.getClass().getClassLoader().loadClass(className);
        if (dynamicallyLoadedClass == null) {
            throw new Exception("Unable to load class " + className);
        }
        Object instance = dynamicallyLoadedClass.newInstance();
        if (instance == null) {
            throw new Exception("Unable to create instance of class " + className);
        }
        Method dynamicallyCalledMethod = dynamicallyLoadedClass.getMethod(methodName, new Class[0]);
        if (dynamicallyCalledMethod == null) {
            throw new Exception("Unable to find method " + dynamicallyCalledMethod + " in class " + className);
        }
    }

    public static void main(String[] args) {
        TestRuntimeClasspathManipulation test = new TestRuntimeClasspathManipulation();
        try {
            test.processCommandLine(args);
        }
        catch (UsageError e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            test.doTest();
        }
        catch (Exception e) {
            System.out.println("Caught Exception: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    private static class UsageError
    extends Exception {
        private static final long serialVersionUID = 3708279207009739411L;

        private UsageError() {
        }
    }

    private static class CommandLineParameterValueNotSpecified
    extends UsageError {
        private static final long serialVersionUID = -959496287109047230L;
        private String m_paremeterName;

        public CommandLineParameterValueNotSpecified(String parameterName) {
            this.m_paremeterName = parameterName;
        }

        @Override
        public String getMessage() {
            return "The parameter " + this.m_paremeterName + " required a value";
        }
    }
}

