/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DataDictionary {
    private Connection m_conn;
    private DatabaseMetaData m_metadata;
    private ServerType m_serverType;
    private String m_currentuser;
    private String m_tableowner;

    public DataDictionary(Connection conn) throws SQLException {
        this.m_conn = conn;
        this.m_metadata = conn.getMetaData();
        this.m_serverType = DatabaseHelper.getServerType(conn);
        this.m_currentuser = DatabaseHelper.getCurrentSchema(conn);
        String verTab = "CVRT";
        if (!this.tableExists("CVRT")) {
            verTab = "PREFER";
        }
        this.m_tableowner = DatabaseHelper.getTableOwner(this.m_conn, verTab);
        if (this.m_tableowner.length() == 0) {
            this.m_tableowner = this.m_serverType == ServerType.SQLSERVER ? "dbo" : this.m_currentuser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getColumns(String tablename) throws SQLException {
        ArrayList<String> st = new ArrayList<String>();
        try (ResultSet rs = this.m_metadata.getColumns(null, this.m_tableowner, tablename, "%");){
            while (rs.next()) {
                String columnname = rs.getString("COLUMN_NAME");
                if (st.contains(columnname) || this.isFreak(tablename, columnname)) continue;
                st.add(columnname);
            }
        }
        return st;
    }

    private boolean isFreak(String tableName, String columnName) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getTables(String tablepattern) throws SQLException {
        ArrayList<String> st = new ArrayList<String>();
        if (tablepattern == null || tablepattern.length() == 0) {
            tablepattern = "%";
        }
        String schemapattern = "%";
        if (this.m_tableowner.length() > 0) {
            schemapattern = this.m_tableowner;
        }
        String[] types = new String[]{"TABLE"};
        try (ResultSet rs = this.m_metadata.getTables(null, schemapattern, tablepattern, types);){
            while (rs.next()) {
                if (rs.getString("TABLE_NAME").startsWith("BIN$")) continue;
                st.add(rs.getString("TABLE_NAME"));
            }
        }
        return st;
    }

    public boolean tableExists(String tablename) throws SQLException {
        String sql = null;
        if (this.m_serverType == ServerType.ORACLE) {
            sql = "select count(*) from all_tables where table_name = ";
        } else if (this.m_serverType == ServerType.SQLSERVER) {
            sql = "select count(*) from sysobjects so where type = 'U' and name = ";
        } else if (this.m_serverType == ServerType.SYBASE) {
            sql = "select count(*) from syscatalog where creator = current user and tname = ";
        } else {
            return false;
        }
        sql = sql + "'" + tablename.toUpperCase() + "'";
        return DataDictionary.getOneQueryValue(this.m_conn, sql) >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOneQueryValue(Connection conn, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public ArrayList<String> getRefTables(DatabaseConnection dbconn, String tablename) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ServerType st = dbconn.getServerType();
        String tableOwner = DatabaseHelper.getTableOwner(dbconn.getConnection(), tablename);
        String sql = null;
        if (st == ServerType.ORACLE || st == ServerType.ORACLEATP) {
            sql = "select rc.table_name from all_constraints rc, all_constraints pc where pc.table_name = ? and pc.owner = '" + tableOwner + "' and rc.owner = '" + tableOwner + "' and pc.constraint_type = 'R' and pc.r_constraint_name = rc.constraint_name";
        } else if (st == ServerType.SQLSERVER) {
            sql = "select distinct soc2.name from sysobjects soc, sysobjects sop, sysforeignkeys sfk, sysobjects soc2 where sop.name = ? and soc.xtype ='F' and sop.id = soc.parent_obj and sfk.rkeyid = soc2.id and sfk.constid = soc.id";
        } else if (st == ServerType.SYBASE) {
            sql = "select pt.table_name  from SYSFOREIGNKEY sf, systable ft, systable pt where ft.table_name = ? and pt.table_id = sf.primary_table_id and ft.table_id = sf.foreign_table_id";
        }
        PreparedStatement stmt = dbconn.getConnection().prepareStatement(sql);
        stmt.setString(1, tablename);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            list.add(rs.getString(1));
        }
        rs.close();
        stmt.close();
        return list;
    }
}

