/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins;

import com.primavera.PhoenixException;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.updatelogins.LoginTableDelta;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class PrivateDatabaseLoginsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4943688697930034208L;
    private static final String[] COLUMN_HEADERS = new String[]{"dbmt.update.private.database.logins.table.column.groupid.title", "dbmt.update.private.database.logins.table.column.username.title"};
    private final List<Record> records = new ArrayList<Record>();
    private final List<LoginTableDelta> edits = new ArrayList<LoginTableDelta>();
    private final Set<PrivateDatabaseLoginsTableModelListener> listeners = new HashSet<PrivateDatabaseLoginsTableModelListener>();

    public synchronized void addListener(PrivateDatabaseLoginsTableModelListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(PrivateDatabaseLoginsTableModelListener l) {
        this.listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataUpdated() {
        HashSet<PrivateDatabaseLoginsTableModelListener> lcopy = new HashSet<PrivateDatabaseLoginsTableModelListener>();
        PrivateDatabaseLoginsTableModel privateDatabaseLoginsTableModel = this;
        synchronized (privateDatabaseLoginsTableModel) {
            lcopy.addAll(this.listeners);
        }
        for (PrivateDatabaseLoginsTableModelListener l : lcopy) {
            l.dataUpdated();
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < this.records.size()) {
            switch (columnIndex) {
                case 0: {
                    this.setNewGroupId(rowIndex, Integer.parseInt(value.toString()));
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    break;
                }
                case 1: {
                    this.setNewUsername(rowIndex, value.toString());
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
            }
        }
    }

    public boolean isUniqueGroupId(int id) {
        for (Record r : this.records) {
            if (r.group_id != id) continue;
            return false;
        }
        return true;
    }

    public boolean isUniqueUsername(String username) {
        for (Record r : this.records) {
            if (!r.username.equals(username)) continue;
            return false;
        }
        return true;
    }

    private void setNewUsername(int rowIndex, String newName) {
        Record oldRecord = this.records.get(rowIndex);
        String oldName = oldRecord.username;
        this.records.set(rowIndex, new Record(oldRecord.group_id, newName, oldRecord.password));
        LoginTableDelta topDelta = null;
        if (this.edits.size() > 0) {
            topDelta = this.edits.get(this.edits.size() - 1);
        }
        if (topDelta == null || topDelta.type != LoginTableDelta.DeltaType.ADD_RECORD || topDelta.row != rowIndex) {
            this.edits.add(new LoginTableDelta.AlterUsername(rowIndex, oldRecord.group_id, oldName, newName));
        } else {
            Record r = ((LoginTableDelta.AddDelta)topDelta).record;
            this.edits.set(this.edits.size() - 1, new LoginTableDelta.AddDelta(topDelta.row, new Record(r.group_id, newName, r.password)));
        }
        this.fireDataUpdated();
    }

    private void setNewGroupId(int rowIndex, int newId) {
        Record oldRecord = this.records.get(rowIndex);
        int oldId = oldRecord.group_id;
        this.records.set(rowIndex, new Record(newId, oldRecord.username, oldRecord.password));
        LoginTableDelta topDelta = null;
        if (this.edits.size() > 0) {
            topDelta = this.edits.get(this.edits.size() - 1);
        }
        if (topDelta == null || topDelta.type != LoginTableDelta.DeltaType.ADD_RECORD || topDelta.row != rowIndex) {
            this.edits.add(new LoginTableDelta.AlterGroupId(rowIndex, oldId, newId));
        } else {
            Record r = ((LoginTableDelta.AddDelta)topDelta).record;
            this.edits.set(this.edits.size() - 1, new LoginTableDelta.AddDelta(topDelta.row, new Record(newId, r.username, r.password)));
        }
        this.fireDataUpdated();
    }

    public void setNewPassword(int rowIndex, String newPass) {
        Record oldRecord = this.records.get(rowIndex);
        String oldPass = oldRecord.password;
        this.records.set(rowIndex, new Record(oldRecord.group_id, oldRecord.username, newPass));
        LoginTableDelta topDelta = null;
        if (this.edits.size() > 0) {
            topDelta = this.edits.get(this.edits.size() - 1);
        }
        if (topDelta == null || topDelta.type != LoginTableDelta.DeltaType.ADD_RECORD || topDelta.row != rowIndex) {
            this.edits.add(new LoginTableDelta.AlterPassword(rowIndex, oldRecord.group_id, oldPass, newPass));
        } else {
            Record r = ((LoginTableDelta.AddDelta)topDelta).record;
            this.edits.set(this.edits.size() - 1, new LoginTableDelta.AddDelta(topDelta.row, new Record(r.group_id, r.username, newPass)));
        }
        this.fireDataUpdated();
    }

    public void addNewRecord(int newGroupId, String newUsername, String newPass) {
        int rowIndex = this.records.size();
        this.addRecord(newGroupId, newUsername, newPass);
        this.edits.add(new LoginTableDelta.AddDelta(rowIndex, new Record(newGroupId, newUsername, newPass)));
        this.fireDataUpdated();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.records.size()) {
            Record r = this.records.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return r.group_id;
                }
                case 1: {
                    return r.username;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (column < COLUMN_HEADERS.length) {
            return StringLocalizer.get(COLUMN_HEADERS[column]);
        }
        return "";
    }

    public void addRecord(int id, String name, String password) {
        int newRowIndex = this.records.size();
        this.records.add(new Record(id, name, password));
        this.fireTableRowsInserted(newRowIndex, newRowIndex);
        this.fireDataUpdated();
    }

    public String getPassword(int row) {
        if (row < this.records.size()) {
            return this.records.get((int)row).password;
        }
        return "";
    }

    public void reset() {
        int rowCount = this.records.size();
        if (rowCount == 0) {
            return;
        }
        this.records.clear();
        this.edits.clear();
        this.fireTableRowsDeleted(0, rowCount - 1);
        this.fireDataUpdated();
    }

    public int undoLastEdit() {
        if (this.edits.isEmpty()) {
            return 0;
        }
        LoginTableDelta delta = this.edits.get(this.edits.size() - 1);
        this.edits.remove(this.edits.size() - 1);
        this.undoDelta(delta);
        int esize = this.edits.size();
        this.fireDataUpdated();
        return esize;
    }

    private void undoDelta(LoginTableDelta delta) {
        if (delta.type == LoginTableDelta.DeltaType.ADD_RECORD) {
            this.undoAddRecord((LoginTableDelta.AddDelta)delta);
        }
        if (delta.type == LoginTableDelta.DeltaType.DELETE_RECORD) {
            this.undoDeleteRecord((LoginTableDelta.DeleteDelta)delta);
        }
        if (delta.type == LoginTableDelta.DeltaType.ALTER_GROUP_ID) {
            this.undoAlterGroupId((LoginTableDelta.AlterGroupId)delta);
        }
        if (delta.type == LoginTableDelta.DeltaType.ALTER_USERNAME) {
            this.undoAlterUsername((LoginTableDelta.AlterUsername)delta);
        }
        if (delta.type == LoginTableDelta.DeltaType.ALTER_PASSWORD) {
            this.undoAlterPassword((LoginTableDelta.AlterPassword)delta);
        }
        this.fireDataUpdated();
    }

    private void undoAlterPassword(LoginTableDelta.AlterPassword delta) {
        Record r = this.records.get(delta.row);
        if (!r.password.equals(delta.to)) {
            return;
        }
        this.records.set(delta.row, new Record(r.group_id, r.username, delta.from));
        this.fireDataUpdated();
    }

    private void undoAlterUsername(LoginTableDelta.AlterUsername delta) {
        Record r = this.records.get(delta.row);
        if (!r.username.equals(delta.to)) {
            return;
        }
        this.records.set(delta.row, new Record(r.group_id, delta.from, r.password));
        this.fireTableCellUpdated(delta.row, 1);
        this.fireDataUpdated();
    }

    private void undoAlterGroupId(LoginTableDelta.AlterGroupId delta) {
        Record r = this.records.get(delta.row);
        if (r.group_id != delta.to) {
            return;
        }
        this.records.set(delta.row, new Record(delta.from, r.username, r.password));
        this.fireTableCellUpdated(delta.row, 0);
        this.fireDataUpdated();
    }

    private void undoDeleteRecord(LoginTableDelta.DeleteDelta delta) {
        this.records.add(delta.row, delta.record);
        this.fireTableRowsInserted(delta.row, delta.row);
        this.fireDataUpdated();
    }

    private void undoAddRecord(LoginTableDelta.AddDelta delta) {
        this.records.remove(delta.row);
        this.fireTableRowsDeleted(delta.row, delta.row);
        this.fireDataUpdated();
    }

    public int editCount() {
        return this.edits.size();
    }

    public int generateUniqueGroupId() {
        HashSet<Integer> usedIds = new HashSet<Integer>();
        for (Record r : this.records) {
            usedIds.add(r.group_id);
        }
        int newId = 1;
        while (usedIds.contains(newId)) {
            ++newId;
        }
        return newId;
    }

    public void deleteRecord(int selectedRow) {
        Record r = this.records.get(selectedRow);
        this.records.remove(selectedRow);
        this.fireTableRowsDeleted(selectedRow, selectedRow);
        this.edits.add(new LoginTableDelta.DeleteDelta(selectedRow, r));
        this.fireDataUpdated();
    }

    public void writeEditsToDatabase(DatabaseConnection connection) {
        try {
            for (LoginTableDelta delta : this.edits) {
                String sql = delta.asSql();
                DBMTLogger.info(Channel.DEV, "SQL : " + sql);
                try {
                    PreparedStatement stmt = connection.getConnection().prepareStatement(sql);
                    Throwable throwable = null;
                    try {
                        delta.setParametersIntoStatement(stmt);
                        stmt.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.update.private.database.error.sql.update.error", new String[]{sql, e.toString()}));
                    throw e;
                }
            }
            Connection conn = connection.getConnection();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.edits.clear();
        }
        catch (SQLException e) {
            try {
                connection.getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean isInSavableState() {
        HashMap<Integer, String> loginIdToPasswdMap = new HashMap<Integer, String>();
        HashMap<Integer, String> loginIdToUsernameMap = new HashMap<Integer, String>();
        for (Record record : this.records) {
            loginIdToPasswdMap.put(record.group_id, record.password);
            loginIdToUsernameMap.put(record.group_id, record.username);
        }
        for (LoginTableDelta loginTableDelta : this.edits) {
            LoginTableDelta a;
            Record r;
            if (loginTableDelta.type == LoginTableDelta.DeltaType.ADD_RECORD) {
                r = ((LoginTableDelta.AddDelta)loginTableDelta).record;
                loginIdToPasswdMap.put(r.group_id, r.password);
                loginIdToUsernameMap.put(r.group_id, r.username);
            }
            if (loginTableDelta.type == LoginTableDelta.DeltaType.DELETE_RECORD) {
                r = ((LoginTableDelta.DeleteDelta)loginTableDelta).record;
                loginIdToPasswdMap.remove(r.group_id);
                loginIdToUsernameMap.remove(r.group_id);
            }
            if (loginTableDelta.type == LoginTableDelta.DeltaType.ALTER_USERNAME) {
                a = (LoginTableDelta.AlterUsername)loginTableDelta;
                loginIdToUsernameMap.put(a.groupId, a.to);
            }
            if (loginTableDelta.type == LoginTableDelta.DeltaType.ALTER_GROUP_ID) {
                a = (LoginTableDelta.AlterGroupId)loginTableDelta;
                String username = (String)loginIdToUsernameMap.get(((LoginTableDelta.AlterGroupId)a).from);
                loginIdToUsernameMap.remove(((LoginTableDelta.AlterGroupId)a).from);
                loginIdToUsernameMap.put(((LoginTableDelta.AlterGroupId)a).to, username);
                String password = (String)loginIdToPasswdMap.get(((LoginTableDelta.AlterGroupId)a).from);
                loginIdToPasswdMap.remove(((LoginTableDelta.AlterGroupId)a).from);
                loginIdToPasswdMap.put(((LoginTableDelta.AlterGroupId)a).to, password);
            }
            if (loginTableDelta.type != LoginTableDelta.DeltaType.ALTER_PASSWORD) continue;
            a = (LoginTableDelta.AlterPassword)loginTableDelta;
            loginIdToPasswdMap.put(((LoginTableDelta.AlterPassword)a).groupId, ((LoginTableDelta.AlterPassword)a).to);
        }
        for (Map.Entry entry : loginIdToPasswdMap.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).trim().isEmpty()) {
                DBMTLogger.info(Channel.DEV, "Not savable because there is no password set for group id " + entry.getKey());
                return false;
            }
            try {
                String password = EntryPoint.d((String)((String)entry.getValue()));
                if (password != null && !password.trim().isEmpty()) continue;
                DBMTLogger.info(Channel.DEV, "Not savable because there is no password set for group id " + entry.getKey());
                return false;
            }
            catch (PhoenixException e) {
                return false;
            }
        }
        for (Map.Entry entry : loginIdToUsernameMap.entrySet()) {
            if (entry.getValue() != null && !((String)entry.getValue()).trim().isEmpty()) continue;
            DBMTLogger.info(Channel.DEV, "Not savable because there is no username set for group id " + entry.getKey());
            return false;
        }
        return true;
    }

    static class Record {
        public final int group_id;
        public final String username;
        public final String password;

        public Record(int group_id, String username, String password) {
            this.group_id = group_id;
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return "Record {" + this.group_id + ", " + this.username + ", " + this.password + "}";
        }
    }

    public static interface PrivateDatabaseLoginsTableModelListener {
        public void dataUpdated();
    }
}

