/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.dialogs.LayoutContext;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class SetDefaultDatabaseValuesAction
implements ValueChangedListener {
    private final LayoutContext m_context;
    private final String m_enumFieldName;
    private final String m_userFieldName;
    private final String m_portFieldName;

    public SetDefaultDatabaseValuesAction(LayoutContext context, String dbTypeEnumName, String userField, String portField) {
        this.m_context = context;
        this.m_enumFieldName = dbTypeEnumName;
        this.m_userFieldName = userField;
        this.m_portFieldName = portField;
    }

    private ServerType getSelectedServerType(LayoutContext context, String dbTypeEnumFeidlName) {
        JComponent[] components = context.getBinding(dbTypeEnumFeidlName).getComponents();
        ServerType type = null;
        if (((JRadioButton)components[0]).isSelected()) {
            type = ServerType.ORACLE;
        }
        if (((JRadioButton)components[1]).isSelected()) {
            type = ServerType.SQLSERVER;
        }
        return type;
    }

    @Override
    public void onValueChanged(String fieldId) {
        try {
            Object portNumber = this.m_context.getValue(this.m_portFieldName);
            String port = portNumber == null ? "" : portNumber.toString();
            Object userObject = this.m_context.getValue(this.m_userFieldName);
            String user = userObject == null ? "" : userObject.toString().trim();
            ServerType type = this.getSelectedServerType(this.m_context, this.m_enumFieldName);
            if (type == null) {
                return;
            }
            boolean portSet = false;
            if ("".equals(port)) {
                this.m_context.getBinding(this.m_portFieldName).setComponentData(Integer.toString(type.getDefaultPortNumber()));
                portSet = true;
            }
            boolean userSet = false;
            if ("".equals(user)) {
                this.m_context.getBinding(this.m_userFieldName).setComponentData(type.getAdministratorName());
                userSet = true;
            }
            for (ServerType possibleType : ServerType.values()) {
                if (!portSet && Integer.toString(possibleType.getDefaultPortNumber()).equals(port)) {
                    this.m_context.getBinding(this.m_portFieldName).setComponentData(Integer.toString(type.getDefaultPortNumber()));
                }
                if (userSet || !possibleType.getAdministratorName().equals(user)) continue;
                this.m_context.getBinding(this.m_userFieldName).setComponentData(type.getAdministratorName());
            }
        }
        catch (InteractorDataError error) {
            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
        }
    }
}

