/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LookAndFeelUtil {
    public static void setLookAndFeelAndUIDefaults() {
        LookAndFeelUtil.setLookAndFeel();
        String lookAndFeelClass = UIManager.getLookAndFeel().getClass().getSimpleName();
        UIManager.getDefaults().put("WizardButton.border", LookAndFeelUtil.getWizardButtonBorder(lookAndFeelClass));
        UIManager.getDefaults().put("WizardButton.background", LookAndFeelUtil.getWizardButtonBackground(lookAndFeelClass));
        UIManager.getDefaults().put("TextField.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("PasswordField.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("FormattedTextField.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("ComboBox.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("CheckBox.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("RadioButton.border", LookAndFeelUtil.getTextFieldBorder(lookAndFeelClass));
        UIManager.getDefaults().put("Label.font", LookAndFeelUtil.getLabelFont(lookAndFeelClass));
        UIManager.getDefaults().put("RadioButton.font", LookAndFeelUtil.getLabelFont(lookAndFeelClass));
        UIManager.getDefaults().put("ComboBox.font", LookAndFeelUtil.getLabelFont(lookAndFeelClass));
        UIManager.getDefaults().put("Button.font", LookAndFeelUtil.getLabelFont(lookAndFeelClass));
    }

    private static Font getLabelFont(String lookAndFeelClass) {
        return UIManager.getFont("Label.font").deriveFont(0);
    }

    private static void setLookAndFeel() {
        String lookAndFeelOverride = System.getProperty("dbmt.ui.class.lookandfeel");
        if (lookAndFeelOverride != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeelOverride);
                return;
            }
            catch (Throwable e) {
                System.err.println("Unable to set look and feel to override (" + lookAndFeelOverride + ") : " + e + ", setting to system");
            }
        }
        String systemLookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(systemLookAndFeel);
        }
        catch (Throwable e) {
            System.err.println("Unable to set look and feel to system look and feel (" + systemLookAndFeel + ") : " + e);
        }
    }

    private static Color getWizardButtonBackground(String lookAndFeelClass) {
        Color baseColor = UIManager.getColor("Panel.background");
        return new Color(Math.max(0, baseColor.getRed() - 10), Math.max(0, baseColor.getGreen() - 10), Math.max(0, baseColor.getBlue() - 10));
    }

    private static Border getTextFieldBorder(String lookAndFeelClass) {
        return BorderFactory.createEtchedBorder();
    }

    private static Border getWizardButtonBorder(String lookAndFeelClass) {
        Border textureBorder = BorderFactory.createEtchedBorder();
        Border paddingBorder = BorderFactory.createEmptyBorder(2, 20, 2, 20);
        return BorderFactory.createCompoundBorder(textureBorder, paddingBorder);
    }
}

