/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.FileDialogUtil;
import com.primavera.database.tools.dbmt.gui.util.SelectAllTextFocusListener;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import com.primavera.database.tools.dbmt.xml.util.actions.FileTypeDef;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class FileComponentBinding
extends ComponentBinding {
    private final JPanel m_panel = new JPanel();
    private final JTextField m_text = new JTextField();
    private final JButton m_button;

    public FileComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileDialogUtil.inst();
            }
        }).start();
        FileSelectAction action = new FileSelectAction(data.getDataPath() + "." + fieldId);
        this.m_button = new JButton(action);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)this.m_text, "Center");
        topPanel.add((Component)this.m_button, "East");
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add((Component)topPanel, "North");
        this.m_text.addFocusListener(new SelectAllTextFocusListener(this.m_text));
        this.m_text.setAction(action);
        this.m_button.setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
        this.m_button.setBackground((Color)UIManager.getDefaults().get("WizardButton.background"));
        this.m_button.setMnemonic(data.getMnemonic(fieldId));
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        this.m_text.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                listener.onValueChanged(FileComponentBinding.this.getFieldId());
            }
        });
    }

    @Override
    public String getComponentData() {
        return this.m_text.getText();
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_panel};
    }

    @Override
    public void setComponentData(String dataString) {
        this.m_text.setText(dataString);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_text.setEnabled(isEnabled);
        this.m_button.setEnabled(isEnabled);
    }

    public int getFileSelectionMode() {
        FileTypeDef fileTypeDef = (FileTypeDef)this.getData().getDef().getTypeDef(this.getFieldId());
        if (fileTypeDef.getSelectable() == FileTypeDef.SelectableObject.FILE) {
            return 0;
        }
        if (fileTypeDef.getSelectable() == FileTypeDef.SelectableObject.DIRECTORY) {
            return 1;
        }
        return 2;
    }

    private class FileSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 6157856779047724131L;
        private final String m_fieldPath;

        public FileSelectAction(String fieldPath) {
            super("...");
            this.m_fieldPath = fieldPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent arg0) {
            FileComponentBinding.this.m_panel.setCursor(Cursor.getPredefinedCursor(3));
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(FileComponentBinding.this.getFileSelectionMode());
                chooser.setMultiSelectionEnabled(false);
                chooser.setCurrentDirectory(FileDialogUtil.getMostRecentDirectory(this.m_fieldPath));
                int result = chooser.showOpenDialog(FileComponentBinding.this.m_panel);
                switch (result) {
                    case -1: {
                        JOptionPane.showMessageDialog(FileComponentBinding.this.m_panel, "An error occurred");
                        return;
                    }
                    case 0: {
                        File file = chooser.getSelectedFile();
                        if (!file.isDirectory() && file.exists()) {
                            FileComponentBinding.this.m_panel.setCursor(Cursor.getDefaultCursor());
                            FileComponentBinding.this.m_text.setText(file.getAbsolutePath());
                            FileDialogUtil.setMostRecentDirectory(this.m_fieldPath, file);
                            return;
                        }
                        JOptionPane.showMessageDialog(FileComponentBinding.this.m_panel, StringLocalizer.get("dbmt.action.error.invalidlicensefile", new String[]{file.getPath()}), StringLocalizer.get("dbmt.action.error.invalidlicensefile.title"), 0);
                        return;
                    }
                }
                return;
            }
            finally {
                FileComponentBinding.this.m_panel.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

