/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BooleanComponentBinding
extends ComponentBinding {
    private final JCheckBox m_checkBox = new JCheckBox();

    public BooleanComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        this.m_checkBox.setToolTipText(data.getDesc(fieldId));
        this.m_checkBox.setMnemonic(data.getMnemonic(fieldId));
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        this.m_checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                listener.onValueChanged(BooleanComponentBinding.this.getFieldId());
            }
        });
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_checkBox};
    }

    @Override
    public void setComponentData(String dataString) {
        this.m_checkBox.setSelected(Boolean.parseBoolean(dataString));
    }

    @Override
    public String getComponentData() {
        return Boolean.toString(this.m_checkBox.isSelected()).toUpperCase();
    }
}

