/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TypeToImageMap {
    private static Map<Class<?>, IconResolver> s_iconMap = TypeToImageMap.createIconMap();
    private static Icon s_defaultIcon = TypeToImageMap.getDefaultIcon();

    private static Map<Class<?>, IconResolver> createIconMap() {
        HashMap iconMap = new HashMap();
        iconMap.put(ServerInfo.class, new ServerIconResolver());
        iconMap.put(DatabaseInfo.class, new DatabaseIconResolver());
        return iconMap;
    }

    public static Class<?> getClassForObject(Object obj) {
        Class<?> next = obj.getClass();
        return TypeToImageMap.getClassForClass(next);
    }

    public static Class<?> getClassForClass(Class<?> cls) {
        for (Class<?> next = cls; next != null; next = next.getSuperclass()) {
            if (s_iconMap.containsKey(next)) {
                return next;
            }
            for (Class<?> intf : next.getInterfaces()) {
                if (!s_iconMap.containsKey(intf)) continue;
                return intf;
            }
        }
        return Object.class;
    }

    public static Icon getIconForObject(Object obj) {
        IconResolver iconResolver = s_iconMap.get(TypeToImageMap.getClassForClass(obj.getClass()));
        if (iconResolver == null) {
            return s_defaultIcon;
        }
        return iconResolver.getIconForObject(obj);
    }

    private static synchronized Icon getDefaultIcon() {
        return new ImageIcon(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/DBMTApplicationIcon16x16.png"));
    }

    private static class ServerIconResolver
    extends IconResolver<ServerInfo> {
        private final Icon m_unconnectedIcon = new ImageIcon(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/TreeNodeDBServer.png"));
        private final Icon m_connectedIcon = new ImageIcon(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/TreeNodeDBServerConnected.png"));

        @Override
        protected Icon getIconForTypedObject(ServerInfo obj) {
            if (obj.isConnected()) {
                return this.m_connectedIcon;
            }
            return this.m_unconnectedIcon;
        }
    }

    private static abstract class IconResolver<T> {
        private IconResolver() {
        }

        public final Icon getIconForObject(Object obj) {
            return this.getIconForTypedObject(obj);
        }

        protected abstract Icon getIconForTypedObject(T var1);
    }

    private static class DatabaseIconResolver
    extends IconResolver<DatabaseInfo> {
        Icon m_databaseIcon = new ImageIcon(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/TreeNodeServer.png"));

        private DatabaseIconResolver() {
        }

        @Override
        protected Icon getIconForTypedObject(DatabaseInfo obj) {
            return this.m_databaseIcon;
        }
    }
}

