/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InvalidWizardPageData;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.SetActionTypeTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.gui.DefaultGuiWizardRunner;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class DefaultFrameGuiWizardRunner
extends DefaultGuiWizardRunner {
    private boolean m_userHasFinished = false;
    private final Object m_sychLock = new Object();
    private final JFrame m_frame = new JFrame();
    private int CHECK_TIME_IN_MILLIS = 100;
    static final String FINISH_PAGE = "finish";
    static final String PAGE_UPGRADE_STATUS = "upgrade_status";

    public DefaultFrameGuiWizardRunner(WizardInteractorData data, String actionPath) {
        super(data, actionPath);
        this.getWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DefaultFrameGuiWizardRunner.this.getCancelAction().actionPerformed(null);
            }
        });
        this.layoutDialog(data, actionPath);
    }

    @Override
    protected Window getIconTarget() {
        return this.m_frame;
    }

    @Override
    protected Container getContentPane() {
        return this.m_frame.getContentPane();
    }

    @Override
    protected JRootPane getRootPane() {
        return this.m_frame.getRootPane();
    }

    @Override
    public Window getWindow() {
        return this.m_frame;
    }

    @Override
    protected boolean invokeWindow() {
        this.m_frame.pack();
        this.m_frame.setVisible(true);
        this.waitForUserToAccept();
        return this.isAccept();
    }

    @Override
    protected void setTitle(String titleString) {
        this.m_frame.setTitle(titleString);
    }

    @Override
    protected Action createCancleAction() {
        return new ASyncActionCompltedAction(WizardNavigationAction.CANCEL){
            private static final long serialVersionUID = -3131547838847019810L;

            @Override
            protected void updateState() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean executeRollback() {
                boolean isExecuting = false;
                try {
                    String nextPage = DefaultFrameGuiWizardRunner.this.getData().getNextPage(DefaultFrameGuiWizardRunner.this.topPage());
                    if ((nextPage.equals(DefaultFrameGuiWizardRunner.FINISH_PAGE) || nextPage.equals(DefaultFrameGuiWizardRunner.PAGE_UPGRADE_STATUS)) && DefaultFrameGuiWizardRunner.this.m_jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.UPGRADE && DefaultFrameGuiWizardRunner.this.m_jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM) {
                        InteractorData page = DefaultFrameGuiWizardRunner.this.getData().getPageData(DefaultFrameGuiWizardRunner.this.topPage());
                        if (!m_ROLLBACK_ASKED && page.getDef().doesFieldExit("job-tree")) {
                            JobTreeTypeDef jobTreeDef = (JobTreeTypeDef)page.getDef().getTypeDef("job-tree");
                            jobTreeDef.getJobRunner().cancelJobs();
                            isExecuting = true;
                        }
                        DefaultFrameGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                    }
                    boolean bl = isExecuting;
                    return bl;
                }
                catch (JobPropertyNotFound ex) {
                    DBMTLogger.warn(ex.getLocalizedMessage());
                    boolean bl = isExecuting;
                    return bl;
                }
                catch (InvalidWizardPageData e) {
                    DBMTLogger.warn(Channel.DEV, "Unable to find top page: " + DefaultFrameGuiWizardRunner.this.topPage());
                    boolean bl = isExecuting;
                    return bl;
                }
                finally {
                    DefaultFrameGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
    }

    @Override
    protected Action createFinishAction() {
        return new ASyncActionCompltedAction(WizardNavigationAction.FINISH){
            private static final long serialVersionUID = -5570265085331320711L;

            @Override
            protected boolean executeRollback() {
                return false;
            }

            @Override
            protected void updateState() {
                DefaultFrameGuiWizardRunner.this.accept();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUserToAccept() {
        Thread waitingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean finished = false;
                Object object = DefaultFrameGuiWizardRunner.this.m_sychLock;
                synchronized (object) {
                    finished = DefaultFrameGuiWizardRunner.this.m_userHasFinished;
                }
                while (!finished) {
                    try {
                        object = DefaultFrameGuiWizardRunner.this.m_sychLock;
                        synchronized (object) {
                            DefaultFrameGuiWizardRunner.this.m_sychLock.wait(DefaultFrameGuiWizardRunner.this.CHECK_TIME_IN_MILLIS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = DefaultFrameGuiWizardRunner.this.m_sychLock;
                    synchronized (object) {
                        finished = DefaultFrameGuiWizardRunner.this.m_userHasFinished;
                    }
                }
            }
        });
        Object object = this.m_sychLock;
        synchronized (object) {
            this.m_userHasFinished = false;
        }
        waitingThread.start();
        try {
            waitingThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private abstract class ASyncActionCompltedAction
    extends AbstractAction {
        public ASyncActionCompltedAction(WizardNavigationAction navAction) {
            super(navAction.getName());
        }

        protected abstract void updateState();

        protected abstract boolean executeRollback();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.updateState();
            Object object = DefaultFrameGuiWizardRunner.this.m_sychLock;
            synchronized (object) {
                DefaultFrameGuiWizardRunner.this.m_userHasFinished = true;
                DefaultFrameGuiWizardRunner.this.m_sychLock.notify();
            }
            if (!this.executeRollback()) {
                DefaultFrameGuiWizardRunner.this.m_frame.dispose();
            }
        }
    }
}

