/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.gui.AbstractWorkspace;
import com.primavera.database.tools.dbmt.gui.ApplicationUI;
import com.primavera.database.tools.dbmt.gui.ApplicationUIState;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunner;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunnerPage;
import com.primavera.database.tools.dbmt.gui.InteractorPage;
import com.primavera.database.tools.dbmt.gui.Workspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class ApplicationUIWizard
extends GuiWizardRunner {
    private final ApplicationUI m_ui;
    private final WizardWorkspace m_workspace = new WizardWorkspace();
    private boolean m_userHasFinished = false;
    private final Object m_sychLock = new Object();

    public ApplicationUIWizard(WizardInteractorData wizardData, String actionPath, ApplicationUI ui) {
        super(wizardData, actionPath);
        this.m_ui = ui;
    }

    @Override
    public void displayMessage(String message) {
        JOptionPane.showMessageDialog(this.m_ui.getMainFrame(), message);
    }

    @Override
    protected InteractorPage createNewPage() {
        return new GuiWizardRunnerPage(this);
    }

    @Override
    public JButton getButton(WizardNavigationAction stock) {
        return this.m_workspace.getNavigationButton(stock);
    }

    @Override
    protected Container getContentPane() {
        return this.m_workspace.getContentPane();
    }

    @Override
    protected JButton getDefaultButton() {
        return this.m_workspace.m_nextButton;
    }

    @Override
    public JTextComponent getDescriptionLabel() {
        return this.m_workspace.getDescriptionLabel();
    }

    @Override
    protected Window getIconTarget() {
        return this.m_ui.getMainFrame();
    }

    @Override
    protected JRootPane getRootPane() {
        return this.m_ui.getMainFrame().getRootPane();
    }

    @Override
    public JLabel getTitleLabel() {
        return this.m_workspace.getTitleLabel();
    }

    @Override
    public Window getWindow() {
        return this.m_ui.getMainFrame();
    }

    @Override
    protected boolean invokeWindow() {
        this.m_ui.setWorkspace(this.m_workspace);
        this.waitForUserToAccept();
        return this.isAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUserToAccept() {
        Thread waitingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean finished = false;
                Object object = ApplicationUIWizard.this.m_sychLock;
                synchronized (object) {
                    finished = ApplicationUIWizard.this.m_userHasFinished;
                }
                while (!finished) {
                    try {
                        object = ApplicationUIWizard.this.m_sychLock;
                        synchronized (object) {
                            ApplicationUIWizard.this.m_sychLock.wait(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = ApplicationUIWizard.this.m_sychLock;
                    synchronized (object) {
                        finished = ApplicationUIWizard.this.m_userHasFinished;
                    }
                }
            }
        });
        Object object = this.m_sychLock;
        synchronized (object) {
            this.m_userHasFinished = false;
        }
        waitingThread.start();
    }

    @Override
    public boolean isAccept() {
        return false;
    }

    @Override
    protected void setTitle(String titleString) {
        this.m_workspace.getTitleLabel().setText(titleString);
    }

    private class WizardWorkspace
    extends AbstractWorkspace {
        private final JPanel m_rootPanel = new JPanel();
        private final JPanel m_contentPane = new JPanel();
        private final JTextComponent m_descTextComponent = new JTextArea("This is a description");
        private final JLabel m_titleLabel = new JLabel("This is a title");
        private final JButton m_nextButton = new JButton(new ProceedAction(WizardNavigationAction.NEXT));
        private final JButton m_prevButton = new JButton(new BackupAction());
        private final JButton m_finshButton = new JButton(new FinishAction());
        private final JButton m_cancelButton = new JButton(new CancelAction());

        public WizardWorkspace() {
            JPanel navButtonPanel = this.createNavButtonPanel();
            JPanel infoPanel = this.createInfoPanel();
            JScrollPane scrollPane = new JScrollPane(this.m_contentPane);
            this.m_rootPanel.setLayout(new BorderLayout());
            this.m_rootPanel.add((Component)scrollPane, "Center");
            this.m_rootPanel.add((Component)navButtonPanel, "South");
            this.m_rootPanel.add((Component)infoPanel, "North");
            this.m_contentPane.setBackground(Color.RED);
            this.m_contentPane.setLayout(new BorderLayout());
        }

        private JPanel createInfoPanel() {
            JPanel panel = new JPanel();
            panel.setBackground(Color.BLUE);
            return panel;
        }

        private JPanel createNavButtonPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.GREEN);
            JPanel innerPanel = new JPanel();
            innerPanel.setOpaque(false);
            innerPanel.setLayout(new GridLayout(1, 4));
            innerPanel.add(this.m_nextButton);
            innerPanel.add(this.m_prevButton);
            innerPanel.add(this.m_finshButton);
            innerPanel.add(this.m_cancelButton);
            panel.add((Component)innerPanel, "East");
            return panel;
        }

        public JButton getNavigationButton(WizardNavigationAction action) {
            if (action == WizardNavigationAction.NEXT) {
                return this.m_nextButton;
            }
            if (action == WizardNavigationAction.INSTALL) {
                return this.m_nextButton;
            }
            if (action == WizardNavigationAction.CREATE) {
                return this.m_nextButton;
            }
            if (action == WizardNavigationAction.UPGRADE) {
                return this.m_nextButton;
            }
            if (action == WizardNavigationAction.PREV) {
                return this.m_prevButton;
            }
            if (action == WizardNavigationAction.CANCEL) {
                return this.m_cancelButton;
            }
            if (action == WizardNavigationAction.FINISH) {
                return this.m_finshButton;
            }
            return null;
        }

        @Override
        public void connect(ApplicationUIState uiState) {
        }

        @Override
        public void disconnect(ApplicationUIState uiState) {
        }

        @Override
        public JComponent getRoot() {
            return this.m_rootPanel;
        }

        @Override
        public void workspaceChanged(Workspace newWorkspace) {
        }

        public Container getContentPane() {
            return this.m_contentPane;
        }

        public JTextComponent getDescriptionLabel() {
            return this.m_descTextComponent;
        }

        public JLabel getTitleLabel() {
            return this.m_titleLabel;
        }

        private class FinishAction
        extends WizardButtonAction {
            private static final long serialVersionUID = -1452021194417860862L;

            public FinishAction() {
                super(WizardNavigationAction.FINISH);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private class BackupAction
        extends WizardButtonAction {
            private static final long serialVersionUID = -7340799077782266170L;

            public BackupAction() {
                super(WizardNavigationAction.PREV);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private class ProceedAction
        extends WizardButtonAction {
            private static final long serialVersionUID = 6878287501722503492L;

            public ProceedAction(WizardNavigationAction navAction) {
                super(navAction);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private class CancelAction
        extends WizardButtonAction {
            private static final long serialVersionUID = -4520398620938072096L;

            public CancelAction() {
                super(WizardNavigationAction.CANCEL);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private abstract class WizardButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = -7492987770233792032L;

            public WizardButtonAction(WizardNavigationAction navAction) {
                super(navAction.getName());
            }
        }
    }
}

