/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.charconv;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.DatabaseToolException;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class RunCharConv {
    private static final String CHAR_CONV_STORPROC = "{call char_conv(?,?,?,?)}";
    private static final String SOUCRE_PARAM_IN = "p_src_chr_set";
    private static final String TARGET_PARAM_IN = "p_target_chr_set";
    private static final String TABLELIST_PARAM_IN = "p_tbl_name_list";
    private static final String MESSAGE_PARAM_OUT = "o_msg";
    private static final String STATUS_MESSAGE = "Success";
    private static RunCharConv m_runCharConv;
    private DatabaseConnection m_conn;
    private String m_sourceCharset;
    private String m_targetCharset;
    private String m_tableList;

    public static RunCharConv getRunCharConv() {
        if (m_runCharConv == null) {
            m_runCharConv = new RunCharConv();
        }
        return m_runCharConv;
    }

    public DatabaseConnection getConnection() {
        return this.m_conn;
    }

    public void setConnection(DatabaseConnection m_conn) {
        this.m_conn = m_conn;
    }

    public String getSourceCharset() {
        return this.m_sourceCharset;
    }

    public void setSourceCharset(String m_sourceCharset) {
        this.m_sourceCharset = m_sourceCharset;
    }

    public String getTargetCharset() {
        return this.m_targetCharset;
    }

    public void setTargetCharset(String m_targetCharset) {
        this.m_targetCharset = m_targetCharset;
    }

    public String getTableList() {
        return this.m_tableList;
    }

    public void setTableList(String m_tableList) {
        this.m_tableList = m_tableList;
    }

    public boolean runCharsetConversion() throws DatabaseToolException {
        try {
            if (this.m_conn == null || this.m_conn.getConnection().isClosed()) {
                throw new DatabaseToolException("No Database Connection");
            }
            CallableStatement stmt = this.m_conn.getConnection().prepareCall(CHAR_CONV_STORPROC);
            stmt.setString(SOUCRE_PARAM_IN, this.m_sourceCharset);
            stmt.setString(TARGET_PARAM_IN, this.m_targetCharset);
            stmt.setString(TABLELIST_PARAM_IN, this.m_tableList);
            stmt.registerOutParameter(MESSAGE_PARAM_OUT, 12);
            stmt.execute();
            System.out.println(stmt.getString(MESSAGE_PARAM_OUT));
            if (STATUS_MESSAGE.equals(stmt.getString(MESSAGE_PARAM_OUT))) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new DatabaseToolException(e.getMessage(), e);
        }
        return false;
    }
}

