/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.DatabaseToolException;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.ProductUpgradeVersionInfo;
import com.primavera.database.tools.dbmt.ProductUpgradeVersionMap;
import com.primavera.database.tools.dbmt.SchemaUpgradeVersionInfoMap;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallPPMSuitePropertyAction;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InstallSuitePropertyAction;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.NoUpgradePathFromVersion;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class SetUpgradeVersionFileString
implements TransitionMap.TransitionOperation {
    private final ApplicationContextLogic m_contextLogic;
    private static boolean currentVersionSameAsInstalledVersion;

    public SetUpgradeVersionFileString(ApplicationContextLogic contextLogic) {
        this.m_contextLogic = contextLogic;
    }

    public static boolean isCurrentVersionSameAsInstalledVersion() {
        return currentVersionSameAsInstalledVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        ProductSuiteType suiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
        DatabaseConnection connection = null;
        SchemaType installedDBType = null;
        try {
            connection = new DatabaseConnection(jobProps.getConnection(ConnectionClass.ADMINISTRATIVE));
            installedDBType = this.getSchemaTypefromDatabase(connection, suiteType);
            if (suiteType == ProductSuiteType.PM && installedDBType == SchemaType.PPM) {
                String string = StringLocalizer.get("dbmt.info.upgrade.ppm.to.pm.error");
                return string;
            }
            if (suiteType == ProductSuiteType.PPM && installedDBType == SchemaType.PM) {
                installedDBType = SchemaType.PPM;
            }
            jobProps.setJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY, (Object)installedDBType);
            jobProps.setJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY, (Object)installedDBType);
        }
        catch (SQLException e) {
            String e2 = e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            return e2;
        }
        catch (SchemaTypeNotFoundError e) {
            String e2 = e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            return e2;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        ProductSuiteType productSuiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
        List<SchemaInfo> schemas = null;
        schemas = productSuiteType == ProductSuiteType.PPM ? InstallPPMSuitePropertyAction.getSchemaInfo(this.m_contextLogic, installedDBType, productSuiteType) : InstallSuitePropertyAction.getSchemaInfo(this.m_contextLogic, installedDBType, productSuiteType);
        jobProps.setJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY, schemas);
        try {
            jobProps.setJobProperty("version", this.resetUpgradeInformation(data, schemas, installedDBType, jobProps, jobProps.getConnection(ConnectionClass.ADMINISTRATIVE)));
        }
        catch (Exception e) {
            data.getPageData(page).setValue("needs_upgrade", "false");
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resetUpgradeInformation(WizardInteractorData data, List<SchemaInfo> schemas, SchemaType type, JobProperties jobProps, String connectionString) throws Exception {
        DatabaseConnection connection = null;
        SchemaUpgradeVersionInfoMap schemaUpgradeMap = SchemaUpgradeVersionInfoMap.create(schemas);
        SchemaInfo productSchema = InstallSuitePropertyAction.getProductSchema(schemas, type);
        ProductUpgradeVersionMap productMap = schemaUpgradeMap.get(type);
        String versionQuery = productSchema.getVersionQuery(this.getServerType());
        String currentInstalledVersion = null;
        try {
            connection = new DatabaseConnection(connectionString);
            currentInstalledVersion = this.getInstalledVersion(versionQuery, connection);
            jobProps.setJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY, currentInstalledVersion);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        ProductUpgradeVersionInfo currentVersion = productMap.getLastest();
        ProductUpgradeVersionInfo installedVersion = productMap.get(currentInstalledVersion);
        if (installedVersion == null) {
            throw new NoUpgradePathFromVersion(currentVersion.getSchemaVersion(), currentInstalledVersion);
        }
        currentVersionSameAsInstalledVersion = currentInstalledVersion.equals(currentVersion.getSchemaVersion());
        String localizedLogString = StringLocalizer.get("dbmt.info.upgrade.version.fromandto", new String[]{installedVersion.getSchemaVersion(), currentVersion.getSchemaVersion()});
        DBMTLogger.info(Channel.USER, localizedLogString);
        return installedVersion.getUpgradeFile();
    }

    protected abstract ServerType getServerType();

    protected abstract SchemaType getSchemaTypefromDatabase(DatabaseConnection var1, ProductSuiteType var2) throws SchemaTypeNotFoundError;

    private String getInstalledVersion(String versionQuery, DatabaseConnection connection) throws InteractorDataError, SQLException, PrimaveraDatabaseException {
        try (PreparedStatement stmt = null;){
            stmt = connection.getConnection().prepareStatement(versionQuery);
            stmt.execute();
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                String string = resultSet.getString("VERSION");
                return string;
            }
            throw new DatabaseToolException("Version string Not found");
        }
    }
}

