/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class InitializeROUsersPage
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectStringName;
    private final String[][] m_userNameAndPassFields;

    public InitializeROUsersPage(ConnectionClass connectStringName, String[][] userNameAndPassFields) {
        this.m_connectStringName = connectStringName;
        this.m_userNameAndPassFields = userNameAndPassFields;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError, DBMTException {
        HashSet<String> temporaryTableSpaces = new HashSet<String>();
        HashSet<String> existingOracleUsers = new HashSet<String>();
        HashSet<String> possibleROUsers = new HashSet<String>();
        HashMap<String, String> oracleTablespaceNameMap = new HashMap<String, String>();
        String connectionString = null;
        try {
            connectionString = jobProps.getConnection(this.m_connectStringName);
        }
        catch (ConnectionNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        temporaryTableSpaces.addAll(TablespaceUtil.getTemporaryTablespaces(connectionString));
        oracleTablespaceNameMap.putAll(TablespaceUtil.getAvailableTablespaces(connectionString));
        existingOracleUsers.addAll(InitializeROUsersPage.getExistingUsers(connectionString));
        for (String[] fieldIds : this.m_userNameAndPassFields) {
            if (fieldIds == null || fieldIds.length == 0) continue;
            String value = "";
            if ("install".equalsIgnoreCase(data.getPageData("operation_pm").getValue("operation"))) {
                value = OracleLogic.getDefaultOracleUserName(existingOracleUsers, data.getValue(page, fieldIds[0]));
                data.getPageData(page).setValue("existingRO", "false");
            } else {
                possibleROUsers.addAll(InitializeROUsersPage.getPossibleROUser(connectionString, data.getPageData("connect_upgrade_or_user").getValue("username").toUpperCase()));
                if (possibleROUsers.isEmpty()) {
                    value = OracleLogic.getDefaultOracleUserName(existingOracleUsers, data.getValue(page, fieldIds[0]));
                    data.getPageData(page).setValue("existingRO", "false");
                } else {
                    value = (String)possibleROUsers.iterator().next();
                    data.getPageData(page).setValue("existingRO", "true");
                }
            }
            data.getPageData(page).setValue(fieldIds[0], value);
        }
        return null;
    }

    public static Set<String> getExistingUsers(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            Set<String> set = OracleLogic.getExistingUsers(conn);
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    private static Set<String> getPossibleROUser(String connectionString, String admuser) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            Set<String> set = OracleLogic.getPossibleROUser(conn, admuser);
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

