/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.InvalidValueString;
import com.primavera.database.tools.dbmt.actions.TypedTypeDef;

public class EnumTypeDef
extends TypedTypeDef<String> {
    private final EnumDataEntry[] m_values;

    private EnumTypeDef(EnumDataEntry[] values) {
        super(EnumTypeUniqueInnerClass.class);
        this.m_values = values;
    }

    public static EnumTypeDef create(EnumDataEntry[] values) {
        return new EnumTypeDef(values);
    }

    public static Class<?> getEnumClass() {
        return EnumTypeUniqueInnerClass.class;
    }

    public EnumDataEntry[] getValues() {
        return this.m_values;
    }

    @Override
    protected String readValue(String o) throws InvalidValueString {
        if (o == null) {
            return null;
        }
        String vstring = o.toString().toUpperCase();
        for (int i = 0; i < this.m_values.length; ++i) {
            if (!this.m_values[i].getId().toUpperCase().equals(vstring)) continue;
            return vstring;
        }
        throw new InvalidValueString(this, o.toString(), "dbmt.typedef.error.notinenum");
    }

    @Override
    protected String writeValue(String value) {
        if (value == null) {
            return null;
        }
        return value.toUpperCase();
    }

    @Override
    public String getNomalizedString(String s) {
        if (s == null) {
            return s;
        }
        return s.toUpperCase();
    }

    private static class EnumTypeUniqueInnerClass {
        private EnumTypeUniqueInnerClass() {
        }
    }
}

