/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.EnumTypeDef;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.IntegerTypeDef;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InteractorPageDef;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.PercentTypeDef;
import com.primavera.database.tools.dbmt.actions.ReadOnlyStringTypedef;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import com.primavera.database.tools.dbmt.actions.tests.TestOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommitPageDataDef
implements InteractorPageDef {
    private static final Map<String, Collection<String>> m_depmap = CommitPageDataDef.createDepMap();
    private final List<Job> m_jobs = new ArrayList<Job>();
    private final Map<String, ValueDef> m_fields = new HashMap<String, ValueDef>();
    private final Map<String, Collection<FieldTester>> m_validatorMap = new HashMap<String, Collection<FieldTester>>();
    private final Set<FieldTester> m_finishValidators = new HashSet<FieldTester>();
    private final Set<String> m_finishDependencies = new HashSet<String>();
    private final String m_id;
    private final String m_nameKey;
    private final String m_descKey;
    private final String m_dataPath;
    public static final String FIELD_COMMITSTATUS = "commit-status";
    public static final String FIELD_JOBSTATUS = "job-status";
    public static final String FIELD_JOBCOUNT = "job-count";
    public static final String FIELD_CURRENTJOB = "current-job";
    public static final String FIELD_JOBTREE = "job-tree";
    public static final String FIELD_STATUSMSG = "status-msg";
    public static final String FIELD_JOBPCT = "job-pct";
    public static final String PROP_LOCATION = "dbmt.action";
    public static final String PROP_KEYBASE = "commit";
    private static final String COMMIT_STRING_PREFIX = "dbmt.action.commit.commitstatus";
    private static final String JOB_STRING_PREFIX = "dbmt.action.commit.jobstatus";

    public CommitPageDataDef(String id, String dataPath, String nameKey, String descKey) {
        this.m_id = id;
        this.m_nameKey = nameKey;
        this.m_descKey = descKey;
        this.m_dataPath = dataPath;
        this.m_fields.put(FIELD_COMMITSTATUS, this.createCommitStatusValueDef());
        this.m_fields.put(FIELD_JOBSTATUS, this.createJobStatusValueDef());
        this.m_fields.put(FIELD_CURRENTJOB, this.createCurrentJobValueDef());
        this.m_fields.put(FIELD_JOBCOUNT, this.createJobCountValueDef());
        this.m_fields.put(FIELD_JOBTREE, this.createJobListValueDef());
        this.m_fields.put(FIELD_STATUSMSG, this.createStatusMsgValueDef());
        this.m_fields.put(FIELD_JOBPCT, this.createJobPercentValueDef());
        this.m_finishDependencies.add(FIELD_COMMITSTATUS);
        this.initializeFieldValidators();
    }

    private void initializeFieldValidators() {
        this.m_finishValidators.add(new FieldTester(new TestOp(){

            @Override
            public boolean validate(Object context, InteractorData data, List<String> fieldIds, List<String> params) throws InteractorDataError {
                return CommitStatus.FINISHED.toString().equals(data.getValue(CommitPageDataDef.FIELD_COMMITSTATUS));
            }

            @Override
            public String[] reasonParams(InteractorData data, List<String> fieldIds, List<String> params) throws InvalidDialogField {
                return new String[0];
            }
        }, new ArrayList<String>(), new ArrayList<String>(), null));
    }

    private ValueDef createJobPercentValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_JOBPCT, this.createJobPctTypeDef(), "0");
    }

    private ValueDef createStatusMsgValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, PROP_KEYBASE, ReadOnlyStringTypedef.inst());
    }

    private ValueDef createJobListValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_JOBTREE, this.createJobListTypeDef());
    }

    private TypeDef createJobListTypeDef() {
        return new JobTreeTypeDef();
    }

    private ValueDef createJobCountValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_JOBCOUNT, IntegerTypeDef.inst(), Integer.toString(this.m_jobs.size()));
    }

    private ValueDef createCurrentJobValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_CURRENTJOB, IntegerTypeDef.inst(), "");
    }

    private ValueDef createJobStatusValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_JOBPCT, CommitPageDataDef.createJobStatusTypeDef(), "NOTSTART");
    }

    private static EnumTypeDef createJobStatusTypeDef() {
        EnumDataEntry[] states = new EnumDataEntry[JobStatus.values().length];
        for (int i = 0; i < states.length; ++i) {
            states[i] = CommitPageDataDef.createEnumEntryFromJobStatus(JobStatus.values()[i]);
        }
        return EnumTypeDef.create(states);
    }

    private TypeDef createJobPctTypeDef() {
        return PercentTypeDef.inst();
    }

    private static Map<String, Collection<String>> createDepMap() {
        HashMap<String, Collection<String>> depMap = new HashMap<String, Collection<String>>();
        return depMap;
    }

    private ValueDef createCommitStatusValueDef() {
        return new ValueDef(PROP_LOCATION, PROP_KEYBASE, FIELD_COMMITSTATUS, CommitPageDataDef.createCommitStatusTypeDef(), "NOTSTART");
    }

    private static EnumTypeDef createCommitStatusTypeDef() {
        EnumDataEntry[] states = new EnumDataEntry[CommitStatus.values().length];
        for (int i = 0; i < states.length; ++i) {
            states[i] = CommitPageDataDef.createEnumEntryFromCommitStatus(CommitStatus.values()[i]);
        }
        return EnumTypeDef.create(states);
    }

    private static EnumDataEntry createEnumEntryFromCommitStatus(CommitStatus status) {
        return new EnumDataEntry(status.toString(), status.getNameKey(), status.getDescKey(), status.getMnemonicKey());
    }

    private static EnumDataEntry createEnumEntryFromJobStatus(JobStatus status) {
        return new EnumDataEntry(status.toString(), status.getNameKey(), status.getDescKey(), status.getMnemonicKey());
    }

    @Override
    public boolean doesFieldExit(String fieldId) {
        return this.m_fields.keySet().contains(fieldId);
    }

    @Override
    public ValueDef get(String valueId) {
        return this.m_fields.get(valueId);
    }

    @Override
    public String getDataPath() {
        return this.m_dataPath;
    }

    @Override
    public Map<String, Collection<String>> getDependencyMap() {
        return m_depmap;
    }

    @Override
    public String getDescKey() {
        return this.m_descKey;
    }

    @Override
    public Iterable<String> getFinishDependencies() {
        return this.m_finishDependencies;
    }

    @Override
    public Iterable<FieldTester> getFinishValidators() {
        return this.m_finishValidators;
    }

    @Override
    public Iterable<String> getKeys() {
        return this.m_fields.keySet();
    }

    @Override
    public String getNameKey() {
        return this.m_nameKey;
    }

    @Override
    public int getSize() {
        return this.m_fields.size();
    }

    @Override
    public TypeDef getTypeDef(String fieldId) {
        ValueDef def = this.m_fields.get(fieldId);
        if (def == null) {
            return null;
        }
        return def.getTypeDef();
    }

    @Override
    public Map<String, Collection<FieldTester>> getValidatorMap() {
        return this.m_validatorMap;
    }

    public final String getId() {
        return this.m_id;
    }

    @Override
    public boolean isCancel() {
        return true;
    }

    @Override
    public String getText(String id, JobProperties props) {
        DBMTLogger.error(Channel.DEV, "No text found for id " + id);
        return "";
    }

    public String toString() {
        return "CommitPageDataDef[id=" + this.m_id + " nameKey=" + this.m_nameKey + " dataPath=" + this.m_dataPath + "]";
    }

    public static enum JobStatus {
        NOTSTART,
        RUNNING,
        FAILED,
        FINISHED,
        ABORTED;

        private final String m_nameKey = "dbmt.action.commit.jobstatus." + this.toString() + ".name";
        private final String m_descKey = "dbmt.action.commit.jobstatus." + this.toString() + ".desc";
        private final String m_mnemonicKey = "dbmt.action.commit.jobstatus." + this.toString() + ".mnemonic";

        public final String getDescKey() {
            return this.m_descKey;
        }

        public final String getNameKey() {
            return this.m_nameKey;
        }

        public String getMnemonicKey() {
            return this.m_mnemonicKey;
        }
    }

    public static enum CommitStatus {
        NOTSTART,
        RUNNING,
        FAILED,
        FINISHED;

        private final String m_nameKey = "dbmt.action.commit.commitstatus." + this.toString() + ".name";
        private final String m_descKey = "dbmt.action.commit.commitstatus." + this.toString() + ".desc";
        private final String m_mnemonicKey = "dbmt.action.commit.commitstatus." + this.toString() + ".mnemonic";

        public final String getDescKey() {
            return this.m_descKey;
        }

        public final String getNameKey() {
            return this.m_nameKey;
        }

        public String getMnemonicKey() {
            return this.m_mnemonicKey;
        }
    }
}

