/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class AddPrivUserTransOp
extends SetConnectStringTransOp {
    public AddPrivUserTransOp(boolean verify, Properties fieldOverrides) {
        super(ConnectionClass.PRIVILEGED, verify, fieldOverrides);
    }

    public AddPrivUserTransOp(boolean verify) {
        this(verify, new Properties());
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String privUserName = data.getPageData(page).getValue("privuser");
        String privPassword = data.getPageData(page).getValue("privpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        String host = parsedAdminConnection.getServer();
        String port = parsedAdminConnection.getPort();
        String instance = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setHost(host);
        info.setPort(Integer.parseInt(port));
        info.setDatabase(instance);
        info.setUsername(privUserName);
        info.setService(parsedAdminConnection.isOracleService());
        return info.createConnectString(privPassword);
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String privUserName = data.getPageData(page).getValue("privuser");
        String privPassword = data.getPageData(page).getValue("privpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        String dbService = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setDatabase(dbService);
        info.setUsername(privUserName);
        String connectString = parsedAdminConnection.getConnectstring();
        return info.createATPConnectString(privPassword, connectString);
    }
}

