/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.List;

public class AddExpeditionInstallJobs
extends AbstractJobAdder {
    private final ApplicationContextLogic m_contextLogic;

    public AddExpeditionInstallJobs(String pageId, ApplicationContextLogic contextLogic) {
        super(pageId);
        this.m_contextLogic = contextLogic;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        Object schemaOptions;
        ProductInfo productInfo = this.m_contextLogic.getApp().getCurrentSuiteInfo(ProductSuiteType.EXP);
        ActionClass action = new ActionClass(ActionType.INSTALL, (ServerType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY)));
        Object schemaType = jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY);
        for (SchemaInfo schema : productInfo.getAllSchemas()) {
            if (schema.getSchemaType() != schemaType) continue;
            for (ParameterizedJobFactory<?> jobFactory : this.m_contextLogic.getApp().getSchemaSteps(schema, action)) {
                jobs.add((Job)jobFactory.createJob(jobProps));
            }
        }
        if (schemaType == SchemaType.EXPADM && (schemaOptions = jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_OPTION_KEY)) == "PM_SAME_INSTANCE") {
            for (SchemaInfo schema : productInfo.getAllSchemas()) {
                if (schema.getSchemaType() != SchemaType.JR) continue;
                for (ParameterizedJobFactory<?> jobFactory : this.m_contextLogic.getApp().getSchemaSteps(schema, action)) {
                    jobs.add((Job)jobFactory.createJob(jobProps));
                }
            }
        }
    }
}

