/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.cache;

import com.primavera.common.cache.PolicyEnforcer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PeriodicRefreshLRUPolicyEnforcer<K, V>
implements PolicyEnforcer<K, V> {
    private static final String l = System.getProperty("line.separator");
    private static final float i = 0.75f;
    private final Map<K, V> h;
    private final ReadWriteLock j = new ReentrantReadWriteLock();
    private int k;

    public PeriodicRefreshLRUPolicyEnforcer(int n2) {
        this.k = n2;
        this.h = new LinkedHashMap(this.k, 0.75f, true);
    }

    @Override
    public void setLimit(int n2) {
        this.k = n2;
    }

    @Override
    public void clear() {
        this.j.writeLock().lock();
        try {
            this.h.clear();
        }
        finally {
            this.j.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        try {
            this.j.readLock().lock();
            if (this.h.containsKey(object)) {
                V v2;
                try {
                    this.j.readLock().unlock();
                    this.j.writeLock().lock();
                    v2 = this.h.get(object);
                    this.j.readLock().lock();
                    this.j.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.j.readLock().lock();
                    this.j.writeLock().unlock();
                    throw throwable;
                }
                return v2;
            }
        }
        finally {
            this.j.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean audit() {
        this.j.readLock().lock();
        try {
            if (this.h.size() > this.k) {
                int n2;
                this.j.readLock().unlock();
                this.j.writeLock().lock();
                try {
                    n2 = this.h.size() - this.k;
                    if (n2 > 0) {
                        Iterator<K> iterator = this.h.keySet().iterator();
                        for (int i2 = 0; i2 < n2; i2 += 1) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                }
                finally {
                    this.j.readLock().lock();
                    this.j.writeLock().unlock();
                }
                n2 = 1;
                return n2 != 0;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.j.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k2, V v2) {
        this.j.writeLock().lock();
        try {
            V v3 = this.h.put(k2, v2);
            return v3;
        }
        finally {
            this.j.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        try {
            this.j.readLock().lock();
            if (this.h.containsKey(object)) {
                V v2;
                this.j.readLock().unlock();
                this.j.writeLock().lock();
                try {
                    v2 = this.h.remove(object);
                    this.j.readLock().lock();
                    this.j.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.j.readLock().lock();
                    this.j.writeLock().unlock();
                    throw throwable;
                }
                return v2;
            }
        }
        finally {
            this.j.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Periodic Refresh Least Recently Used Enforcer");
        stringBuilder.append(l);
        this.j.readLock().lock();
        try {
            stringBuilder.append("Number of elements in the cache = ");
            stringBuilder.append(this.h.size());
            stringBuilder.append(l);
            Set<Map.Entry<K, V>> set = this.h.entrySet();
            for (Map.Entry<K, V> entry : set) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.j.readLock().unlock();
        }
    }
}

